/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.lang.Nullable;

class SortedProperties
extends Properties {
    static final String EOL = System.lineSeparator();
    private static final Comparator<Object> keyComparator = Comparator.comparing(String::valueOf);
    private static final Comparator<Map.Entry<Object, Object>> entryComparator = Map.Entry.comparingByKey(keyComparator);
    private final boolean omitComments;

    SortedProperties(boolean bl) {
        this.omitComments = bl;
    }

    SortedProperties(Properties properties, boolean bl) {
        this(bl);
        this.putAll((Map<?, ?>)properties);
    }

    @Override
    public void store(OutputStream outputStream2, @Nullable String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.store(byteArrayOutputStream, this.omitComments ? null : string);
        String string2 = byteArrayOutputStream.toString(StandardCharsets.ISO_8859_1.name());
        for (String string3 : string2.split(EOL)) {
            if (this.omitComments && string3.startsWith("#")) continue;
            outputStream2.write((string3 + EOL).getBytes(StandardCharsets.ISO_8859_1));
        }
    }

    @Override
    public void store(Writer writer, @Nullable String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        super.store(stringWriter, this.omitComments ? null : string);
        String string2 = stringWriter.toString();
        for (String string3 : string2.split(EOL)) {
            if (this.omitComments && string3.startsWith("#")) continue;
            writer.write(string3 + EOL);
        }
    }

    @Override
    public void storeToXML(OutputStream outputStream2, @Nullable String string) throws IOException {
        super.storeToXML(outputStream2, this.omitComments ? null : string);
    }

    @Override
    public void storeToXML(OutputStream outputStream2, @Nullable String string, String string2) throws IOException {
        super.storeToXML(outputStream2, this.omitComments ? null : string, string2);
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public Set<Object> keySet() {
        TreeSet<Object> treeSet = new TreeSet<Object>(keyComparator);
        treeSet.addAll(super.keySet());
        return Collections.synchronizedSet(treeSet);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        TreeSet<Map.Entry<Object, Object>> treeSet = new TreeSet<Map.Entry<Object, Object>>(entryComparator);
        treeSet.addAll(super.entrySet());
        return Collections.synchronizedSet(treeSet);
    }
}

