/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.springframework.core.GraalDetector;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

final class SerializableTypeWrapper {
    private static final Class<?>[] SUPPORTED_SERIALIZABLE_TYPES = new Class[]{GenericArrayType.class, ParameterizedType.class, TypeVariable.class, WildcardType.class};
    static final ConcurrentReferenceHashMap<Type, Type> cache = new ConcurrentReferenceHashMap(256);

    private SerializableTypeWrapper() {
    }

    @Nullable
    public static Type forField(Field field) {
        return SerializableTypeWrapper.forTypeProvider(new FieldTypeProvider(field));
    }

    @Nullable
    public static Type forMethodParameter(MethodParameter methodParameter) {
        return SerializableTypeWrapper.forTypeProvider(new MethodParameterTypeProvider(methodParameter));
    }

    public static <T extends Type> T unwrap(T t2) {
        Type type = null;
        if (t2 instanceof SerializableTypeProxy) {
            type = ((SerializableTypeProxy)((Object)t2)).getTypeProvider().getType();
        }
        return (T)(type != null ? type : (Type)t2);
    }

    @Nullable
    static Type forTypeProvider(TypeProvider typeProvider) {
        Type type = typeProvider.getType();
        if (type == null || type instanceof Serializable) {
            return type;
        }
        if (GraalDetector.inImageCode() || !Serializable.class.isAssignableFrom(Class.class)) {
            return type;
        }
        Type type2 = cache.get(type);
        if (type2 != null) {
            return type2;
        }
        for (Class<?> clazz : SUPPORTED_SERIALIZABLE_TYPES) {
            if (!clazz.isInstance(type)) continue;
            ClassLoader classLoader = typeProvider.getClass().getClassLoader();
            Class[] classArray = new Class[]{clazz, SerializableTypeProxy.class, Serializable.class};
            TypeProxyInvocationHandler typeProxyInvocationHandler = new TypeProxyInvocationHandler(typeProvider);
            type2 = (Type)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)typeProxyInvocationHandler);
            cache.put(type, type2);
            return type2;
        }
        throw new IllegalArgumentException("Unsupported Type class: " + type.getClass().getName());
    }

    static class MethodInvokeTypeProvider
    implements TypeProvider {
        private final TypeProvider provider;
        private final String methodName;
        private final Class<?> declaringClass;
        private final int index;
        private transient Method method;
        @Nullable
        private volatile transient Object result;

        public MethodInvokeTypeProvider(TypeProvider typeProvider, Method method, int n) {
            this.provider = typeProvider;
            this.methodName = method.getName();
            this.declaringClass = method.getDeclaringClass();
            this.index = n;
            this.method = method;
        }

        @Override
        @Nullable
        public Type getType() {
            Object object = this.result;
            if (object == null) {
                this.result = object = ReflectionUtils.invokeMethod(this.method, this.provider.getType());
            }
            return object instanceof Type[] ? ((Type[])object)[this.index] : (Type)object;
        }

        @Override
        @Nullable
        public Object getSource() {
            return null;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            Method method = ReflectionUtils.findMethod(this.declaringClass, this.methodName);
            if (method == null) {
                throw new IllegalStateException("Cannot find method on deserialization: " + this.methodName);
            }
            if (method.getReturnType() != Type.class && method.getReturnType() != Type[].class) {
                throw new IllegalStateException("Invalid return type on deserialized method - needs to be Type or Type[]: " + method);
            }
            this.method = method;
        }
    }

    static class MethodParameterTypeProvider
    implements TypeProvider {
        @Nullable
        private final String methodName;
        private final Class<?>[] parameterTypes;
        private final Class<?> declaringClass;
        private final int parameterIndex;
        private transient MethodParameter methodParameter;

        public MethodParameterTypeProvider(MethodParameter methodParameter) {
            this.methodName = methodParameter.getMethod() != null ? methodParameter.getMethod().getName() : null;
            this.parameterTypes = methodParameter.getExecutable().getParameterTypes();
            this.declaringClass = methodParameter.getDeclaringClass();
            this.parameterIndex = methodParameter.getParameterIndex();
            this.methodParameter = methodParameter;
        }

        @Override
        public Type getType() {
            return this.methodParameter.getGenericParameterType();
        }

        @Override
        public Object getSource() {
            return this.methodParameter;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            try {
                this.methodParameter = this.methodName != null ? new MethodParameter(this.declaringClass.getDeclaredMethod(this.methodName, this.parameterTypes), this.parameterIndex) : new MethodParameter(this.declaringClass.getDeclaredConstructor(this.parameterTypes), this.parameterIndex);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Could not find original class structure", throwable);
            }
        }
    }

    static class FieldTypeProvider
    implements TypeProvider {
        private final String fieldName;
        private final Class<?> declaringClass;
        private transient Field field;

        public FieldTypeProvider(Field field) {
            this.fieldName = field.getName();
            this.declaringClass = field.getDeclaringClass();
            this.field = field;
        }

        @Override
        public Type getType() {
            return this.field.getGenericType();
        }

        @Override
        public Object getSource() {
            return this.field;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            try {
                this.field = this.declaringClass.getDeclaredField(this.fieldName);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Could not find original class structure", throwable);
            }
        }
    }

    private static class TypeProxyInvocationHandler
    implements Serializable,
    InvocationHandler {
        private final TypeProvider provider;

        public TypeProxyInvocationHandler(TypeProvider typeProvider) {
            this.provider = typeProvider;
        }

        @Override
        @Nullable
        public Object invoke(Object object, Method method, @Nullable Object[] objectArray) throws Throwable {
            if (method.getName().equals("equals") && objectArray != null) {
                Object object2 = objectArray[0];
                if (object2 instanceof Type) {
                    object2 = SerializableTypeWrapper.unwrap((Type)object2);
                }
                return ObjectUtils.nullSafeEquals(this.provider.getType(), object2);
            }
            if (method.getName().equals("hashCode")) {
                return ObjectUtils.nullSafeHashCode(this.provider.getType());
            }
            if (method.getName().equals("getTypeProvider")) {
                return this.provider;
            }
            if (Type.class == method.getReturnType() && objectArray == null) {
                return SerializableTypeWrapper.forTypeProvider(new MethodInvokeTypeProvider(this.provider, method, -1));
            }
            if (Type[].class == method.getReturnType() && objectArray == null) {
                Type[] typeArray = new Type[((Type[])method.invoke((Object)this.provider.getType(), new Object[0])).length];
                for (int i = 0; i < typeArray.length; ++i) {
                    typeArray[i] = SerializableTypeWrapper.forTypeProvider(new MethodInvokeTypeProvider(this.provider, method, i));
                }
                return typeArray;
            }
            try {
                return method.invoke((Object)this.provider.getType(), objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
        }
    }

    static interface TypeProvider
    extends Serializable {
        @Nullable
        public Type getType();

        @Nullable
        default public Object getSource() {
            return null;
        }
    }

    static interface SerializableTypeProxy {
        public TypeProvider getTypeProvider();
    }
}

