/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableTypeProvider;
import org.springframework.core.SerializableTypeWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ResolvableType
implements Serializable {
    public static final ResolvableType NONE = new ResolvableType(EmptyType.INSTANCE, null, null, 0);
    private static final ResolvableType[] EMPTY_TYPES_ARRAY = new ResolvableType[0];
    private static final ConcurrentReferenceHashMap<ResolvableType, ResolvableType> cache = new ConcurrentReferenceHashMap(256);
    private final Type type;
    @Nullable
    private final SerializableTypeWrapper.TypeProvider typeProvider;
    @Nullable
    private final VariableResolver variableResolver;
    @Nullable
    private final ResolvableType componentType;
    @Nullable
    private final Integer hash;
    @Nullable
    private Class<?> resolved;
    @Nullable
    private volatile ResolvableType superType;
    @Nullable
    private volatile ResolvableType[] interfaces;
    @Nullable
    private volatile ResolvableType[] generics;

    private ResolvableType(Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = null;
        this.hash = this.calculateHashCode();
        this.resolved = null;
    }

    private ResolvableType(Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver, @Nullable Integer n) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = null;
        this.hash = n;
        this.resolved = this.resolveClass();
    }

    private ResolvableType(Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver, @Nullable ResolvableType resolvableType) {
        this.type = type;
        this.typeProvider = typeProvider;
        this.variableResolver = variableResolver;
        this.componentType = resolvableType;
        this.hash = null;
        this.resolved = this.resolveClass();
    }

    private ResolvableType(@Nullable Class<?> clazz) {
        this.type = this.resolved = clazz != null ? clazz : Object.class;
        this.typeProvider = null;
        this.variableResolver = null;
        this.componentType = null;
        this.hash = null;
    }

    public Type getType() {
        return SerializableTypeWrapper.unwrap(this.type);
    }

    @Nullable
    public Class<?> getRawClass() {
        if (this.type == this.resolved) {
            return this.resolved;
        }
        Type type = this.type;
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getRawType();
        }
        return type instanceof Class ? (Class)type : null;
    }

    public Object getSource() {
        Object object = this.typeProvider != null ? this.typeProvider.getSource() : null;
        return object != null ? object : this.type;
    }

    public Class<?> toClass() {
        return this.resolve(Object.class);
    }

    public boolean isInstance(@Nullable Object object) {
        return object != null && this.isAssignableFrom(object.getClass());
    }

    public boolean isAssignableFrom(Class<?> clazz) {
        return this.isAssignableFrom(ResolvableType.forClass(clazz), null);
    }

    public boolean isAssignableFrom(ResolvableType resolvableType) {
        return this.isAssignableFrom(resolvableType, null);
    }

    private boolean isAssignableFrom(ResolvableType resolvableType, @Nullable Map<Type, Type> map) {
        Object object;
        Type type;
        Assert.notNull((Object)resolvableType, "ResolvableType must not be null");
        if (this == NONE || resolvableType == NONE) {
            return false;
        }
        if (this.isArray()) {
            return resolvableType.isArray() && this.getComponentType().isAssignableFrom(resolvableType.getComponentType());
        }
        if (map != null && map.get(this.type) == resolvableType.type) {
            return true;
        }
        WildcardBounds wildcardBounds = WildcardBounds.get(this);
        WildcardBounds wildcardBounds2 = WildcardBounds.get(resolvableType);
        if (wildcardBounds2 != null) {
            return wildcardBounds != null && wildcardBounds.isSameKind(wildcardBounds2) && wildcardBounds.isAssignableFrom(wildcardBounds2.getBounds());
        }
        if (wildcardBounds != null) {
            return wildcardBounds.isAssignableFrom(resolvableType);
        }
        boolean bl = map != null;
        boolean bl2 = true;
        Class<?> clazz = null;
        if (this.type instanceof TypeVariable) {
            type = (TypeVariable)this.type;
            if (this.variableResolver != null && (object = this.variableResolver.resolveVariable((TypeVariable<?>)type)) != null) {
                clazz = ((ResolvableType)object).resolve();
            }
            if (clazz == null && resolvableType.variableResolver != null && (object = resolvableType.variableResolver.resolveVariable((TypeVariable<?>)type)) != null) {
                clazz = ((ResolvableType)object).resolve();
                bl2 = false;
            }
            if (clazz == null) {
                bl = false;
            }
        }
        if (clazz == null) {
            clazz = this.resolve(Object.class);
        }
        type = resolvableType.toClass();
        if (bl ? !clazz.equals(type) : !ClassUtils.isAssignable(clazz, type)) {
            return false;
        }
        if (bl2) {
            ResolvableType[] resolvableTypeArray;
            object = this.getGenerics();
            if (((Object)object).length != (resolvableTypeArray = resolvableType.as(clazz).getGenerics()).length) {
                return false;
            }
            if (map == null) {
                map = new IdentityHashMap<Type, Type>(1);
            }
            map.put(this.type, resolvableType.type);
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (super.isAssignableFrom(resolvableTypeArray[i], map)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isArray() {
        if (this == NONE) {
            return false;
        }
        return this.type instanceof Class && ((Class)this.type).isArray() || this.type instanceof GenericArrayType || this.resolveType().isArray();
    }

    public ResolvableType getComponentType() {
        if (this == NONE) {
            return NONE;
        }
        if (this.componentType != null) {
            return this.componentType;
        }
        if (this.type instanceof Class) {
            Class<?> clazz = ((Class)this.type).getComponentType();
            return ResolvableType.forType(clazz, this.variableResolver);
        }
        if (this.type instanceof GenericArrayType) {
            return ResolvableType.forType(((GenericArrayType)this.type).getGenericComponentType(), this.variableResolver);
        }
        return this.resolveType().getComponentType();
    }

    public ResolvableType asCollection() {
        return this.as(Collection.class);
    }

    public ResolvableType asMap() {
        return this.as(Map.class);
    }

    public ResolvableType as(Class<?> clazz) {
        if (this == NONE) {
            return NONE;
        }
        Class<?> clazz2 = this.resolve();
        if (clazz2 == null || clazz2 == clazz) {
            return this;
        }
        for (ResolvableType resolvableType : this.getInterfaces()) {
            ResolvableType resolvableType2 = resolvableType.as(clazz);
            if (resolvableType2 == NONE) continue;
            return resolvableType2;
        }
        return this.getSuperType().as(clazz);
    }

    public ResolvableType getSuperType() {
        Class<?> clazz = this.resolve();
        if (clazz == null) {
            return NONE;
        }
        try {
            Type type = clazz.getGenericSuperclass();
            if (type == null) {
                return NONE;
            }
            ResolvableType resolvableType = this.superType;
            if (resolvableType == null) {
                this.superType = resolvableType = ResolvableType.forType(type, this);
            }
            return resolvableType;
        }
        catch (TypeNotPresentException typeNotPresentException) {
            return NONE;
        }
    }

    public ResolvableType[] getInterfaces() {
        Class<?> clazz = this.resolve();
        if (clazz == null) {
            return EMPTY_TYPES_ARRAY;
        }
        ResolvableType[] resolvableTypeArray = this.interfaces;
        if (resolvableTypeArray == null) {
            Type[] typeArray = clazz.getGenericInterfaces();
            resolvableTypeArray = new ResolvableType[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                resolvableTypeArray[i] = ResolvableType.forType(typeArray[i], this);
            }
            this.interfaces = resolvableTypeArray;
        }
        return resolvableTypeArray;
    }

    public boolean hasGenerics() {
        return this.getGenerics().length > 0;
    }

    boolean isEntirelyUnresolvable() {
        ResolvableType[] resolvableTypeArray;
        if (this == NONE) {
            return false;
        }
        for (ResolvableType resolvableType : resolvableTypeArray = this.getGenerics()) {
            if (resolvableType.isUnresolvableTypeVariable() || resolvableType.isWildcardWithoutBounds()) continue;
            return false;
        }
        return true;
    }

    public boolean hasUnresolvableGenerics() {
        if (this == NONE) {
            return false;
        }
        ResolvableType[] resolvableTypeArray = this.getGenerics();
        for (ResolvableType resolvableType : resolvableTypeArray) {
            if (!resolvableType.isUnresolvableTypeVariable() && !resolvableType.isWildcardWithoutBounds()) continue;
            return true;
        }
        Class<?> clazz = this.resolve();
        if (clazz != null) {
            try {
                for (Type type : clazz.getGenericInterfaces()) {
                    if (!(type instanceof Class) || !ResolvableType.forClass((Class)type).hasGenerics()) continue;
                    return true;
                }
            }
            catch (TypeNotPresentException typeNotPresentException) {
                // empty catch block
            }
            return this.getSuperType().hasUnresolvableGenerics();
        }
        return false;
    }

    private boolean isUnresolvableTypeVariable() {
        if (this.type instanceof TypeVariable) {
            if (this.variableResolver == null) {
                return true;
            }
            TypeVariable typeVariable = (TypeVariable)this.type;
            ResolvableType resolvableType = this.variableResolver.resolveVariable(typeVariable);
            if (resolvableType == null || resolvableType.isUnresolvableTypeVariable()) {
                return true;
            }
        }
        return false;
    }

    private boolean isWildcardWithoutBounds() {
        Type[] typeArray;
        WildcardType wildcardType;
        return this.type instanceof WildcardType && (wildcardType = (WildcardType)this.type).getLowerBounds().length == 0 && ((typeArray = wildcardType.getUpperBounds()).length == 0 || typeArray.length == 1 && Object.class == typeArray[0]);
    }

    public ResolvableType getNested(int n) {
        return this.getNested(n, null);
    }

    public ResolvableType getNested(int n, @Nullable Map<Integer, Integer> map) {
        ResolvableType resolvableType = this;
        for (int i = 2; i <= n; ++i) {
            if (resolvableType.isArray()) {
                resolvableType = resolvableType.getComponentType();
                continue;
            }
            while (resolvableType != NONE && !resolvableType.hasGenerics()) {
                resolvableType = resolvableType.getSuperType();
            }
            Integer n2 = map != null ? map.get(i) : null;
            n2 = n2 == null ? resolvableType.getGenerics().length - 1 : n2;
            resolvableType = resolvableType.getGeneric(n2);
        }
        return resolvableType;
    }

    public ResolvableType getGeneric(int ... nArray) {
        ResolvableType[] resolvableTypeArray = this.getGenerics();
        if (nArray == null || nArray.length == 0) {
            return resolvableTypeArray.length == 0 ? NONE : resolvableTypeArray[0];
        }
        ResolvableType resolvableType = this;
        for (int n : nArray) {
            resolvableTypeArray = resolvableType.getGenerics();
            if (n < 0 || n >= resolvableTypeArray.length) {
                return NONE;
            }
            resolvableType = resolvableTypeArray[n];
        }
        return resolvableType;
    }

    public ResolvableType[] getGenerics() {
        if (this == NONE) {
            return EMPTY_TYPES_ARRAY;
        }
        ResolvableType[] resolvableTypeArray = this.generics;
        if (resolvableTypeArray == null) {
            if (this.type instanceof Class) {
                TypeVariable<Class<T>>[] typeVariableArray = ((Class)this.type).getTypeParameters();
                resolvableTypeArray = new ResolvableType[typeVariableArray.length];
                for (int i = 0; i < resolvableTypeArray.length; ++i) {
                    resolvableTypeArray[i] = ResolvableType.forType(typeVariableArray[i], this);
                }
            } else if (this.type instanceof ParameterizedType) {
                Type[] typeArray = ((ParameterizedType)this.type).getActualTypeArguments();
                resolvableTypeArray = new ResolvableType[typeArray.length];
                for (int i = 0; i < typeArray.length; ++i) {
                    resolvableTypeArray[i] = ResolvableType.forType(typeArray[i], this.variableResolver);
                }
            } else {
                resolvableTypeArray = this.resolveType().getGenerics();
            }
            this.generics = resolvableTypeArray;
        }
        return resolvableTypeArray;
    }

    public Class<?>[] resolveGenerics() {
        ResolvableType[] resolvableTypeArray = this.getGenerics();
        Class[] classArray = new Class[resolvableTypeArray.length];
        for (int i = 0; i < resolvableTypeArray.length; ++i) {
            classArray[i] = resolvableTypeArray[i].resolve();
        }
        return classArray;
    }

    public Class<?>[] resolveGenerics(Class<?> clazz) {
        ResolvableType[] resolvableTypeArray = this.getGenerics();
        Class[] classArray = new Class[resolvableTypeArray.length];
        for (int i = 0; i < resolvableTypeArray.length; ++i) {
            classArray[i] = resolvableTypeArray[i].resolve(clazz);
        }
        return classArray;
    }

    @Nullable
    public Class<?> resolveGeneric(int ... nArray) {
        return this.getGeneric(nArray).resolve();
    }

    @Nullable
    public Class<?> resolve() {
        return this.resolved;
    }

    public Class<?> resolve(Class<?> clazz) {
        return this.resolved != null ? this.resolved : clazz;
    }

    @Nullable
    private Class<?> resolveClass() {
        if (this.type == EmptyType.INSTANCE) {
            return null;
        }
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof GenericArrayType) {
            Class<?> clazz = this.getComponentType().resolve();
            return clazz != null ? Array.newInstance(clazz, 0).getClass() : null;
        }
        return this.resolveType().resolve();
    }

    ResolvableType resolveType() {
        if (this.type instanceof ParameterizedType) {
            return ResolvableType.forType(((ParameterizedType)this.type).getRawType(), this.variableResolver);
        }
        if (this.type instanceof WildcardType) {
            Type type = this.resolveBounds(((WildcardType)this.type).getUpperBounds());
            if (type == null) {
                type = this.resolveBounds(((WildcardType)this.type).getLowerBounds());
            }
            return ResolvableType.forType(type, this.variableResolver);
        }
        if (this.type instanceof TypeVariable) {
            ResolvableType resolvableType;
            TypeVariable typeVariable = (TypeVariable)this.type;
            if (this.variableResolver != null && (resolvableType = this.variableResolver.resolveVariable(typeVariable)) != null) {
                return resolvableType;
            }
            return ResolvableType.forType(this.resolveBounds(typeVariable.getBounds()), this.variableResolver);
        }
        return NONE;
    }

    @Nullable
    private Type resolveBounds(Type[] typeArray) {
        if (typeArray.length == 0 || typeArray[0] == Object.class) {
            return null;
        }
        return typeArray[0];
    }

    @Nullable
    private ResolvableType resolveVariable(TypeVariable<?> typeVariable) {
        Object object;
        if (this.type instanceof TypeVariable) {
            return this.resolveType().resolveVariable(typeVariable);
        }
        if (this.type instanceof ParameterizedType) {
            object = (ParameterizedType)this.type;
            Class<?> clazz = this.resolve();
            if (clazz == null) {
                return null;
            }
            TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
            for (int i = 0; i < typeVariableArray.length; ++i) {
                if (!ObjectUtils.nullSafeEquals(typeVariableArray[i].getName(), typeVariable.getName())) continue;
                Type type = object.getActualTypeArguments()[i];
                return ResolvableType.forType(type, this.variableResolver);
            }
            Type type = object.getOwnerType();
            if (type != null) {
                return ResolvableType.forType(type, this.variableResolver).resolveVariable(typeVariable);
            }
        }
        if (this.type instanceof WildcardType && (object = this.resolveType().resolveVariable(typeVariable)) != null) {
            return object;
        }
        if (this.variableResolver != null) {
            return this.variableResolver.resolveVariable(typeVariable);
        }
        return null;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResolvableType)) {
            return false;
        }
        ResolvableType resolvableType = (ResolvableType)object;
        if (!ObjectUtils.nullSafeEquals(this.type, resolvableType.type)) {
            return false;
        }
        if (!(this.typeProvider == resolvableType.typeProvider || this.typeProvider != null && resolvableType.typeProvider != null && ObjectUtils.nullSafeEquals(this.typeProvider.getType(), resolvableType.typeProvider.getType()))) {
            return false;
        }
        if (!(this.variableResolver == resolvableType.variableResolver || this.variableResolver != null && resolvableType.variableResolver != null && ObjectUtils.nullSafeEquals(this.variableResolver.getSource(), resolvableType.variableResolver.getSource()))) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.componentType, resolvableType.componentType);
    }

    public int hashCode() {
        return this.hash != null ? this.hash.intValue() : this.calculateHashCode();
    }

    private int calculateHashCode() {
        int n = ObjectUtils.nullSafeHashCode(this.type);
        if (this.typeProvider != null) {
            n = 31 * n + ObjectUtils.nullSafeHashCode(this.typeProvider.getType());
        }
        if (this.variableResolver != null) {
            n = 31 * n + ObjectUtils.nullSafeHashCode(this.variableResolver.getSource());
        }
        if (this.componentType != null) {
            n = 31 * n + ObjectUtils.nullSafeHashCode(this.componentType);
        }
        return n;
    }

    @Nullable
    VariableResolver asVariableResolver() {
        if (this == NONE) {
            return null;
        }
        return new DefaultVariableResolver(this);
    }

    private Object readResolve() {
        return this.type == EmptyType.INSTANCE ? NONE : this;
    }

    public String toString() {
        if (this.isArray()) {
            return this.getComponentType() + "[]";
        }
        if (this.resolved == null) {
            return "?";
        }
        if (this.type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)this.type;
            if (this.variableResolver == null || this.variableResolver.resolveVariable(typeVariable) == null) {
                return "?";
            }
        }
        if (this.hasGenerics()) {
            return this.resolved.getName() + '<' + StringUtils.arrayToDelimitedString(this.getGenerics(), ", ") + '>';
        }
        return this.resolved.getName();
    }

    public static ResolvableType forClass(@Nullable Class<?> clazz) {
        return new ResolvableType(clazz);
    }

    public static ResolvableType forRawClass(final @Nullable Class<?> clazz) {
        return new ResolvableType(clazz){

            @Override
            public ResolvableType[] getGenerics() {
                return EMPTY_TYPES_ARRAY;
            }

            @Override
            public boolean isAssignableFrom(Class<?> clazz2) {
                return clazz == null || ClassUtils.isAssignable(clazz, clazz2);
            }

            @Override
            public boolean isAssignableFrom(ResolvableType resolvableType) {
                Class<?> clazz2 = resolvableType.resolve();
                return clazz2 != null && (clazz == null || ClassUtils.isAssignable(clazz, clazz2));
            }
        };
    }

    public static ResolvableType forClass(Class<?> clazz, Class<?> clazz2) {
        Assert.notNull(clazz, "Base type must not be null");
        ResolvableType resolvableType = ResolvableType.forType(clazz2).as(clazz);
        return resolvableType == NONE ? ResolvableType.forType(clazz) : resolvableType;
    }

    public static ResolvableType forClassWithGenerics(Class<?> clazz, Class<?> ... classArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(classArray, "Generics array must not be null");
        ResolvableType[] resolvableTypeArray = new ResolvableType[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            resolvableTypeArray[i] = ResolvableType.forClass(classArray[i]);
        }
        return ResolvableType.forClassWithGenerics(clazz, resolvableTypeArray);
    }

    public static ResolvableType forClassWithGenerics(Class<?> clazz, ResolvableType ... resolvableTypeArray) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull((Object)resolvableTypeArray, "Generics array must not be null");
        TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
        Assert.isTrue(typeVariableArray.length == resolvableTypeArray.length, "Mismatched number of generics specified");
        Type[] typeArray = new Type[resolvableTypeArray.length];
        for (int i = 0; i < resolvableTypeArray.length; ++i) {
            ResolvableType resolvableType = resolvableTypeArray[i];
            Type type = resolvableType != null ? resolvableType.getType() : null;
            typeArray[i] = type != null && !(type instanceof TypeVariable) ? type : typeVariableArray[i];
        }
        SyntheticParameterizedType syntheticParameterizedType = new SyntheticParameterizedType(clazz, typeArray);
        return ResolvableType.forType((Type)syntheticParameterizedType, new TypeVariablesVariableResolver(typeVariableArray, resolvableTypeArray));
    }

    public static ResolvableType forInstance(Object object) {
        ResolvableType resolvableType;
        Assert.notNull(object, "Instance must not be null");
        if (object instanceof ResolvableTypeProvider && (resolvableType = ((ResolvableTypeProvider)object).getResolvableType()) != null) {
            return resolvableType;
        }
        return ResolvableType.forClass(object.getClass());
    }

    public static ResolvableType forField(Field field) {
        Assert.notNull((Object)field, "Field must not be null");
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), null);
    }

    public static ResolvableType forField(Field field, Class<?> clazz) {
        Assert.notNull((Object)field, "Field must not be null");
        ResolvableType resolvableType = ResolvableType.forType(clazz).as(field.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), resolvableType.asVariableResolver());
    }

    public static ResolvableType forField(Field field, @Nullable ResolvableType resolvableType) {
        Assert.notNull((Object)field, "Field must not be null");
        ResolvableType resolvableType2 = resolvableType != null ? resolvableType : NONE;
        resolvableType2 = resolvableType2.as(field.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), resolvableType2.asVariableResolver());
    }

    public static ResolvableType forField(Field field, int n) {
        Assert.notNull((Object)field, "Field must not be null");
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), null).getNested(n);
    }

    public static ResolvableType forField(Field field, int n, @Nullable Class<?> clazz) {
        Assert.notNull((Object)field, "Field must not be null");
        ResolvableType resolvableType = ResolvableType.forType(clazz).as(field.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.FieldTypeProvider(field), resolvableType.asVariableResolver()).getNested(n);
    }

    public static ResolvableType forConstructorParameter(Constructor<?> constructor, int n) {
        Assert.notNull(constructor, "Constructor must not be null");
        return ResolvableType.forMethodParameter(new MethodParameter(constructor, n));
    }

    public static ResolvableType forConstructorParameter(Constructor<?> constructor, int n, Class<?> clazz) {
        Assert.notNull(constructor, "Constructor must not be null");
        MethodParameter methodParameter = new MethodParameter(constructor, n, clazz);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodReturnType(Method method) {
        Assert.notNull((Object)method, "Method must not be null");
        return ResolvableType.forMethodParameter(new MethodParameter(method, -1));
    }

    public static ResolvableType forMethodReturnType(Method method, Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        MethodParameter methodParameter = new MethodParameter((Executable)method, -1, clazz);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodParameter(Method method, int n) {
        Assert.notNull((Object)method, "Method must not be null");
        return ResolvableType.forMethodParameter(new MethodParameter(method, n));
    }

    public static ResolvableType forMethodParameter(Method method, int n, Class<?> clazz) {
        Assert.notNull((Object)method, "Method must not be null");
        MethodParameter methodParameter = new MethodParameter((Executable)method, n, clazz);
        return ResolvableType.forMethodParameter(methodParameter);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter) {
        return ResolvableType.forMethodParameter(methodParameter, (Type)null);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, @Nullable ResolvableType resolvableType) {
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        resolvableType = resolvableType != null ? resolvableType : ResolvableType.forType(methodParameter.getContainingClass());
        ResolvableType resolvableType2 = resolvableType.as(methodParameter.getDeclaringClass());
        return ResolvableType.forType(null, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), resolvableType2.asVariableResolver()).getNested(methodParameter.getNestingLevel(), methodParameter.typeIndexesPerLevel);
    }

    public static ResolvableType forMethodParameter(MethodParameter methodParameter, @Nullable Type type) {
        Assert.notNull((Object)methodParameter, "MethodParameter must not be null");
        return ResolvableType.forMethodParameter(methodParameter, type, methodParameter.getNestingLevel());
    }

    static ResolvableType forMethodParameter(MethodParameter methodParameter, @Nullable Type type, int n) {
        ResolvableType resolvableType = ResolvableType.forType(methodParameter.getContainingClass()).as(methodParameter.getDeclaringClass());
        return ResolvableType.forType(type, new SerializableTypeWrapper.MethodParameterTypeProvider(methodParameter), resolvableType.asVariableResolver()).getNested(n, methodParameter.typeIndexesPerLevel);
    }

    public static ResolvableType forArrayComponent(ResolvableType resolvableType) {
        Assert.notNull((Object)resolvableType, "Component type must not be null");
        Class<?> clazz = Array.newInstance(resolvableType.resolve(), 0).getClass();
        return new ResolvableType(clazz, null, null, resolvableType);
    }

    public static ResolvableType forType(@Nullable Type type) {
        return ResolvableType.forType(type, null, null);
    }

    public static ResolvableType forType(@Nullable Type type, @Nullable ResolvableType resolvableType) {
        VariableResolver variableResolver = null;
        if (resolvableType != null) {
            variableResolver = resolvableType.asVariableResolver();
        }
        return ResolvableType.forType(type, variableResolver);
    }

    public static ResolvableType forType(ParameterizedTypeReference<?> parameterizedTypeReference) {
        return ResolvableType.forType(parameterizedTypeReference.getType(), null, null);
    }

    static ResolvableType forType(@Nullable Type type, @Nullable VariableResolver variableResolver) {
        return ResolvableType.forType(type, null, variableResolver);
    }

    static ResolvableType forType(@Nullable Type type, @Nullable SerializableTypeWrapper.TypeProvider typeProvider, @Nullable VariableResolver variableResolver) {
        if (type == null && typeProvider != null) {
            type = SerializableTypeWrapper.forTypeProvider(typeProvider);
        }
        if (type == null) {
            return NONE;
        }
        if (type instanceof Class) {
            return new ResolvableType(type, typeProvider, variableResolver, (ResolvableType)null);
        }
        cache.purgeUnreferencedEntries();
        ResolvableType resolvableType = new ResolvableType(type, typeProvider, variableResolver);
        ResolvableType resolvableType2 = cache.get(resolvableType);
        if (resolvableType2 == null) {
            resolvableType2 = new ResolvableType(type, typeProvider, variableResolver, resolvableType.hash);
            cache.put(resolvableType2, resolvableType2);
        }
        resolvableType.resolved = resolvableType2.resolved;
        return resolvableType;
    }

    public static void clearCache() {
        cache.clear();
        SerializableTypeWrapper.cache.clear();
    }

    static class EmptyType
    implements Serializable,
    Type {
        static final Type INSTANCE = new EmptyType();

        EmptyType() {
        }

        Object readResolve() {
            return INSTANCE;
        }
    }

    private static class WildcardBounds {
        private final Kind kind;
        private final ResolvableType[] bounds;

        public WildcardBounds(Kind kind, ResolvableType[] resolvableTypeArray) {
            this.kind = kind;
            this.bounds = resolvableTypeArray;
        }

        public boolean isSameKind(WildcardBounds wildcardBounds) {
            return this.kind == wildcardBounds.kind;
        }

        public boolean isAssignableFrom(ResolvableType ... resolvableTypeArray) {
            for (ResolvableType resolvableType : this.bounds) {
                for (ResolvableType resolvableType2 : resolvableTypeArray) {
                    if (this.isAssignable(resolvableType, resolvableType2)) continue;
                    return false;
                }
            }
            return true;
        }

        private boolean isAssignable(ResolvableType resolvableType, ResolvableType resolvableType2) {
            return this.kind == Kind.UPPER ? resolvableType.isAssignableFrom(resolvableType2) : resolvableType2.isAssignableFrom(resolvableType);
        }

        public ResolvableType[] getBounds() {
            return this.bounds;
        }

        @Nullable
        public static WildcardBounds get(ResolvableType resolvableType) {
            ResolvableType resolvableType2 = resolvableType;
            while (!(resolvableType2.getType() instanceof WildcardType)) {
                if (resolvableType2 == NONE) {
                    return null;
                }
                resolvableType2 = resolvableType2.resolveType();
            }
            WildcardType wildcardType = (WildcardType)resolvableType2.type;
            Kind kind = wildcardType.getLowerBounds().length > 0 ? Kind.LOWER : Kind.UPPER;
            Type[] typeArray = kind == Kind.UPPER ? wildcardType.getUpperBounds() : wildcardType.getLowerBounds();
            ResolvableType[] resolvableTypeArray = new ResolvableType[typeArray.length];
            for (int i = 0; i < typeArray.length; ++i) {
                resolvableTypeArray[i] = ResolvableType.forType(typeArray[i], resolvableType.variableResolver);
            }
            return new WildcardBounds(kind, resolvableTypeArray);
        }

        static enum Kind {
            UPPER,
            LOWER;

        }
    }

    private static final class SyntheticParameterizedType
    implements Serializable,
    ParameterizedType {
        private final Type rawType;
        private final Type[] typeArguments;

        public SyntheticParameterizedType(Type type, Type[] typeArray) {
            this.rawType = type;
            this.typeArguments = typeArray;
        }

        @Override
        public String getTypeName() {
            String string = this.rawType.getTypeName();
            if (this.typeArguments.length > 0) {
                StringJoiner stringJoiner = new StringJoiner(", ", "<", ">");
                for (Type type : this.typeArguments) {
                    stringJoiner.add(type.getTypeName());
                }
                return string + stringJoiner;
            }
            return string;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType parameterizedType = (ParameterizedType)object;
            return parameterizedType.getOwnerType() == null && this.rawType.equals(parameterizedType.getRawType()) && Arrays.equals(this.typeArguments, parameterizedType.getActualTypeArguments());
        }

        public int hashCode() {
            return this.rawType.hashCode() * 31 + Arrays.hashCode(this.typeArguments);
        }

        public String toString() {
            return this.getTypeName();
        }
    }

    private static class TypeVariablesVariableResolver
    implements VariableResolver {
        private final TypeVariable<?>[] variables;
        private final ResolvableType[] generics;

        public TypeVariablesVariableResolver(TypeVariable<?>[] typeVariableArray, ResolvableType[] resolvableTypeArray) {
            this.variables = typeVariableArray;
            this.generics = resolvableTypeArray;
        }

        @Override
        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> typeVariable) {
            TypeVariable<?> typeVariable2 = SerializableTypeWrapper.unwrap(typeVariable);
            for (int i = 0; i < this.variables.length; ++i) {
                TypeVariable<?> typeVariable3 = SerializableTypeWrapper.unwrap(this.variables[i]);
                if (!ObjectUtils.nullSafeEquals(typeVariable3, typeVariable2)) continue;
                return this.generics[i];
            }
            return null;
        }

        @Override
        public Object getSource() {
            return this.generics;
        }
    }

    private static class DefaultVariableResolver
    implements VariableResolver {
        private final ResolvableType source;

        DefaultVariableResolver(ResolvableType resolvableType) {
            this.source = resolvableType;
        }

        @Override
        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> typeVariable) {
            return this.source.resolveVariable(typeVariable);
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    static interface VariableResolver
    extends Serializable {
        public Object getSource();

        @Nullable
        public ResolvableType resolveVariable(TypeVariable<?> var1);
    }
}

