/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveTypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReactiveAdapter {
    private final ReactiveTypeDescriptor descriptor;
    private final Function<Object, Publisher<?>> toPublisherFunction;
    private final Function<Publisher<?>, Object> fromPublisherFunction;

    public ReactiveAdapter(ReactiveTypeDescriptor reactiveTypeDescriptor, Function<Object, Publisher<?>> function, Function<Publisher<?>, Object> function2) {
        Assert.notNull((Object)reactiveTypeDescriptor, "'descriptor' is required");
        Assert.notNull(function, "'toPublisherFunction' is required");
        Assert.notNull(function2, "'fromPublisherFunction' is required");
        this.descriptor = reactiveTypeDescriptor;
        this.toPublisherFunction = function;
        this.fromPublisherFunction = function2;
    }

    public ReactiveTypeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Class<?> getReactiveType() {
        return this.getDescriptor().getReactiveType();
    }

    public boolean isMultiValue() {
        return this.getDescriptor().isMultiValue();
    }

    public boolean isNoValue() {
        return this.getDescriptor().isNoValue();
    }

    public boolean supportsEmpty() {
        return this.getDescriptor().supportsEmpty();
    }

    public <T> Publisher<T> toPublisher(@Nullable Object object) {
        if (object == null) {
            object = this.getDescriptor().getEmptyValue();
        }
        return this.toPublisherFunction.apply(object);
    }

    public Object fromPublisher(Publisher<?> publisher) {
        return this.fromPublisherFunction.apply(publisher);
    }
}

