/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import org.springframework.lang.Nullable;

public abstract class NestedExceptionUtils {
    @Nullable
    public static String buildMessage(@Nullable String string, @Nullable Throwable throwable) {
        if (throwable == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        if (string != null) {
            stringBuilder.append(string).append("; ");
        }
        stringBuilder.append("nested exception is ").append(throwable);
        return stringBuilder.toString();
    }

    @Nullable
    public static Throwable getRootCause(@Nullable Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = null;
        for (Throwable throwable3 = throwable.getCause(); throwable3 != null && throwable3 != throwable2; throwable3 = throwable3.getCause()) {
            throwable2 = throwable3;
        }
        return throwable2;
    }

    public static Throwable getMostSpecificCause(Throwable throwable) {
        Throwable throwable2 = NestedExceptionUtils.getRootCause(throwable);
        return throwable2 != null ? throwable2 : throwable;
    }
}

