/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.springframework.util.Assert;

public class ExceptionDepthComparator
implements Comparator<Class<? extends Throwable>> {
    private final Class<? extends Throwable> targetException;

    public ExceptionDepthComparator(Throwable throwable) {
        Assert.notNull((Object)throwable, "Target exception must not be null");
        this.targetException = throwable.getClass();
    }

    public ExceptionDepthComparator(Class<? extends Throwable> clazz) {
        Assert.notNull(clazz, "Target exception type must not be null");
        this.targetException = clazz;
    }

    @Override
    public int compare(Class<? extends Throwable> clazz, Class<? extends Throwable> clazz2) {
        int n = this.getDepth(clazz, this.targetException, 0);
        int n2 = this.getDepth(clazz2, this.targetException, 0);
        return n - n2;
    }

    private int getDepth(Class<?> clazz, Class<?> clazz2, int n) {
        if (clazz2.equals(clazz)) {
            return n;
        }
        if (clazz2 == Throwable.class) {
            return Integer.MAX_VALUE;
        }
        return this.getDepth(clazz, clazz2.getSuperclass(), n + 1);
    }

    public static Class<? extends Throwable> findClosestMatch(Collection<Class<? extends Throwable>> collection, Throwable throwable) {
        Assert.notEmpty(collection, "Exception types must not be empty");
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        ArrayList<Class<? extends Throwable>> arrayList = new ArrayList<Class<? extends Throwable>>(collection);
        arrayList.sort(new ExceptionDepthComparator(throwable));
        return (Class)arrayList.get(0);
    }
}

