/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class DecoratingClassLoader
extends ClassLoader {
    private final Set<String> excludedPackages = Collections.newSetFromMap(new ConcurrentHashMap(8));
    private final Set<String> excludedClasses = Collections.newSetFromMap(new ConcurrentHashMap(8));

    public DecoratingClassLoader() {
    }

    public DecoratingClassLoader(@Nullable ClassLoader classLoader) {
        super(classLoader);
    }

    public void excludePackage(String string) {
        Assert.notNull((Object)string, "Package name must not be null");
        this.excludedPackages.add(string);
    }

    public void excludeClass(String string) {
        Assert.notNull((Object)string, "Class name must not be null");
        this.excludedClasses.add(string);
    }

    protected boolean isExcluded(String string) {
        if (this.excludedClasses.contains(string)) {
            return true;
        }
        for (String string2 : this.excludedPackages) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

