/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.util;

abstract class SorterTemplate {
    private static final int MERGESORT_THRESHOLD = 12;
    private static final int QUICKSORT_THRESHOLD = 7;

    SorterTemplate() {
    }

    protected abstract void swap(int var1, int var2);

    protected abstract int compare(int var1, int var2);

    protected void quickSort(int n, int n2) {
        this.quickSortHelper(n, n2);
        this.insertionSort(n, n2);
    }

    private void quickSortHelper(int n, int n2) {
        int n3;
        while ((n3 = n2 - n) > 7) {
            int n4 = (n2 + n) / 2;
            if (this.compare(n, n4) > 0) {
                this.swap(n, n4);
            }
            if (this.compare(n, n2) > 0) {
                this.swap(n, n2);
            }
            if (this.compare(n4, n2) > 0) {
                this.swap(n4, n2);
            }
            int n5 = n2 - 1;
            this.swap(n4, n5);
            n4 = n;
            int n6 = n5;
            while (true) {
                if (this.compare(++n4, n6) < 0) {
                    continue;
                }
                while (this.compare(--n5, n6) > 0) {
                }
                if (n5 < n4) break;
                this.swap(n4, n5);
            }
            this.swap(n4, n2 - 1);
            if (n5 - n <= n2 - n4 + 1) {
                this.quickSortHelper(n, n5);
                n = n4 + 1;
                continue;
            }
            this.quickSortHelper(n4 + 1, n2);
            n2 = n5;
        }
    }

    private void insertionSort(int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            for (int j = i; j > n && this.compare(j - 1, j) > 0; --j) {
                this.swap(j - 1, j);
            }
        }
    }

    protected void mergeSort(int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 12) {
            this.insertionSort(n, n2);
            return;
        }
        int n4 = n + n3 / 2;
        this.mergeSort(n, n4);
        this.mergeSort(n4, n2);
        this.merge(n, n4, n2, n4 - n, n2 - n4);
    }

    private void merge(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        if (n4 == 0 || n5 == 0) {
            return;
        }
        if (n4 + n5 == 2) {
            if (this.compare(n2, n) < 0) {
                this.swap(n2, n);
            }
            return;
        }
        if (n4 > n5) {
            n9 = n4 / 2;
            n8 = n + n9;
            n7 = this.lower(n2, n3, n8);
            n6 = n7 - n2;
        } else {
            n6 = n5 / 2;
            n7 = n2 + n6;
            n8 = this.upper(n, n2, n7);
            n9 = n8 - n;
        }
        this.rotate(n8, n2, n7);
        int n10 = n8 + n6;
        this.merge(n, n8, n10, n9, n6);
        this.merge(n10, n7, n3, n4 - n9, n5 - n6);
    }

    private void rotate(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2 - 1;
        while (n4 < n5) {
            this.swap(n4++, n5--);
        }
        n4 = n2;
        n5 = n3 - 1;
        while (n4 < n5) {
            this.swap(n4++, n5--);
        }
        n4 = n;
        n5 = n3 - 1;
        while (n4 < n5) {
            this.swap(n4++, n5--);
        }
    }

    private int lower(int n, int n2, int n3) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (this.compare(n6, n3) < 0) {
                n = n6 + 1;
                n4 = n4 - n5 - 1;
                continue;
            }
            n4 = n5;
        }
        return n;
    }

    private int upper(int n, int n2, int n3) {
        int n4 = n2 - n;
        while (n4 > 0) {
            int n5 = n4 / 2;
            int n6 = n + n5;
            if (this.compare(n3, n6) < 0) {
                n4 = n5;
                continue;
            }
            n = n6 + 1;
            n4 = n4 - n5 - 1;
        }
        return n;
    }
}

