/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.transform.impl;

import org.springframework.asm.Type;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.transform.ClassEmitterTransformer;

public class AccessFieldTransformer
extends ClassEmitterTransformer {
    private Callback callback;

    public AccessFieldTransformer(Callback callback) {
        this.callback = callback;
    }

    @Override
    public void declare_field(int n, String string, Type type, Object object) {
        super.declare_field(n, string, type, object);
        String string2 = TypeUtils.upperFirst(this.callback.getPropertyName(this.getClassType(), string));
        if (string2 != null) {
            CodeEmitter codeEmitter = this.begin_method(1, new Signature("get" + string2, type, Constants.TYPES_EMPTY), null);
            codeEmitter.load_this();
            codeEmitter.getfield(string);
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = this.begin_method(1, new Signature("set" + string2, Type.VOID_TYPE, new Type[]{type}), null);
            codeEmitter.load_this();
            codeEmitter.load_arg(0);
            codeEmitter.putfield(string);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
    }

    public static interface Callback {
        public String getPropertyName(Type var1, String var2);
    }
}

