/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.reflect;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.AbstractClassGenerator;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ProcessArrayCallback;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.TypeUtils;

public abstract class MulticastDelegate
implements Cloneable {
    protected Object[] targets = new Object[0];

    protected MulticastDelegate() {
    }

    public List getTargets() {
        return new ArrayList<Object>(Arrays.asList(this.targets));
    }

    public abstract MulticastDelegate add(Object var1);

    protected MulticastDelegate addHelper(Object object) {
        MulticastDelegate multicastDelegate = this.newInstance();
        multicastDelegate.targets = new Object[this.targets.length + 1];
        System.arraycopy(this.targets, 0, multicastDelegate.targets, 0, this.targets.length);
        multicastDelegate.targets[this.targets.length] = object;
        return multicastDelegate;
    }

    public MulticastDelegate remove(Object object) {
        for (int i = this.targets.length - 1; i >= 0; --i) {
            if (!this.targets[i].equals(object)) continue;
            MulticastDelegate multicastDelegate = this.newInstance();
            multicastDelegate.targets = new Object[this.targets.length - 1];
            System.arraycopy(this.targets, 0, multicastDelegate.targets, 0, i);
            System.arraycopy(this.targets, i + 1, multicastDelegate.targets, i, this.targets.length - i - 1);
            return multicastDelegate;
        }
        return this;
    }

    public abstract MulticastDelegate newInstance();

    public static MulticastDelegate create(Class clazz) {
        Generator generator = new Generator();
        generator.setInterface(clazz);
        return generator.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(MulticastDelegate.class.getName());
        private static final Type MULTICAST_DELEGATE = TypeUtils.parseType("org.springframework.cglib.reflect.MulticastDelegate");
        private static final Signature NEW_INSTANCE = new Signature("newInstance", MULTICAST_DELEGATE, new Type[0]);
        private static final Signature ADD_DELEGATE = new Signature("add", MULTICAST_DELEGATE, new Type[]{Constants.TYPE_OBJECT});
        private static final Signature ADD_HELPER = new Signature("addHelper", MULTICAST_DELEGATE, new Type[]{Constants.TYPE_OBJECT});
        private Class iface;

        public Generator() {
            super(SOURCE);
        }

        @Override
        protected ClassLoader getDefaultClassLoader() {
            return this.iface.getClassLoader();
        }

        @Override
        protected ProtectionDomain getProtectionDomain() {
            return ReflectUtils.getProtectionDomain(this.iface);
        }

        public void setInterface(Class clazz) {
            this.iface = clazz;
        }

        public MulticastDelegate create() {
            this.setNamePrefix(MulticastDelegate.class.getName());
            return (MulticastDelegate)super.create(this.iface.getName());
        }

        @Override
        public void generateClass(ClassVisitor classVisitor) {
            MethodInfo methodInfo = ReflectUtils.getMethodInfo(ReflectUtils.findInterfaceMethod(this.iface));
            ClassEmitter classEmitter = new ClassEmitter(classVisitor);
            classEmitter.begin_class(52, 1, this.getClassName(), MULTICAST_DELEGATE, new Type[]{Type.getType(this.iface)}, "<generated>");
            EmitUtils.null_constructor(classEmitter);
            this.emitProxy(classEmitter, methodInfo);
            CodeEmitter codeEmitter = classEmitter.begin_method(1, NEW_INSTANCE, null);
            codeEmitter.new_instance_this();
            codeEmitter.dup();
            codeEmitter.invoke_constructor_this();
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = classEmitter.begin_method(1, ADD_DELEGATE, null);
            codeEmitter.load_this();
            codeEmitter.load_arg(0);
            codeEmitter.checkcast(Type.getType(this.iface));
            codeEmitter.invoke_virtual_this(ADD_HELPER);
            codeEmitter.return_value();
            codeEmitter.end_method();
            classEmitter.end_class();
        }

        private void emitProxy(ClassEmitter classEmitter, final MethodInfo methodInfo) {
            int n = 1;
            if ((methodInfo.getModifiers() & 0x80) == 128) {
                n |= 0x80;
            }
            final CodeEmitter codeEmitter = EmitUtils.begin_method(classEmitter, methodInfo, n);
            Type type = methodInfo.getSignature().getReturnType();
            final boolean bl = type != Type.VOID_TYPE;
            Local local = null;
            if (bl) {
                local = codeEmitter.make_local(type);
                codeEmitter.zero_or_null(type);
                codeEmitter.store_local(local);
            }
            codeEmitter.load_this();
            codeEmitter.super_getfield("targets", Constants.TYPE_OBJECT_ARRAY);
            final Local local2 = local;
            EmitUtils.process_array(codeEmitter, Constants.TYPE_OBJECT_ARRAY, new ProcessArrayCallback(){

                @Override
                public void processElement(Type type) {
                    codeEmitter.checkcast(Type.getType(iface));
                    codeEmitter.load_args();
                    codeEmitter.invoke(methodInfo);
                    if (bl) {
                        codeEmitter.store_local(local2);
                    }
                }
            });
            if (bl) {
                codeEmitter.load_local(local);
            }
            codeEmitter.return_value();
            codeEmitter.end_method();
        }

        @Override
        protected Object firstInstance(Class clazz) {
            return ((MulticastDelegate)ReflectUtils.newInstance(clazz)).newInstance();
        }

        @Override
        protected Object nextInstance(Object object) {
            return ((MulticastDelegate)object).newInstance();
        }
    }
}

