/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.InvocationHandler;
import org.springframework.cglib.proxy.NoOp;

public class Proxy
implements Serializable {
    protected InvocationHandler h;
    private static final CallbackFilter BAD_OBJECT_METHOD_FILTER = new CallbackFilter(){

        @Override
        public int accept(Method method) {
            String string;
            if (method.getDeclaringClass().getName().equals("java.lang.Object") && !(string = method.getName()).equals("hashCode") && !string.equals("equals") && !string.equals("toString")) {
                return 1;
            }
            return 0;
        }
    };

    protected Proxy(InvocationHandler invocationHandler) {
        Enhancer.registerCallbacks(this.getClass(), new Callback[]{invocationHandler, null});
        this.h = invocationHandler;
    }

    public static InvocationHandler getInvocationHandler(Object object) {
        if (!(object instanceof ProxyImpl)) {
            throw new IllegalArgumentException("Object is not a proxy");
        }
        return ((Proxy)object).h;
    }

    public static Class getProxyClass(ClassLoader classLoader, Class[] classArray) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(ProxyImpl.class);
        enhancer.setInterfaces(classArray);
        enhancer.setCallbackTypes(new Class[]{InvocationHandler.class, NoOp.class});
        enhancer.setCallbackFilter(BAD_OBJECT_METHOD_FILTER);
        enhancer.setUseFactory(false);
        return enhancer.createClass();
    }

    public static boolean isProxyClass(Class clazz) {
        return clazz.getSuperclass().equals(ProxyImpl.class);
    }

    public static Object newProxyInstance(ClassLoader classLoader, Class[] classArray, InvocationHandler invocationHandler) {
        try {
            Class clazz = Proxy.getProxyClass(classLoader, classArray);
            return clazz.getConstructor(InvocationHandler.class).newInstance(invocationHandler);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    private static class ProxyImpl
    extends Proxy {
        protected ProxyImpl(InvocationHandler invocationHandler) {
            super(invocationHandler);
        }
    }
}

