/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.asm.Label;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ClassEmitter;
import org.springframework.cglib.core.ClassInfo;
import org.springframework.cglib.core.CodeEmitter;
import org.springframework.cglib.core.CollectionUtils;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.EmitUtils;
import org.springframework.cglib.core.Local;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.ObjectSwitchCallback;
import org.springframework.cglib.core.Signature;
import org.springframework.cglib.core.Transformer;
import org.springframework.cglib.core.TypeUtils;
import org.springframework.cglib.proxy.CallbackGenerator;

class MethodInterceptorGenerator
implements CallbackGenerator {
    public static final MethodInterceptorGenerator INSTANCE = new MethodInterceptorGenerator();
    static final String EMPTY_ARGS_NAME = "CGLIB$emptyArgs";
    static final String FIND_PROXY_NAME = "CGLIB$findMethodProxy";
    static final Class[] FIND_PROXY_TYPES = new Class[]{Signature.class};
    private static final Type ABSTRACT_METHOD_ERROR = TypeUtils.parseType("AbstractMethodError");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Type REFLECT_UTILS = TypeUtils.parseType("org.springframework.cglib.core.ReflectUtils");
    private static final Type METHOD_PROXY = TypeUtils.parseType("org.springframework.cglib.proxy.MethodProxy");
    private static final Type METHOD_INTERCEPTOR = TypeUtils.parseType("org.springframework.cglib.proxy.MethodInterceptor");
    private static final Signature GET_DECLARED_METHODS = TypeUtils.parseSignature("java.lang.reflect.Method[] getDeclaredMethods()");
    private static final Signature GET_DECLARING_CLASS = TypeUtils.parseSignature("Class getDeclaringClass()");
    private static final Signature FIND_METHODS = TypeUtils.parseSignature("java.lang.reflect.Method[] findMethods(String[], java.lang.reflect.Method[])");
    private static final Signature MAKE_PROXY = new Signature("create", METHOD_PROXY, new Type[]{Constants.TYPE_CLASS, Constants.TYPE_CLASS, Constants.TYPE_STRING, Constants.TYPE_STRING, Constants.TYPE_STRING});
    private static final Signature INTERCEPT = new Signature("intercept", Constants.TYPE_OBJECT, new Type[]{Constants.TYPE_OBJECT, METHOD, Constants.TYPE_OBJECT_ARRAY, METHOD_PROXY});
    private static final Signature FIND_PROXY = new Signature("CGLIB$findMethodProxy", METHOD_PROXY, new Type[]{Constants.TYPE_SIGNATURE});
    private static final Signature TO_STRING = TypeUtils.parseSignature("String toString()");
    private static final Transformer METHOD_TO_CLASS = new Transformer(){

        @Override
        public Object transform(Object object) {
            return ((MethodInfo)object).getClassInfo();
        }
    };
    private static final Signature CSTRUCT_SIGNATURE = TypeUtils.parseConstructor("String, String");

    MethodInterceptorGenerator() {
    }

    private String getMethodField(Signature signature) {
        return signature.getName() + "$Method";
    }

    private String getMethodProxyField(Signature signature) {
        return signature.getName() + "$Proxy";
    }

    @Override
    public void generate(ClassEmitter classEmitter, CallbackGenerator.Context context, List list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (MethodInfo methodInfo : list) {
            Signature signature = methodInfo.getSignature();
            Signature signature2 = context.getImplSignature(methodInfo);
            String string = this.getMethodField(signature2);
            String string2 = this.getMethodProxyField(signature2);
            hashMap.put(signature.toString(), string2);
            classEmitter.declare_field(26, string, METHOD, null);
            classEmitter.declare_field(26, string2, METHOD_PROXY, null);
            classEmitter.declare_field(26, EMPTY_ARGS_NAME, Constants.TYPE_OBJECT_ARRAY, null);
            CodeEmitter codeEmitter = classEmitter.begin_method(16, signature2, methodInfo.getExceptionTypes());
            MethodInterceptorGenerator.superHelper(codeEmitter, methodInfo, context);
            codeEmitter.return_value();
            codeEmitter.end_method();
            codeEmitter = context.beginMethod(classEmitter, methodInfo);
            Label label = codeEmitter.make_label();
            context.emitCallback(codeEmitter, context.getIndex(methodInfo));
            codeEmitter.dup();
            codeEmitter.ifnull(label);
            codeEmitter.load_this();
            codeEmitter.getfield(string);
            if (signature.getArgumentTypes().length == 0) {
                codeEmitter.getfield(EMPTY_ARGS_NAME);
            } else {
                codeEmitter.create_arg_array();
            }
            codeEmitter.getfield(string2);
            codeEmitter.invoke_interface(METHOD_INTERCEPTOR, INTERCEPT);
            codeEmitter.unbox_or_zero(signature.getReturnType());
            codeEmitter.return_value();
            codeEmitter.mark(label);
            MethodInterceptorGenerator.superHelper(codeEmitter, methodInfo, context);
            codeEmitter.return_value();
            codeEmitter.end_method();
        }
        this.generateFindProxy(classEmitter, hashMap);
    }

    private static void superHelper(CodeEmitter codeEmitter, MethodInfo methodInfo, CallbackGenerator.Context context) {
        if (TypeUtils.isAbstract(methodInfo.getModifiers())) {
            codeEmitter.throw_exception(ABSTRACT_METHOD_ERROR, methodInfo.toString() + " is abstract");
        } else {
            codeEmitter.load_this();
            context.emitLoadArgsAndInvoke(codeEmitter, methodInfo);
        }
    }

    @Override
    public void generateStatic(CodeEmitter codeEmitter, CallbackGenerator.Context context, List list) throws Exception {
        codeEmitter.push(0);
        codeEmitter.newarray();
        codeEmitter.putfield(EMPTY_ARGS_NAME);
        Local local = codeEmitter.make_local();
        Local local2 = codeEmitter.make_local();
        EmitUtils.load_class_this(codeEmitter);
        codeEmitter.store_local(local);
        Map map = CollectionUtils.bucket(list, METHOD_TO_CLASS);
        for (ClassInfo classInfo : map.keySet()) {
            Signature signature;
            MethodInfo methodInfo;
            int n;
            List list2 = (List)map.get(classInfo);
            codeEmitter.push(2 * list2.size());
            codeEmitter.newarray(Constants.TYPE_STRING);
            for (n = 0; n < list2.size(); ++n) {
                methodInfo = (MethodInfo)list2.get(n);
                signature = methodInfo.getSignature();
                codeEmitter.dup();
                codeEmitter.push(2 * n);
                codeEmitter.push(signature.getName());
                codeEmitter.aastore();
                codeEmitter.dup();
                codeEmitter.push(2 * n + 1);
                codeEmitter.push(signature.getDescriptor());
                codeEmitter.aastore();
            }
            EmitUtils.load_class(codeEmitter, classInfo.getType());
            codeEmitter.dup();
            codeEmitter.store_local(local2);
            codeEmitter.invoke_virtual(Constants.TYPE_CLASS, GET_DECLARED_METHODS);
            codeEmitter.invoke_static(REFLECT_UTILS, FIND_METHODS);
            for (n = 0; n < list2.size(); ++n) {
                methodInfo = (MethodInfo)list2.get(n);
                signature = methodInfo.getSignature();
                Signature signature2 = context.getImplSignature(methodInfo);
                codeEmitter.dup();
                codeEmitter.push(n);
                codeEmitter.array_load(METHOD);
                codeEmitter.putfield(this.getMethodField(signature2));
                codeEmitter.load_local(local2);
                codeEmitter.load_local(local);
                codeEmitter.push(signature.getDescriptor());
                codeEmitter.push(signature.getName());
                codeEmitter.push(signature2.getName());
                codeEmitter.invoke_static(METHOD_PROXY, MAKE_PROXY);
                codeEmitter.putfield(this.getMethodProxyField(signature2));
            }
            codeEmitter.pop();
        }
    }

    public void generateFindProxy(ClassEmitter classEmitter, final Map map) {
        final CodeEmitter codeEmitter = classEmitter.begin_method(9, FIND_PROXY, null);
        codeEmitter.load_arg(0);
        codeEmitter.invoke_virtual(Constants.TYPE_OBJECT, TO_STRING);
        ObjectSwitchCallback objectSwitchCallback = new ObjectSwitchCallback(){

            @Override
            public void processCase(Object object, Label label) {
                codeEmitter.getfield((String)map.get(object));
                codeEmitter.return_value();
            }

            @Override
            public void processDefault() {
                codeEmitter.aconst_null();
                codeEmitter.return_value();
            }
        };
        EmitUtils.string_switch(codeEmitter, map.keySet().toArray(new String[0]), 1, objectSwitchCallback);
        codeEmitter.end_method();
    }
}

