/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.CallbackFilter;
import org.springframework.cglib.proxy.Enhancer;

public abstract class CallbackHelper
implements CallbackFilter {
    private Map methodMap = new HashMap();
    private List callbacks = new ArrayList();

    public CallbackHelper(Class clazz, Class[] classArray) {
        ArrayList arrayList = new ArrayList();
        Enhancer.getMethods(clazz, classArray, arrayList);
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Method method = (Method)arrayList.get(i);
            Object object = this.getCallback(method);
            if (object == null) {
                throw new IllegalStateException("getCallback cannot return null");
            }
            boolean bl = object instanceof Callback;
            if (!bl && !(object instanceof Class)) {
                throw new IllegalStateException("getCallback must return a Callback or a Class");
            }
            if (i > 0 && this.callbacks.get(i - 1) instanceof Callback ^ bl) {
                throw new IllegalStateException("getCallback must return a Callback or a Class consistently for every Method");
            }
            Integer n2 = (Integer)hashMap.get(object);
            if (n2 == null) {
                n2 = new Integer(this.callbacks.size());
                hashMap.put(object, n2);
            }
            this.methodMap.put(method, n2);
            this.callbacks.add(object);
        }
    }

    protected abstract Object getCallback(Method var1);

    public Callback[] getCallbacks() {
        if (this.callbacks.size() == 0) {
            return new Callback[0];
        }
        if (this.callbacks.get(0) instanceof Callback) {
            return this.callbacks.toArray(new Callback[this.callbacks.size()]);
        }
        throw new IllegalStateException("getCallback returned classes, not callbacks; call getCallbackTypes instead");
    }

    public Class[] getCallbackTypes() {
        if (this.callbacks.size() == 0) {
            return new Class[0];
        }
        if (this.callbacks.get(0) instanceof Callback) {
            return ReflectUtils.getClasses(this.getCallbacks());
        }
        return this.callbacks.toArray(new Class[this.callbacks.size()]);
    }

    @Override
    public int accept(Method method) {
        return (Integer)this.methodMap.get(method);
    }

    public int hashCode() {
        return this.methodMap.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof CallbackHelper)) {
            return false;
        }
        return this.methodMap.equals(((CallbackHelper)object).methodMap);
    }
}

