/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.springframework.asm.Type;
import org.springframework.cglib.core.Predicate;
import org.springframework.cglib.core.TypeUtils;

public class VisibilityPredicate
implements Predicate {
    private boolean protectedOk;
    private String pkg;
    private boolean samePackageOk;

    public VisibilityPredicate(Class clazz, boolean bl) {
        this.protectedOk = bl;
        this.samePackageOk = clazz.getClassLoader() != null;
        this.pkg = TypeUtils.getPackageName(Type.getType(clazz));
    }

    @Override
    public boolean evaluate(Object object) {
        Member member = (Member)object;
        int n = member.getModifiers();
        if (Modifier.isPrivate(n)) {
            return false;
        }
        if (Modifier.isPublic(n)) {
            return true;
        }
        if (Modifier.isProtected(n) && this.protectedOk) {
            return true;
        }
        return this.samePackageOk && this.pkg.equals(TypeUtils.getPackageName(Type.getType(member.getDeclaringClass())));
    }
}

