/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.MethodWrapper;
import org.springframework.cglib.core.Predicate;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.cglib.core.Signature;

public class DuplicatesPredicate
implements Predicate {
    private final Set unique;
    private final Set rejected;

    public DuplicatesPredicate() {
        this.unique = new HashSet();
        this.rejected = Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DuplicatesPredicate(List list) {
        GenericDeclaration genericDeclaration;
        Object object4;
        Object object2;
        this.rejected = new HashSet();
        this.unique = new HashSet();
        HashMap hashMap = new HashMap();
        HashMap<Object, Method> hashMap2 = new HashMap<Object, Method>();
        for (Object object3 : list) {
            object2 = (Method)object3;
            object4 = MethodWrapper.create((Method)object2);
            genericDeclaration = (Method)hashMap.get(object4);
            if (genericDeclaration == null) {
                hashMap.put(object4, object2);
                continue;
            }
            if (hashMap2.containsKey(object4) || !((Method)genericDeclaration).isBridge() || ((Method)object2).isBridge()) continue;
            hashMap2.put(object4, (Method)genericDeclaration);
        }
        if (!hashMap2.isEmpty()) {
            Object object3;
            HashSet hashSet = new HashSet();
            object3 = new UnnecessaryBridgeFinder(this.rejected);
            for (Object object4 : hashMap2.values()) {
                genericDeclaration = (Method)object4;
                hashSet.add(((Method)genericDeclaration).getDeclaringClass());
                ((UnnecessaryBridgeFinder)object3).addSuspectMethod((Method)genericDeclaration);
            }
            object2 = hashSet.iterator();
            while (object2.hasNext()) {
                object4 = object2.next();
                genericDeclaration = (Class)object4;
                try {
                    InputStream inputStream2;
                    ClassLoader classLoader = DuplicatesPredicate.getClassLoader((Class)genericDeclaration);
                    if (classLoader == null || (inputStream2 = classLoader.getResourceAsStream(((Class)genericDeclaration).getName().replace('.', '/') + ".class")) == null) continue;
                    try {
                        new ClassReader(inputStream2).accept((ClassVisitor)object3, 6);
                    }
                    finally {
                        inputStream2.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean evaluate(Object object) {
        return !this.rejected.contains(object) && this.unique.add(MethodWrapper.create((Method)object));
    }

    private static ClassLoader getClassLoader(Class clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = DuplicatesPredicate.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    private static class UnnecessaryBridgeFinder
    extends ClassVisitor {
        private final Set rejected;
        private Signature currentMethodSig = null;
        private Map methods = new HashMap();

        UnnecessaryBridgeFinder(Set set) {
            super(Constants.ASM_API);
            this.rejected = set;
        }

        void addSuspectMethod(Method method) {
            this.methods.put(ReflectUtils.getSignature(method), method);
        }

        @Override
        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        }

        @Override
        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            Signature signature = new Signature(string, string2);
            final Method method = (Method)this.methods.remove(signature);
            if (method != null) {
                this.currentMethodSig = signature;
                return new MethodVisitor(Constants.ASM_API){

                    @Override
                    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
                        if (n == 183 && currentMethodSig != null) {
                            Signature signature = new Signature(string2, string3);
                            if (signature.equals(currentMethodSig)) {
                                rejected.add(method);
                            }
                            currentMethodSig = null;
                        }
                    }
                };
            }
            return null;
        }
    }
}

