/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.cglib.core.ClassGenerator;
import org.springframework.cglib.core.CodeGenerationException;
import org.springframework.cglib.core.DefaultGeneratorStrategy;
import org.springframework.cglib.core.DefaultNamingPolicy;
import org.springframework.cglib.core.GeneratorStrategy;
import org.springframework.cglib.core.NamingPolicy;
import org.springframework.cglib.core.Predicate;
import org.springframework.cglib.core.internal.Function;
import org.springframework.cglib.core.internal.LoadingCache;

public abstract class AbstractClassGenerator<T>
implements ClassGenerator {
    private static final ThreadLocal CURRENT = new ThreadLocal();
    private static volatile Map<ClassLoader, ClassLoaderData> CACHE = new WeakHashMap<ClassLoader, ClassLoaderData>();
    private static final boolean DEFAULT_USE_CACHE = Boolean.parseBoolean(System.getProperty("cglib.useCache", "true"));
    private GeneratorStrategy strategy = DefaultGeneratorStrategy.INSTANCE;
    private NamingPolicy namingPolicy = DefaultNamingPolicy.INSTANCE;
    private Source source;
    private ClassLoader classLoader;
    private Class contextClass;
    private String namePrefix;
    private Object key;
    private boolean useCache = DEFAULT_USE_CACHE;
    private String className;
    private boolean attemptLoad;

    protected T wrapCachedClass(Class clazz) {
        return (T)new WeakReference<Class>(clazz);
    }

    protected Object unwrapCachedValue(T t2) {
        return ((WeakReference)t2).get();
    }

    protected AbstractClassGenerator(Source source2) {
        this.source = source2;
    }

    protected void setNamePrefix(String string) {
        this.namePrefix = string;
    }

    protected final String getClassName() {
        return this.className;
    }

    private void setClassName(String string) {
        this.className = string;
    }

    private String generateClassName(Predicate predicate) {
        return this.namingPolicy.getClassName(this.namePrefix, this.source.name, this.key, predicate);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setContextClass(Class clazz) {
        this.contextClass = clazz;
    }

    public void setNamingPolicy(NamingPolicy namingPolicy) {
        if (namingPolicy == null) {
            namingPolicy = DefaultNamingPolicy.INSTANCE;
        }
        this.namingPolicy = namingPolicy;
    }

    public NamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }

    public void setUseCache(boolean bl) {
        this.useCache = bl;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public void setAttemptLoad(boolean bl) {
        this.attemptLoad = bl;
    }

    public boolean getAttemptLoad() {
        return this.attemptLoad;
    }

    public void setStrategy(GeneratorStrategy generatorStrategy) {
        if (generatorStrategy == null) {
            generatorStrategy = DefaultGeneratorStrategy.INSTANCE;
        }
        this.strategy = generatorStrategy;
    }

    public GeneratorStrategy getStrategy() {
        return this.strategy;
    }

    public static AbstractClassGenerator getCurrent() {
        return (AbstractClassGenerator)CURRENT.get();
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) {
            classLoader = this.getDefaultClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            throw new IllegalStateException("Cannot determine classloader");
        }
        return classLoader;
    }

    protected abstract ClassLoader getDefaultClassLoader();

    protected ProtectionDomain getProtectionDomain() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Object create(Object object) {
        try {
            Object object2;
            ClassLoader classLoader = this.getClassLoader();
            Map<ClassLoader, ClassLoaderData> map = CACHE;
            ClassLoaderData classLoaderData = map.get(classLoader);
            if (classLoaderData == null) {
                object2 = AbstractClassGenerator.class;
                // MONITORENTER : org.springframework.cglib.core.AbstractClassGenerator.class
                map = CACHE;
                classLoaderData = map.get(classLoader);
                if (classLoaderData == null) {
                    WeakHashMap<ClassLoader, ClassLoaderData> weakHashMap = new WeakHashMap<ClassLoader, ClassLoaderData>(map);
                    classLoaderData = new ClassLoaderData(classLoader);
                    weakHashMap.put(classLoader, classLoaderData);
                    CACHE = weakHashMap;
                }
                // MONITOREXIT : object2
            }
            this.key = object;
            object2 = classLoaderData.get(this, this.getUseCache());
            if (!(object2 instanceof Class)) return this.nextInstance(object2);
            return this.firstInstance((Class)object2);
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        catch (Exception exception) {
            throw new CodeGenerationException(exception);
        }
    }

    /*
     * Exception decompiling
     */
    protected Class generate(ClassLoaderData var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract Object firstInstance(Class var1) throws Exception;

    protected abstract Object nextInstance(Object var1) throws Exception;

    protected static class Source {
        String name;

        public Source(String string) {
            this.name = string;
        }
    }

    protected static class ClassLoaderData {
        private final Set<String> reservedClassNames = new HashSet<String>();
        private final LoadingCache<AbstractClassGenerator, Object, Object> generatedClasses;
        private final WeakReference<ClassLoader> classLoader;
        private final Predicate uniqueNamePredicate = new Predicate(){

            @Override
            public boolean evaluate(Object object) {
                return reservedClassNames.contains(object);
            }
        };
        private static final Function<AbstractClassGenerator, Object> GET_KEY = new Function<AbstractClassGenerator, Object>(){

            @Override
            public Object apply(AbstractClassGenerator abstractClassGenerator) {
                return abstractClassGenerator.key;
            }
        };

        public ClassLoaderData(ClassLoader classLoader) {
            if (classLoader == null) {
                throw new IllegalArgumentException("classLoader == null is not yet supported");
            }
            this.classLoader = new WeakReference<ClassLoader>(classLoader);
            Function<AbstractClassGenerator, Object> function = new Function<AbstractClassGenerator, Object>(){

                @Override
                public Object apply(AbstractClassGenerator abstractClassGenerator) {
                    Class clazz = abstractClassGenerator.generate(this);
                    return abstractClassGenerator.wrapCachedClass(clazz);
                }
            };
            this.generatedClasses = new LoadingCache<AbstractClassGenerator, Object, Object>(GET_KEY, function);
        }

        public ClassLoader getClassLoader() {
            return (ClassLoader)this.classLoader.get();
        }

        public void reserveName(String string) {
            this.reservedClassNames.add(string);
        }

        public Predicate getUniqueNamePredicate() {
            return this.uniqueNamePredicate;
        }

        public Object get(AbstractClassGenerator abstractClassGenerator, boolean bl) {
            if (!bl) {
                return abstractClassGenerator.generate(this);
            }
            Object object = this.generatedClasses.get(abstractClassGenerator);
            return abstractClassGenerator.unwrapCachedValue(object);
        }
    }
}

