/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.asm;

public class ByteVector {
    byte[] data;
    int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(int n) {
        this.data = new byte[n];
    }

    ByteVector(byte[] byArray) {
        this.data = byArray;
        this.length = byArray.length;
    }

    public ByteVector putByte(int n) {
        int n2 = this.length;
        if (n2 + 1 > this.data.length) {
            this.enlarge(1);
        }
        this.data[n2++] = (byte)n;
        this.length = n2;
        return this;
    }

    final ByteVector put11(int n, int n2) {
        int n3 = this.length;
        if (n3 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)n;
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    public ByteVector putShort(int n) {
        int n2 = this.length;
        if (n2 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)n;
        this.length = n2;
        return this;
    }

    final ByteVector put12(int n, int n2) {
        int n3 = this.length;
        if (n3 + 3 > this.data.length) {
            this.enlarge(3);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)n;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    final ByteVector put112(int n, int n2, int n3) {
        int n4 = this.length;
        if (n4 + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] byArray = this.data;
        byArray[n4++] = (byte)n;
        byArray[n4++] = (byte)n2;
        byArray[n4++] = (byte)(n3 >>> 8);
        byArray[n4++] = (byte)n3;
        this.length = n4;
        return this;
    }

    public ByteVector putInt(int n) {
        int n2 = this.length;
        if (n2 + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] byArray = this.data;
        byArray[n2++] = (byte)(n >>> 24);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)n;
        this.length = n2;
        return this;
    }

    final ByteVector put122(int n, int n2, int n3) {
        int n4 = this.length;
        if (n4 + 5 > this.data.length) {
            this.enlarge(5);
        }
        byte[] byArray = this.data;
        byArray[n4++] = (byte)n;
        byArray[n4++] = (byte)(n2 >>> 8);
        byArray[n4++] = (byte)n2;
        byArray[n4++] = (byte)(n3 >>> 8);
        byArray[n4++] = (byte)n3;
        this.length = n4;
        return this;
    }

    public ByteVector putLong(long l) {
        int n = this.length;
        if (n + 8 > this.data.length) {
            this.enlarge(8);
        }
        byte[] byArray = this.data;
        int n2 = (int)(l >>> 32);
        byArray[n++] = (byte)(n2 >>> 24);
        byArray[n++] = (byte)(n2 >>> 16);
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n++] = (byte)n2;
        n2 = (int)l;
        byArray[n++] = (byte)(n2 >>> 24);
        byArray[n++] = (byte)(n2 >>> 16);
        byArray[n++] = (byte)(n2 >>> 8);
        byArray[n++] = (byte)n2;
        this.length = n;
        return this;
    }

    public ByteVector putUTF8(String string) {
        int n = string.length();
        if (n > 65535) {
            throw new IllegalArgumentException("UTF8 string too large");
        }
        int n2 = this.length;
        if (n2 + 2 + n > this.data.length) {
            this.enlarge(2 + n);
        }
        byte[] byArray = this.data;
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)n;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0001' || c > '\u007f') {
                this.length = n2;
                return this.encodeUtf8(string, i, 65535);
            }
            byArray[n2++] = (byte)c;
        }
        this.length = n2;
        return this;
    }

    final ByteVector encodeUtf8(String string, int n, int n2) {
        int n3;
        int n4;
        int n5 = string.length();
        int n6 = n;
        for (n4 = n; n4 < n5; ++n4) {
            n3 = string.charAt(n4);
            if (n3 >= 1 && n3 <= 127) {
                ++n6;
                continue;
            }
            if (n3 <= 2047) {
                n6 += 2;
                continue;
            }
            n6 += 3;
        }
        if (n6 > n2) {
            throw new IllegalArgumentException("UTF8 string too large");
        }
        n4 = this.length - n - 2;
        if (n4 >= 0) {
            this.data[n4] = (byte)(n6 >>> 8);
            this.data[n4 + 1] = (byte)n6;
        }
        if (this.length + n6 - n > this.data.length) {
            this.enlarge(n6 - n);
        }
        n3 = this.length;
        for (int i = n; i < n5; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.data[n3++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                this.data[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                this.data[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            this.data[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
            this.data[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
            this.data[n3++] = (byte)(0x80 | c & 0x3F);
        }
        this.length = n3;
        return this;
    }

    public ByteVector putByteArray(byte[] byArray, int n, int n2) {
        if (this.length + n2 > this.data.length) {
            this.enlarge(n2);
        }
        if (byArray != null) {
            System.arraycopy(byArray, n, this.data, this.length, n2);
        }
        this.length += n2;
        return this;
    }

    private void enlarge(int n) {
        int n2 = 2 * this.data.length;
        int n3 = this.length + n;
        byte[] byArray = new byte[n2 > n3 ? n2 : n3];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        this.data = byArray;
    }
}

