/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.EncoderException;
import org.bouncycastle.util.encoders.HexEncoder;

public class Hex {
    private static final HexEncoder encoder = new HexEncoder();

    public static String toHexString(byte[] byArray) {
        return Hex.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        byte[] byArray2 = Hex.encode(byArray, n, n2);
        return Strings.fromByteArray(byArray2);
    }

    public static byte[] encode(byte[] byArray) {
        return Hex.encode(byArray, 0, byArray.length);
    }

    public static byte[] encode(byte[] byArray, int n, int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.encode(byArray, n, n2, byteArrayOutputStream);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new EncoderException(new StringBuilder(47).append("exception encoding Hex string: ").append(string).toString(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int encode(byte[] byArray, OutputStream outputStream2) throws IOException {
        return encoder.encode(byArray, 0, byArray.length, outputStream2);
    }

    public static int encode(byte[] byArray, int n, int n2, OutputStream outputStream2) throws IOException {
        return encoder.encode(byArray, n, n2, outputStream2);
    }

    public static byte[] decode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.decode(byArray, 0, byArray.length, byteArrayOutputStream);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            throw new DecoderException(new StringBuilder(45).append("exception decoding Hex data: ").append(string).toString(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decode(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            encoder.decode(string, byteArrayOutputStream);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            throw new DecoderException(new StringBuilder(47).append("exception decoding Hex string: ").append(string2).toString(), exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int decode(String string, OutputStream outputStream2) throws IOException {
        return encoder.decode(string, outputStream2);
    }

    public static byte[] decodeStrict(String string) {
        try {
            return encoder.decodeStrict(string, 0, string.length());
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            throw new DecoderException(new StringBuilder(47).append("exception decoding Hex string: ").append(string2).toString(), exception);
        }
    }

    public static byte[] decodeStrict(String string, int n, int n2) {
        try {
            return encoder.decodeStrict(string, n, n2);
        }
        catch (Exception exception) {
            String string2 = exception.getMessage();
            throw new DecoderException(new StringBuilder(47).append("exception decoding Hex string: ").append(string2).toString(), exception);
        }
    }
}

