/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.LimitedInputStream;
import org.bouncycastle.util.io.Streams;

class DefiniteLengthInputStream
extends LimitedInputStream {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final int _originalLength;
    private int _remaining;

    DefiniteLengthInputStream(InputStream inputStream2, int n, int n2) {
        super(inputStream2, n2);
        if (n < 0) {
            throw new IllegalArgumentException("negative lengths not allowed");
        }
        this._originalLength = n;
        this._remaining = n;
        if (n == 0) {
            this.setParentEofDetect(true);
        }
    }

    int getRemaining() {
        return this._remaining;
    }

    @Override
    public int read() throws IOException {
        if (this._remaining == 0) {
            return -1;
        }
        int n = this._in.read();
        if (n < 0) {
            int n2 = this._remaining;
            int n3 = this._originalLength;
            throw new EOFException(new StringBuilder(64).append("DEF length ").append((Object)n3).append(" object truncated by ").append((Object)n2).toString());
        }
        if (--this._remaining == 0) {
            this.setParentEofDetect(true);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._remaining == 0) {
            return -1;
        }
        int n3 = Math.min(n2, this._remaining);
        int n4 = this._in.read(byArray, n, n3);
        if (n4 < 0) {
            int n5 = this._remaining;
            int n6 = this._originalLength;
            throw new EOFException(new StringBuilder(64).append("DEF length ").append((Object)n6).append(" object truncated by ").append((Object)n5).toString());
        }
        if ((this._remaining -= n4) == 0) {
            this.setParentEofDetect(true);
        }
        return n4;
    }

    void readAllIntoByteArray(byte[] byArray) throws IOException {
        if (this._remaining != byArray.length) {
            throw new IllegalArgumentException("buffer length not right for data");
        }
        if (this._remaining == 0) {
            return;
        }
        int n = this.getLimit();
        if (this._remaining >= n) {
            int n2 = n;
            int n3 = this._remaining;
            throw new IOException(new StringBuilder(83).append("corrupted stream - out of bounds length found: ").append((Object)n3).append(" >= ").append((Object)n2).toString());
        }
        if ((this._remaining -= Streams.readFully(this._in, byArray)) != 0) {
            int n4 = this._remaining;
            int n5 = this._originalLength;
            throw new EOFException(new StringBuilder(64).append("DEF length ").append((Object)n5).append(" object truncated by ").append((Object)n4).toString());
        }
        this.setParentEofDetect(true);
    }

    byte[] toByteArray() throws IOException {
        if (this._remaining == 0) {
            return EMPTY_BYTES;
        }
        int n = this.getLimit();
        if (this._remaining >= n) {
            int n2 = n;
            int n3 = this._remaining;
            throw new IOException(new StringBuilder(83).append("corrupted stream - out of bounds length found: ").append((Object)n3).append(" >= ").append((Object)n2).toString());
        }
        byte[] byArray = new byte[this._remaining];
        if ((this._remaining -= Streams.readFully(this._in, byArray)) != 0) {
            int n4 = this._remaining;
            int n5 = this._originalLength;
            throw new EOFException(new StringBuilder(64).append("DEF length ").append((Object)n5).append(" object truncated by ").append((Object)n4).toString());
        }
        this.setParentEofDetect(true);
        return byArray;
    }
}

