/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.util.Args;

public final class IdleConnectionEvictor {
    private final HttpClientConnectionManager connectionManager;
    private final ThreadFactory threadFactory;
    private final Thread thread;
    private final long sleepTimeMs;
    private final long maxIdleTimeMs;
    private volatile Exception exception;

    public IdleConnectionEvictor(final HttpClientConnectionManager httpClientConnectionManager, ThreadFactory threadFactory2, long l, TimeUnit timeUnit, long l2, TimeUnit timeUnit2) {
        this.connectionManager = Args.notNull(httpClientConnectionManager, "Connection manager");
        this.threadFactory = threadFactory2 != null ? threadFactory2 : new DefaultThreadFactory();
        this.sleepTimeMs = timeUnit != null ? timeUnit.toMillis(l) : l;
        this.maxIdleTimeMs = timeUnit2 != null ? timeUnit2.toMillis(l2) : l2;
        this.thread = this.threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Thread.sleep(IdleConnectionEvictor.this.sleepTimeMs);
                        httpClientConnectionManager.closeExpiredConnections();
                        if (IdleConnectionEvictor.this.maxIdleTimeMs <= 0L) continue;
                        httpClientConnectionManager.closeIdleConnections(IdleConnectionEvictor.this.maxIdleTimeMs, TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception exception) {
                    IdleConnectionEvictor.this.exception = exception;
                }
            }
        });
    }

    public IdleConnectionEvictor(HttpClientConnectionManager httpClientConnectionManager, long l, TimeUnit timeUnit, long l2, TimeUnit timeUnit2) {
        this(httpClientConnectionManager, null, l, timeUnit, l2, timeUnit2);
    }

    public IdleConnectionEvictor(HttpClientConnectionManager httpClientConnectionManager, long l, TimeUnit timeUnit) {
        this(httpClientConnectionManager, null, l > 0L ? l : 5L, timeUnit != null ? timeUnit : TimeUnit.SECONDS, l, timeUnit);
    }

    public void start() {
        this.thread.start();
    }

    public void shutdown() {
        this.thread.interrupt();
    }

    public boolean isRunning() {
        return this.thread.isAlive();
    }

    public void awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        this.thread.join((timeUnit != null ? timeUnit : TimeUnit.MILLISECONDS).toMillis(l));
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        DefaultThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable2) {
            Thread thread2 = new Thread(runnable2, "Connection evictor");
            thread2.setDaemon(true);
            return thread2;
        }
    }
}

