/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.util.Args;

public class InputStreamBody
extends AbstractContentBody {
    private final InputStream in;
    private final String filename;

    @Deprecated
    public InputStreamBody(InputStream inputStream2, String string, String string2) {
        this(inputStream2, ContentType.create(string), string2);
    }

    public InputStreamBody(InputStream inputStream2, String string) {
        this(inputStream2, ContentType.DEFAULT_BINARY, string);
    }

    public InputStreamBody(InputStream inputStream2, ContentType contentType, String string) {
        super(contentType);
        Args.notNull(inputStream2, "Input stream");
        this.in = inputStream2;
        this.filename = string;
    }

    public InputStreamBody(InputStream inputStream2, ContentType contentType) {
        this(inputStream2, contentType, null);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outputStream2) throws IOException {
        Args.notNull(outputStream2, "Output stream");
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = this.in.read(byArray)) != -1) {
                outputStream2.write(byArray, 0, n);
            }
            outputStream2.flush();
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

