/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.Serializable;
import java.util.logging.LogRecord;
import org.apache.commons.logging.Log;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

final class LogAdapter {
    private static final String LOG4J_SPI = "org.apache.logging.log4j.spi.ExtendedLogger";
    private static final String LOG4J_SLF4J_PROVIDER = "org.apache.logging.slf4j.SLF4JProvider";
    private static final String SLF4J_SPI = "org.slf4j.spi.LocationAwareLogger";
    private static final String SLF4J_API = "org.slf4j.Logger";
    private static final LogApi logApi = LogAdapter.isPresent("org.apache.logging.log4j.spi.ExtendedLogger") ? (LogAdapter.isPresent("org.apache.logging.slf4j.SLF4JProvider") && LogAdapter.isPresent("org.slf4j.spi.LocationAwareLogger") ? LogApi.SLF4J_LAL : LogApi.LOG4J) : (LogAdapter.isPresent("org.slf4j.spi.LocationAwareLogger") ? LogApi.SLF4J_LAL : (LogAdapter.isPresent("org.slf4j.Logger") ? LogApi.SLF4J : LogApi.JUL));

    private LogAdapter() {
    }

    public static Log createLog(String string) {
        switch (logApi) {
            case LOG4J: {
                return Log4jAdapter.createLog(string);
            }
            case SLF4J_LAL: {
                return Slf4jAdapter.createLocationAwareLog(string);
            }
            case SLF4J: {
                return Slf4jAdapter.createLog(string);
            }
        }
        return JavaUtilAdapter.createLog(string);
    }

    private static boolean isPresent(String string) {
        try {
            Class.forName(string, false, LogAdapter.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static class LocationResolvingLogRecord
    extends LogRecord {
        private static final String FQCN = JavaUtilLog.class.getName();
        private volatile boolean resolved;

        public LocationResolvingLogRecord(java.util.logging.Level level, String string) {
            super(level, string);
        }

        @Override
        public String getSourceClassName() {
            if (!this.resolved) {
                this.resolve();
            }
            return super.getSourceClassName();
        }

        @Override
        public void setSourceClassName(String string) {
            super.setSourceClassName(string);
            this.resolved = true;
        }

        @Override
        public String getSourceMethodName() {
            if (!this.resolved) {
                this.resolve();
            }
            return super.getSourceMethodName();
        }

        @Override
        public void setSourceMethodName(String string) {
            super.setSourceMethodName(string);
            this.resolved = true;
        }

        private void resolve() {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            String string = null;
            String string2 = null;
            boolean bl = false;
            for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                String string3 = stackTraceElement.getClassName();
                if (FQCN.equals(string3)) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                string = string3;
                string2 = stackTraceElement.getMethodName();
                break;
            }
            this.setSourceClassName(string);
            this.setSourceMethodName(string2);
        }

        protected Object writeReplace() {
            LogRecord logRecord = new LogRecord(this.getLevel(), this.getMessage());
            logRecord.setLoggerName(this.getLoggerName());
            logRecord.setResourceBundle(this.getResourceBundle());
            logRecord.setResourceBundleName(this.getResourceBundleName());
            logRecord.setSourceClassName(this.getSourceClassName());
            logRecord.setSourceMethodName(this.getSourceMethodName());
            logRecord.setSequenceNumber(this.getSequenceNumber());
            logRecord.setParameters(this.getParameters());
            logRecord.setThreadID(this.getThreadID());
            logRecord.setMillis(this.getMillis());
            logRecord.setThrown(this.getThrown());
            return logRecord;
        }
    }

    private static class JavaUtilLog
    implements Serializable,
    Log {
        private String name;
        private transient java.util.logging.Logger logger;

        public JavaUtilLog(String string) {
            this.name = string;
            this.logger = java.util.logging.Logger.getLogger(string);
        }

        @Override
        public boolean isFatalEnabled() {
            return this.isErrorEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isLoggable(java.util.logging.Level.SEVERE);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isLoggable(java.util.logging.Level.WARNING);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(java.util.logging.Level.INFO);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isLoggable(java.util.logging.Level.FINE);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isLoggable(java.util.logging.Level.FINEST);
        }

        @Override
        public void fatal(Object object) {
            this.error(object);
        }

        @Override
        public void fatal(Object object, Throwable throwable) {
            this.error(object, throwable);
        }

        @Override
        public void error(Object object) {
            this.log(java.util.logging.Level.SEVERE, object, null);
        }

        @Override
        public void error(Object object, Throwable throwable) {
            this.log(java.util.logging.Level.SEVERE, object, throwable);
        }

        @Override
        public void warn(Object object) {
            this.log(java.util.logging.Level.WARNING, object, null);
        }

        @Override
        public void warn(Object object, Throwable throwable) {
            this.log(java.util.logging.Level.WARNING, object, throwable);
        }

        @Override
        public void info(Object object) {
            this.log(java.util.logging.Level.INFO, object, null);
        }

        @Override
        public void info(Object object, Throwable throwable) {
            this.log(java.util.logging.Level.INFO, object, throwable);
        }

        @Override
        public void debug(Object object) {
            this.log(java.util.logging.Level.FINE, object, null);
        }

        @Override
        public void debug(Object object, Throwable throwable) {
            this.log(java.util.logging.Level.FINE, object, throwable);
        }

        @Override
        public void trace(Object object) {
            this.log(java.util.logging.Level.FINEST, object, null);
        }

        @Override
        public void trace(Object object, Throwable throwable) {
            this.log(java.util.logging.Level.FINEST, object, throwable);
        }

        private void log(java.util.logging.Level level, Object object, Throwable throwable) {
            if (this.logger.isLoggable(level)) {
                LogRecord logRecord;
                if (object instanceof LogRecord) {
                    logRecord = (LogRecord)object;
                } else {
                    logRecord = new LocationResolvingLogRecord(level, String.valueOf(object));
                    logRecord.setLoggerName(this.name);
                    logRecord.setResourceBundleName(this.logger.getResourceBundleName());
                    logRecord.setResourceBundle(this.logger.getResourceBundle());
                    logRecord.setThrown(throwable);
                }
                this.logger.log(logRecord);
            }
        }

        protected Object readResolve() {
            return new JavaUtilLog(this.name);
        }
    }

    private static class Slf4jLocationAwareLog
    extends Slf4jLog<LocationAwareLogger>
    implements Serializable {
        private static final String FQCN = Slf4jLocationAwareLog.class.getName();

        public Slf4jLocationAwareLog(LocationAwareLogger locationAwareLogger) {
            super(locationAwareLogger);
        }

        @Override
        public void fatal(Object object) {
            this.error(object);
        }

        @Override
        public void fatal(Object object, Throwable throwable) {
            this.error(object, throwable);
        }

        @Override
        public void error(Object object) {
            if (object instanceof String || ((LocationAwareLogger)this.logger).isErrorEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 40, String.valueOf(object), null, null);
            }
        }

        @Override
        public void error(Object object, Throwable throwable) {
            if (object instanceof String || ((LocationAwareLogger)this.logger).isErrorEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 40, String.valueOf(object), null, throwable);
            }
        }

        @Override
        public void warn(Object object) {
            if (object instanceof String || ((LocationAwareLogger)this.logger).isWarnEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 30, String.valueOf(object), null, null);
            }
        }

        @Override
        public void warn(Object object, Throwable throwable) {
            if (object instanceof String || ((LocationAwareLogger)this.logger).isWarnEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 30, String.valueOf(object), null, throwable);
            }
        }

        @Override
        public void info(Object object) {
            if (object instanceof String || ((LocationAwareLogger)this.logger).isInfoEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 20, String.valueOf(object), null, null);
            }
        }

        @Override
        public void info(Object object, Throwable throwable) {
            if (object instanceof String || ((LocationAwareLogger)this.logger).isInfoEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 20, String.valueOf(object), null, throwable);
            }
        }

        @Override
        public void debug(Object object) {
            if (object instanceof String || ((LocationAwareLogger)this.logger).isDebugEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 10, String.valueOf(object), null, null);
            }
        }

        @Override
        public void debug(Object object, Throwable throwable) {
            if (object instanceof String || ((LocationAwareLogger)this.logger).isDebugEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 10, String.valueOf(object), null, throwable);
            }
        }

        @Override
        public void trace(Object object) {
            if (object instanceof String || ((LocationAwareLogger)this.logger).isTraceEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 0, String.valueOf(object), null, null);
            }
        }

        @Override
        public void trace(Object object, Throwable throwable) {
            if (object instanceof String || ((LocationAwareLogger)this.logger).isTraceEnabled()) {
                ((LocationAwareLogger)this.logger).log(null, FQCN, 0, String.valueOf(object), null, throwable);
            }
        }

        @Override
        protected Object readResolve() {
            return Slf4jAdapter.createLocationAwareLog(this.name);
        }
    }

    private static class Slf4jLog<T extends Logger>
    implements Serializable,
    Log {
        protected final String name;
        protected transient T logger;

        public Slf4jLog(T t2) {
            this.name = t2.getName();
            this.logger = t2;
        }

        @Override
        public boolean isFatalEnabled() {
            return this.isErrorEnabled();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void fatal(Object object) {
            this.error(object);
        }

        @Override
        public void fatal(Object object, Throwable throwable) {
            this.error(object, throwable);
        }

        @Override
        public void error(Object object) {
            if (object instanceof String || this.logger.isErrorEnabled()) {
                this.logger.error(String.valueOf(object));
            }
        }

        @Override
        public void error(Object object, Throwable throwable) {
            if (object instanceof String || this.logger.isErrorEnabled()) {
                this.logger.error(String.valueOf(object), throwable);
            }
        }

        @Override
        public void warn(Object object) {
            if (object instanceof String || this.logger.isWarnEnabled()) {
                this.logger.warn(String.valueOf(object));
            }
        }

        @Override
        public void warn(Object object, Throwable throwable) {
            if (object instanceof String || this.logger.isWarnEnabled()) {
                this.logger.warn(String.valueOf(object), throwable);
            }
        }

        @Override
        public void info(Object object) {
            if (object instanceof String || this.logger.isInfoEnabled()) {
                this.logger.info(String.valueOf(object));
            }
        }

        @Override
        public void info(Object object, Throwable throwable) {
            if (object instanceof String || this.logger.isInfoEnabled()) {
                this.logger.info(String.valueOf(object), throwable);
            }
        }

        @Override
        public void debug(Object object) {
            if (object instanceof String || this.logger.isDebugEnabled()) {
                this.logger.debug(String.valueOf(object));
            }
        }

        @Override
        public void debug(Object object, Throwable throwable) {
            if (object instanceof String || this.logger.isDebugEnabled()) {
                this.logger.debug(String.valueOf(object), throwable);
            }
        }

        @Override
        public void trace(Object object) {
            if (object instanceof String || this.logger.isTraceEnabled()) {
                this.logger.trace(String.valueOf(object));
            }
        }

        @Override
        public void trace(Object object, Throwable throwable) {
            if (object instanceof String || this.logger.isTraceEnabled()) {
                this.logger.trace(String.valueOf(object), throwable);
            }
        }

        protected Object readResolve() {
            return Slf4jAdapter.createLog(this.name);
        }
    }

    private static class Log4jLog
    implements Serializable,
    Log {
        private static final String FQCN = Log4jLog.class.getName();
        private static final LoggerContext loggerContext = LogManager.getContext((ClassLoader)Log4jLog.class.getClassLoader(), (boolean)false);
        private final ExtendedLogger logger;

        public Log4jLog(String string) {
            LoggerContext loggerContext = Log4jLog.loggerContext;
            if (loggerContext == null) {
                loggerContext = LogManager.getContext((ClassLoader)Log4jLog.class.getClassLoader(), (boolean)false);
            }
            this.logger = loggerContext.getLogger(string);
        }

        @Override
        public boolean isFatalEnabled() {
            return this.logger.isEnabled(Level.FATAL);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isEnabled(Level.ERROR);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isEnabled(Level.WARN);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isEnabled(Level.INFO);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isEnabled(Level.DEBUG);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isEnabled(Level.TRACE);
        }

        @Override
        public void fatal(Object object) {
            this.log(Level.FATAL, object, null);
        }

        @Override
        public void fatal(Object object, Throwable throwable) {
            this.log(Level.FATAL, object, throwable);
        }

        @Override
        public void error(Object object) {
            this.log(Level.ERROR, object, null);
        }

        @Override
        public void error(Object object, Throwable throwable) {
            this.log(Level.ERROR, object, throwable);
        }

        @Override
        public void warn(Object object) {
            this.log(Level.WARN, object, null);
        }

        @Override
        public void warn(Object object, Throwable throwable) {
            this.log(Level.WARN, object, throwable);
        }

        @Override
        public void info(Object object) {
            this.log(Level.INFO, object, null);
        }

        @Override
        public void info(Object object, Throwable throwable) {
            this.log(Level.INFO, object, throwable);
        }

        @Override
        public void debug(Object object) {
            this.log(Level.DEBUG, object, null);
        }

        @Override
        public void debug(Object object, Throwable throwable) {
            this.log(Level.DEBUG, object, throwable);
        }

        @Override
        public void trace(Object object) {
            this.log(Level.TRACE, object, null);
        }

        @Override
        public void trace(Object object, Throwable throwable) {
            this.log(Level.TRACE, object, throwable);
        }

        private void log(Level level, Object object, Throwable throwable) {
            if (object instanceof String) {
                if (throwable != null) {
                    this.logger.logIfEnabled(FQCN, level, null, (String)object, throwable);
                } else {
                    this.logger.logIfEnabled(FQCN, level, null, (String)object);
                }
            } else {
                this.logger.logIfEnabled(FQCN, level, null, object, throwable);
            }
        }
    }

    private static class JavaUtilAdapter {
        private JavaUtilAdapter() {
        }

        public static Log createLog(String string) {
            return new JavaUtilLog(string);
        }
    }

    private static class Slf4jAdapter {
        private Slf4jAdapter() {
        }

        public static Log createLocationAwareLog(String string) {
            Logger logger = LoggerFactory.getLogger(string);
            return logger instanceof LocationAwareLogger ? new Slf4jLocationAwareLog((LocationAwareLogger)logger) : new Slf4jLog<Logger>(logger);
        }

        public static Log createLog(String string) {
            return new Slf4jLog<Logger>(LoggerFactory.getLogger(string));
        }
    }

    private static class Log4jAdapter {
        private Log4jAdapter() {
        }

        public static Log createLog(String string) {
            return new Log4jLog(string);
        }
    }

    private static enum LogApi {
        LOG4J,
        SLF4J_LAL,
        SLF4J,
        JUL;

    }
}

