/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import org.apache.commons.io.input.ProxyReader;

public class TeeReader
extends ProxyReader {
    private final Writer branch;
    private final boolean closeBranch;

    public TeeReader(Reader reader, Writer writer) {
        this(reader, writer, false);
    }

    public TeeReader(Reader reader, Writer writer, boolean bl) {
        super(reader);
        this.branch = writer;
        this.closeBranch = bl;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            if (this.closeBranch) {
                this.branch.close();
            }
        }
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n != -1) {
            this.branch.write(n);
        }
        return n;
    }

    @Override
    public int read(char[] cArray) throws IOException {
        int n = super.read(cArray);
        if (n != -1) {
            this.branch.write(cArray, 0, n);
        }
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        if (n3 != -1) {
            this.branch.write(cArray, n, n3);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(CharBuffer charBuffer) throws IOException {
        int n = charBuffer.position();
        int n2 = super.read(charBuffer);
        if (n2 != -1) {
            int n3 = charBuffer.position();
            int n4 = charBuffer.limit();
            try {
                charBuffer.position(n).limit(n3);
                this.branch.append(charBuffer);
            }
            finally {
                charBuffer.position(n3).limit(n4);
            }
        }
        return n2;
    }
}

