/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0019\u0010 \u001a\u00020\u001f2\n\u0010!\u001a\u00060\u001aR\u00020\u001bH\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b$J\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b%J\u0016\u0010&\u001a\b\u0018\u00010\u001aR\u00020\u001b2\u0006\u0010'\u001a\u00020(H\u0002J)\u0010)\u001a\u00020\u001f\"\u0004\b\u0000\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,2\u0006\u0010!\u001a\u0002H*H\u0002\u00a2\u0006\u0002\u0010-J\u0015\u0010)\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b.J\u0019\u0010)\u001a\u00020\u001f2\n\u0010!\u001a\u00060\u001aR\u00020\u001bH\u0000\u00a2\u0006\u0002\b.J\b\u0010/\u001a\u000200H\u0002J\f\u00101\u001a\b\u0012\u0004\u0012\u00020302J\u0006\u00104\u001a\u00020\u0010J\f\u00105\u001a\b\u0012\u0004\u0012\u00020302J\u0006\u00106\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0018\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u001aR\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u001aR\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lokhttp3/Dispatcher;", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "(Ljava/util/concurrent/ExecutorService;)V", "()V", "()Ljava/util/concurrent/ExecutorService;", "executorServiceOrNull", "<set-?>", "Ljava/lang/Runnable;", "idleCallback", "getIdleCallback", "()Ljava/lang/Runnable;", "setIdleCallback", "(Ljava/lang/Runnable;)V", "maxRequests", "", "getMaxRequests", "()I", "setMaxRequests", "(I)V", "maxRequestsPerHost", "getMaxRequestsPerHost", "setMaxRequestsPerHost", "readyAsyncCalls", "Ljava/util/ArrayDeque;", "Lokhttp3/internal/connection/RealCall$AsyncCall;", "Lokhttp3/internal/connection/RealCall;", "runningAsyncCalls", "runningSyncCalls", "cancelAll", "", "enqueue", "call", "enqueue$okhttp", "executed", "executed$okhttp", "-deprecated_executorService", "findExistingCallWithHost", "host", "", "finished", "T", "calls", "Ljava/util/Deque;", "(Ljava/util/Deque;Ljava/lang/Object;)V", "finished$okhttp", "promoteAndExecute", "", "queuedCalls", "", "Lokhttp3/Call;", "queuedCallsCount", "runningCalls", "runningCallsCount", "okhttp"})
public final class Dispatcher {
    private int maxRequests;
    private int maxRequestsPerHost;
    @Nullable
    private Runnable idleCallback;
    private ExecutorService executorServiceOrNull;
    private final ArrayDeque<RealCall.AsyncCall> readyAsyncCalls;
    private final ArrayDeque<RealCall.AsyncCall> runningAsyncCalls;
    private final ArrayDeque<RealCall> runningSyncCalls;

    public final synchronized int getMaxRequests() {
        return this.maxRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxRequests(int n) {
        boolean bl = n >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "max < 1: " + n;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Dispatcher dispatcher = this;
        bl2 = false;
        bl3 = false;
        synchronized (dispatcher) {
            boolean bl5 = false;
            this.maxRequests = n;
            Unit unit = Unit.INSTANCE;
        }
        this.promoteAndExecute();
    }

    public final synchronized int getMaxRequestsPerHost() {
        return this.maxRequestsPerHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMaxRequestsPerHost(int n) {
        boolean bl = n >= 1;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "max < 1: " + n;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Dispatcher dispatcher = this;
        bl2 = false;
        bl3 = false;
        synchronized (dispatcher) {
            boolean bl5 = false;
            this.maxRequestsPerHost = n;
            Unit unit = Unit.INSTANCE;
        }
        this.promoteAndExecute();
    }

    @Nullable
    public final synchronized Runnable getIdleCallback() {
        return this.idleCallback;
    }

    public final synchronized void setIdleCallback(@Nullable Runnable runnable2) {
        this.idleCallback = runnable2;
    }

    @JvmName(name="executorService")
    @NotNull
    public final synchronized ExecutorService executorService() {
        if (this.executorServiceOrNull == null) {
            this.executorServiceOrNull = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new SynchronousQueue(), Util.threadFactory(Util.okHttpName + " Dispatcher", false));
        }
        ExecutorService executorService = this.executorServiceOrNull;
        Intrinsics.checkNotNull(executorService);
        return executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue$okhttp(@NotNull RealCall.AsyncCall asyncCall) {
        Intrinsics.checkNotNullParameter(asyncCall, "call");
        Dispatcher dispatcher = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (dispatcher) {
            RealCall.AsyncCall asyncCall2;
            boolean bl3 = false;
            this.readyAsyncCalls.add(asyncCall);
            if (!asyncCall.getCall().getForWebSocket() && (asyncCall2 = this.findExistingCallWithHost(asyncCall.getHost())) != null) {
                asyncCall.reuseCallsPerHostFrom(asyncCall2);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.promoteAndExecute();
    }

    private final RealCall.AsyncCall findExistingCallWithHost(String string) {
        for (RealCall.AsyncCall asyncCall : this.runningAsyncCalls) {
            if (!Intrinsics.areEqual(asyncCall.getHost(), string)) continue;
            return asyncCall;
        }
        for (RealCall.AsyncCall asyncCall : this.readyAsyncCalls) {
            if (!Intrinsics.areEqual(asyncCall.getHost(), string)) continue;
            return asyncCall;
        }
        return null;
    }

    public final synchronized void cancelAll() {
        for (RealCall.AsyncCall object : this.readyAsyncCalls) {
            object.getCall().cancel();
        }
        for (RealCall.AsyncCall asyncCall : this.runningAsyncCalls) {
            asyncCall.getCall().cancel();
        }
        for (RealCall realCall : this.runningSyncCalls) {
            realCall.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean promoteAndExecute() {
        Object object;
        Object object2 = this;
        boolean bl = false;
        if (Util.assertionsEnabled && Thread.holdsLock(object2)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST NOT hold lock on ").append(object2).toString()));
        }
        bl = false;
        object2 = new ArrayList();
        bl = false;
        Dispatcher dispatcher = this;
        int n = 0;
        boolean bl2 = false;
        synchronized (dispatcher) {
            boolean bl3 = false;
            Iterator<RealCall.AsyncCall> iterator2 = this.readyAsyncCalls.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "readyAsyncCalls.iterator()");
            Iterator<RealCall.AsyncCall> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                RealCall.AsyncCall asyncCall = iterator3.next();
                if (this.runningAsyncCalls.size() >= this.maxRequests) break;
                if (asyncCall.getCallsPerHost().get() >= this.maxRequestsPerHost) continue;
                iterator3.remove();
                asyncCall.getCallsPerHost().incrementAndGet();
                RealCall.AsyncCall asyncCall2 = asyncCall;
                Intrinsics.checkNotNullExpressionValue(asyncCall2, "asyncCall");
                object2.add(asyncCall2);
                this.runningAsyncCalls.add(asyncCall);
            }
            bl = this.runningCallsCount() > 0;
            object = Unit.INSTANCE;
        }
        n = object2.size();
        for (int i = 0; i < n; ++i) {
            object = (RealCall.AsyncCall)object2.get(i);
            ((RealCall.AsyncCall)object).executeOn(this.executorService());
        }
        return bl;
    }

    public final synchronized void executed$okhttp(@NotNull RealCall realCall) {
        Intrinsics.checkNotNullParameter(realCall, "call");
        this.runningSyncCalls.add(realCall);
    }

    public final void finished$okhttp(@NotNull RealCall.AsyncCall asyncCall) {
        Intrinsics.checkNotNullParameter(asyncCall, "call");
        asyncCall.getCallsPerHost().decrementAndGet();
        this.finished((Deque)this.runningAsyncCalls, asyncCall);
    }

    public final void finished$okhttp(@NotNull RealCall realCall) {
        Intrinsics.checkNotNullParameter(realCall, "call");
        this.finished((Deque)this.runningSyncCalls, realCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void finished(Deque<T> deque, T t2) {
        Runnable runnable2 = null;
        Dispatcher dispatcher = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (dispatcher) {
            boolean bl3 = false;
            if (!deque.remove(t2)) {
                throw (Throwable)((Object)new AssertionError((Object)"Call wasn't in-flight!"));
            }
            runnable2 = this.idleCallback;
            Unit unit = Unit.INSTANCE;
        }
        boolean bl4 = this.promoteAndExecute();
        if (!bl4 && runnable2 != null) {
            runnable2.run();
        }
    }

    @NotNull
    public final synchronized List<Call> queuedCalls() {
        Iterable iterable = this.readyAsyncCalls;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            RealCall.AsyncCall asyncCall = (RealCall.AsyncCall)t2;
            Collection collection2 = collection;
            boolean bl3 = false;
            RealCall realCall = asyncCall.getCall();
            collection2.add(realCall);
        }
        List<Call> list = Collections.unmodifiableList((List)collection);
        Intrinsics.checkNotNullExpressionValue(list, "Collections.unmodifiable\u2026yncCalls.map { it.call })");
        return list;
    }

    @NotNull
    public final synchronized List<Call> runningCalls() {
        Collection<RealCall> collection;
        Iterable iterable = this.runningAsyncCalls;
        Collection collection2 = this.runningSyncCalls;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            RealCall.AsyncCall asyncCall = (RealCall.AsyncCall)t2;
            collection = collection3;
            boolean bl3 = false;
            RealCall realCall = asyncCall.getCall();
            collection.add(realCall);
        }
        collection = (List)collection3;
        List<Call> list = Collections.unmodifiableList(CollectionsKt.plus(collection2, (Iterable)collection));
        Intrinsics.checkNotNullExpressionValue(list, "Collections.unmodifiable\u2026yncCalls.map { it.call })");
        return list;
    }

    public final synchronized int queuedCallsCount() {
        return this.readyAsyncCalls.size();
    }

    public final synchronized int runningCallsCount() {
        return this.runningAsyncCalls.size() + this.runningSyncCalls.size();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(imports={}, expression="executorService"), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_executorService")
    @NotNull
    public final ExecutorService -deprecated_executorService() {
        return this.executorService();
    }

    public Dispatcher() {
        this.maxRequests = 64;
        this.maxRequestsPerHost = 5;
        this.readyAsyncCalls = new ArrayDeque();
        this.runningAsyncCalls = new ArrayDeque();
        this.runningSyncCalls = new ArrayDeque();
    }

    public Dispatcher(@NotNull ExecutorService executorService) {
        Intrinsics.checkNotNullParameter(executorService, "executorService");
        this();
        this.executorServiceOrNull = executorService;
    }
}

