/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.HostnamesKt;
import okhttp3.internal.tls.CertificateChainCleaner;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0003!\"#B!\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0014J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0015\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lokhttp3/CertificatePinner;", "", "pins", "", "Lokhttp3/CertificatePinner$Pin;", "certificateChainCleaner", "Lokhttp3/internal/tls/CertificateChainCleaner;", "(Ljava/util/Set;Lokhttp3/internal/tls/CertificateChainCleaner;)V", "getCertificateChainCleaner$okhttp", "()Lokhttp3/internal/tls/CertificateChainCleaner;", "getPins", "()Ljava/util/Set;", "check", "", "hostname", "", "cleanedPeerCertificatesFn", "Lkotlin/Function0;", "", "Ljava/security/cert/X509Certificate;", "check$okhttp", "peerCertificates", "", "Ljava/security/cert/Certificate;", "(Ljava/lang/String;[Ljava/security/cert/Certificate;)V", "equals", "", "other", "findMatchingPins", "hashCode", "", "withCertificateChainCleaner", "withCertificateChainCleaner$okhttp", "Builder", "Companion", "Pin", "okhttp"})
public final class CertificatePinner {
    @NotNull
    private final Set<Pin> pins;
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;
    @JvmField
    @NotNull
    public static final CertificatePinner DEFAULT;
    public static final Companion Companion;

    public final void check(@NotNull String string, @NotNull List<? extends Certificate> list) throws SSLPeerUnverifiedException {
        Intrinsics.checkNotNullParameter(string, "hostname");
        Intrinsics.checkNotNullParameter(list, "peerCertificates");
        this.check$okhttp(string, (Function0<? extends List<? extends X509Certificate>>)new Function0<List<? extends X509Certificate>>(this, list, string){
            final /* synthetic */ CertificatePinner this$0;
            final /* synthetic */ List $peerCertificates;
            final /* synthetic */ String $hostname;

            @NotNull
            public final List<X509Certificate> invoke() {
                Object object = this.this$0.getCertificateChainCleaner$okhttp();
                if (object == null || (object = ((CertificateChainCleaner)object).clean(this.$peerCertificates, this.$hostname)) == null) {
                    object = this.$peerCertificates;
                }
                Iterable iterable = (Iterable)object;
                boolean bl = false;
                Iterable iterable2 = iterable;
                Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault(iterable, 10));
                boolean bl2 = false;
                for (T t2 : iterable2) {
                    Certificate certificate = (Certificate)t2;
                    Collection collection2 = collection;
                    boolean bl3 = false;
                    Certificate certificate2 = certificate;
                    if (certificate2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                    }
                    X509Certificate x509Certificate = (X509Certificate)certificate2;
                    collection2.add(x509Certificate);
                }
                return (List)collection;
            }
            {
                this.this$0 = certificatePinner;
                this.$peerCertificates = list;
                this.$hostname = string;
                super(0);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void check$okhttp(@NotNull String string, @NotNull Function0<? extends List<? extends X509Certificate>> function0) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        Intrinsics.checkNotNullParameter(function0, "cleanedPeerCertificatesFn");
        List<Pin> list = this.findMatchingPins(string);
        if (list.isEmpty()) {
            return;
        }
        List<? extends X509Certificate> list2 = function0.invoke();
        for (X509Certificate x509Certificate : list2) {
            ByteString byteString = null;
            ByteString byteString2 = null;
            block5: for (Pin pin : list) {
                String string2 = pin.getHashAlgorithm();
                switch (string2.hashCode()) {
                    case 3528965: {
                        if (!string2.equals("sha1")) throw (Throwable)((Object)new AssertionError((Object)("unsupported hashAlgorithm: " + pin.getHashAlgorithm())));
                        break;
                    }
                    case -903629273: {
                        if (!string2.equals("sha256")) throw (Throwable)((Object)new AssertionError((Object)("unsupported hashAlgorithm: " + pin.getHashAlgorithm())));
                        if (byteString2 == null) {
                            byteString2 = Companion.sha256Hash(x509Certificate);
                        }
                        if (!Intrinsics.areEqual(pin.getHash(), byteString2)) continue block5;
                        return;
                    }
                }
                if (byteString == null) {
                    byteString = Companion.sha1Hash(x509Certificate);
                }
                if (!Intrinsics.areEqual(pin.getHash(), byteString)) continue;
                return;
                throw (Throwable)((Object)new AssertionError((Object)("unsupported hashAlgorithm: " + pin.getHashAlgorithm())));
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder stringBuilder2 = stringBuilder;
        boolean bl5 = false;
        stringBuilder2.append("Certificate pinning failure!");
        stringBuilder2.append("\n  Peer certificate chain:");
        for (X509Certificate x509Certificate : list2) {
            stringBuilder2.append("\n    ");
            stringBuilder2.append(Companion.pin(x509Certificate));
            stringBuilder2.append(": ");
            Principal principal = x509Certificate.getSubjectDN();
            Intrinsics.checkNotNullExpressionValue(principal, "element.subjectDN");
            stringBuilder2.append(principal.getName());
        }
        stringBuilder2.append("\n  Pinned certificates for ");
        stringBuilder2.append(string);
        stringBuilder2.append(":");
        for (Pin pin : list) {
            stringBuilder2.append("\n    ");
            stringBuilder2.append(pin);
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
        String string4 = string3;
        throw (Throwable)new SSLPeerUnverifiedException(string4);
    }

    @Deprecated(message="replaced with {@link #check(String, List)}.", replaceWith=@ReplaceWith(imports={}, expression="check(hostname, peerCertificates.toList())"))
    public final void check(@NotNull String string, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        Intrinsics.checkNotNullParameter(string, "hostname");
        Intrinsics.checkNotNullParameter(certificateArray, "peerCertificates");
        this.check(string, ArraysKt.toList(certificateArray));
    }

    @NotNull
    public final List<Pin> findMatchingPins(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "hostname");
        Iterable iterable = this.pins;
        boolean bl = false;
        List list = CollectionsKt.emptyList();
        for (Object t2 : iterable) {
            Pin pin = (Pin)t2;
            boolean bl2 = false;
            if (!pin.matchesHostname(string)) continue;
            if (list.isEmpty()) {
                boolean bl3 = false;
                list = new ArrayList();
            }
            List list2 = list;
            if (list2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableList<T>");
            }
            TypeIntrinsics.asMutableList(list2).add(t2);
        }
        return list;
    }

    @NotNull
    public final CertificatePinner withCertificateChainCleaner$okhttp(@NotNull CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkNotNullParameter(certificateChainCleaner, "certificateChainCleaner");
        return Intrinsics.areEqual(this.certificateChainCleaner, certificateChainCleaner) ? this : new CertificatePinner(this.pins, certificateChainCleaner);
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof CertificatePinner && Intrinsics.areEqual(((CertificatePinner)object).pins, this.pins) && Intrinsics.areEqual(((CertificatePinner)object).certificateChainCleaner, this.certificateChainCleaner);
    }

    public int hashCode() {
        int n = 37;
        n = 41 * n + ((Object)this.pins).hashCode();
        CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
        boolean bl = false;
        CertificateChainCleaner certificateChainCleaner2 = certificateChainCleaner;
        n = 41 * n + (certificateChainCleaner2 != null ? certificateChainCleaner2.hashCode() : 0);
        return n;
    }

    @NotNull
    public final Set<Pin> getPins() {
        return this.pins;
    }

    @Nullable
    public final CertificateChainCleaner getCertificateChainCleaner$okhttp() {
        return this.certificateChainCleaner;
    }

    public CertificatePinner(@NotNull Set<Pin> set, @Nullable CertificateChainCleaner certificateChainCleaner) {
        Intrinsics.checkNotNullParameter(set, "pins");
        this.pins = set;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public /* synthetic */ CertificatePinner(Set set, CertificateChainCleaner certificateChainCleaner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            certificateChainCleaner = null;
        }
        this(set, certificateChainCleaner);
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new Builder().build();
    }

    @JvmStatic
    @NotNull
    public static final ByteString sha1Hash(@NotNull X509Certificate x509Certificate) {
        return Companion.sha1Hash(x509Certificate);
    }

    @JvmStatic
    @NotNull
    public static final ByteString sha256Hash(@NotNull X509Certificate x509Certificate) {
        return Companion.sha256Hash(x509Certificate);
    }

    @JvmStatic
    @NotNull
    public static final String pin(@NotNull Certificate certificate) {
        return Companion.pin(certificate);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lokhttp3/CertificatePinner$Pin;", "", "pattern", "", "pin", "(Ljava/lang/String;Ljava/lang/String;)V", "hash", "Lokio/ByteString;", "getHash", "()Lokio/ByteString;", "hashAlgorithm", "getHashAlgorithm", "()Ljava/lang/String;", "getPattern", "equals", "", "other", "hashCode", "", "matchesCertificate", "certificate", "Ljava/security/cert/X509Certificate;", "matchesHostname", "hostname", "toString", "okhttp"})
    public static final class Pin {
        @NotNull
        private final String pattern;
        @NotNull
        private final String hashAlgorithm;
        @NotNull
        private final ByteString hash;

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        @NotNull
        public final String getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        @NotNull
        public final ByteString getHash() {
            return this.hash;
        }

        public final boolean matchesHostname(@NotNull String string) {
            boolean bl;
            Intrinsics.checkNotNullParameter(string, "hostname");
            if (StringsKt.startsWith$default(this.pattern, "**.", false, 2, null)) {
                int n = this.pattern.length() - 3;
                int n2 = string.length() - n;
                bl = StringsKt.regionMatches$default(string, string.length() - n, this.pattern, 3, n, false, 16, null) && (n2 == 0 || string.charAt(n2 - 1) == '.');
            } else if (StringsKt.startsWith$default(this.pattern, "*.", false, 2, null)) {
                int n = this.pattern.length() - 1;
                int n3 = string.length() - n;
                bl = StringsKt.regionMatches$default(string, string.length() - n, this.pattern, 1, n, false, 16, null) && StringsKt.lastIndexOf$default((CharSequence)string, '.', n3 - 1, false, 4, null) == -1;
            } else {
                bl = Intrinsics.areEqual(string, this.pattern);
            }
            return bl;
        }

        /*
         * WARNING - bad return control flow
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean matchesCertificate(@NotNull X509Certificate x509Certificate) {
            boolean bl;
            Intrinsics.checkNotNullParameter(x509Certificate, "certificate");
            String string = this.hashAlgorithm;
            switch (string.hashCode()) {
                case 3528965: {
                    if (!string.equals("sha1")) return false;
                    break;
                }
                case -903629273: {
                    if (!string.equals("sha256")) return false;
                    bl = Intrinsics.areEqual(this.hash, Companion.sha256Hash(x509Certificate));
                    return bl;
                }
            }
            bl = Intrinsics.areEqual(this.hash, Companion.sha1Hash(x509Certificate));
            return bl;
            return false;
        }

        @NotNull
        public String toString() {
            return this.hashAlgorithm + '/' + this.hash.base64();
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Pin)) {
                return false;
            }
            if (Intrinsics.areEqual(this.pattern, ((Pin)object).pattern) ^ true) {
                return false;
            }
            if (Intrinsics.areEqual(this.hashAlgorithm, ((Pin)object).hashAlgorithm) ^ true) {
                return false;
            }
            return !(Intrinsics.areEqual(this.hash, ((Pin)object).hash) ^ true);
        }

        public int hashCode() {
            int n = this.pattern.hashCode();
            n = 31 * n + this.hashAlgorithm.hashCode();
            n = 31 * n + this.hash.hashCode();
            return n;
        }

        public Pin(@NotNull String string, @NotNull String string2) {
            Intrinsics.checkNotNullParameter(string, "pattern");
            Intrinsics.checkNotNullParameter(string2, "pin");
            boolean bl = StringsKt.startsWith$default(string, "*.", false, 2, null) && StringsKt.indexOf$default((CharSequence)string, "*", 1, false, 4, null) == -1 || StringsKt.startsWith$default(string, "**.", false, 2, null) && StringsKt.indexOf$default((CharSequence)string, "*", 2, false, 4, null) == -1 || StringsKt.indexOf$default((CharSequence)string, "*", 0, false, 6, null) == -1;
            int n = 0;
            boolean bl2 = false;
            if (!bl) {
                boolean bl3 = false;
                String string3 = "Unexpected pattern: " + string;
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            String string4 = HostnamesKt.toCanonicalHost(string);
            if (string4 == null) {
                throw (Throwable)new IllegalArgumentException("Invalid pattern: " + string);
            }
            this.pattern = string4;
            if (StringsKt.startsWith$default(string2, "sha1/", false, 2, null)) {
                this.hashAlgorithm = "sha1";
                String string5 = string2;
                n = "sha1/".length();
                bl2 = false;
                String string6 = string5.substring(n);
                Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.String).substring(startIndex)");
                ByteString byteString = ByteString.Companion.decodeBase64(string6);
                if (byteString == null) {
                    throw (Throwable)new IllegalArgumentException("Invalid pin hash: " + string2);
                }
                this.hash = byteString;
            } else if (StringsKt.startsWith$default(string2, "sha256/", false, 2, null)) {
                this.hashAlgorithm = "sha256";
                String string7 = string2;
                n = "sha256/".length();
                bl2 = false;
                String string8 = string7.substring(n);
                Intrinsics.checkNotNullExpressionValue(string8, "(this as java.lang.String).substring(startIndex)");
                ByteString byteString = ByteString.Companion.decodeBase64(string8);
                if (byteString == null) {
                    throw (Throwable)new IllegalArgumentException("Invalid pin hash: " + string2);
                }
                this.hash = byteString;
            } else {
                throw (Throwable)new IllegalArgumentException("pins must start with 'sha256/' or 'sha1/': " + string2);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u000b\"\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lokhttp3/CertificatePinner$Builder;", "", "()V", "pins", "", "Lokhttp3/CertificatePinner$Pin;", "getPins", "()Ljava/util/List;", "add", "pattern", "", "", "(Ljava/lang/String;[Ljava/lang/String;)Lokhttp3/CertificatePinner$Builder;", "build", "Lokhttp3/CertificatePinner;", "okhttp"})
    public static final class Builder {
        @NotNull
        private final List<Pin> pins;

        @NotNull
        public final List<Pin> getPins() {
            return this.pins;
        }

        @NotNull
        public final Builder add(@NotNull String string, String ... stringArray) {
            Intrinsics.checkNotNullParameter(string, "pattern");
            Intrinsics.checkNotNullParameter(stringArray, "pins");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder builder2 = builder;
            boolean bl3 = false;
            for (String string2 : stringArray) {
                builder2.pins.add(new Pin(string, string2));
            }
            return builder;
        }

        @NotNull
        public final CertificatePinner build() {
            return new CertificatePinner(CollectionsKt.toSet((Iterable)this.pins), null, 2, null);
        }

        public Builder() {
            boolean bl = false;
            this.pins = new ArrayList();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0007J\f\u0010\f\u001a\u00020\n*\u00020\u000bH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/CertificatePinner$Companion;", "", "()V", "DEFAULT", "Lokhttp3/CertificatePinner;", "pin", "", "certificate", "Ljava/security/cert/Certificate;", "sha1Hash", "Lokio/ByteString;", "Ljava/security/cert/X509Certificate;", "sha256Hash", "okhttp"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ByteString sha1Hash(@NotNull X509Certificate x509Certificate) {
            Intrinsics.checkNotNullParameter(x509Certificate, "$this$sha1Hash");
            PublicKey publicKey = x509Certificate.getPublicKey();
            Intrinsics.checkNotNullExpressionValue(publicKey, "publicKey");
            byte[] byArray = publicKey.getEncoded();
            Intrinsics.checkNotNullExpressionValue(byArray, "publicKey.encoded");
            return ByteString.Companion.of$default(ByteString.Companion, byArray, 0, 0, 3, null).sha1();
        }

        @JvmStatic
        @NotNull
        public final ByteString sha256Hash(@NotNull X509Certificate x509Certificate) {
            Intrinsics.checkNotNullParameter(x509Certificate, "$this$sha256Hash");
            PublicKey publicKey = x509Certificate.getPublicKey();
            Intrinsics.checkNotNullExpressionValue(publicKey, "publicKey");
            byte[] byArray = publicKey.getEncoded();
            Intrinsics.checkNotNullExpressionValue(byArray, "publicKey.encoded");
            return ByteString.Companion.of$default(ByteString.Companion, byArray, 0, 0, 3, null).sha256();
        }

        @JvmStatic
        @NotNull
        public final String pin(@NotNull Certificate certificate) {
            Intrinsics.checkNotNullParameter(certificate, "certificate");
            boolean bl = certificate instanceof X509Certificate;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Certificate pinning requires X509 certificates";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return "sha256/" + this.sha256Hash((X509Certificate)certificate).base64();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

