/*
 * Decompiled with CFR 0.152.
 */
package kotlin.random;

import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.internal.PlatformImplementationsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.PlatformRandomKt;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b'\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H&J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lkotlin/random/Random;", "", "()V", "nextBits", "", "bitCount", "nextBoolean", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "nextDouble", "", "until", "from", "nextFloat", "", "nextInt", "nextLong", "", "Default", "kotlin-stdlib"})
@SinceKotlin(version="1.3")
public abstract class Random {
    private static final Random defaultRandom;
    public static final Default Default;

    public abstract int nextBits(int var1);

    public int nextInt() {
        return this.nextBits(32);
    }

    public int nextInt(int n) {
        return this.nextInt(0, n);
    }

    public int nextInt(int n, int n2) {
        int n3;
        int n4;
        RandomKt.checkRangeBounds(n, n2);
        int n5 = n2 - n;
        if (n5 > 0 || n5 == Integer.MIN_VALUE) {
            int n6;
            int n7;
            if ((n5 & -n5) == n5) {
                n7 = RandomKt.fastLog2(n5);
                n6 = this.nextBits(n7);
            } else {
                int n8;
                n7 = 0;
                while ((n8 = this.nextInt() >>> 1) - (n7 = n8 % n5) + (n5 - 1) < 0) {
                }
                n6 = n7;
            }
            int n9 = n6;
            return n + n9;
        }
        while (n > (n4 = (n3 = this.nextInt())) || n2 <= n4) {
        }
        return n3;
    }

    public long nextLong() {
        return ((long)this.nextInt() << 32) + (long)this.nextInt();
    }

    public long nextLong(long l) {
        return this.nextLong(0L, l);
    }

    public long nextLong(long l, long l2) {
        long l3;
        long l4;
        RandomKt.checkRangeBounds(l, l2);
        long l5 = l2 - l;
        if (l5 > 0L) {
            long l6 = 0L;
            if ((l5 & -l5) == l5) {
                long l7;
                int n;
                int n2 = (int)l5;
                int n3 = (int)(l5 >>> 32);
                if (n2 != 0) {
                    n = RandomKt.fastLog2(n2);
                    l7 = (long)this.nextBits(n) & 0xFFFFFFFFL;
                } else if (n3 == 1) {
                    l7 = (long)this.nextInt() & 0xFFFFFFFFL;
                } else {
                    n = RandomKt.fastLog2(n3);
                    l7 = ((long)this.nextBits(n) << 32) + (long)this.nextInt();
                }
                l6 = l7;
            } else {
                long l8;
                long l9 = 0L;
                while ((l8 = this.nextLong() >>> 1) - (l9 = l8 % l5) + (l5 - 1L) < 0L) {
                }
                l6 = l9;
            }
            return l + l6;
        }
        while (l > (l4 = (l3 = this.nextLong())) || l2 <= l4) {
        }
        return l3;
    }

    public boolean nextBoolean() {
        return this.nextBits(1) != 0;
    }

    public double nextDouble() {
        return PlatformRandomKt.doubleFromParts(this.nextBits(26), this.nextBits(27));
    }

    public double nextDouble(double d) {
        return this.nextDouble(0.0, d);
    }

    /*
     * Unable to fully structure code
     */
    public double nextDouble(double var1_1, double var3_2) {
        RandomKt.checkRangeBounds(var1_1, var3_2);
        var9_4 = var5_3 = var3_2 - var1_1;
        var11_5 = false;
        if (!Double.isInfinite(var9_4)) ** GOTO lbl-1000
        var9_4 = var1_1;
        var11_5 = false;
        var12_6 = var9_4;
        var14_7 = false;
        if (Double.isInfinite(var12_6)) ** GOTO lbl-1000
        var12_6 = var9_4;
        var14_7 = false;
        if (!Double.isNaN(var12_6)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        if (!v0) ** GOTO lbl-1000
        var9_4 = var3_2;
        var11_5 = false;
        var12_6 = var9_4;
        var14_7 = false;
        if (Double.isInfinite(var12_6)) ** GOTO lbl-1000
        var12_6 = var9_4;
        var14_7 = false;
        if (!Double.isNaN(var12_6)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (v1) {
            var9_4 = this.nextDouble() * (var3_2 / (double)2 - var1_1 / (double)2);
            v2 = var1_1 + var9_4 + var9_4;
        } else lbl-1000:
        // 3 sources

        {
            v2 = var7_8 = var1_1 + this.nextDouble() * var5_3;
        }
        if (var7_8 >= var3_2) {
            var9_4 = var3_2;
            var11_5 = false;
            v3 = Math.nextAfter(var9_4, -Infinity);
        } else {
            v3 = var7_8;
        }
        return v3;
    }

    public float nextFloat() {
        return (float)this.nextBits(24) / (float)0x1000000;
    }

    @NotNull
    public byte[] nextBytes(@NotNull byte[] byArray, int n, int n2) {
        int n3;
        Intrinsics.checkNotNullParameter(byArray, "array");
        int n4 = n;
        n4 = 0 <= n4 && byArray.length >= n4 && 0 <= (n4 = n2) && byArray.length >= n4 ? 1 : 0;
        int n5 = 0;
        int n6 = 0;
        if (n4 == 0) {
            boolean bl = false;
            String string = "fromIndex (" + n + ") or toIndex (" + n2 + ") are out of range: 0.." + byArray.length + '.';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n4 = n <= n2 ? 1 : 0;
        n5 = 0;
        n6 = 0;
        if (n4 == 0) {
            boolean bl = false;
            String string = "fromIndex (" + n + ") must be not greater than toIndex (" + n2 + ").";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n4 = (n2 - n) / 4;
        n5 = n;
        n6 = 0;
        int n7 = 0;
        n7 = 0;
        int n8 = n4;
        while (n7 < n8) {
            n3 = n7++;
            boolean bl = false;
            int n9 = this.nextInt();
            byArray[n5] = (byte)n9;
            byArray[n5 + 1] = (byte)(n9 >>> 8);
            byArray[n5 + 2] = (byte)(n9 >>> 16);
            byArray[n5 + 3] = (byte)(n9 >>> 24);
            n5 += 4;
        }
        n6 = n2 - n5;
        n7 = this.nextBits(n6 * 8);
        n3 = n6;
        for (n8 = 0; n8 < n3; ++n8) {
            byArray[n5 + n8] = (byte)(n7 >>> n8 * 8);
        }
        return byArray;
    }

    public static /* synthetic */ byte[] nextBytes$default(Random random, byte[] byArray, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: nextBytes");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return random.nextBytes(byArray, n, n2);
    }

    @NotNull
    public byte[] nextBytes(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "array");
        return this.nextBytes(byArray, 0, byArray.length);
    }

    @NotNull
    public byte[] nextBytes(int n) {
        return this.nextBytes(new byte[n]);
    }

    static {
        Default = new Default(null);
        boolean bl = false;
        defaultRandom = PlatformImplementationsKt.IMPLEMENTATIONS.defaultPlatformRandom();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0017H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lkotlin/random/Random$Default;", "Lkotlin/random/Random;", "()V", "defaultRandom", "nextBits", "", "bitCount", "nextBoolean", "", "nextBytes", "", "array", "fromIndex", "toIndex", "size", "nextDouble", "", "until", "from", "nextFloat", "", "nextInt", "nextLong", "", "kotlin-stdlib"})
    public static final class Default
    extends Random {
        @Override
        public int nextBits(int n) {
            return defaultRandom.nextBits(n);
        }

        @Override
        public int nextInt() {
            return defaultRandom.nextInt();
        }

        @Override
        public int nextInt(int n) {
            return defaultRandom.nextInt(n);
        }

        @Override
        public int nextInt(int n, int n2) {
            return defaultRandom.nextInt(n, n2);
        }

        @Override
        public long nextLong() {
            return defaultRandom.nextLong();
        }

        @Override
        public long nextLong(long l) {
            return defaultRandom.nextLong(l);
        }

        @Override
        public long nextLong(long l, long l2) {
            return defaultRandom.nextLong(l, l2);
        }

        @Override
        public boolean nextBoolean() {
            return defaultRandom.nextBoolean();
        }

        @Override
        public double nextDouble() {
            return defaultRandom.nextDouble();
        }

        @Override
        public double nextDouble(double d) {
            return defaultRandom.nextDouble(d);
        }

        @Override
        public double nextDouble(double d, double d2) {
            return defaultRandom.nextDouble(d, d2);
        }

        @Override
        public float nextFloat() {
            return defaultRandom.nextFloat();
        }

        @Override
        @NotNull
        public byte[] nextBytes(@NotNull byte[] byArray) {
            Intrinsics.checkNotNullParameter(byArray, "array");
            return defaultRandom.nextBytes(byArray);
        }

        @Override
        @NotNull
        public byte[] nextBytes(int n) {
            return defaultRandom.nextBytes(n);
        }

        @Override
        @NotNull
        public byte[] nextBytes(@NotNull byte[] byArray, int n, int n2) {
            Intrinsics.checkNotNullParameter(byArray, "array");
            return defaultRandom.nextBytes(byArray, n, n2);
        }

        private Default() {
        }

        public /* synthetic */ Default(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

