/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.symtabfile;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.SubroutineVariable;
import com.uqm.crashsight.symtabtool.common.VariableEntry;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.dwarf.EhFrameParser;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileHeader;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileInfoBean;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class SymtabFile {
    public static final String FILE_KEY = "File";
    public static final String FORMAT_KEY = "Format";
    public static final String APP_ID_KEY = "AppID";
    public static final String APP_VERSION_KEY = "AppVer";
    public static final String ARCH_KEY = "Arch";
    public static final String SYMBOLS_KEY = "Symbols";
    public static final String TOOL_VERSION_KEY = "Tool Version";
    public static final String FILE_VERSION_KEY = "File Version";
    public static final String BUILT_TIME_KEY = "Built Time";
    public static final String UUID_KEY = "UUID";
    public static final String SHA1_KEY = "SHA-1";
    public static final String SO_VERSION_KEY = "SO Version";
    public static final String P_VADDR = "Program Virtual Address";
    public static final String P_OFFSET = "Program Offset";
    public static final String P_ALIGN = "Program Align";
    public static final String SYMTAB_LABEL = "Symbol table";
    public static final String SYMTAB_FILE_VERSION = "3.0";
    public static final String ZIP_FILE_SEPERATOR = "_";
    public static final String SYMTAB_FILE_PREFIX = "crashsightSymbol";
    public static final String BREAKPAD_SYMTAB_FILE_PREFIX = "crashsightBreakpadSymbol";
    public static final String SYMTAB_FILE_SUFFIX = ".symbol";
    public static final String BREAKPAD_SYMTAB_FILE_SUFFIX = ".sym";
    public static final String STACK_VARIABLE_SYMTAB_FILE_SUFFIX = ".stack";
    public static final String FILE_TYPE_ELF = "ELF";
    public static final String FILE_TYPE_MACH = "Mach-O";
    public static final String FILE_TYPE_PDB = "PDB";
    public static final String FILE_TYPE_LINUX_ELF = "LINUX_ELF";
    public static final int BYTE_BUFFER_SIZE = 0x6400000;
    public static final int MAX_LEB128_LENGTH = 16;
    public static final long FILE_FORMAT_INVALID = 0L;
    public static final long FILE_FORMAT_32 = 32L;
    public static final long FILE_FORMAT_64 = 64L;
    private static final String SYMTAB_FILE_SEPERATOR = "&";
    private static final String BREAKPAD_FILE_SUFFIX = "sym";
    private static final String STACK_VARIABLE_FILE_SUFFIX = "stack";
    private static final String BREAKPAD_INDEX_FILE_SUFFIX = "file";
    private static final String BREAKPAD_INDEX_FUNC_SUFFIX = "func";
    private static final String BREAKPAD_INDEX_CFI_SUFFIX = "cfi";
    private static File breakpadSym = null;
    private static RandomAccessFile breakpadRandomAccess = null;
    private static File breakpadFile;
    private static RandomAccessFile breakpadFileRandomAccess;
    private static File breakpadFuncFile;
    private static RandomAccessFile breakpadFuncRandomAccess;
    private static File breakpadCfiFile;
    private static RandomAccessFile breakpadCfiRandomAccess;
    private static File stackVariableFile;
    private static RandomAccessFile stackVariableRandomAccess;
    private String fileName = null;
    private String pathName = null;
    private String symtabFileName = null;
    private String breakpadSymtabFileName = null;
    private String stackVariableSymtabFileName = null;
    private String appName = null;
    private String arch = null;
    private String uuid = null;
    private String sha1 = null;
    private String soVersion = null;
    private String fileType = null;
    private String fileFormat = null;
    private String symtabToolVersion = null;
    private SymtabFileHeader header = null;
    private String programVaddr = null;
    private String programOffset = null;
    private String programAlign = null;
    private boolean useTempDir = false;

    private SymtabFile() {
    }

    private static FileChannel createFileChannel(String string, String string2, String string3) {
        if (null == string) {
            return null;
        }
        String string4 = FileHelper.changeFileSuffix(new File(string).getName(), string3);
        string4 = FileHelper.changeFilePath(string4, string2);
        switch (string3) {
            case "sym": {
                breakpadSym = new File(string4);
                if (breakpadSym.exists() && !breakpadSym.delete()) {
                    Log.error("[Breakpad] Fail to delete " + string4, new Object[0]);
                }
                if (null == (breakpadRandomAccess = FileHelper.openRandomAccessFile(breakpadSym))) {
                    Log.error("[Breakpad] Fail to open sym channel", new Object[0]);
                    return null;
                }
                return breakpadRandomAccess.getChannel();
            }
            case "file": {
                breakpadFile = new File(string4);
                if (breakpadFile.exists() && !breakpadFile.delete()) {
                    Log.error("[Breakpad] Fail to delete " + string4, new Object[0]);
                }
                if (null == (breakpadFileRandomAccess = FileHelper.openRandomAccessFile(breakpadFile))) {
                    Log.error("[Breakpad] Fail to open file index channel", new Object[0]);
                    return null;
                }
                return breakpadFileRandomAccess.getChannel();
            }
            case "func": {
                breakpadFuncFile = new File(string4);
                if (breakpadFuncFile.exists() && !breakpadFuncFile.delete()) {
                    Log.error("[Breakpad] Fail to delete " + string4, new Object[0]);
                }
                if (null == (breakpadFuncRandomAccess = FileHelper.openRandomAccessFile(breakpadFuncFile))) {
                    Log.error("[Breakpad] Fail to open func index channel", new Object[0]);
                    return null;
                }
                return breakpadFuncRandomAccess.getChannel();
            }
            case "cfi": {
                breakpadCfiFile = new File(string4);
                if (breakpadCfiFile.exists() && !breakpadCfiFile.delete()) {
                    Log.error("[Breakpad] Fail to delete " + string4, new Object[0]);
                }
                if (null == (breakpadCfiRandomAccess = FileHelper.openRandomAccessFile(breakpadCfiFile))) {
                    Log.error("[Breakpad] Fail to open cfi index channel", new Object[0]);
                    return null;
                }
                return breakpadCfiRandomAccess.getChannel();
            }
            case "stack": {
                stackVariableFile = new File(string4);
                if (stackVariableFile.exists() && !stackVariableFile.delete()) {
                    Log.error("[StackVariable] Fail to delete " + string4, new Object[0]);
                }
                if (null == (stackVariableRandomAccess = FileHelper.openRandomAccessFile(stackVariableFile))) {
                    Log.error("[StackVariable] Fail to open stack variable index channel", new Object[0]);
                    return null;
                }
                return stackVariableRandomAccess.getChannel();
            }
        }
        return null;
    }

    public static void writeStrToBuffer(FileChannel fileChannel, ByteBuffer byteBuffer, String string) {
        try {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            if (byteBuffer.remaining() < byArray.length + 1024) {
                byteBuffer.flip();
                fileChannel.write(byteBuffer);
                byteBuffer.clear();
            }
            byteBuffer.put(byArray);
        }
        catch (Exception exception) {
            Log.error(exception);
        }
    }

    private static boolean writeBufferToFile(FileChannel fileChannel, FileChannel fileChannel2, ByteBuffer byteBuffer) {
        byteBuffer.clear();
        try {
            fileChannel2.position(0L);
            while (fileChannel2.read(byteBuffer) > 0) {
                byteBuffer.flip();
                fileChannel.write(byteBuffer);
                byteBuffer.clear();
            }
            return true;
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
    }

    public static SymtabFile create(SymtabFileInfoBean symtabFileInfoBean) {
        SymtabFile symtabFile = new SymtabFile();
        symtabFile.setSymtabFileInfo(symtabFileInfoBean);
        symtabFile.setUseTempDir(symtabFileInfoBean.isUseTempDir());
        if (!symtabFile.createSymtabFile(symtabFileInfoBean.getSymbolTable(), symtabFileInfoBean)) {
            return null;
        }
        return symtabFile;
    }

    public String getSymtabFileName() {
        return this.symtabFileName;
    }

    public String getBreakpadSymtabFileName() {
        return this.breakpadSymtabFileName;
    }

    private void setFileName(String string) {
        this.fileName = string;
        this.pathName = new File(string).getParent() + File.separator;
    }

    private void setFileType(String string) {
        this.fileType = string;
    }

    private void setFileFormat(long l) {
        if (32L == l) {
            this.fileFormat = Long.toString(64L);
        } else if (64L == l) {
            this.fileFormat = Long.toString(l);
        } else {
            Log.error("SymtabFile: The file-format is not acceptable!", new Object[0]);
        }
        this.fileFormat = this.fileFormat + "-Bit";
    }

    private void setAppName(String string) {
        this.appName = string;
    }

    private void setArch(String string) {
        this.arch = string;
    }

    public void setUuid(String string) {
        this.uuid = string;
    }

    public void setSha1(String string) {
        this.sha1 = string;
    }

    public void setSoVersion(String string) {
        this.soVersion = string;
    }

    private void setSymtabToolVersion(String string) {
        this.symtabToolVersion = string;
    }

    private void setProgramVaddr(String string) {
        this.programVaddr = string;
    }

    private void setProgramOffset(String string) {
        this.programOffset = string;
    }

    private void setProgramAlign(String string) {
        this.programAlign = string;
    }

    public boolean delete() {
        if (null == this.symtabFileName) {
            return true;
        }
        File file = new File(this.symtabFileName);
        if (file.exists()) {
            file.deleteOnExit();
        }
        return true;
    }

    private String elfSymtabFileNameFormatter(SymtabFileInfoBean symtabFileInfoBean) {
        if (null == this.pathName) {
            return null;
        }
        if (null == this.arch || null == this.appName) {
            return null;
        }
        String string = this.pathName;
        string = string + SYMTAB_FILE_PREFIX;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + this.arch;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + Utils.urlEncodeString(this.appName);
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + this.sha1;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + symtabFileInfoBean.getSymbolTable().isHasDwarfInfo();
        string = string + SYMTAB_FILE_SUFFIX;
        return string;
    }

    private String machSymtabFileNameFormatter(SymtabFileInfoBean symtabFileInfoBean) {
        if (null == this.pathName) {
            return null;
        }
        if (null == this.arch || null == this.appName || null == this.uuid) {
            return null;
        }
        String string = this.pathName;
        string = string + SYMTAB_FILE_PREFIX;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + Utils.urlEncodeString(this.appName);
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + this.arch;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + this.uuid;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + symtabFileInfoBean.getSymbolTable().isHasDwarfInfo();
        string = string + SYMTAB_FILE_SUFFIX;
        return string;
    }

    private String pdbSymtabFileNameFormatter(SymtabFileInfoBean symtabFileInfoBean) {
        if (null == this.pathName) {
            return null;
        }
        if (null == this.arch || null == this.appName) {
            return null;
        }
        if (this.useTempDir) {
            this.pathName = System.getProperty("java.io.tmpdir");
        }
        String string = this.pathName;
        string = string + SYMTAB_FILE_PREFIX;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + this.arch;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + Utils.urlEncodeString(this.appName);
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + this.uuid;
        string = string + SYMTAB_FILE_SUFFIX;
        return string;
    }

    private String breakpadSymtabFileNameFormatter(boolean bl) {
        if (null == this.pathName) {
            return null;
        }
        if (null == this.arch || null == this.appName) {
            return null;
        }
        String string = this.pathName;
        string = string + SYMTAB_FILE_PREFIX;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + this.arch;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + Utils.urlEncodeString(this.appName);
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + this.uuid;
        string = string + BREAKPAD_SYMTAB_FILE_SUFFIX;
        return string;
    }

    private String stackVariableSymtabFileNameFormatter() {
        if (null == this.pathName) {
            return null;
        }
        if (null == this.arch || null == this.appName) {
            return null;
        }
        String string = this.pathName;
        string = string + SYMTAB_FILE_PREFIX;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + this.arch;
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + Utils.urlEncodeString(this.appName);
        string = string + SYMTAB_FILE_SEPERATOR;
        string = string + this.uuid;
        string = string + STACK_VARIABLE_SYMTAB_FILE_SUFFIX;
        return string;
    }

    private void fixSymbolAddr(Symbol symbol, long l) {
        if (this.fileType.equals(FILE_TYPE_ELF)) {
            symbol.setAddress(symbol.getAddress() + l);
            symbol.setEndAddress(symbol.getEndAddress() + l);
        } else {
            symbol.setAddress(symbol.getAddress() - l);
            symbol.setEndAddress(symbol.getEndAddress() - l);
        }
    }

    private void fixSymbolSrcFile(Symbol symbol) {
        int n;
        String string;
        if (FILE_TYPE_MACH.equals(this.fileType) && null != (string = symbol.getSourceFile()) && (n = string.lastIndexOf("/")) > 0) {
            string = string.substring(n + 1);
            symbol.setSourceFile(string);
        }
    }

    private String constructSymtabFileHeader(SymbolTable symbolTable) {
        this.header = new SymtabFileHeader();
        this.header.put(FILE_KEY, this.fileName);
        String string = this.fileType + "/" + this.fileFormat;
        this.header.put(FORMAT_KEY, string);
        this.header.put(ARCH_KEY, this.arch);
        this.header.put(SYMBOLS_KEY, Long.toString(symbolTable.size()));
        this.header.put(TOOL_VERSION_KEY, this.symtabToolVersion);
        this.header.put(FILE_VERSION_KEY, SYMTAB_FILE_VERSION);
        if (FILE_TYPE_ELF.equals(this.fileType)) {
            if (this.soVersion != null) {
                this.header.put(SO_VERSION_KEY, this.soVersion);
            }
            this.header.put(SHA1_KEY, this.sha1);
        } else if (FILE_TYPE_MACH.equals(this.fileType)) {
            this.header.put(UUID_KEY, this.uuid);
        }
        this.header.put(BUILT_TIME_KEY, Utils.getDateTime());
        this.header.put(P_VADDR, this.programVaddr);
        this.header.put(P_OFFSET, this.programOffset);
        this.header.put(P_ALIGN, this.programAlign);
        this.header.put(SYMTAB_LABEL, null);
        return this.header.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createBreakpadSymtab(ElfParser elfParser, boolean bl) {
        elfParser.parseBreakpadDebugId();
        elfParser.parseBreakpadCodeId();
        SymbolTable symbolTable = elfParser.getSymbolTable();
        ByteBuffer byteBuffer = ByteBuffer.allocate(0x6400000);
        this.breakpadSymtabFileName = this.breakpadSymtabFileNameFormatter(bl);
        FileChannel fileChannel = SymtabFile.createFileChannel(this.breakpadSymtabFileName, this.pathName, BREAKPAD_FILE_SUFFIX);
        if (fileChannel == null) {
            return false;
        }
        FileChannel fileChannel2 = SymtabFile.createFileChannel(this.fileName, this.pathName, BREAKPAD_INDEX_FILE_SUFFIX);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(0x6400000);
        FileChannel fileChannel3 = SymtabFile.createFileChannel(this.fileName, this.pathName, BREAKPAD_INDEX_FUNC_SUFFIX);
        ByteBuffer byteBuffer3 = ByteBuffer.allocate(0x6400000);
        FileChannel fileChannel4 = SymtabFile.createFileChannel(this.fileName, this.pathName, BREAKPAD_INDEX_CFI_SUFFIX);
        ByteBuffer byteBuffer4 = ByteBuffer.allocate(0x6400000);
        try {
            Object object;
            if (!bl) {
                object = new HashMap();
                int n = 1;
                Symbol symbol = symbolTable.next();
                while (symbol != null) {
                    String string;
                    this.fixSymbolSrcFile(symbol);
                    String string2 = symbol.getSourceFile();
                    int n2 = 0;
                    if (string2 != null) {
                        if (!object.containsKey(string2)) {
                            object.put(string2, n);
                            n2 = n;
                            string = String.format("FILE %d %s\n", n, string2);
                            SymtabFile.writeStrToBuffer(fileChannel2, byteBuffer2, string);
                            ++n;
                        } else {
                            n2 = (Integer)object.get(string2);
                        }
                    }
                    if (symbol.getAddress() < symbol.getEndAddress()) {
                        string = symbol.getFunction();
                        ArrayList<Symbol> arrayList = new ArrayList<Symbol>();
                        arrayList.add(symbol);
                        Symbol symbol2 = symbol;
                        while (null != (symbol = symbolTable.next()) && StringUtils.equalsIgnoreCase(symbol2.getFunction(), symbol.getFunction())) {
                            arrayList.add(symbol);
                        }
                        long l = ((Symbol)arrayList.get(0)).getAddress();
                        long l2 = ((Symbol)arrayList.get(arrayList.size() - 1)).getEndAddress();
                        long l3 = l2 - l;
                        String string3 = String.format("FUNC %s %s 0 %s\n", Long.toHexString(l), Long.toHexString(l3), string);
                        SymtabFile.writeStrToBuffer(fileChannel3, byteBuffer3, string3);
                        for (Symbol symbol3 : arrayList) {
                            String string4 = String.format("%s %s %d %d\n", Long.toHexString(symbol3.getAddress()), Long.toHexString(symbol3.getEndAddress() - symbol3.getAddress()), symbol3.getSourceLine() < 0L ? 0L : symbol3.getSourceLine(), n2);
                            SymtabFile.writeStrToBuffer(fileChannel3, byteBuffer3, string4);
                        }
                        continue;
                    }
                    symbol = symbolTable.next();
                }
            }
            object = new EhFrameParser();
            ((EhFrameParser)object).parseDwarf(elfParser.getHeaderParser(), elfParser, fileChannel4, byteBuffer4);
            String string = Paths.get(elfParser.getFileName(), new String[0]).getFileName().toString();
            elfParser.breakpadArch = ((EhFrameParser)object).getArchName();
            SymtabFile.writeStrToBuffer(fileChannel, byteBuffer, String.format("MODULE Linux %s %s %s\n", ((EhFrameParser)object).getArchName(), elfParser.getBreakpadDebugId(), string));
            SymtabFile.writeStrToBuffer(fileChannel, byteBuffer, String.format("INFO CODE_ID %s\n", elfParser.getBreakpadCodeId()));
            byteBuffer2.flip();
            fileChannel2.write(byteBuffer2);
            byteBuffer3.flip();
            fileChannel3.write(byteBuffer3);
            byteBuffer4.flip();
            fileChannel4.write(byteBuffer4);
            byteBuffer.flip();
            fileChannel.write(byteBuffer);
            if (!bl) {
                if (!SymtabFile.writeBufferToFile(fileChannel, fileChannel2, byteBuffer)) {
                    Log.error("[Breakpad] write file index error", new Object[0]);
                }
                if (!SymtabFile.writeBufferToFile(fileChannel, fileChannel3, byteBuffer)) {
                    Log.error("[Breakpad] write func index error", new Object[0]);
                }
            }
            if (!SymtabFile.writeBufferToFile(fileChannel, fileChannel4, byteBuffer)) {
                Log.error("[Breakpad] write cfi index error", new Object[0]);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            Log.error(exception);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            FileHelper.closeFile(breakpadFileRandomAccess);
            if (!breakpadFile.delete()) {
                breakpadFile.deleteOnExit();
            }
            FileHelper.closeFile(breakpadFuncRandomAccess);
            if (!breakpadFuncFile.delete()) {
                breakpadFuncFile.deleteOnExit();
            }
            FileHelper.closeFile(breakpadCfiRandomAccess);
            if (!breakpadCfiFile.delete()) {
                breakpadCfiFile.deleteOnExit();
            }
            FileHelper.closeFile(breakpadRandomAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createStackVariableSymtab(ElfParser elfParser) {
        SymbolTable symbolTable = elfParser.getSymbolTable();
        this.stackVariableSymtabFileName = this.stackVariableSymtabFileNameFormatter();
        FileChannel fileChannel = SymtabFile.createFileChannel(this.stackVariableSymtabFileName, this.pathName, STACK_VARIABLE_FILE_SUFFIX);
        if (fileChannel == null) {
            return false;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(0x6400000);
        try {
            String string = Paths.get(elfParser.getFileName(), new String[0]).getFileName().toString();
            SymtabFile.writeStrToBuffer(fileChannel, byteBuffer, String.format("MODULE Linux %s %s %s\n", elfParser.breakpadArch, elfParser.getBreakpadDebugId(), string));
            SymtabFile.writeStrToBuffer(fileChannel, byteBuffer, String.format("INFO CODE_ID %s\n", elfParser.getBreakpadCodeId()));
            for (SubroutineVariable subroutineVariable : symbolTable.subroutineVariables) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < subroutineVariable.getVariableEntries().size(); ++i) {
                    VariableEntry variableEntry = subroutineVariable.getVariableEntries().get(i);
                    stringBuilder.append(variableEntry.getName()).append(" ").append(variableEntry.getSize()).append(" ").append(variableEntry.getReadable()).append("\n");
                }
                String string2 = stringBuilder.toString();
                for (Subroutine subroutine : subroutineVariable.getSubroutines()) {
                    long l = subroutine.getLowPc();
                    long l2 = subroutine.getHighPc();
                    long l3 = l2 - l;
                    String string3 = String.format("FUNC %s %s\n%s", Long.toHexString(l), Long.toHexString(l3), string2);
                    SymtabFile.writeStrToBuffer(fileChannel, byteBuffer, string3);
                }
            }
            byteBuffer.flip();
            fileChannel.write(byteBuffer);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            Log.error(exception);
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(stackVariableRandomAccess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createSymtabFile(SymbolTable symbolTable, SymtabFileInfoBean symtabFileInfoBean) {
        if (FILE_TYPE_ELF.equals(this.fileType) || FILE_TYPE_LINUX_ELF.equals(this.fileType)) {
            this.symtabFileName = this.elfSymtabFileNameFormatter(symtabFileInfoBean);
        } else if (FILE_TYPE_MACH.equals(this.fileType)) {
            this.symtabFileName = this.machSymtabFileNameFormatter(symtabFileInfoBean);
        } else if (FILE_TYPE_PDB.equals(this.fileType)) {
            this.symtabFileName = this.pdbSymtabFileNameFormatter(symtabFileInfoBean);
        } else {
            Log.error("SymtabFile: Type of the file is unknown!", new Object[0]);
            return false;
        }
        if (null == this.symtabFileName) {
            Log.error("SymtabFile: The info to construct name of the symtab file is not enough!", new Object[0]);
            return false;
        }
        Log.info("Begin to create symtab file: %s", this.symtabFileName);
        BufferedWriter bufferedWriter = FileHelper.openFileWriter(new File(this.symtabFileName));
        if (null == bufferedWriter) {
            Log.error("SymtabFile: Failed to open symtab file!", new Object[0]);
            return false;
        }
        try {
            String string = this.constructSymtabFileHeader(symbolTable);
            if (null == string) {
                Log.error("SymtabFile: Failed to construct header of symtab file!", new Object[0]);
                boolean bl = false;
                return bl;
            }
            bufferedWriter.write(string);
        }
        catch (IOException iOException) {
            Log.error(iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            FileHelper.closeFile(bufferedWriter);
        }
        Log.info("Successfully created symtab file!", new Object[0]);
        return true;
    }

    private void setSymtabFileInfo(SymtabFileInfoBean symtabFileInfoBean) {
        this.setFileType(symtabFileInfoBean.getFileType());
        this.setFileFormat(symtabFileInfoBean.getFileFormat());
        this.setArch(symtabFileInfoBean.getArch());
        this.setFileName(symtabFileInfoBean.getFileName());
        this.setAppName(symtabFileInfoBean.getAppName());
        this.setSha1(symtabFileInfoBean.getSha1());
        this.setSoVersion(symtabFileInfoBean.getSoVersion());
        this.setUuid(symtabFileInfoBean.getUuid());
        this.setSymtabToolVersion(symtabFileInfoBean.getSymtabToolVersion());
        this.setProgramVaddr(String.valueOf(symtabFileInfoBean.getPvaddr()));
        this.setProgramAlign(String.valueOf(symtabFileInfoBean.getPAlign()));
        if (this.fileType.equals(FILE_TYPE_LINUX_ELF)) {
            this.setProgramOffset(String.valueOf(symtabFileInfoBean.getPvaddr()));
        } else {
            this.setProgramOffset(String.valueOf(symtabFileInfoBean.getPOffset()));
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getStackVariableSymtabFileName() {
        return this.stackVariableSymtabFileName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getArch() {
        return this.arch;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getSoVersion() {
        return this.soVersion;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getSymtabToolVersion() {
        return this.symtabToolVersion;
    }

    public SymtabFileHeader getHeader() {
        return this.header;
    }

    public String getProgramVaddr() {
        return this.programVaddr;
    }

    public String getProgramOffset() {
        return this.programOffset;
    }

    public String getProgramAlign() {
        return this.programAlign;
    }

    public boolean isUseTempDir() {
        return this.useTempDir;
    }

    public void setPathName(String string) {
        this.pathName = string;
    }

    public void setSymtabFileName(String string) {
        this.symtabFileName = string;
    }

    public void setBreakpadSymtabFileName(String string) {
        this.breakpadSymtabFileName = string;
    }

    public void setStackVariableSymtabFileName(String string) {
        this.stackVariableSymtabFileName = string;
    }

    public void setHeader(SymtabFileHeader symtabFileHeader) {
        this.header = symtabFileHeader;
    }

    public void setUseTempDir(boolean bl) {
        this.useTempDir = bl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SymtabFile)) {
            return false;
        }
        SymtabFile symtabFile = (SymtabFile)object;
        if (!symtabFile.canEqual(this)) {
            return false;
        }
        if (this.isUseTempDir() != symtabFile.isUseTempDir()) {
            return false;
        }
        String string = this.getFileName();
        String string2 = symtabFile.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getPathName();
        String string4 = symtabFile.getPathName();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.getSymtabFileName();
        String string6 = symtabFile.getSymtabFileName();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.getBreakpadSymtabFileName();
        String string8 = symtabFile.getBreakpadSymtabFileName();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.getStackVariableSymtabFileName();
        String string10 = symtabFile.getStackVariableSymtabFileName();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        String string11 = this.getAppName();
        String string12 = symtabFile.getAppName();
        if (string11 == null ? string12 != null : !string11.equals(string12)) {
            return false;
        }
        String string13 = this.getArch();
        String string14 = symtabFile.getArch();
        if (string13 == null ? string14 != null : !string13.equals(string14)) {
            return false;
        }
        String string15 = this.getUuid();
        String string16 = symtabFile.getUuid();
        if (string15 == null ? string16 != null : !string15.equals(string16)) {
            return false;
        }
        String string17 = this.getSha1();
        String string18 = symtabFile.getSha1();
        if (string17 == null ? string18 != null : !string17.equals(string18)) {
            return false;
        }
        String string19 = this.getSoVersion();
        String string20 = symtabFile.getSoVersion();
        if (string19 == null ? string20 != null : !string19.equals(string20)) {
            return false;
        }
        String string21 = this.getFileType();
        String string22 = symtabFile.getFileType();
        if (string21 == null ? string22 != null : !string21.equals(string22)) {
            return false;
        }
        String string23 = this.getFileFormat();
        String string24 = symtabFile.getFileFormat();
        if (string23 == null ? string24 != null : !string23.equals(string24)) {
            return false;
        }
        String string25 = this.getSymtabToolVersion();
        String string26 = symtabFile.getSymtabToolVersion();
        if (string25 == null ? string26 != null : !string25.equals(string26)) {
            return false;
        }
        SymtabFileHeader symtabFileHeader = this.getHeader();
        SymtabFileHeader symtabFileHeader2 = symtabFile.getHeader();
        if (symtabFileHeader == null ? symtabFileHeader2 != null : !symtabFileHeader.equals(symtabFileHeader2)) {
            return false;
        }
        String string27 = this.getProgramVaddr();
        String string28 = symtabFile.getProgramVaddr();
        if (string27 == null ? string28 != null : !string27.equals(string28)) {
            return false;
        }
        String string29 = this.getProgramOffset();
        String string30 = symtabFile.getProgramOffset();
        if (string29 == null ? string30 != null : !string29.equals(string30)) {
            return false;
        }
        String string31 = this.getProgramAlign();
        String string32 = symtabFile.getProgramAlign();
        return !(string31 == null ? string32 != null : !string31.equals(string32));
    }

    protected boolean canEqual(Object object) {
        return object instanceof SymtabFile;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + (this.isUseTempDir() ? 79 : 97);
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getPathName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.getSymtabFileName();
        n2 = n2 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.getBreakpadSymtabFileName();
        n2 = n2 * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.getStackVariableSymtabFileName();
        n2 = n2 * 59 + (string5 == null ? 43 : string5.hashCode());
        String string6 = this.getAppName();
        n2 = n2 * 59 + (string6 == null ? 43 : string6.hashCode());
        String string7 = this.getArch();
        n2 = n2 * 59 + (string7 == null ? 43 : string7.hashCode());
        String string8 = this.getUuid();
        n2 = n2 * 59 + (string8 == null ? 43 : string8.hashCode());
        String string9 = this.getSha1();
        n2 = n2 * 59 + (string9 == null ? 43 : string9.hashCode());
        String string10 = this.getSoVersion();
        n2 = n2 * 59 + (string10 == null ? 43 : string10.hashCode());
        String string11 = this.getFileType();
        n2 = n2 * 59 + (string11 == null ? 43 : string11.hashCode());
        String string12 = this.getFileFormat();
        n2 = n2 * 59 + (string12 == null ? 43 : string12.hashCode());
        String string13 = this.getSymtabToolVersion();
        n2 = n2 * 59 + (string13 == null ? 43 : string13.hashCode());
        SymtabFileHeader symtabFileHeader = this.getHeader();
        n2 = n2 * 59 + (symtabFileHeader == null ? 43 : symtabFileHeader.hashCode());
        String string14 = this.getProgramVaddr();
        n2 = n2 * 59 + (string14 == null ? 43 : string14.hashCode());
        String string15 = this.getProgramOffset();
        n2 = n2 * 59 + (string15 == null ? 43 : string15.hashCode());
        String string16 = this.getProgramAlign();
        n2 = n2 * 59 + (string16 == null ? 43 : string16.hashCode());
        return n2;
    }

    public String toString() {
        return "SymtabFile(fileName=" + this.getFileName() + ", pathName=" + this.getPathName() + ", symtabFileName=" + this.getSymtabFileName() + ", breakpadSymtabFileName=" + this.getBreakpadSymtabFileName() + ", stackVariableSymtabFileName=" + this.getStackVariableSymtabFileName() + ", appName=" + this.getAppName() + ", arch=" + this.getArch() + ", uuid=" + this.getUuid() + ", sha1=" + this.getSha1() + ", soVersion=" + this.getSoVersion() + ", fileType=" + this.getFileType() + ", fileFormat=" + this.getFileFormat() + ", symtabToolVersion=" + this.getSymtabToolVersion() + ", header=" + this.getHeader() + ", programVaddr=" + this.getProgramVaddr() + ", programOffset=" + this.getProgramOffset() + ", programAlign=" + this.getProgramAlign() + ", useTempDir=" + this.isUseTempDir() + ")";
    }

    static {
        breakpadFileRandomAccess = null;
        breakpadFuncRandomAccess = null;
        breakpadCfiRandomAccess = null;
        stackVariableRandomAccess = null;
    }
}

