/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.symtab;

import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.DebugLineParser;
import com.uqm.crashsight.symtabtool.symtab.SymbolEntry;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Symbol {
    public static final String SEPARATOR = "\t";
    public static final String NO_FUNCTION = "NoFunction";
    public static final String INLINE_INNER_SEPARATOR = "#";
    public static final String INLINE_SEPARATOR = ";";
    public static char FILE_SEPARATOR = (char)47;
    public boolean fixedVmAddr = false;
    private long address = -1L;
    private long endAddress = 0L;
    private String function = null;
    private String sourceFile = null;
    private long sourceline = -1L;
    private long sourceEndLine = -1L;
    private long sourceColumn = -1L;
    private List<SymbolEntry> entries = null;

    public Symbol() {
    }

    public Symbol(DebugLineParser.DebugLineEntry debugLineEntry, Subroutine subroutine) {
        this.setAddress(debugLineEntry.getAddress());
        this.setSourceFile(debugLineEntry.getPathName());
        this.setSourceLine(debugLineEntry.getLineNumber());
        this.setSourceEndLine(debugLineEntry.getEndLineNumber());
        this.setSourceColumn(debugLineEntry.getColumnNumber());
        this.setFunction(subroutine.getName());
        this.setEndAddress(subroutine.getHighPc());
    }

    public boolean hasFunctionName() {
        return null != this.function;
    }

    public long getAddress() {
        return this.address;
    }

    public void setAddress(long l) {
        this.address = l;
    }

    public long getEndAddress() {
        return this.endAddress;
    }

    public void setEndAddress(long l) {
        this.endAddress = l;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String string) {
        this.function = string;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String string) {
        this.sourceFile = string;
    }

    public long getSourceLine() {
        return this.sourceline;
    }

    public void setSourceLine(long l) {
        this.sourceline = l;
    }

    public long getSourceEndLine() {
        return this.sourceEndLine;
    }

    public void setSourceEndLine(long l) {
        this.sourceEndLine = l;
    }

    public long getSourceColumn() {
        return this.sourceColumn;
    }

    public void setSourceColumn(long l) {
        this.sourceColumn = l;
    }

    public List<SymbolEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<SymbolEntry> list) {
        this.entries = list;
    }

    public Symbol parseString(String string) {
        try {
            if (string.contains("\n")) {
                string = string.substring(0, string.indexOf("\n"));
            }
            String[] stringArray = string.split(SEPARATOR);
            this.address = Long.parseLong(stringArray[0], 16);
            this.endAddress = Long.parseLong(stringArray[1], 16);
            this.function = stringArray[2];
            if (this.function.equals(NO_FUNCTION)) {
                this.function = null;
            }
            if (stringArray.length > 3) {
                this.sourceFile = stringArray[3];
                this.sourceline = Long.parseLong(stringArray[4]);
                this.sourceEndLine = Long.parseLong(stringArray[5]);
                this.sourceColumn = Long.parseLong(stringArray[6]);
            }
            return this;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this;
        }
    }

    public Symbol parseStringLast(String string) {
        this.parseString(string);
        return this.transformSymbol();
    }

    public Symbol transformSymbol() {
        String[] stringArray;
        String string = "";
        String string2 = "";
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtils.isEmpty(this.sourceFile)) {
            stringArray = FileHelper.splitPath(this.sourceFile);
            string = stringArray[0];
            string2 = stringArray[1];
            if (StringUtils.isNotEmpty(string2)) {
                stringBuilder.append(this.sourceline);
                if (-1L != this.sourceEndLine) {
                    stringBuilder.append("-").append(this.sourceEndLine);
                }
                if (-1L != this.sourceColumn) {
                    stringBuilder.append(":").append(this.sourceColumn);
                }
            }
        }
        this.entries = new ArrayList<SymbolEntry>();
        if (this.function == null) {
            this.function = NO_FUNCTION;
        }
        if ((stringArray = this.function.split(INLINE_SEPARATOR)).length == 1) {
            this.entries.add(SymbolEntry.create(string, string2, this.function, stringBuilder.toString()));
        } else {
            int n = 0;
            for (n = 0; n < stringArray.length - 1; ++n) {
                String[] stringArray2 = stringArray[n].split(INLINE_INNER_SEPARATOR);
                if (stringArray2.length == 1) {
                    this.entries.add(SymbolEntry.create("", "", stringArray2[0], ""));
                    continue;
                }
                if (stringArray2.length != 3) {
                    Log.error("inline parse error: " + this, new Object[0]);
                    continue;
                }
                String[] stringArray3 = FileHelper.splitPath(stringArray2[1]);
                try {
                    this.entries.add(SymbolEntry.create(stringArray3[0], stringArray3[1], stringArray2[0], stringArray2[2]));
                    continue;
                }
                catch (Exception exception) {
                    Log.error(exception);
                }
            }
            this.entries.add(SymbolEntry.create(string, string2, stringArray[n], stringBuilder.toString()));
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (-1L == this.address) {
            Log.error("The symbol has no address!", new Object[0]);
            return null;
        }
        stringBuilder.append(Long.toHexString(this.address));
        stringBuilder.append(SEPARATOR);
        stringBuilder.append(Long.toHexString(this.endAddress));
        stringBuilder.append(SEPARATOR);
        if (StringUtils.isNotBlank(this.function)) {
            stringBuilder.append(this.function);
        } else {
            stringBuilder.append(NO_FUNCTION);
        }
        if (null != this.sourceFile) {
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(this.sourceFile);
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(this.sourceline);
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(this.sourceEndLine);
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(this.sourceColumn);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public String getSrcLineString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (null != this.sourceFile) {
            stringBuilder.append(this.sourceFile);
            stringBuilder.append("->");
            stringBuilder.append(this.sourceline);
            if (-1L != this.sourceEndLine) {
                stringBuilder.append("-");
                stringBuilder.append(this.sourceEndLine);
            }
        }
        return stringBuilder.toString();
    }

    public boolean contain(Symbol symbol) {
        return symbol.address >= this.address && symbol.endAddress <= this.endAddress;
    }

    public boolean contain(long l) {
        return l >= this.address && l < this.endAddress;
    }

    public boolean equals(Symbol symbol) {
        if (symbol.address != symbol.address) {
            return false;
        }
        if (!symbol.sourceFile.equals(this.sourceFile)) {
            return false;
        }
        if (symbol.sourceline != this.sourceline) {
            return false;
        }
        return symbol.sourceEndLine == this.sourceEndLine;
    }

    public boolean inter(Symbol symbol) {
        if (this.address >= symbol.getEndAddress()) {
            return false;
        }
        return this.endAddress > symbol.getAddress();
    }
}

