/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe.header;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class WindowsFields {
    long image_base;
    long section_alignment;
    long file_alignment;
    int major_operating_system_version;
    int minor_operating_system_version;
    int major_image_version;
    int minor_image_version;
    int major_subsystem_version;
    int minor_subsystem_version;
    long win32_version_value;
    long sizeOfImage;
    long size_of_headers;
    long check_sum;
    int subsystem;
    int dll_characteristics;
    long size_of_stack_reserve;
    long size_of_stack_commit;
    long size_of_heap_reserve;
    long size_of_heap_commit;
    long loader_flags;
    long number_of_rva_and_sizes;
    private static final long SIZEOF_WINDOWS_FIELDS_64 = 88L;

    public static WindowsFields parse(ParseBuffer parseBuffer) {
        WindowsFields windowsFields = new WindowsFields();
        windowsFields.image_base = parseBuffer.readU64();
        windowsFields.section_alignment = parseBuffer.readU32();
        windowsFields.file_alignment = parseBuffer.readU32();
        windowsFields.major_operating_system_version = parseBuffer.readU16();
        windowsFields.minor_operating_system_version = parseBuffer.readU16();
        windowsFields.major_image_version = parseBuffer.readU16();
        windowsFields.minor_image_version = parseBuffer.readU16();
        windowsFields.major_subsystem_version = parseBuffer.readU16();
        windowsFields.minor_subsystem_version = parseBuffer.readU16();
        windowsFields.win32_version_value = parseBuffer.readU32();
        windowsFields.sizeOfImage = parseBuffer.readU32();
        windowsFields.size_of_headers = parseBuffer.readU32();
        windowsFields.check_sum = parseBuffer.readU32();
        windowsFields.subsystem = parseBuffer.readU16();
        windowsFields.dll_characteristics = parseBuffer.readU16();
        windowsFields.size_of_stack_reserve = parseBuffer.readU64();
        windowsFields.size_of_stack_commit = parseBuffer.readU64();
        windowsFields.size_of_heap_reserve = parseBuffer.readU64();
        windowsFields.size_of_heap_commit = parseBuffer.readU64();
        windowsFields.loader_flags = parseBuffer.readU32();
        windowsFields.number_of_rva_and_sizes = parseBuffer.readU32();
        return windowsFields;
    }

    public long getImage_base() {
        return this.image_base;
    }

    public long getSection_alignment() {
        return this.section_alignment;
    }

    public long getFile_alignment() {
        return this.file_alignment;
    }

    public int getMajor_operating_system_version() {
        return this.major_operating_system_version;
    }

    public int getMinor_operating_system_version() {
        return this.minor_operating_system_version;
    }

    public int getMajor_image_version() {
        return this.major_image_version;
    }

    public int getMinor_image_version() {
        return this.minor_image_version;
    }

    public int getMajor_subsystem_version() {
        return this.major_subsystem_version;
    }

    public int getMinor_subsystem_version() {
        return this.minor_subsystem_version;
    }

    public long getWin32_version_value() {
        return this.win32_version_value;
    }

    public long getSizeOfImage() {
        return this.sizeOfImage;
    }

    public long getSize_of_headers() {
        return this.size_of_headers;
    }

    public long getCheck_sum() {
        return this.check_sum;
    }

    public int getSubsystem() {
        return this.subsystem;
    }

    public int getDll_characteristics() {
        return this.dll_characteristics;
    }

    public long getSize_of_stack_reserve() {
        return this.size_of_stack_reserve;
    }

    public long getSize_of_stack_commit() {
        return this.size_of_stack_commit;
    }

    public long getSize_of_heap_reserve() {
        return this.size_of_heap_reserve;
    }

    public long getSize_of_heap_commit() {
        return this.size_of_heap_commit;
    }

    public long getLoader_flags() {
        return this.loader_flags;
    }

    public long getNumber_of_rva_and_sizes() {
        return this.number_of_rva_and_sizes;
    }

    public void setImage_base(long l) {
        this.image_base = l;
    }

    public void setSection_alignment(long l) {
        this.section_alignment = l;
    }

    public void setFile_alignment(long l) {
        this.file_alignment = l;
    }

    public void setMajor_operating_system_version(int n) {
        this.major_operating_system_version = n;
    }

    public void setMinor_operating_system_version(int n) {
        this.minor_operating_system_version = n;
    }

    public void setMajor_image_version(int n) {
        this.major_image_version = n;
    }

    public void setMinor_image_version(int n) {
        this.minor_image_version = n;
    }

    public void setMajor_subsystem_version(int n) {
        this.major_subsystem_version = n;
    }

    public void setMinor_subsystem_version(int n) {
        this.minor_subsystem_version = n;
    }

    public void setWin32_version_value(long l) {
        this.win32_version_value = l;
    }

    public void setSizeOfImage(long l) {
        this.sizeOfImage = l;
    }

    public void setSize_of_headers(long l) {
        this.size_of_headers = l;
    }

    public void setCheck_sum(long l) {
        this.check_sum = l;
    }

    public void setSubsystem(int n) {
        this.subsystem = n;
    }

    public void setDll_characteristics(int n) {
        this.dll_characteristics = n;
    }

    public void setSize_of_stack_reserve(long l) {
        this.size_of_stack_reserve = l;
    }

    public void setSize_of_stack_commit(long l) {
        this.size_of_stack_commit = l;
    }

    public void setSize_of_heap_reserve(long l) {
        this.size_of_heap_reserve = l;
    }

    public void setSize_of_heap_commit(long l) {
        this.size_of_heap_commit = l;
    }

    public void setLoader_flags(long l) {
        this.loader_flags = l;
    }

    public void setNumber_of_rva_and_sizes(long l) {
        this.number_of_rva_and_sizes = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WindowsFields)) {
            return false;
        }
        WindowsFields windowsFields = (WindowsFields)object;
        if (!windowsFields.canEqual(this)) {
            return false;
        }
        if (this.getImage_base() != windowsFields.getImage_base()) {
            return false;
        }
        if (this.getSection_alignment() != windowsFields.getSection_alignment()) {
            return false;
        }
        if (this.getFile_alignment() != windowsFields.getFile_alignment()) {
            return false;
        }
        if (this.getMajor_operating_system_version() != windowsFields.getMajor_operating_system_version()) {
            return false;
        }
        if (this.getMinor_operating_system_version() != windowsFields.getMinor_operating_system_version()) {
            return false;
        }
        if (this.getMajor_image_version() != windowsFields.getMajor_image_version()) {
            return false;
        }
        if (this.getMinor_image_version() != windowsFields.getMinor_image_version()) {
            return false;
        }
        if (this.getMajor_subsystem_version() != windowsFields.getMajor_subsystem_version()) {
            return false;
        }
        if (this.getMinor_subsystem_version() != windowsFields.getMinor_subsystem_version()) {
            return false;
        }
        if (this.getWin32_version_value() != windowsFields.getWin32_version_value()) {
            return false;
        }
        if (this.getSizeOfImage() != windowsFields.getSizeOfImage()) {
            return false;
        }
        if (this.getSize_of_headers() != windowsFields.getSize_of_headers()) {
            return false;
        }
        if (this.getCheck_sum() != windowsFields.getCheck_sum()) {
            return false;
        }
        if (this.getSubsystem() != windowsFields.getSubsystem()) {
            return false;
        }
        if (this.getDll_characteristics() != windowsFields.getDll_characteristics()) {
            return false;
        }
        if (this.getSize_of_stack_reserve() != windowsFields.getSize_of_stack_reserve()) {
            return false;
        }
        if (this.getSize_of_stack_commit() != windowsFields.getSize_of_stack_commit()) {
            return false;
        }
        if (this.getSize_of_heap_reserve() != windowsFields.getSize_of_heap_reserve()) {
            return false;
        }
        if (this.getSize_of_heap_commit() != windowsFields.getSize_of_heap_commit()) {
            return false;
        }
        if (this.getLoader_flags() != windowsFields.getLoader_flags()) {
            return false;
        }
        return this.getNumber_of_rva_and_sizes() == windowsFields.getNumber_of_rva_and_sizes();
    }

    protected boolean canEqual(Object object) {
        return object instanceof WindowsFields;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getImage_base();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getSection_alignment();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getFile_alignment();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        n2 = n2 * 59 + this.getMajor_operating_system_version();
        n2 = n2 * 59 + this.getMinor_operating_system_version();
        n2 = n2 * 59 + this.getMajor_image_version();
        n2 = n2 * 59 + this.getMinor_image_version();
        n2 = n2 * 59 + this.getMajor_subsystem_version();
        n2 = n2 * 59 + this.getMinor_subsystem_version();
        long l4 = this.getWin32_version_value();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = this.getSizeOfImage();
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        long l6 = this.getSize_of_headers();
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        long l7 = this.getCheck_sum();
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        n2 = n2 * 59 + this.getSubsystem();
        n2 = n2 * 59 + this.getDll_characteristics();
        long l8 = this.getSize_of_stack_reserve();
        n2 = n2 * 59 + (int)(l8 >>> 32 ^ l8);
        long l9 = this.getSize_of_stack_commit();
        n2 = n2 * 59 + (int)(l9 >>> 32 ^ l9);
        long l10 = this.getSize_of_heap_reserve();
        n2 = n2 * 59 + (int)(l10 >>> 32 ^ l10);
        long l11 = this.getSize_of_heap_commit();
        n2 = n2 * 59 + (int)(l11 >>> 32 ^ l11);
        long l12 = this.getLoader_flags();
        n2 = n2 * 59 + (int)(l12 >>> 32 ^ l12);
        long l13 = this.getNumber_of_rva_and_sizes();
        n2 = n2 * 59 + (int)(l13 >>> 32 ^ l13);
        return n2;
    }

    public String toString() {
        return "WindowsFields(image_base=" + this.getImage_base() + ", section_alignment=" + this.getSection_alignment() + ", file_alignment=" + this.getFile_alignment() + ", major_operating_system_version=" + this.getMajor_operating_system_version() + ", minor_operating_system_version=" + this.getMinor_operating_system_version() + ", major_image_version=" + this.getMajor_image_version() + ", minor_image_version=" + this.getMinor_image_version() + ", major_subsystem_version=" + this.getMajor_subsystem_version() + ", minor_subsystem_version=" + this.getMinor_subsystem_version() + ", win32_version_value=" + this.getWin32_version_value() + ", sizeOfImage=" + this.getSizeOfImage() + ", size_of_headers=" + this.getSize_of_headers() + ", check_sum=" + this.getCheck_sum() + ", subsystem=" + this.getSubsystem() + ", dll_characteristics=" + this.getDll_characteristics() + ", size_of_stack_reserve=" + this.getSize_of_stack_reserve() + ", size_of_stack_commit=" + this.getSize_of_stack_commit() + ", size_of_heap_reserve=" + this.getSize_of_heap_reserve() + ", size_of_heap_commit=" + this.getSize_of_heap_commit() + ", loader_flags=" + this.getLoader_flags() + ", number_of_rva_and_sizes=" + this.getNumber_of_rva_and_sizes() + ")";
    }
}

