/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe.header;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.header.DataDirectories;
import com.uqm.crashsight.symtabtool.pe.header.StandardFields;
import com.uqm.crashsight.symtabtool.pe.header.WindowsFields;

public class OptionalHeader {
    StandardFields standardFields;
    WindowsFields windowsFields;
    DataDirectories dataDirectories;
    private static final long MAGIC_32 = 267L;
    private static final long MAGIC_64 = 523L;

    public static OptionalHeader parse(ParseBuffer parseBuffer) {
        OptionalHeader optionalHeader = new OptionalHeader();
        long l = parseBuffer.pos();
        int n = parseBuffer.readU16();
        parseBuffer.pos(l);
        if ((long)n == 267L) {
            optionalHeader.standardFields = StandardFields.parse(parseBuffer);
            optionalHeader.windowsFields = WindowsFields.parse(parseBuffer);
        } else if ((long)n == 523L) {
            optionalHeader.standardFields = StandardFields.parse(parseBuffer);
            optionalHeader.windowsFields = WindowsFields.parse(parseBuffer);
        }
        optionalHeader.dataDirectories = DataDirectories.parse(parseBuffer, 8L);
        l = parseBuffer.pos();
        return optionalHeader;
    }

    public StandardFields getStandardFields() {
        return this.standardFields;
    }

    public WindowsFields getWindowsFields() {
        return this.windowsFields;
    }

    public DataDirectories getDataDirectories() {
        return this.dataDirectories;
    }

    public void setStandardFields(StandardFields standardFields) {
        this.standardFields = standardFields;
    }

    public void setWindowsFields(WindowsFields windowsFields) {
        this.windowsFields = windowsFields;
    }

    public void setDataDirectories(DataDirectories dataDirectories) {
        this.dataDirectories = dataDirectories;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OptionalHeader)) {
            return false;
        }
        OptionalHeader optionalHeader = (OptionalHeader)object;
        if (!optionalHeader.canEqual(this)) {
            return false;
        }
        StandardFields standardFields = this.getStandardFields();
        StandardFields standardFields2 = optionalHeader.getStandardFields();
        if (standardFields == null ? standardFields2 != null : !standardFields.equals(standardFields2)) {
            return false;
        }
        WindowsFields windowsFields = this.getWindowsFields();
        WindowsFields windowsFields2 = optionalHeader.getWindowsFields();
        if (windowsFields == null ? windowsFields2 != null : !((Object)windowsFields).equals(windowsFields2)) {
            return false;
        }
        DataDirectories dataDirectories = this.getDataDirectories();
        DataDirectories dataDirectories2 = optionalHeader.getDataDirectories();
        return !(dataDirectories == null ? dataDirectories2 != null : !dataDirectories.equals(dataDirectories2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof OptionalHeader;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        StandardFields standardFields = this.getStandardFields();
        n2 = n2 * 59 + (standardFields == null ? 43 : standardFields.hashCode());
        WindowsFields windowsFields = this.getWindowsFields();
        n2 = n2 * 59 + (windowsFields == null ? 43 : ((Object)windowsFields).hashCode());
        DataDirectories dataDirectories = this.getDataDirectories();
        n2 = n2 * 59 + (dataDirectories == null ? 43 : dataDirectories.hashCode());
        return n2;
    }

    public String toString() {
        return "OptionalHeader(standardFields=" + this.getStandardFields() + ", windowsFields=" + this.getWindowsFields() + ", dataDirectories=" + this.getDataDirectories() + ")";
    }
}

