/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.pdb.Cpu;
import com.uqm.crashsight.symtabtool.pdb.dbi.MachineType;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.DebugData;
import com.uqm.crashsight.symtabtool.pe.ExceptionData;
import com.uqm.crashsight.symtabtool.pe.Section;
import com.uqm.crashsight.symtabtool.pe.header.Header;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;

public class PE {
    public Header header;
    public Section[] sections;
    public DebugData debugData;
    public ExceptionData exceptionData;
    public long fileAlignment;

    public static PE parse(ParseBuffer parseBuffer) {
        return PE.parseWithOpts(parseBuffer, true);
    }

    public static PE parseWithOpts(ParseBuffer parseBuffer, boolean bl) {
        PE pE = new PE();
        pE.header = Header.parse(parseBuffer);
        long l = pE.header.getDosHeader().pePointer + 4L + 20L + (long)pE.header.getCoffHeader().getSize_of_optional_header();
        pE.fileAlignment = pE.header.getOptionalHeader().getWindowsFields().getFile_alignment();
        pE.sections = pE.header.getCoffHeader().parseSection(parseBuffer, l);
        pE.debugData = DebugData.parse(parseBuffer, pE.header.getOptionalHeader().getDataDirectories().getDebugTable(), pE.sections, pE.fileAlignment);
        if ((long)pE.header.getCoffHeader().getMachine() == 34404L) {
            pE.exceptionData = ExceptionData.parse(parseBuffer, pE.header.getOptionalHeader().getDataDirectories().getExceptionTable(), pE.sections, pE.fileAlignment);
        }
        return pE;
    }

    public Cpu getCpu() {
        MachineType machineType = MachineType.fromInt(this.header.getCoffHeader().getMachine());
        switch (machineType) {
            case X86: {
                return Cpu.X86;
            }
            case Amd64: 
            case Ia64: {
                return Cpu.X86_64;
            }
        }
        return Cpu.Unknown;
    }

    public String getDebugId() {
        if (this.debugData != null && this.debugData.codeviewPDB70DebugInfo.signature != null) {
            String string = Hex.encodeHexString(this.debugData.codeviewPDB70DebugInfo.signature.getBytes()).toUpperCase();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(Long.toHexString(this.debugData.codeviewPDB70DebugInfo.age));
            return stringBuilder.toString().toUpperCase();
        }
        return "";
    }

    public Header getHeader() {
        return this.header;
    }

    public Section[] getSections() {
        return this.sections;
    }

    public DebugData getDebugData() {
        return this.debugData;
    }

    public ExceptionData getExceptionData() {
        return this.exceptionData;
    }

    public long getFileAlignment() {
        return this.fileAlignment;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setSections(Section[] sectionArray) {
        this.sections = sectionArray;
    }

    public void setDebugData(DebugData debugData) {
        this.debugData = debugData;
    }

    public void setExceptionData(ExceptionData exceptionData) {
        this.exceptionData = exceptionData;
    }

    public void setFileAlignment(long l) {
        this.fileAlignment = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PE)) {
            return false;
        }
        PE pE = (PE)object;
        if (!pE.canEqual(this)) {
            return false;
        }
        if (this.getFileAlignment() != pE.getFileAlignment()) {
            return false;
        }
        Header header = this.getHeader();
        Header header2 = pE.getHeader();
        if (header == null ? header2 != null : !((Object)header).equals(header2)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSections(), pE.getSections())) {
            return false;
        }
        DebugData debugData = this.getDebugData();
        DebugData debugData2 = pE.getDebugData();
        if (debugData == null ? debugData2 != null : !debugData.equals(debugData2)) {
            return false;
        }
        ExceptionData exceptionData = this.getExceptionData();
        ExceptionData exceptionData2 = pE.getExceptionData();
        return !(exceptionData == null ? exceptionData2 != null : !exceptionData.equals(exceptionData2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof PE;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getFileAlignment();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        Header header = this.getHeader();
        n2 = n2 * 59 + (header == null ? 43 : ((Object)header).hashCode());
        n2 = n2 * 59 + Arrays.deepHashCode(this.getSections());
        DebugData debugData = this.getDebugData();
        n2 = n2 * 59 + (debugData == null ? 43 : debugData.hashCode());
        ExceptionData exceptionData = this.getExceptionData();
        n2 = n2 * 59 + (exceptionData == null ? 43 : exceptionData.hashCode());
        return n2;
    }

    public String toString() {
        return "PE(header=" + this.getHeader() + ", sections=" + Arrays.deepToString(this.getSections()) + ", debugData=" + this.getDebugData() + ", exceptionData=" + this.getExceptionData() + ", fileAlignment=" + this.getFileAlignment() + ")";
    }
}

