/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pe;

import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pe.RuntimeFunction;
import com.uqm.crashsight.symtabtool.pe.Section;
import com.uqm.crashsight.symtabtool.pe.header.DataDirectories;

public class ExceptionData {
    byte a;
    long offset;
    long size;
    long fileAlignment;
    private static final long RUNTIME_FUNCTION_SIZE = 12L;

    public static ExceptionData parse(ParseBuffer parseBuffer, DataDirectories.DataDirectory dataDirectory, Section[] sectionArray, long l) {
        ExceptionData exceptionData = new ExceptionData();
        exceptionData.size = dataDirectory.size;
        if (exceptionData.size % 12L != 0L) {
            return null;
        }
        long l2 = dataDirectory.virtualAddress;
        exceptionData.offset = Utils.findOffset(l2, sectionArray, l);
        if (exceptionData.offset % 4L != 0L) {
            return null;
        }
        return exceptionData;
    }

    public RuntimeFunction[] findFunctions(ParseBuffer parseBuffer) {
        int n = new Long(this.size).intValue() / new Long(12L).intValue();
        RuntimeFunction[] runtimeFunctionArray = new RuntimeFunction[n];
        parseBuffer.pos(this.offset);
        for (int i = 0; i < n; ++i) {
            runtimeFunctionArray[i] = new RuntimeFunction();
            runtimeFunctionArray[i].beginAddr = parseBuffer.readU32();
            runtimeFunctionArray[i].endAddr = parseBuffer.readU32();
            runtimeFunctionArray[i].unwind_info_addr = parseBuffer.readU32();
        }
        return runtimeFunctionArray;
    }
}

