/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.common.Variant;
import com.uqm.crashsight.symtabtool.pdb.common.VariantEnum;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.tpi.ArgumentList;
import com.uqm.crashsight.symtabtool.pdb.tpi.ArrayType;
import com.uqm.crashsight.symtabtool.pdb.tpi.BaseClassType;
import com.uqm.crashsight.symtabtool.pdb.tpi.BitfieldType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ClassKind;
import com.uqm.crashsight.symtabtool.pdb.tpi.ClassType;
import com.uqm.crashsight.symtabtool.pdb.tpi.EnumerateType;
import com.uqm.crashsight.symtabtool.pdb.tpi.EnumerationType;
import com.uqm.crashsight.symtabtool.pdb.tpi.FieldAttributes;
import com.uqm.crashsight.symtabtool.pdb.tpi.FieldList;
import com.uqm.crashsight.symtabtool.pdb.tpi.MemberFunctionType;
import com.uqm.crashsight.symtabtool.pdb.tpi.MemberType;
import com.uqm.crashsight.symtabtool.pdb.tpi.MethodList;
import com.uqm.crashsight.symtabtool.pdb.tpi.MethodListEntry;
import com.uqm.crashsight.symtabtool.pdb.tpi.MethodType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ModifierType;
import com.uqm.crashsight.symtabtool.pdb.tpi.NestedType;
import com.uqm.crashsight.symtabtool.pdb.tpi.OverloadedMethodType;
import com.uqm.crashsight.symtabtool.pdb.tpi.PFunctionAttributes;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerAttributes;
import com.uqm.crashsight.symtabtool.pdb.tpi.PointerType;
import com.uqm.crashsight.symtabtool.pdb.tpi.ProcedureType;
import com.uqm.crashsight.symtabtool.pdb.tpi.StaticMemberType;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeEnum;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeIndex;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeInterface;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeProperties;
import com.uqm.crashsight.symtabtool.pdb.tpi.UnionType;
import com.uqm.crashsight.symtabtool.pdb.tpi.VirtualBaseClassType;
import com.uqm.crashsight.symtabtool.pdb.tpi.VirtualFunctionTablePointerType;
import java.util.ArrayList;
import java.util.EnumMap;

public class TypeData
extends EnumMap<TypeEnum, TypeInterface> {
    public TypeData(Class<TypeEnum> clazz) {
        super(clazz);
    }

    public static TypeIndex parseOptionalTypeIndex(ParseBuffer parseBuffer) {
        long l = parseBuffer.readU32();
        if (l == 0L || l == 65535L) {
            return null;
        }
        return new TypeIndex(l);
    }

    public static long parseUnsigned(ParseBuffer parseBuffer) {
        int n = parseBuffer.readU16();
        if (n < 32768) {
            return n;
        }
        switch (n) {
            case 32768: {
                return parseBuffer.readU8();
            }
            case 32770: {
                return parseBuffer.readU16();
            }
            case 32772: {
                return parseBuffer.readU32();
            }
            case 32778: {
                return parseBuffer.readI64();
            }
        }
        Log.error("UnexpectedNumericPrefix", new Object[0]);
        return n;
    }

    public static String parseString(int n, ParseBuffer parseBuffer) {
        if (n > 5376) {
            return parseBuffer.readCString();
        }
        return parseBuffer.readU8PascalStr();
    }

    public static TypeData parseTypeData(ParseBuffer parseBuffer) {
        TypeData typeData = new TypeData(TypeEnum.class);
        int n = parseBuffer.readU16();
        switch (n) {
            case 4100: 
            case 4101: 
            case 5380: 
            case 5381: 
            case 5401: {
                ClassType classType = new ClassType();
                switch (n) {
                    case 4100: 
                    case 5380: {
                        classType.kind = ClassKind.Class;
                        break;
                    }
                    case 4101: 
                    case 5381: {
                        classType.kind = ClassKind.Struct;
                        break;
                    }
                    default: {
                        classType.kind = ClassKind.Interface;
                    }
                }
                classType.count = parseBuffer.readU16();
                classType.properties = new TypeProperties(parseBuffer.readU16());
                classType.fields = TypeData.parseOptionalTypeIndex(parseBuffer);
                classType.derivedFrom = TypeData.parseOptionalTypeIndex(parseBuffer);
                classType.vtableShape = TypeData.parseOptionalTypeIndex(parseBuffer);
                classType.size = (int)TypeData.parseUnsigned(parseBuffer);
                classType.name = TypeData.parseString(n, parseBuffer);
                classType.uniqueName = null;
                typeData.put(TypeEnum.Class, classType);
                break;
            }
            case 5641: {
                ClassType classType = new ClassType();
                classType.kind = ClassKind.Struct;
                classType.properties = new TypeProperties(parseBuffer.readU16());
                classType.fields = TypeData.parseOptionalTypeIndex(parseBuffer);
                classType.derivedFrom = TypeData.parseOptionalTypeIndex(parseBuffer);
                classType.vtableShape = TypeData.parseOptionalTypeIndex(parseBuffer);
                classType.count = parseBuffer.readU16();
                classType.size = (int)TypeData.parseUnsigned(parseBuffer);
                classType.name = TypeData.parseString(n, parseBuffer);
                classType.uniqueName = null;
                if (classType.properties.has_unique_name()) {
                    classType.uniqueName = TypeData.parseString(n, parseBuffer);
                }
                typeData.put(TypeEnum.Class, classType);
                break;
            }
            case 5125: 
            case 5389: {
                MemberType memberType = new MemberType();
                memberType.attributes = new FieldAttributes(parseBuffer.readU16());
                memberType.field_type = new TypeIndex(parseBuffer.readU32());
                memberType.offset = (int)TypeData.parseUnsigned(parseBuffer);
                memberType.name = TypeData.parseString(n, parseBuffer);
                typeData.put(TypeEnum.Member, memberType);
                break;
            }
            case 5128: 
            case 5133: 
            case 5392: 
            case 5394: {
                int n2 = 0;
                if (n == 5394 || n == 5133) {
                    n2 = parseBuffer.readU16();
                } else {
                    parseBuffer.readU16();
                }
                NestedType nestedType = new NestedType();
                nestedType.attributes = new FieldAttributes(n2);
                nestedType.nested_type = new TypeIndex(parseBuffer.readU32());
                typeData.put(TypeEnum.Nested, nestedType);
                break;
            }
            case 4105: {
                MemberFunctionType memberFunctionType = new MemberFunctionType();
                memberFunctionType.returnType = TypeIndex.parse(parseBuffer);
                memberFunctionType.classType = TypeIndex.parse(parseBuffer);
                memberFunctionType.thisPointerType = TypeData.parseOptionalTypeIndex(parseBuffer);
                memberFunctionType.attributes = PFunctionAttributes.parse(parseBuffer);
                memberFunctionType.parameterCount = parseBuffer.readU16();
                memberFunctionType.argumentList = TypeIndex.parse(parseBuffer);
                typeData.put(TypeEnum.MemberFunction, memberFunctionType);
                break;
            }
            case 5127: 
            case 5391: {
                OverloadedMethodType overloadedMethodType = new OverloadedMethodType();
                overloadedMethodType.count = parseBuffer.readU16();
                overloadedMethodType.method_list = TypeIndex.parse(parseBuffer);
                overloadedMethodType.name = TypeData.parseString(n, parseBuffer);
                typeData.put(TypeEnum.OverloadedMethod, overloadedMethodType);
                break;
            }
            case 5131: 
            case 5393: {
                FieldAttributes fieldAttributes = FieldAttributes.parse(parseBuffer);
                MethodType methodType = new MethodType();
                methodType.attributes = fieldAttributes;
                methodType.method_type = TypeIndex.parse(parseBuffer);
                methodType.vtable_offset = fieldAttributes.isIntroVirtual() ? parseBuffer.readU32() : 0L;
                methodType.name = TypeData.parseString(n, parseBuffer);
                typeData.put(TypeEnum.Method, methodType);
                break;
            }
            case 5120: 
            case 5402: {
                BaseClassType baseClassType = new BaseClassType();
                switch (n) {
                    case 5120: {
                        baseClassType.kind = ClassKind.Class;
                        break;
                    }
                    case 5402: {
                        baseClassType.kind = ClassKind.Interface;
                        break;
                    }
                    default: {
                        Log.error("kind unreachable", new Object[0]);
                    }
                }
                baseClassType.attributes = FieldAttributes.parse(parseBuffer);
                baseClassType.baseClass = TypeIndex.parse(parseBuffer);
                baseClassType.offset = TypeData.parseUnsigned(parseBuffer);
                typeData.put(TypeEnum.BaseClass, baseClassType);
                break;
            }
            case 5129: {
                parseBuffer.readU16();
                VirtualFunctionTablePointerType virtualFunctionTablePointerType = new VirtualFunctionTablePointerType();
                virtualFunctionTablePointerType.table = TypeIndex.parse(parseBuffer);
                typeData.put(TypeEnum.VirtualFunctionTablePointer, virtualFunctionTablePointerType);
                break;
            }
            case 5126: 
            case 5390: {
                StaticMemberType staticMemberType = new StaticMemberType();
                staticMemberType.attributes = FieldAttributes.parse(parseBuffer);
                staticMemberType.fieldType = TypeIndex.parse(parseBuffer);
                staticMemberType.name = TypeData.parseString(n, parseBuffer);
                typeData.put(TypeEnum.StaticMember, staticMemberType);
                break;
            }
            case 4098: {
                TypeIndex typeIndex = TypeIndex.parse(parseBuffer);
                PointerAttributes pointerAttributes = PointerAttributes.parse(parseBuffer);
                TypeIndex typeIndex2 = pointerAttributes.pointerToMember() ? TypeIndex.parse(parseBuffer) : null;
                PointerType pointerType = new PointerType();
                pointerType.underlyingType = typeIndex;
                pointerType.attributes = pointerAttributes;
                pointerType.containingClass = typeIndex2;
                typeData.put(TypeEnum.Pointer, pointerType);
                break;
            }
            case 4104: {
                ProcedureType procedureType = new ProcedureType();
                procedureType.returnType = TypeData.parseOptionalTypeIndex(parseBuffer);
                procedureType.attributes = PFunctionAttributes.parse(parseBuffer);
                procedureType.parameterCount = parseBuffer.readU16();
                procedureType.argumentList = TypeIndex.parse(parseBuffer);
                typeData.put(TypeEnum.Procedure, procedureType);
                break;
            }
            case 4097: {
                TypeIndex typeIndex = TypeIndex.parse(parseBuffer);
                int n3 = parseBuffer.readU16();
                ModifierType modifierType = new ModifierType();
                modifierType.underlyingType = typeIndex;
                modifierType.constant = (n3 & 1) != 0;
                modifierType.pVolatile = (n3 & 2) != 0;
                modifierType.unaligned = (n3 & 4) != 0;
                typeData.put(TypeEnum.Modifier, modifierType);
                break;
            }
            case 4103: 
            case 5383: {
                EnumerationType enumerationType = new EnumerationType();
                enumerationType.count = parseBuffer.readU16();
                enumerationType.properties = new TypeProperties(parseBuffer.readU16());
                enumerationType.underlyingType = new TypeIndex(parseBuffer.readU32());
                enumerationType.fields = new TypeIndex(parseBuffer.readU32());
                enumerationType.name = TypeData.parseString(n, parseBuffer);
                enumerationType.uniqueName = null;
                typeData.put(TypeEnum.Enumeration, enumerationType);
                break;
            }
            case 1027: 
            case 5378: {
                EnumerateType enumerateType = new EnumerateType();
                enumerateType.attributes = new FieldAttributes(parseBuffer.readU16());
                enumerateType.value = new Variant(VariantEnum.class).parse(parseBuffer);
                enumerateType.name = TypeData.parseString(n, parseBuffer);
                typeData.put(TypeEnum.Enumerate, enumerateType);
                break;
            }
            case 4099: 
            case 5379: 
            case 5398: {
                TypeIndex typeIndex = new TypeIndex(parseBuffer.readU32());
                TypeIndex typeIndex3 = new TypeIndex(parseBuffer.readU32());
                Long l = n == 5398 ? Long.valueOf(parseBuffer.readU32()) : null;
                ArrayList<Long> arrayList = new ArrayList<Long>();
                do {
                    long l2;
                    if ((l2 = TypeData.parseUnsigned(parseBuffer)) > 0xFFFFFFFFL) {
                        Log.error("Unsupported symbol data format(u64 array sizes)", new Object[0]);
                        return typeData;
                    }
                    arrayList.add(l2);
                    if (!parseBuffer.isEmpty()) continue;
                    Log.error("UnexpectedEof", new Object[0]);
                    return typeData;
                } while (parseBuffer.getU8() != 0);
                parseBuffer.readU8();
                TypeData.parsePadding(parseBuffer);
                assert (parseBuffer.isEmpty());
                typeData.put(TypeEnum.Array, new ArrayType(typeIndex, typeIndex3, l, arrayList));
                break;
            }
            case 4102: 
            case 5382: {
                UnionType unionType = new UnionType(parseBuffer.readU16(), new TypeProperties(parseBuffer.readU16()), new TypeIndex(parseBuffer.readU32()), TypeData.parseUnsigned(parseBuffer), TypeData.parseString(n, parseBuffer), null);
                if (unionType.properties.has_unique_name()) {
                    unionType.uniqueName = TypeData.parseString(n, parseBuffer);
                }
                typeData.put(TypeEnum.Union, unionType);
                break;
            }
            case 4613: {
                typeData.put(TypeEnum.Bitfield, new BitfieldType(new TypeIndex(parseBuffer.readU32()), parseBuffer.readU8(), parseBuffer.readU8()));
                break;
            }
            case 10: 
            case 5405: {
                break;
            }
            case 5121: 
            case 5122: {
                typeData.put(TypeEnum.VirtualBaseClass, new VirtualBaseClassType(n == 5121, new FieldAttributes(parseBuffer.readU16()), new TypeIndex(parseBuffer.readU32()), new TypeIndex(parseBuffer.readU32()), TypeData.parseUnsigned(parseBuffer), TypeData.parseUnsigned(parseBuffer)));
                break;
            }
            case 4611: {
                ArrayList<TypeData> arrayList = new ArrayList<TypeData>();
                TypeIndex typeIndex = null;
                while (!parseBuffer.isEmpty()) {
                    int n4 = parseBuffer.getU16();
                    if (n4 == 5124) {
                        parseBuffer.readU16();
                        typeIndex = new TypeIndex(parseBuffer.readU32());
                    } else {
                        arrayList.add(TypeData.parseTypeData(parseBuffer));
                    }
                    TypeData.parsePadding(parseBuffer);
                }
                typeData.put(TypeEnum.FieldList, new FieldList(arrayList, typeIndex));
                break;
            }
            case 4609: {
                long l = parseBuffer.readU32();
                ArrayList<TypeIndex> arrayList = new ArrayList<TypeIndex>((int)l);
                int n5 = 0;
                while ((long)n5 < l) {
                    arrayList.add(new TypeIndex(parseBuffer.readU32()));
                    ++n5;
                }
                typeData.put(TypeEnum.ArgumentList, new ArgumentList(arrayList));
                break;
            }
            case 4614: {
                ArrayList<MethodListEntry> arrayList = new ArrayList<MethodListEntry>();
                while (!parseBuffer.isEmpty()) {
                    FieldAttributes fieldAttributes = new FieldAttributes(parseBuffer.readU16());
                    parseBuffer.readU16();
                    arrayList.add(new MethodListEntry(fieldAttributes, new TypeIndex(parseBuffer.readU32()), fieldAttributes.isIntroVirtual() ? Long.valueOf(parseBuffer.readU32()) : null));
                }
                typeData.put(TypeEnum.MethodList, new MethodList(arrayList));
                break;
            }
        }
        return typeData;
    }

    public static void parsePadding(ParseBuffer parseBuffer) {
        while (!parseBuffer.isEmpty() && parseBuffer.getU8() >= 240) {
            short s2 = parseBuffer.readU8();
            if (s2 <= 240) continue;
            parseBuffer.take((s2 & 0xF) - 1);
        }
    }
}

