/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.tpi.Constants;
import com.uqm.crashsight.symtabtool.pdb.tpi.Item;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemIndex;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemInformation;
import com.uqm.crashsight.symtabtool.pdb.tpi.ItemIter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class ItemFinder {
    ParseBuffer buffer;
    long minimumIndex;
    long maximumIndex;
    List<Long> positions;
    short shift;

    public ItemFinder(ItemInformation itemInformation, short s2) {
        long l = itemInformation.header.maximumIndex - itemInformation.header.minimumIndex;
        long l2 = (1L << s2) - 1L;
        long l3 = (l + l2 & (l2 ^ 0xFFFFFFFFFFFFFFFFL)) >> s2;
        ArrayList<Long> arrayList = new ArrayList<Long>((int)l3);
        if (l3 > 0L) {
            arrayList.add(itemInformation.header.headSize);
        }
        this.buffer = itemInformation.buffer.copyRef();
        this.minimumIndex = itemInformation.header.minimumIndex;
        this.maximumIndex = itemInformation.header.maximumIndex;
        this.positions = arrayList;
        this.shift = s2;
    }

    Pair<Long, Long> resolve(long l) {
        long l2 = l - this.minimumIndex;
        return new Pair<Long, Long>(l2 >> this.shift, l2 & (1L << this.shift) - 1L);
    }

    public ItemIndex maxIndex() {
        int n = this.positions.size();
        if (n == 0) {
            return new ItemIndex(0L);
        }
        return new ItemIndex(((long)n << this.shift) + this.minimumIndex + 1L);
    }

    public void update(ItemIter itemIter) {
        Pair<Long, Long> pair = this.resolve(itemIter.index);
        long l = pair.getValue();
        long l2 = pair.getKey();
        if (l == 0L && l2 == (long)this.positions.size()) {
            long l3 = itemIter.buffer.pos();
            assert (l3 < 0xFFFFFFFFL);
            this.positions.add(l3);
        }
    }

    public Item find(long l) {
        if (l < this.minimumIndex) {
            ParseBuffer parseBuffer = new ParseBuffer(ByteBuffer.wrap(Constants.PRIMITIVE_TYPE), 0L);
            return new Item(l, parseBuffer);
        }
        if (l > this.maximumIndex) {
            Log.error("TypeNotFound(%d)", l);
            return null;
        }
        Pair<Long, Long> pair = this.resolve(l);
        long l2 = pair.getValue();
        long l3 = pair.getKey();
        Long l4 = this.positions.get((int)l3);
        if (l4 != null) {
            ParseBuffer parseBuffer = this.buffer.copyRef();
            parseBuffer.pos(parseBuffer.pos() + l4);
            int n = 0;
            while ((long)n < l2) {
                int n2 = parseBuffer.readU16();
                parseBuffer.pos(parseBuffer.pos() + (long)n2);
                ++n;
            }
            n = parseBuffer.readU16();
            return new Item(l, parseBuffer.take(n));
        }
        Log.error("TypeNotIndexed", new Object[0]);
        return null;
    }
}

