/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.tpi;

import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.tpi.BuildInfoId;
import com.uqm.crashsight.symtabtool.pdb.tpi.FunctionId;
import com.uqm.crashsight.symtabtool.pdb.tpi.IdEnum;
import com.uqm.crashsight.symtabtool.pdb.tpi.IdIndex;
import com.uqm.crashsight.symtabtool.pdb.tpi.IdInterface;
import com.uqm.crashsight.symtabtool.pdb.tpi.MemberFunctionId;
import com.uqm.crashsight.symtabtool.pdb.tpi.StringId;
import com.uqm.crashsight.symtabtool.pdb.tpi.StringListId;
import com.uqm.crashsight.symtabtool.pdb.tpi.TypeIndex;
import com.uqm.crashsight.symtabtool.pdb.tpi.UserDefinedTypeSourceFileRef;
import com.uqm.crashsight.symtabtool.pdb.tpi.UserDefinedTypeSourceId;
import java.util.ArrayList;
import java.util.EnumMap;

public class IdData
extends EnumMap<IdEnum, IdInterface> {
    public IdData(Class<IdEnum> clazz) {
        super(clazz);
    }

    public static IdIndex parseOptionalTypeIndex(ParseBuffer parseBuffer) {
        long l = parseBuffer.readU32();
        if (l == 0L) {
            return null;
        }
        return new IdIndex(l);
    }

    public static String parseString(int n, ParseBuffer parseBuffer) {
        if (n > 5376) {
            return parseBuffer.readCString();
        }
        return parseBuffer.readU8PascalStr();
    }

    public void parse(ParseBuffer parseBuffer) {
        int n = parseBuffer.readU16();
        switch (n) {
            case 5633: {
                FunctionId functionId = new FunctionId();
                functionId.scope = IdData.parseOptionalTypeIndex(parseBuffer);
                functionId.functionType = TypeIndex.parse(parseBuffer);
                functionId.name = IdData.parseString(n, parseBuffer);
                this.put(IdEnum.Function, functionId);
                break;
            }
            case 5634: {
                MemberFunctionId memberFunctionId = new MemberFunctionId();
                memberFunctionId.parent = TypeIndex.parse(parseBuffer);
                memberFunctionId.functionType = TypeIndex.parse(parseBuffer);
                memberFunctionId.name = IdData.parseString(n, parseBuffer);
                this.put(IdEnum.MemberFunction, memberFunctionId);
                break;
            }
            case 5635: {
                int n2 = parseBuffer.readU16();
                ArrayList<IdIndex> arrayList = new ArrayList<IdIndex>(n2);
                for (int i = 0; i < n2; ++i) {
                    arrayList.add(IdIndex.parse(parseBuffer));
                }
                BuildInfoId buildInfoId = new BuildInfoId();
                buildInfoId.arguments = arrayList;
                this.put(IdEnum.BuildInfo, buildInfoId);
                break;
            }
            case 5636: {
                StringListId stringListId = new StringListId();
                long l = parseBuffer.readU32();
                ArrayList<TypeIndex> arrayList = new ArrayList<TypeIndex>((int)l);
                int n3 = 0;
                while ((long)n3 < l) {
                    arrayList.add(TypeIndex.parse(parseBuffer));
                    ++n3;
                }
                stringListId.substrings = arrayList;
                this.put(IdEnum.StringList, stringListId);
                break;
            }
            case 5637: {
                StringId stringId = new StringId();
                stringId.substrings = IdData.parseOptionalTypeIndex(parseBuffer);
                stringId.name = IdData.parseString(n, parseBuffer);
                this.put(IdEnum.PString, stringId);
                break;
            }
            case 5638: 
            case 5639: {
                TypeIndex typeIndex = TypeIndex.parse(parseBuffer);
                long l = parseBuffer.readU32();
                long l2 = parseBuffer.readU32();
                UserDefinedTypeSourceId userDefinedTypeSourceId = new UserDefinedTypeSourceId();
                userDefinedTypeSourceId.sourceFile = n == 5638 ? new UserDefinedTypeSourceFileRef(new IdIndex(l), null) : new UserDefinedTypeSourceFileRef(null, new Pair<Integer, Long>(parseBuffer.readU16(), l));
                userDefinedTypeSourceId.udt = typeIndex;
                userDefinedTypeSourceId.line = l2;
                this.put(IdEnum.UserDefinedTypeSource, userDefinedTypeSourceId);
                break;
            }
        }
    }
}

