/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class ThreadStorageSymbol {
    boolean global;
    long typeIndex;
    PdbInternalSectionOffset offset;
    String name;

    public ThreadStorageSymbol(boolean bl, long l, PdbInternalSectionOffset pdbInternalSectionOffset, String string) {
        this.global = bl;
        this.typeIndex = l;
        this.offset = pdbInternalSectionOffset;
        this.name = string;
    }

    public static ThreadStorageSymbol parse(ParseBuffer parseBuffer, int n) {
        try {
            return new ThreadStorageSymbol(n == 4371 || n == 4111, parseBuffer.readU32(), PdbInternalSectionOffset.parse(parseBuffer), Utils.parseSymbolName(parseBuffer, n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isGlobal() {
        return this.global;
    }

    public long getTypeIndex() {
        return this.typeIndex;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public void setGlobal(boolean bl) {
        this.global = bl;
    }

    public void setTypeIndex(long l) {
        this.typeIndex = l;
    }

    public void setOffset(PdbInternalSectionOffset pdbInternalSectionOffset) {
        this.offset = pdbInternalSectionOffset;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ThreadStorageSymbol)) {
            return false;
        }
        ThreadStorageSymbol threadStorageSymbol = (ThreadStorageSymbol)object;
        if (!threadStorageSymbol.canEqual(this)) {
            return false;
        }
        if (this.isGlobal() != threadStorageSymbol.isGlobal()) {
            return false;
        }
        if (this.getTypeIndex() != threadStorageSymbol.getTypeIndex()) {
            return false;
        }
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        PdbInternalSectionOffset pdbInternalSectionOffset2 = threadStorageSymbol.getOffset();
        if (pdbInternalSectionOffset == null ? pdbInternalSectionOffset2 != null : !((Object)pdbInternalSectionOffset).equals(pdbInternalSectionOffset2)) {
            return false;
        }
        String string = this.getName();
        String string2 = threadStorageSymbol.getName();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof ThreadStorageSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + (this.isGlobal() ? 79 : 97);
        long l = this.getTypeIndex();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        n2 = n2 * 59 + (pdbInternalSectionOffset == null ? 43 : ((Object)pdbInternalSectionOffset).hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    public String toString() {
        return "ThreadStorageSymbol(global=" + this.isGlobal() + ", typeIndex=" + this.getTypeIndex() + ", offset=" + this.getOffset() + ", name=" + this.getName() + ")";
    }
}

