/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.pdb.PDBContributions;
import com.uqm.crashsight.symtabtool.pdb.PDBSections;
import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.framedata.FrameTable;
import com.uqm.crashsight.symtabtool.pdb.module.source.Lines;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceLineCollector;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import com.uqm.crashsight.symtabtool.pdb.omap.Rva;
import com.uqm.crashsight.symtabtool.pdb.omap.RvaRangeIter;
import com.uqm.crashsight.symtabtool.pdb.symbol.BlockInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.EBPInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PDBSymbols;
import com.uqm.crashsight.symtabtool.pdb.symbol.ProcedureSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PublicSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.RegisterRelativeSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.SelectedSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.SymbolKey;
import com.uqm.crashsight.symtabtool.pdb.types.TypeDumper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class RvaSymbols {
    Map<Long, SelectedSymbol> map;
    long rva;
    SelectedSymbol symbol;
    long lastId;

    public static RvaSymbols empty() {
        RvaSymbols rvaSymbols = new RvaSymbols();
        rvaSymbols.map = new HashMap<Long, SelectedSymbol>(0);
        rvaSymbols.rva = 0L;
        rvaSymbols.symbol = null;
        rvaSymbols.lastId = 0L;
        return rvaSymbols;
    }

    public void addPublicSymbol(PublicSymbol publicSymbol, PDBSections pDBSections, PDBContributions pDBContributions, AddressMap addressMap) {
        Rva rva = publicSymbol.getOffset().toRva(addressMap);
        if (rva == null || rva.isNone()) {
            return;
        }
        if (publicSymbol.isCode() || publicSymbol.isFunction() || pDBSections.isCode(publicSymbol.getOffset().getSection()) && pDBContributions.isCode(publicSymbol.getOffset().getSection(), publicSymbol.getOffset().getOffset())) {
            String string = publicSymbol.getName();
            if (this.filterPublic(string)) {
                return;
            }
            SelectedSymbol selectedSymbol = this.map.getOrDefault(rva.getAddress(), null);
            if (selectedSymbol != null) {
                selectedSymbol.updatePublic(publicSymbol);
            } else {
                PdbInternalSectionOffset pdbInternalSectionOffset = publicSymbol.getOffset();
                SelectedSymbol selectedSymbol2 = new SelectedSymbol(string, 0L, true, false, pdbInternalSectionOffset, null, 0L, 0L, new Lines(), new ArrayList<EBPInfo>(0), this.lastId);
                this.map.put(rva.getAddress(), selectedSymbol2);
                ++this.lastId;
            }
        }
    }

    public void addProcedureSymbol(SourceLineCollector sourceLineCollector, ProcedureSymbol procedureSymbol, BlockInfo blockInfo) {
        String string = procedureSymbol.getName();
        SelectedSymbol selectedSymbol = this.map.get(blockInfo.getRva());
        if (selectedSymbol != null) {
            selectedSymbol.updatePrivate(procedureSymbol, blockInfo, sourceLineCollector);
        } else {
            Lines lines = sourceLineCollector.collectSourceLines(blockInfo.getOffset(), blockInfo.getLen());
            this.rva = blockInfo.getRva();
            this.symbol = new SelectedSymbol(string, procedureSymbol.getTypeIndex(), false, false, blockInfo.getOffset(), procedureSymbol.getOffset(), blockInfo.getLen(), 0L, lines, new ArrayList<EBPInfo>(), this.lastId);
            ++this.lastId;
        }
    }

    public SelectedSymbol getSymbolAt(long l) {
        return this.map.get(l);
    }

    public void addSymbol(SelectedSymbol selectedSymbol, BlockInfo blockInfo) {
        SelectedSymbol selectedSymbol2 = this.map.getOrDefault(blockInfo.getRva(), null);
        if (selectedSymbol2 != null) {
            selectedSymbol2.isMultiple = true;
        } else {
            this.map.put(blockInfo.getRva(), selectedSymbol);
        }
    }

    public void addEbp(RegisterRelativeSymbol registerRelativeSymbol) {
        if (this.symbol != null) {
            this.symbol.ebp.add(new EBPInfo(registerRelativeSymbol.getTypeIndex(), registerRelativeSymbol.getOffset()));
        }
    }

    public void closeProcedure() {
        if (this.symbol != null) {
            this.map.put(this.rva, this.symbol);
        }
    }

    public Pair<List<PDBSymbol>, Map<SymbolKey, Long>> splitAndCollect(TypeDumper typeDumper, AddressMap addressMap, FrameTable frameTable) {
        TreeMap<SymbolKey, Long> treeMap = new TreeMap<SymbolKey, Long>(Comparator.comparingLong(symbolKey -> symbolKey.rva));
        ArrayList<PDBSymbol> arrayList = new ArrayList<PDBSymbol>(this.map.size());
        for (Map.Entry<Long, SelectedSymbol> entry : this.map.entrySet()) {
            long l = entry.getKey();
            SelectedSymbol selectedSymbol = entry.getValue();
            if (selectedSymbol.offset.getOffset() == 95248L) {
                Log.info("break", new Object[0]);
            }
            Pair<PDBSymbol, PdbInternalSectionOffset> pair = selectedSymbol.mvToPdbSymbol(typeDumper, l, addressMap, frameTable);
            PDBSymbol pDBSymbol = pair.getKey();
            PdbInternalSectionOffset pdbInternalSectionOffset = pair.getValue();
            long l2 = arrayList.size();
            if (pDBSymbol.len == 0L) {
                treeMap.put(new SymbolKey(l, 0L), l2);
            } else {
                Range<Long> range;
                PdbInternalRva pdbInternalRva = pdbInternalSectionOffset.toInternalRva(addressMap);
                PdbInternalRva pdbInternalRva2 = new PdbInternalRva(pdbInternalRva.getAddress() + pDBSymbol.len);
                RvaRangeIter rvaRangeIter = addressMap.rvaRanges(Range.between(pdbInternalRva.getAddress(), pdbInternalRva2.getAddress()));
                while ((range = rvaRangeIter.next()) != null) {
                    treeMap.put(new SymbolKey(range.getMinimum(), range.getMaximum() - range.getMinimum()), l2);
                }
            }
            arrayList.add(pDBSymbol);
        }
        return new ImmutablePair<List<PDBSymbol>, Map<SymbolKey, Long>>(arrayList, treeMap);
    }

    public PDBSymbols fillTheGaps(List<PDBSymbol> list, Map<SymbolKey, Long> map) {
        TreeMap<Long, PDBSymbol> treeMap = PDBSymbols.empty().map;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        PDBSymbol pDBSymbol = null;
        long l3 = 0L;
        for (Map.Entry<SymbolKey, Long> entry : map.entrySet()) {
            long l4 = entry.getValue();
            long l5 = entry.getKey().rva;
            long l6 = entry.getKey().len;
            if (n == 0) {
                l = l5;
                l2 = l6;
                pDBSymbol = list.get((int)l4);
                l3 = pDBSymbol.id;
            } else {
                PDBSymbol pDBSymbol2 = list.get((int)l4);
                if (l3 == pDBSymbol2.id) {
                    l2 = l5 - l + l6;
                } else {
                    treeMap.put(l, pDBSymbol.getFrom(l, l2));
                    pDBSymbol = pDBSymbol2;
                    l3 = pDBSymbol2.id;
                    l = l5;
                    l2 = l6;
                }
            }
            ++n;
        }
        if (pDBSymbol != null) {
            treeMap.put(l, pDBSymbol.getFrom(l, l2));
        }
        return new PDBSymbols(treeMap);
    }

    public boolean isConstantString(String string) {
        return string != null && string.startsWith("??_C");
    }

    public boolean isConstantNumber(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("__")) {
            return (string = string.replaceFirst("__", "")).startsWith("real@") || string.startsWith("xmm@") || string.startsWith("ymm@");
        }
        return false;
    }

    public boolean filterPublic(String string) {
        return this.isConstantString(string) || this.isConstantNumber(string);
    }

    public PDBSymbols moveToPdbSymbols(TypeDumper typeDumper, AddressMap addressMap, FrameTable frameTable) {
        if (this.map.isEmpty()) {
            return PDBSymbols.empty();
        }
        Pair<List<PDBSymbol>, Map<SymbolKey, Long>> pair = this.splitAndCollect(typeDumper, addressMap, frameTable);
        return this.fillTheGaps(pair.getLeft(), pair.getRight());
    }
}

