/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.symbol;

import com.uqm.crashsight.symtabtool.pdb.common.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;
import com.uqm.crashsight.symtabtool.pdb.symbol.Utils;

public class BlockSymbol {
    long parent;
    long end;
    long len;
    PdbInternalSectionOffset offset;
    String name;

    public static BlockSymbol parse(ParseBuffer parseBuffer, int n) {
        try {
            BlockSymbol blockSymbol = new BlockSymbol();
            blockSymbol.parent = parseBuffer.readU32();
            blockSymbol.end = parseBuffer.readU32();
            blockSymbol.len = parseBuffer.readU32();
            blockSymbol.offset = PdbInternalSectionOffset.parse(parseBuffer);
            blockSymbol.name = Utils.parseSymbolName(parseBuffer, n);
            return blockSymbol;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public long getParent() {
        return this.parent;
    }

    public long getEnd() {
        return this.end;
    }

    public long getLen() {
        return this.len;
    }

    public PdbInternalSectionOffset getOffset() {
        return this.offset;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(long l) {
        this.parent = l;
    }

    public void setEnd(long l) {
        this.end = l;
    }

    public void setLen(long l) {
        this.len = l;
    }

    public void setOffset(PdbInternalSectionOffset pdbInternalSectionOffset) {
        this.offset = pdbInternalSectionOffset;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BlockSymbol)) {
            return false;
        }
        BlockSymbol blockSymbol = (BlockSymbol)object;
        if (!blockSymbol.canEqual(this)) {
            return false;
        }
        if (this.getParent() != blockSymbol.getParent()) {
            return false;
        }
        if (this.getEnd() != blockSymbol.getEnd()) {
            return false;
        }
        if (this.getLen() != blockSymbol.getLen()) {
            return false;
        }
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        PdbInternalSectionOffset pdbInternalSectionOffset2 = blockSymbol.getOffset();
        if (pdbInternalSectionOffset == null ? pdbInternalSectionOffset2 != null : !((Object)pdbInternalSectionOffset).equals(pdbInternalSectionOffset2)) {
            return false;
        }
        String string = this.getName();
        String string2 = blockSymbol.getName();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof BlockSymbol;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getParent();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getEnd();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getLen();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        PdbInternalSectionOffset pdbInternalSectionOffset = this.getOffset();
        n2 = n2 * 59 + (pdbInternalSectionOffset == null ? 43 : ((Object)pdbInternalSectionOffset).hashCode());
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }

    public String toString() {
        return "BlockSymbol(parent=" + this.getParent() + ", end=" + this.getEnd() + ", len=" + this.getLen() + ", offset=" + this.getOffset() + ", name=" + this.getName() + ")";
    }
}

