/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.stream;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ParseBuffer {
    private static final long FIX_LEB128 = 127L;
    private ByteBuffer buffer;
    private final ByteBuffer tmpBuffer = ByteBuffer.allocate(8);
    private final ByteBuffer tmpBuffer4 = ByteBuffer.allocate(4);
    private final byte[] tmpBytes = new byte[8];
    private final byte[] tmpBytes4 = new byte[4];
    private long ptr = 0L;

    public void addPtr(long l) {
        this.ptr += l;
    }

    public static ParseBuffer empty() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return new ParseBuffer(byteBuffer);
    }

    public ParseBuffer(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer = byteBuffer;
    }

    public ParseBuffer(ByteBuffer byteBuffer) {
        assert (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN);
        this.buffer = byteBuffer;
    }

    public ParseBuffer(ByteBuffer byteBuffer, long l, long l2) {
        assert (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN);
        int n = (int)(l2 - l);
        byte[] byArray = new byte[n];
        System.arraycopy(byteBuffer.array(), (int)l, byArray, 0, n);
        this.buffer = ByteBuffer.wrap(byArray);
    }

    public ParseBuffer copy() {
        return this.copyFrom(0L);
    }

    public ParseBuffer copyRef() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.getBuffer().array());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return new ParseBuffer(byteBuffer);
    }

    public ParseBuffer copyPos() {
        return this.copyFrom(this.pos());
    }

    public ParseBuffer copyFrom(long l) {
        assert (this.buffer.order() == ByteOrder.LITTLE_ENDIAN);
        int n = (int)l;
        byte[] byArray = this.buffer.array();
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ParseBuffer parseBuffer = new ParseBuffer(byteBuffer);
        parseBuffer.ptr = n;
        return parseBuffer;
    }

    public ParseBuffer copy(long l, long l2) {
        long l3 = this.pos();
        this.pos(l);
        byte[] byArray = this.buffer.array();
        byte[] byArray2 = new byte[(int)l2];
        System.arraycopy(byArray, (int)l, byArray2, 0, byArray2.length);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ParseBuffer parseBuffer = new ParseBuffer(byteBuffer);
        parseBuffer.ptr = l;
        this.pos(l3);
        return parseBuffer;
    }

    public ParseBuffer truncate(long l) {
        if ((long)this.buffer.limit() >= l) {
            byte[] byArray = new byte[(int)l];
            System.arraycopy(this.buffer.array(), 0, byArray, 0, byArray.length);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            return new ParseBuffer(byteBuffer);
        }
        Log.error("UnexpectedEof", new Object[0]);
        return this;
    }

    public ParseBuffer(ByteBuffer byteBuffer, long l) {
        assert (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN);
        int n = (int)l;
        byte[] byArray = byteBuffer.array();
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer = byteBuffer2;
    }

    public ParseBuffer take(long l) {
        byte[] byArray = this.readBytes(l);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return new ParseBuffer(byteBuffer);
    }

    public ParseBuffer[] splitAt(long l) {
        ParseBuffer[] parseBufferArray = new ParseBuffer[2];
        byte[] byArray = new byte[(int)l];
        byte[] byArray2 = new byte[(int)(this.limit() - l)];
        System.arraycopy(this.buffer.array(), 0, byArray, 0, byArray.length);
        System.arraycopy(this.buffer.array(), byArray.length, byArray2, 0, byArray2.length);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        parseBufferArray[0] = new ParseBuffer(byteBuffer);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray2);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        parseBufferArray[1] = new ParseBuffer(byteBuffer2);
        return parseBufferArray;
    }

    public long pos() {
        return this.buffer.position();
    }

    public void pos(long l) {
        this.buffer.position((int)l);
    }

    public long limit() {
        return this.buffer.limit();
    }

    public void start(long l) {
    }

    public long len() {
        return this.buffer.limit() - this.buffer.position();
    }

    public boolean isEmpty() {
        return this.len() == 0L;
    }

    public long remaining() {
        return this.buffer.remaining();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public void align(long l) {
        long l2 = this.pos() % l;
        if (l2 > 0L) {
            if (this.len() < l - l2) {
                Log.error("UnexpectedEof", new Object[0]);
            }
            this.pos(this.pos() + (l - l2));
        }
    }

    public byte get(long l) {
        return this.buffer.get((int)l);
    }

    public byte[] getBytes(long l) {
        byte[] byArray = this.readBytes(l);
        this.pos(this.pos() - l);
        return byArray;
    }

    public byte[] readBytes(long l) {
        byte[] byArray = new byte[(int)l];
        this.buffer.get(byArray);
        return byArray;
    }

    public byte readI8() {
        return this.buffer.get();
    }

    public short readI16() {
        return this.buffer.getShort();
    }

    public short readLeI16() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        short s2 = this.buffer.getShort();
        this.buffer.order(byteOrder);
        return s2;
    }

    public short readBeI16() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        short s2 = this.buffer.getShort();
        this.buffer.order(byteOrder);
        return s2;
    }

    public int readI32() {
        return this.buffer.getInt();
    }

    public int readLeI32() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = this.buffer.getInt();
        this.buffer.order(byteOrder);
        return n;
    }

    public int readBeI32() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int n = this.buffer.getInt();
        this.buffer.order(byteOrder);
        return n;
    }

    public long readI64() {
        return this.buffer.getLong();
    }

    public long readLeI64() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        long l = this.buffer.getLong();
        this.buffer.order(byteOrder);
        return l;
    }

    public long readBeI64() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        long l = this.buffer.getLong();
        this.buffer.order(byteOrder);
        return l;
    }

    public short readU8() {
        byte by = this.buffer.get();
        this.tmpBuffer.clear();
        this.tmpBuffer.put((byte)0);
        this.tmpBuffer.put(by);
        this.tmpBuffer.flip();
        return this.tmpBuffer.getShort();
    }

    public short getU8() {
        short s2 = this.readU8();
        this.pos(this.pos() - 1L);
        return s2;
    }

    public int readU16() {
        this.buffer.get(this.tmpBytes, 0, 2);
        this.tmpBuffer.clear();
        this.tmpBuffer.putShort((short)0);
        for (int i = 1; i >= 0; --i) {
            this.tmpBuffer.put(this.tmpBytes[i]);
        }
        this.tmpBuffer.flip();
        return this.tmpBuffer.getInt();
    }

    public int getU16() {
        int n = this.readU16();
        this.pos(this.pos() - 2L);
        return n;
    }

    public int getBeU16() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int n = this.readU16();
        this.pos(this.pos() - 2L);
        this.buffer.order(byteOrder);
        return n;
    }

    public int getLeU16() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = this.readU16();
        this.pos(this.pos() - 2L);
        this.buffer.order(byteOrder);
        return n;
    }

    public long readU32() {
        try {
            this.buffer.get(this.tmpBytes4, 0, 4);
            this.tmpBuffer.clear();
            this.tmpBuffer.putInt(0);
            for (int i = 3; i >= 0; --i) {
                this.tmpBuffer.put(this.tmpBytes4[i]);
            }
            this.tmpBuffer.flip();
        }
        catch (Exception exception) {
            boolean bl = false;
        }
        return this.tmpBuffer.getLong();
    }

    public long readU64() {
        this.buffer.get(this.tmpBytes, 0, 8);
        this.tmpBuffer.clear();
        for (int i = 7; i >= 0; --i) {
            this.tmpBuffer.put(this.tmpBytes[i]);
        }
        this.tmpBuffer.flip();
        return this.tmpBuffer.getLong();
    }

    public byte[] readAtPosWithMode(long l, int n, int n2) {
        byte[] byArray = new byte[100];
        this.buffer.get(byArray, new Long(l).intValue(), n);
        return byArray;
    }

    public long getU32() {
        long l = this.readU32();
        this.pos(this.pos() - 4L);
        return l;
    }

    public long getLeU32() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        long l = this.readU32();
        this.pos(this.pos() - 4L);
        this.buffer.order(byteOrder);
        return l;
    }

    public long getBeU32() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        long l = this.readU32();
        this.pos(this.pos() - 4L);
        this.buffer.order(byteOrder);
        return l;
    }

    public long getLeU64() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        long l = this.readI64();
        this.pos(this.pos() - 8L);
        this.buffer.order(byteOrder);
        return l;
    }

    public long getBeU64() {
        ByteOrder byteOrder = this.buffer.order();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        long l = this.readI64();
        this.pos(this.pos() - 8L);
        this.buffer.order(byteOrder);
        return l;
    }

    public long parseULeb128() {
        byte by;
        long l = 0L;
        long l2 = 0L;
        do {
            by = this.buffer.get();
            l |= ((long)by & 0x7FL) << (int)l2;
            l2 += 7L;
        } while ((by & 0x80) != 0);
        return l;
    }

    public long parseSLeb128() {
        byte by;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        do {
            by = this.buffer.get();
            l |= ((long)by & 0x7FL) << (int)l2;
            l2 += 7L;
            boolean bl2 = bl = (by & 0x40) != 0;
        } while ((by & 0x80) != 0);
        if (bl) {
            l |= -(1L << (int)l2);
        }
        return l;
    }

    public String readCString(long l) {
        this.pos(l);
        return this.readCString();
    }

    public boolean checkCString() {
        long l = this.pos();
        boolean bl = false;
        while (this.buffer.hasRemaining()) {
            if (this.buffer.get() != 0) continue;
            bl = true;
            break;
        }
        this.pos(l);
        return bl;
    }

    public String readCString() {
        byte by;
        StringBuilder stringBuilder = new StringBuilder();
        while ((by = this.buffer.get()) != 0) {
            stringBuilder.append((char)by);
        }
        return stringBuilder.toString();
    }

    public String readU8PascalStr() {
        int n = this.readU8();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = n; i > 0; --i) {
            stringBuilder.append((char)this.readI8());
        }
        return stringBuilder.toString();
    }

    public int find(byte by) {
        int n = 0;
        for (byte by2 : this.buffer.array()) {
            if (by2 == by) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getTmpBuffer() {
        return this.tmpBuffer;
    }

    public ByteBuffer getTmpBuffer4() {
        return this.tmpBuffer4;
    }

    public byte[] getTmpBytes() {
        return this.tmpBytes;
    }

    public byte[] getTmpBytes4() {
        return this.tmpBytes4;
    }

    public long getPtr() {
        return this.ptr;
    }

    public void setBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public void setPtr(long l) {
        this.ptr = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ParseBuffer)) {
            return false;
        }
        ParseBuffer parseBuffer = (ParseBuffer)object;
        if (!parseBuffer.canEqual(this)) {
            return false;
        }
        if (this.getPtr() != parseBuffer.getPtr()) {
            return false;
        }
        ByteBuffer byteBuffer = this.getBuffer();
        ByteBuffer byteBuffer2 = parseBuffer.getBuffer();
        if (byteBuffer == null ? byteBuffer2 != null : !((Object)byteBuffer).equals(byteBuffer2)) {
            return false;
        }
        ByteBuffer byteBuffer3 = this.getTmpBuffer();
        ByteBuffer byteBuffer4 = parseBuffer.getTmpBuffer();
        if (byteBuffer3 == null ? byteBuffer4 != null : !((Object)byteBuffer3).equals(byteBuffer4)) {
            return false;
        }
        ByteBuffer byteBuffer5 = this.getTmpBuffer4();
        ByteBuffer byteBuffer6 = parseBuffer.getTmpBuffer4();
        if (byteBuffer5 == null ? byteBuffer6 != null : !((Object)byteBuffer5).equals(byteBuffer6)) {
            return false;
        }
        if (!Arrays.equals(this.getTmpBytes(), parseBuffer.getTmpBytes())) {
            return false;
        }
        return Arrays.equals(this.getTmpBytes4(), parseBuffer.getTmpBytes4());
    }

    protected boolean canEqual(Object object) {
        return object instanceof ParseBuffer;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getPtr();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        ByteBuffer byteBuffer = this.getBuffer();
        n2 = n2 * 59 + (byteBuffer == null ? 43 : ((Object)byteBuffer).hashCode());
        ByteBuffer byteBuffer2 = this.getTmpBuffer();
        n2 = n2 * 59 + (byteBuffer2 == null ? 43 : ((Object)byteBuffer2).hashCode());
        ByteBuffer byteBuffer3 = this.getTmpBuffer4();
        n2 = n2 * 59 + (byteBuffer3 == null ? 43 : ((Object)byteBuffer3).hashCode());
        n2 = n2 * 59 + Arrays.hashCode(this.getTmpBytes());
        n2 = n2 * 59 + Arrays.hashCode(this.getTmpBytes4());
        return n2;
    }

    public String toString() {
        return "ParseBuffer(buffer=" + this.getBuffer() + ", tmpBuffer=" + this.getTmpBuffer() + ", tmpBuffer4=" + this.getTmpBuffer4() + ", tmpBytes=" + Arrays.toString(this.getTmpBytes()) + ", tmpBytes4=" + Arrays.toString(this.getTmpBytes4()) + ", ptr=" + this.getPtr() + ")";
    }
}

