/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.pe;

import com.uqm.crashsight.symtabtool.pdb.stream.ParseBuffer;

public class ImageSectionHeader {
    byte[] name = new byte[8];
    long physicalAddress;
    long virtualAddress;
    long sizeOfRawData;
    long pointerToRawData;
    long pointerToRelocations;
    long pointerToLineNumbers;
    int numberOfRelocations;
    int numberOfLineNumbers;
    long characteristics;

    public static ImageSectionHeader parse(ParseBuffer parseBuffer) {
        ImageSectionHeader imageSectionHeader = new ImageSectionHeader();
        imageSectionHeader.name = parseBuffer.readBytes(8L);
        imageSectionHeader.physicalAddress = parseBuffer.readU32();
        imageSectionHeader.virtualAddress = parseBuffer.readU32();
        imageSectionHeader.sizeOfRawData = parseBuffer.readU32();
        imageSectionHeader.pointerToRawData = parseBuffer.readU32();
        imageSectionHeader.pointerToRelocations = parseBuffer.readU32();
        imageSectionHeader.pointerToLineNumbers = parseBuffer.readU32();
        imageSectionHeader.numberOfRelocations = parseBuffer.readU16();
        imageSectionHeader.numberOfLineNumbers = parseBuffer.readU16();
        imageSectionHeader.characteristics = parseBuffer.readU32();
        return imageSectionHeader;
    }

    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : this.name) {
            if (by == 0) break;
            char c = (char)by;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public boolean isTextSection() {
        return ".text".equalsIgnoreCase(this.getName());
    }

    public String toString() {
        return "name:" + this.getName() + " PhysicalAddress(VirtualSize):0x" + Long.toString(this.physicalAddress, 16) + " virtualAddress:0x" + Long.toString(this.virtualAddress, 16) + " sizeOfRawData:0x" + Long.toString(this.sizeOfRawData, 16);
    }

    public long getPhysicalAddress() {
        return this.physicalAddress;
    }

    public long getVirtualAddress() {
        return this.virtualAddress;
    }

    public long getSizeOfRawData() {
        return this.sizeOfRawData;
    }

    public long getPointerToRawData() {
        return this.pointerToRawData;
    }

    public long getPointerToRelocations() {
        return this.pointerToRelocations;
    }

    public long getPointerToLineNumbers() {
        return this.pointerToLineNumbers;
    }

    public int getNumberOfRelocations() {
        return this.numberOfRelocations;
    }

    public int getNumberOfLineNumbers() {
        return this.numberOfLineNumbers;
    }

    public long getCharacteristics() {
        return this.characteristics;
    }

    public void setName(byte[] byArray) {
        this.name = byArray;
    }

    public void setPhysicalAddress(long l) {
        this.physicalAddress = l;
    }

    public void setVirtualAddress(long l) {
        this.virtualAddress = l;
    }

    public void setSizeOfRawData(long l) {
        this.sizeOfRawData = l;
    }

    public void setPointerToRawData(long l) {
        this.pointerToRawData = l;
    }

    public void setPointerToRelocations(long l) {
        this.pointerToRelocations = l;
    }

    public void setPointerToLineNumbers(long l) {
        this.pointerToLineNumbers = l;
    }

    public void setNumberOfRelocations(int n) {
        this.numberOfRelocations = n;
    }

    public void setNumberOfLineNumbers(int n) {
        this.numberOfLineNumbers = n;
    }

    public void setCharacteristics(long l) {
        this.characteristics = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImageSectionHeader)) {
            return false;
        }
        ImageSectionHeader imageSectionHeader = (ImageSectionHeader)object;
        if (!imageSectionHeader.canEqual(this)) {
            return false;
        }
        if (this.getPhysicalAddress() != imageSectionHeader.getPhysicalAddress()) {
            return false;
        }
        if (this.getVirtualAddress() != imageSectionHeader.getVirtualAddress()) {
            return false;
        }
        if (this.getSizeOfRawData() != imageSectionHeader.getSizeOfRawData()) {
            return false;
        }
        if (this.getPointerToRawData() != imageSectionHeader.getPointerToRawData()) {
            return false;
        }
        if (this.getPointerToRelocations() != imageSectionHeader.getPointerToRelocations()) {
            return false;
        }
        if (this.getPointerToLineNumbers() != imageSectionHeader.getPointerToLineNumbers()) {
            return false;
        }
        if (this.getNumberOfRelocations() != imageSectionHeader.getNumberOfRelocations()) {
            return false;
        }
        if (this.getNumberOfLineNumbers() != imageSectionHeader.getNumberOfLineNumbers()) {
            return false;
        }
        if (this.getCharacteristics() != imageSectionHeader.getCharacteristics()) {
            return false;
        }
        String string = this.getName();
        String string2 = imageSectionHeader.getName();
        return !(string == null ? string2 != null : !string.equals(string2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof ImageSectionHeader;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getPhysicalAddress();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getVirtualAddress();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getSizeOfRawData();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        long l4 = this.getPointerToRawData();
        n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
        long l5 = this.getPointerToRelocations();
        n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
        long l6 = this.getPointerToLineNumbers();
        n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
        n2 = n2 * 59 + this.getNumberOfRelocations();
        n2 = n2 * 59 + this.getNumberOfLineNumbers();
        long l7 = this.getCharacteristics();
        n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
        String string = this.getName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        return n2;
    }
}

