/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb.omap;

import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalRva;
import com.uqm.crashsight.symtabtool.pdb.omap.PdbInternalSectionOffset;
import com.uqm.crashsight.symtabtool.pdb.omap.SectionOffset;

public class Rva {
    Long address;

    public Rva(Long l) {
        this.address = l;
    }

    public boolean isNone() {
        return this.address == null;
    }

    public PdbInternalRva toInternalRva(AddressMap addressMap) {
        if (addressMap.transformedToOriginal != null) {
            return new PdbInternalRva(addressMap.transformedToOriginal.lookup(this.address));
        }
        return new PdbInternalRva(this.address);
    }

    public SectionOffset toSectionOffset(AddressMap addressMap) {
        if (addressMap.transformedSections != null) {
            return AddressMap.getSectionOffset(addressMap.transformedSections, this.address);
        }
        return AddressMap.getSectionOffset(addressMap.originalSections, this.address);
    }

    public PdbInternalSectionOffset toInternalOffset(AddressMap addressMap) {
        return this.toInternalRva(addressMap).toInternalOffset(addressMap);
    }

    public Long getAddress() {
        return this.address;
    }

    public void setAddress(Long l) {
        this.address = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rva)) {
            return false;
        }
        Rva rva = (Rva)object;
        if (!rva.canEqual(this)) {
            return false;
        }
        Long l = this.getAddress();
        Long l2 = rva.getAddress();
        return !(l == null ? l2 != null : !((Object)l).equals(l2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof Rva;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        Long l = this.getAddress();
        n2 = n2 * 59 + (l == null ? 43 : ((Object)l).hashCode());
        return n2;
    }

    public String toString() {
        return "Rva(address=" + this.getAddress() + ")";
    }
}

