/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.pdb;

import com.uqm.crashsight.symtabtool.pdb.Cpu;
import com.uqm.crashsight.symtabtool.pdb.PDBContributions;
import com.uqm.crashsight.symtabtool.pdb.PDBSections;
import com.uqm.crashsight.symtabtool.pdb.module.source.SourceLineCollector;
import com.uqm.crashsight.symtabtool.pdb.omap.AddressMap;
import com.uqm.crashsight.symtabtool.pdb.symbol.BlockInfo;
import com.uqm.crashsight.symtabtool.pdb.symbol.ProcedureSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.PublicSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.RegisterRelativeSymbol;
import com.uqm.crashsight.symtabtool.pdb.symbol.RvaSymbols;
import com.uqm.crashsight.symtabtool.pdb.symbol.SelectedSymbol;

public class Collector {
    Cpu cpu;
    RvaSymbols symbols;
    PDBSections pdbSections;
    PDBContributions pdbContributions;

    public Collector(Cpu cpu, RvaSymbols rvaSymbols, PDBSections pDBSections, PDBContributions pDBContributions) {
        this.cpu = cpu;
        this.symbols = rvaSymbols;
        this.pdbSections = pDBSections;
        this.pdbContributions = pDBContributions;
    }

    public void addPublicSymbol(PublicSymbol publicSymbol, AddressMap addressMap) {
        this.symbols.addPublicSymbol(publicSymbol, this.pdbSections, this.pdbContributions, addressMap);
    }

    public void addProcedureSymbol(ProcedureSymbol procedureSymbol, BlockInfo blockInfo, SourceLineCollector sourceLineCollector) {
        this.symbols.addProcedureSymbol(sourceLineCollector, procedureSymbol, blockInfo);
    }

    public SelectedSymbol getSymbolAt(long l) {
        return this.symbols.getSymbolAt(l);
    }

    public void addSymbol(SelectedSymbol selectedSymbol, BlockInfo blockInfo) {
        this.symbols.addSymbol(selectedSymbol, blockInfo);
    }

    public void addRegRel(RegisterRelativeSymbol registerRelativeSymbol) {
        if (this.cpu == Cpu.X86 && registerRelativeSymbol.getRegister() == 22 && registerRelativeSymbol.getOffset() > 0) {
            this.symbols.addEbp(registerRelativeSymbol);
        }
    }

    public void closeProcedure() {
        this.symbols.closeProcedure();
    }
}

