/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.mach;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.Vector;

public class MachSymtabParser {
    private static final long N_SECT = 14L;
    private String fileName = null;
    private long fileFormat = 0L;
    private long endian = 0L;
    private BinaryFileReader binaryFileReader = null;

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFileFormat(long l) {
        this.fileFormat = l;
    }

    public void setEndian(long l) {
        this.endian = l;
    }

    public MachSymtabParser(String string, long l, long l2) {
        this.setFileName(string);
        this.setFileFormat(l);
        this.setEndian(l2);
    }

    private void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName, this.endian);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return true;
    }

    private long parseSymbolType(long l) {
        return l & 0xEL;
    }

    private Vector<MachSymtabEntry> parseSubroutineTable(long l) {
        Vector<MachSymtabEntry> vector = new Vector<MachSymtabEntry>();
        int n = 0;
        while ((long)n < l) {
            MachSymtabEntry machSymtabEntry = new MachSymtabEntry();
            if (!machSymtabEntry.parse(this.binaryFileReader, this.fileFormat)) {
                Log.error("MachSymtab \u7b26\u53f7\u89e3\u6790\u9519\u8bef\uff01", new Object[0]);
                return null;
            }
            if (14L == this.parseSymbolType(machSymtabEntry.getType())) {
                vector.add(machSymtabEntry);
            }
            ++n;
        }
        return vector;
    }

    public Vector<MachSymtabEntry> getSubroutineTable(long l, long l2) {
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(l)) {
            this.close();
            return null;
        }
        Vector<MachSymtabEntry> vector = this.parseSubroutineTable(l2);
        this.close();
        MachSymtabParser.sortSubroutineTable(vector);
        return vector;
    }

    private static void sortSubroutineTable(Vector<MachSymtabEntry> vector) {
        vector.sort((machSymtabEntry, machSymtabEntry2) -> {
            int n = Long.compare(machSymtabEntry.getValue(), machSymtabEntry2.getValue());
            if (n == 0) {
                return Long.compare(machSymtabEntry.getSectionIndex(), machSymtabEntry2.getSectionIndex());
            }
            return n;
        });
    }

    public static class MachSymtabEntry {
        private long name = 0L;
        private long type = 0L;
        private long sectionIndex = 0L;
        private long description = 0L;
        private long value = 0L;

        public long getName() {
            return this.name;
        }

        public long getType() {
            return this.type;
        }

        public long getSectionIndex() {
            return this.sectionIndex;
        }

        public long getDescription() {
            return this.description;
        }

        public long getValue() {
            return this.value;
        }

        public boolean parse(BinaryFileReader binaryFileReader, long l) {
            block4: {
                try {
                    this.name = binaryFileReader.readUInt();
                    this.type = binaryFileReader.readUByte();
                    this.sectionIndex = binaryFileReader.readUByte();
                    this.description = binaryFileReader.readUShort();
                    if (32L == l) {
                        this.value = binaryFileReader.readUInt();
                        break block4;
                    }
                    if (64L == l) {
                        this.value = binaryFileReader.readULong();
                        break block4;
                    }
                    Log.error("MachSymtabEntry \u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01", new Object[0]);
                    return false;
                }
                catch (IOException iOException) {
                    Log.error(iOException);
                    return false;
                }
            }
            return true;
        }
    }
}

