/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic.extractor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.uqm.crashsight.symtabparser.SymtabFileParser;
import com.uqm.crashsight.symtabparser.stif.SymtabIndexFile;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.generic.ArgsParser;
import com.uqm.crashsight.symtabtool.generic.SymtabToolClient;
import com.uqm.crashsight.symtabtool.pdb.PdbHeaderParser;
import com.uqm.crashsight.symtabtool.pdb.PdbParser;
import com.uqm.crashsight.symtabtool.pe.PeDebugIdFile;
import com.uqm.crashsight.symtabtool.pe.PeObject;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFile;
import com.uqm.crashsight.symtabtool.symtabfile.SymtabFileInfoBean;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

public class SymtabExtractorWin {
    private static SymtabExtractorWin instance = null;
    private ExecutorService executorService = null;

    private SymtabExtractorWin() {
        ThreadFactory threadFactory2 = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable2) {
                Thread thread2 = new Thread(runnable2);
                return thread2;
            }
        };
        this.executorService = Executors.newScheduledThreadPool(3, threadFactory2);
    }

    private static SymtabFileInfoBean getSymtabFileInfoBean(ArgsParser argsParser, PdbParser pdbParser, String string) {
        SymtabFileInfoBean symtabFileInfoBean = new SymtabFileInfoBean();
        symtabFileInfoBean.setFileType("PDB");
        symtabFileInfoBean.setFileFormat(pdbParser.fileFormat);
        symtabFileInfoBean.setArch(pdbParser.arch);
        symtabFileInfoBean.setUuid(pdbParser.uuid + "0");
        symtabFileInfoBean.setFileName(string);
        symtabFileInfoBean.setAppName(pdbParser.appName);
        symtabFileInfoBean.setVmAddr(0L);
        symtabFileInfoBean.setSymbolTable(pdbParser.symbolTable);
        symtabFileInfoBean.setSymtabToolVersion(argsParser.crashsightVersion);
        symtabFileInfoBean.setUseTempDir(argsParser.getUseTempDir());
        return symtabFileInfoBean;
    }

    /*
     * WARNING - void declaration
     */
    public String[] extract(final ArgsParser argsParser) {
        String[] stringArray;
        String string;
        block42: {
            final ArrayList<File> arrayList = new ArrayList<File>();
            final ArrayList<File> arrayList2 = new ArrayList<File>();
            final ArrayList arrayList3 = new ArrayList();
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            File file = null;
            string = argsParser.getPathName() + "CrashSight_" + System.currentTimeMillis() + "_WinSymbol.zip";
            try {
                Object object;
                void file3;
                stringArray = argsParser.getPathName().split(";");
                Object file2 = stringArray;
                int n = ((String[])file2).length;
                boolean bl = false;
                while (file3 < n) {
                    String string2 = file2[file3];
                    arrayList4.add(new File(string2));
                    ++file3;
                }
                file2 = new File(argsParser.getFileName());
                if (((File)file2).isFile()) {
                    arrayList4.clear();
                    arrayList4.add(file2);
                }
                for (File stringBuilder : arrayList4) {
                    Files.walkFileTree(stringBuilder.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                            if (argsParser.getParseMode().equals("") || argsParser.getParseMode().equals("ori")) {
                                if (path.toFile().getName().endsWith(".pdb") | path.toFile().getName().endsWith(".exe") | path.toFile().getName().endsWith(".dll")) {
                                    arrayList.add(path.toFile());
                                    Log.info("File " + path.toFile() + " will be processed.", new Object[0]);
                                }
                            } else if (argsParser.getParseMode().equals("generic")) {
                                if (path.toFile().getName().endsWith(".pdb")) {
                                    if (PdbHeaderParser.isPdb(path.toFile().getAbsolutePath())) {
                                        arrayList.add(path.toFile());
                                        Log.info("File " + path.toFile() + " will be processed.", new Object[0]);
                                    } else {
                                        Log.error("%s is not a PDB file", path.toFile().getAbsolutePath());
                                    }
                                }
                                if (path.toFile().getName().endsWith(".exe") | path.toFile().getName().endsWith(".dll")) {
                                    arrayList2.add(path.toFile());
                                    Log.info("File " + path.toFile() + " will be processed.", new Object[0]);
                                }
                            } else if (path.toFile().getName().endsWith(".pdb")) {
                                arrayList.add(path.toFile());
                                Log.info("File " + path.toFile() + " will be processed.", new Object[0]);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                if (arrayList.size() == 0 && arrayList2.size() == 0) {
                    Log.info("no .pdb or .exe/.dll file found", new Object[0]);
                    return null;
                }
                if (argsParser.getParseMode().equals("") || argsParser.getParseMode().equals("ori")) {
                    file = SymtabExtractorWin.zipFiles(arrayList, string);
                    object = new String[]{string};
                    return object;
                }
                if (argsParser.getParseMode().equals("generic")) {
                    void var11_20;
                    void var12_26;
                    Object object2;
                    boolean bl2;
                    object = argsParser.getPathName();
                    StringBuilder file7 = new StringBuilder("crashsightSymbol");
                    StringBuilder stringBuilder = new StringBuilder("crashsightBreakpadSymbol");
                    stringBuilder.insert(0, (String)object);
                    file7.insert(0, (String)object);
                    HashMap<String, File> hashMap = new HashMap<String, File>();
                    HashMap<String, File> hashMap2 = new HashMap<String, File>();
                    if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                        return null;
                    }
                    if (arrayList.size() == 1) {
                        Log.info("Extracting symtab file: %s", ((File)arrayList.get(0)).getName());
                    } else {
                        Log.info("Extracting symtab files of directory: %s", object);
                    }
                    int n2 = 0;
                    for (File file4 : arrayList) {
                        boolean bl3;
                        String string3;
                        long l = System.currentTimeMillis();
                        try {
                            string3 = file4.getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            Log.error(iOException);
                            return null;
                        }
                        long l2 = System.currentTimeMillis();
                        bl2 = argsParser.dumpSymbol();
                        boolean bl4 = argsParser.getDumpCfi();
                        PdbParser pdbParser = PdbParser.create(string3, bl2, bl4, argsParser.getUseTempDir());
                        if (null == pdbParser) {
                            SymtabToolClient.getErrorInfo().addErrorMsg("Failed to parse the file!");
                            Log.error("Failed to parse the file!", new Object[0]);
                            continue;
                        }
                        Log.info("[Time]parse elf cost " + (System.currentTimeMillis() - l2) + "ms", new Object[0]);
                        Log.info("UUID: " + pdbParser.uuid, new Object[0]);
                        object2 = SymtabExtractorWin.getSymtabFileInfoBean(argsParser, pdbParser, string3);
                        SymtabFile symtabFile = SymtabFile.create((SymtabFileInfoBean)object2);
                        if (argsParser.getDumpStif()) {
                            bl3 = SymtabExtractorWin.generateStifFile((SymtabFileInfoBean)object2, argsParser, symtabFile, hashMap);
                            if (!bl3) continue;
                            if (n2++ < 2) {
                                file7.append("_").append(pdbParser.arch);
                                file7.append("-").append(pdbParser.uuid, 0, 5);
                            }
                        }
                        if (argsParser.getDumpSym()) {
                            bl3 = SymtabExtractorWin.generateSymFile((SymtabFileInfoBean)object2, argsParser, symtabFile, pdbParser, hashMap2);
                            if (!bl3) continue;
                            if (n2++ < 2) {
                                stringBuilder.append("_").append(pdbParser.arch);
                                stringBuilder.append("-").append(pdbParser.uuid, 0, 5);
                            }
                        }
                        long l3 = System.currentTimeMillis();
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.addProperty("name", file4.getName());
                        jsonObject.addProperty("time", l3 - l);
                        SymtabToolClient.getJsonArray().add(jsonObject);
                    }
                    List<File> list = SymtabExtractorWin.checkPeFiles(arrayList2, arrayList);
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        String string4;
                        File file5 = (File)iterator2.next();
                        long l = System.currentTimeMillis();
                        try {
                            string4 = file5.getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            Log.error(iOException);
                            return null;
                        }
                        PeObject peObject = new PeObject(string4, "peFile");
                        peObject.useTempDir = argsParser.getUseTempDir();
                        bl2 = peObject.load();
                        if (bl2 && argsParser.getDumpCfi() && !peObject.getDebugId().equals("")) {
                            hashMap2.put(peObject.symbolPath, new File(peObject.symbolPath));
                            if (n2++ < 2) {
                                stringBuilder.append("_").append(peObject.getArch());
                                stringBuilder.append("-").append(peObject.getDebugId(), 0, 5);
                            }
                        }
                        long l4 = System.currentTimeMillis();
                        object2 = new JsonObject();
                        ((JsonObject)object2).addProperty("name", file5.getName());
                        ((JsonObject)object2).addProperty("time", l4 - l);
                        SymtabToolClient.getJsonArray().add((JsonElement)object2);
                    }
                    file7.append(".zip");
                    stringBuilder.append(".zip");
                    if (argsParser.getSymZipFileName() != null && !argsParser.getSymZipFileName().isEmpty()) {
                        StringBuilder stringBuilder2 = new StringBuilder(argsParser.getSymZipFileName());
                    }
                    if (argsParser.getStifZipFileName() != null && !argsParser.getStifZipFileName().isEmpty()) {
                        StringBuilder stringBuilder3 = new StringBuilder(argsParser.getStifZipFileName());
                    }
                    boolean bl5 = false;
                    if (hashMap2.size() > 0) {
                        boolean bl6 = FileHelper.zipFiles(new Vector<File>(hashMap2.values()), var12_26.toString());
                        if (bl6) {
                            Log.info("Successfully zipped symtab file!", new Object[0]);
                        } else {
                            SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to zip file!");
                            Log.error("SymtabExtractor: Failed to zip file!", new Object[0]);
                        }
                    }
                    if (hashMap.size() > 0) {
                        Log.info("Begin to zip stif file: " + var11_20.toString(), new Object[0]);
                        boolean bl7 = FileHelper.zipFiles(new Vector<File>(hashMap.values()), var11_20.toString());
                        if (bl7) {
                            Log.info("Successfully zipped stif file!", new Object[0]);
                        } else {
                            SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to zip file!");
                            Log.error("SymtabExtractor: Failed to zip file!", new Object[0]);
                        }
                    }
                    for (File file6 : hashMap.values()) {
                        if (file6.delete()) continue;
                        file6.deleteOnExit();
                    }
                    for (File file8 : hashMap2.values()) {
                        if (file8.delete()) continue;
                        file8.deleteOnExit();
                    }
                    String[] stringArray2 = new String[]{var11_20.toString(), var12_26.toString()};
                    return stringArray2;
                }
                if (!argsParser.getParseMode().equals("win")) break block42;
                for (final File file9 : arrayList) {
                    this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            SymtabExtractorWin.generateWinSym(file9, arrayList3);
                        }
                    });
                }
                this.executorService.shutdown();
                try {
                    if (!this.executorService.awaitTermination(1800000L, TimeUnit.MILLISECONDS)) {
                        this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.executorService.shutdownNow();
                }
                Log.info("Begin to zip symtab file: " + string, new Object[0]);
                boolean bl8 = FileHelper.zipFiles(new Vector<File>(arrayList3), string.toString());
                if (bl8) {
                    Log.info("Successfully zipped symtab file!", new Object[0]);
                } else {
                    SymtabToolClient.getErrorInfo().addErrorMsg("SymtabExtractor: Failed to zip file!");
                    Log.error("SymtabExtractor: Failed to zip file!", new Object[0]);
                }
                if (!argsParser.uploadDsym()) {
                    for (File file10 : arrayList3) {
                        if (file10.delete()) continue;
                        file10.deleteOnExit();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                SymtabToolClient.getErrorInfo().addErrorMsg(exception.getMessage());
                Log.error("Error1!!!!", new Object[0]);
            }
        }
        stringArray = new String[]{string};
        return stringArray;
    }

    public static Vector<String> getUuid(ArgsParser argsParser) {
        if (null == argsParser) {
            return null;
        }
        String string = argsParser.getPathName();
        Vector<File> vector = argsParser.getSoFiles();
        if (vector.isEmpty()) {
            return null;
        }
        if (vector.size() == 1) {
            Log.info("Extracting symtab file: %s", vector.get(0).getName());
        } else if (vector.size() > 1) {
            Log.info("Extracting symtab files of directory: %s", string);
        }
        Vector<String> vector2 = new Vector<String>();
        for (File file : vector) {
            String string2 = null;
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return null;
            }
            vector2.add(ElfParser.getUuid(string2, false));
        }
        return vector2;
    }

    public static File zipFiles(List<File> list, String string) throws IOException {
        int n = 2048;
        File file = new File(string);
        byte[] byArray = new byte[n];
        ZipOutputStream zipOutputStream = null;
        zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zipOutputStream, n);
        HashSet<String> hashSet = new HashSet<String>();
        Log.info("Zipping with size " + list.size(), new Object[0]);
        for (File file2 : list) {
            String string2 = file2.getName();
            Log.info("Zipping " + string2, new Object[0]);
            if (hashSet.contains(string2)) continue;
            hashSet.add(string2);
            FileInputStream fileInputStream = new FileInputStream(file2);
            ZipEntry zipEntry = new ZipEntry(string2);
            zipEntry.setTime(0L);
            zipOutputStream.putNextEntry(zipEntry);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            int n2 = 0;
            while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                bufferedOutputStream.write(byArray, 0, n2);
            }
            bufferedOutputStream.flush();
            ((InputStream)fileInputStream).close();
        }
        zipOutputStream.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL outputResTool(String string) throws IOException {
        File file = new File(string);
        InputStream inputStream2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        InputStream inputStream3 = null;
        OutputStream outputStream2 = null;
        if (inputStream2 == null) {
            Log.info("resToolInputMD5Stream is null.", new Object[0]);
            throw new NullPointerException();
        }
        String string2 = DigestUtils.md5Hex(inputStream2);
        try {
            boolean bl = true;
            if (bl) {
                int n;
                inputStream3 = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
                outputStream2 = new FileOutputStream(file);
                if (inputStream3 == null) {
                    throw new NullPointerException("\u6307\u5b9ajar\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                byte[] byArray = new byte[1024];
                while ((n = inputStream3.read(byArray)) != -1) {
                    outputStream2.write(byArray, 0, n);
                }
            }
        }
        finally {
            inputStream2.close();
            if (inputStream3 != null) {
                inputStream3.close();
            }
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        return file.toURI().toURL();
    }

    private static void generateWinSym(File file, List<File> list) {
        try {
            if (file.getName().endsWith(".pdb")) {
                URL uRL = SymtabExtractorWin.outputBuglyTool("crashSightDumpSym.exe");
                URL uRL2 = SymtabExtractorWin.outputBuglyTool("msdia140.dll");
                Log.info(file.getName() + " with size " + file.length() + " byte", new Object[0]);
                File file2 = new File(file.getCanonicalPath() + ".sym");
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("cmd");
                arrayList.add("/c");
                arrayList.add("crashSightDumpSym.exe  \"" + file.getCanonicalPath() + "\" \"" + file2.getCanonicalPath() + "\"");
                String[] stringArray = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                SymtabExtractorWin.checkPeFile(file);
                Process process = null;
                Runtime runtime = Runtime.getRuntime();
                process = runtime.exec(stringArray);
                InputStream inputStream2 = process.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream2);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    Log.info(string, new Object[0]);
                }
                BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string = bufferedReader2.readLine()) != null) {
                    stringBuilder.append(string).append("\n");
                }
                int n = process.waitFor();
                Log.info("exitCode:" + n, new Object[0]);
                Log.info("exitInfo:" + stringBuilder.toString(), new Object[0]);
                if (file2.exists()) {
                    Object object;
                    BufferedReader bufferedReader3 = new BufferedReader(new FileReader(file2));
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    String string5 = bufferedReader3.readLine();
                    if (string5 != null && ((String[])(object = string5.split(" "))).length == 5) {
                        string4 = object[2];
                        string2 = object[3];
                        string3 = object[4];
                        string3 = string3.substring(0, string3.lastIndexOf("."));
                    }
                    bufferedReader3.close();
                    Log.info(string4 + "&" + string2 + "&" + string3, new Object[0]);
                    object = file2.getParent();
                    String string6 = (String)object + "/crashsight&" + string4 + "&" + string3 + "&" + string2.toUpperCase() + ".sym";
                    File file3 = new File(string6);
                    boolean bl = file2.renameTo(file3);
                    if (!bl) {
                        file2.delete();
                    }
                    Log.info("rename file result:" + bl, new Object[0]);
                    if (file3.exists()) {
                        list.add(file3);
                    } else {
                        Log.info(string6 + " is not exits.", new Object[0]);
                    }
                } else {
                    Log.error("Sym file:" + file2 + " not exist", new Object[0]);
                    SymtabToolClient.getErrorInfo().addErrorMsg("Sym file:" + file2 + " not exist");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static PeDebugIdFile checkPeFile(File file) {
        try {
            String string = PdbParser.getPdbDebugId(file.getAbsolutePath());
            String string2 = Paths.get(file.getAbsolutePath(), new String[0]).getParent().toString();
            Vector<File> vector = FileHelper.getDirFileList(new File(string2));
            for (File file2 : vector) {
                PeObject peObject;
                String string3;
                if (StringUtils.equals(file2.getAbsolutePath(), file.getAbsolutePath()) || !StringUtils.endsWith(file2.getAbsolutePath(), ".dll") && !StringUtils.endsWith(file2.getAbsolutePath(), ".exe") || !StringUtils.equals(string, string3 = (peObject = new PeObject(file2.getAbsolutePath(), "pe")).getDebugId())) continue;
                if (StringUtils.equals(FilenameUtils.removeExtension(file2.getAbsolutePath()), FilenameUtils.removeExtension(file.getAbsolutePath()))) {
                    return new PeDebugIdFile(string3, file2);
                }
                String string4 = FileHelper.changeFileSuffix(file.getAbsolutePath(), FilenameUtils.getExtension(file2.getAbsolutePath()));
                File file3 = new File(string4);
                FileUtils.copyFile(file2, file3);
                file3.deleteOnExit();
                return new PeDebugIdFile(string3, file3);
            }
        }
        catch (Exception exception) {
            Log.error("preparePeFile err:", exception);
        }
        return null;
    }

    private static List<File> checkPeFiles(List<File> list, List<File> list2) {
        Object object;
        ArrayList<File> arrayList = new ArrayList<File>();
        HashMap<String, File> hashMap = new HashMap<String, File>();
        for (File object2 : list) {
            object = SymtabExtractorWin.getPeDebugId(object2);
            if (!StringUtils.isNotEmpty((CharSequence)object)) continue;
            hashMap.put((String)object, object2);
        }
        for (File file : list2) {
            object = SymtabExtractorWin.checkPeFile(file);
            if (object == null || !hashMap.containsKey(((PeDebugIdFile)object).getDebugId())) continue;
            hashMap.put(((PeDebugIdFile)object).getDebugId(), ((PeDebugIdFile)object).getFile());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            arrayList.add((File)entry.getValue());
        }
        return arrayList;
    }

    private static String getPeDebugId(File file) {
        PeObject peObject = new PeObject(file.getAbsolutePath(), "pe");
        return peObject.getDebugId();
    }

    public static SymtabExtractorWin getInstance() {
        if (instance == null) {
            instance = new SymtabExtractorWin();
        }
        return instance;
    }

    private static boolean generateStifFile(SymtabFileInfoBean symtabFileInfoBean, ArgsParser argsParser, SymtabFile symtabFile, Map<String, File> map) {
        SymtabIndexFile.vmAddr = symtabFileInfoBean.getVmAddr();
        SymtabIndexFile.pvAddr = symtabFileInfoBean.getPvaddr();
        SymtabIndexFile.fileType = symtabFileInfoBean.getFileType();
        String string = symtabFile.getSymtabFileName();
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (!SymtabFileParser.parseFile(string, file.getParent(), symtabFileInfoBean.getSymbolTable())) {
            Log.warn("Failed to parse symbol file: " + string, new Object[0]);
        } else {
            String string2 = FileHelper.changeFileSuffix(string, "stif");
            File file2 = new File(string2);
            Log.info("Add stif to symtab zip file: " + string2, new Object[0]);
            map.put(string2, file2);
        }
        if (null != symtabFileInfoBean.getSymbolTable()) {
            symtabFileInfoBean.getSymbolTable().close();
        }
        if (argsParser.dumpSymbol()) {
            Log.info("Add symbol to symtab zip file: " + string, new Object[0]);
            map.put(string, file);
        } else if (!file.delete()) {
            file.deleteOnExit();
        }
        return true;
    }

    private static boolean generateSymFile(SymtabFileInfoBean symtabFileInfoBean, ArgsParser argsParser, SymtabFile symtabFile, PdbParser pdbParser, Map<String, File> map) {
        symtabFile.setUuid(pdbParser.uuid);
        Log.info("Breakpad UUID: " + pdbParser.uuid, new Object[0]);
        SymtabFile symtabFile2 = SymtabFile.create(symtabFileInfoBean);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL outputBuglyTool(String string) throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(string);
        File file = new File(string);
        InputStream inputStream2 = classPathResource.getInputStream();
        InputStream inputStream3 = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        InputStream inputStream4 = null;
        OutputStream outputStream2 = null;
        if (inputStream3 == null) {
            throw new NullPointerException();
        }
        String string2 = DigestUtils.md5Hex(inputStream3);
        try {
            Object object;
            boolean bl = true;
            if (file.exists() && string2.equals(object = DigestUtils.md5Hex(inputStream2))) {
                bl = false;
            }
            if (bl) {
                int n;
                inputStream4 = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
                outputStream2 = new FileOutputStream(file);
                if (inputStream4 == null) {
                    throw new NullPointerException("\u6307\u5b9ajar\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                object = new byte[1024];
                while ((n = inputStream4.read((byte[])object)) != -1) {
                    outputStream2.write((byte[])object, 0, n);
                }
            }
        }
        finally {
            inputStream3.close();
            inputStream2.close();
            if (inputStream4 != null) {
                inputStream4.close();
            }
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        return file.toURI().toURL();
    }
}

