/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.generic;

import com.uqm.crashsight.symtabtool.common.file.SettingFileParser;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.elf.ElfParser;
import com.uqm.crashsight.symtabtool.mach.MachParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ArgsParser {
    public static final String CRASHSIGHT_VERSION_2X = "2.x";
    private static final String DSYM_SUFFIX = ".app.dSYM";
    private static final String DSYM_SUFFIX_EX = ".appex.dSYM";
    private static final String IS_DEBUG = "-d";
    private static final String INPUT_FILE = "-i";
    private static final String OUTPUT_FILE = "-o";
    private static final String SYM_OUTPUT_FILE = "-osym";
    private static final String STIF_OUTPUT_FILE = "-ostif";
    private static final String SETTING_FILE = "-s";
    private static final String UPLOAD = "-u";
    private static final String DUMP_UUID = "-uuid";
    private static final String DUMP_SYMBOL = "-symbol";
    private static final String APP_ID = "-id";
    private static final String APP_KEY = "-key";
    private static final String APP_VERSION = "-version";
    private static final String APP_PACKAGE = "-package";
    private static final String CRASHSIGHT_VERSION = "-crashsight";
    private static final String NETWORK_TIMEOUT = "-timeout";
    private static final String UPLOAD_URL = "-url";
    private static final String PARSE_MODE = "-m";
    private static final String SYMBOL_PLATFORM = "-p";
    private static final String UPLOAD_PROXY = "-proxy";
    private static final String ONLY_REBUILD_DSYM = "-onlyrebuild";
    private static final String REBUILD_DSYM = "-rebuild";
    private static final String DUMP_STACK_VARIABLE = "-stackVariable";
    private static final String DUMP_STIF = "-stif";
    private static final String NOT_DUMP_STIF = "-nostif";
    private static final String DUMP_CFI = "-cfi";
    private static final String DUMP_SYM = "-sym";
    private static final String ID_STYLE = "-idstyle";
    private static final String UPLOAD_COS = "-uploadcos";
    private static final String MAPPING_FILE = "-mapping";
    private static final String JS_FILE = "-jsFile";
    private static final String USE_TEMP_DIR = "-useTempDir";
    private Vector<File> dSymFiles = new Vector();
    private Vector<File> soFiles = new Vector();
    private String zipFileName = null;
    private String symZipFileName = null;
    private String stifZipFileName = null;
    private String pathName = null;
    private String fileName = null;
    private String appId = null;
    private String appKey = null;
    private String appVersion = null;
    private String appPackage = null;
    private String appChannel = null;
    private long offsetAddress = 0L;
    private boolean shouldUpload = false;
    private boolean dumpUuid = false;
    private boolean dumpSymbol = false;
    private boolean isDebug = false;
    public String crashsightVersion = "2.x";
    private boolean uploadDsym = false;
    private int networkTimeout = -1;
    private String uploadUrl = null;
    private String parseMode = "";
    private String symbolPlatform = "aos";
    private String mappingFileName = null;
    private String upload_proxy = "";
    private boolean onlyRebuildDsym = false;
    private boolean rebuildDsym = false;
    private boolean dumpStackVariable = false;
    private boolean dumpSym = false;
    private boolean dumpCfi = false;
    private boolean dumpStif = true;
    private String idStyle = "ori";
    private boolean uploadCos = false;
    private String jsFileName = null;
    private boolean useTempDir = false;

    public static void printHelp() {
        System.out.println("\nCrashSight Symtab Tool\n-------------------------------------------------------------------\n");
        System.out.println("-- Usage\n Java -jar CrashSightWin.jar -i <input> [-o <output>] [-d] [-s <setting file>] [-u -id <APP ID> -key <APP key>] -version <APP version> [-m <modle>]  [-p <platform>]\n");
        System.out.println("\u53c2\u6570\u8bf4\u660e -- Introduction for arguments\n -i    \u6307\u5b9a\u6587\u4ef6\u8def\u5f84\uff0c\u53ef\u6307\u5b9a\u76ee\u5f55 -- File path which contain debug info\n -o    \u8f93\u51fa\u7684\u7b26\u53f7\u8868zip\u6587\u4ef6\u7684\u8def\u5f84\uff0c\u5fc5\u987b\u662fzip\u6587\u4ef6 -- The output symbol.zip file path, it need to be named *.zip\n -d        \u5f00\u542f\u8c03\u8bd5\u6a21\u5f0f -- Open debug mode\n -s    \u6307\u5b9a\u914d\u7f6e\u6587\u4ef6\uff08\u9ed8\u8ba4\u8bfb\u53d6JAR\u76ee\u5f55\u4e0b\u7684\u201csettings.txt\u201d\u6587\u4ef6\uff09 -- Specify the setting file\n -u    \u4e0a\u4f20 -- Upload to CrashSight\n -id        APP ID -- APP ID of CrashSight\n -key  APP key -- APP key of CrashSight\n -version  APP\u7248\u672c -- APP version name\n -m  \u4e0a\u4f20\u7b26\u53f7\u8868\u6a21\u5f0f -- ori/win default is ori\n -p  \u4e0a\u4f20\u7b26\u53f7\u8868\u6240\u5c5e\u5e73\u53f0 -- aos/ios/win/js/ps5 default is aos\n");
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean uploadDsym() {
        return this.uploadDsym;
    }

    public boolean shouldUpload() {
        return this.shouldUpload;
    }

    public boolean dumpUuid() {
        return this.dumpUuid;
    }

    public boolean dumpSymbol() {
        return this.dumpSymbol;
    }

    private ArgsParser() {
    }

    public boolean getOnlyRebuildDsym() {
        return this.onlyRebuildDsym;
    }

    public boolean getRebuildDsym() {
        return this.rebuildDsym;
    }

    public boolean dumpStackVariable() {
        return this.dumpStackVariable;
    }

    public boolean getDumpStif() {
        return this.dumpStif;
    }

    public boolean getDumpSym() {
        return this.dumpSym;
    }

    public boolean getDumpCfi() {
        return this.dumpCfi;
    }

    public Vector<File> getdSymFiles() {
        if (null == this.fileName) {
            return this.dSymFiles;
        }
        File file = new File(this.fileName);
        this.fileName = file.getName();
        this.pathName = file.getAbsoluteFile().getParent() + File.separator;
        if (!this.findMachFile(file)) {
            Log.error("There is no dSYM file in the path: %s", this.fileName);
            return this.dSymFiles;
        }
        return this.dSymFiles;
    }

    public Vector<File> getSoFiles() {
        if (null == this.fileName) {
            Log.error("File name is null.", new Object[0]);
            return this.soFiles;
        }
        File file = new File(this.fileName);
        this.pathName = file.getAbsoluteFile().getParent() + File.separator;
        if (!this.findSoFile(file)) {
            Log.error("Can not find any SO files to parse.", new Object[0]);
            return this.soFiles;
        }
        return this.soFiles;
    }

    public String getZipFileName() {
        return this.zipFileName;
    }

    public String getSymZipFileName() {
        return this.symZipFileName;
    }

    public String getStifZipFileName() {
        return this.stifZipFileName;
    }

    public String getZipFileName(String string) {
        File file;
        if (this.zipFileName != null && string != null && (file = new File(this.zipFileName)).isDirectory()) {
            this.zipFileName = this.zipFileName + File.separator + string;
        }
        return this.zipFileName;
    }

    public int getNetworkTimeout() {
        return this.networkTimeout;
    }

    public String getDsymName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        if (string2.endsWith(DSYM_SUFFIX) || string2.endsWith(DSYM_SUFFIX_EX)) {
            string2 = string2.substring(0, string2.indexOf("."));
        }
        return string2;
    }

    public String getSoName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        if (string2.contains(".")) {
            string2 = string2.substring(0, string2.indexOf("."));
        }
        return string2;
    }

    public String getWinName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        if (string2.contains(".")) {
            string2 = string2.substring(0, string2.indexOf("."));
        }
        return string2;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppPackage() {
        return this.appPackage;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppChannel() {
        return this.appChannel;
    }

    public String getCrashSightVersion() {
        return this.crashsightVersion;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public String getSymbolPlatform() {
        return this.symbolPlatform;
    }

    public long getOffsetAddress() {
        return this.offsetAddress;
    }

    public String getMappingFileName() {
        return this.mappingFileName;
    }

    public String getIdStyle() {
        return this.idStyle;
    }

    private String parseAppName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        if (string2.contains(".")) {
            string2 = string2.substring(0, string2.indexOf("."));
        }
        return string2;
    }

    public String getAppName(String string) {
        return this.parseAppName(string);
    }

    private boolean verify() {
        if (this.pathName == null) {
            Log.error("Path name is null.", new Object[0]);
            ArgsParser.printHelp();
            return false;
        }
        return true;
    }

    private boolean findMachFile(File file) {
        if (!file.exists()) {
            Log.error("Dir %s is not exist, Please check again.", file);
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) {
                    this.findMachFile(file2);
                    continue;
                }
                try {
                    if (!MachParser.isMach(file2.getCanonicalPath())) continue;
                    this.dSymFiles.add(file2);
                }
                catch (IOException iOException) {
                    Log.error(iOException);
                }
            }
        } else {
            try {
                if (file.isDirectory()) {
                    Log.error("%s is directory", file.getCanonicalPath());
                }
                if (MachParser.isMach(file.getCanonicalPath())) {
                    this.dSymFiles.add(file);
                }
                Log.error("The file is not a dSYM file!", new Object[0]);
            }
            catch (IOException iOException) {
                Log.error(iOException);
            }
        }
        return !this.dSymFiles.isEmpty();
    }

    private boolean parseFileName(String string) {
        Log.info("FileName is  [%s] .", string);
        if (null == string) {
            return false;
        }
        File file = new File(string);
        this.fileName = string;
        if (!file.exists()) {
            Log.error("File %s is not exists. Please check the file path.", file.getAbsoluteFile());
            return false;
        }
        this.pathName = file.isDirectory() ? string + File.separator : file.getAbsoluteFile().getParent() + File.separator;
        return true;
    }

    private boolean findSoFile(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isDirectory()) {
                    this.findSoFile(file2);
                    continue;
                }
                try {
                    String string = file2.getCanonicalPath();
                    if (string.endsWith(".o") || string.endsWith(".a") || !ElfParser.isElf(string)) continue;
                    Log.info("path = %s", string);
                    this.soFiles.add(file2);
                }
                catch (IOException iOException) {
                    Log.error(iOException);
                }
            }
        } else {
            try {
                if (ElfParser.isElf(file.getCanonicalPath())) {
                    this.soFiles.add(file);
                }
                Log.error("The file %s is not a SO file!", file.getCanonicalPath());
            }
            catch (IOException iOException) {
                Log.error(iOException);
            }
        }
        return !this.soFiles.isEmpty();
    }

    private String parseZipFileName(String string) {
        if (null == string) {
            return "";
        }
        File file = new File(string);
        if (file.isFile() && !string.endsWith(".zip")) {
            Log.warn("The output specified hasn't suffix of zip!", new Object[0]);
        }
        return file.getPath();
    }

    private boolean parseSettingFile(String string) {
        String string2;
        if (null == string) {
            return false;
        }
        SettingFileParser settingFileParser = SettingFileParser.create(string);
        if (null == settingFileParser) {
            return false;
        }
        Map<String, String> map = settingFileParser.getSettings();
        if (this.dSymFiles.isEmpty() && map.containsKey("input")) {
            this.parseFileName(map.get("input"));
        }
        this.parseSettingFileIfNull(map);
        if (!this.shouldUpload && map.containsKey("upload")) {
            string2 = map.get("upload");
            if (string2.toLowerCase().equals("true")) {
                this.shouldUpload = true;
            } else if (string2.toLowerCase().equals("false")) {
                this.shouldUpload = false;
            } else {
                Log.warn("Setting of \"Upload\" should only be \"true\" or \"false\"", new Object[0]);
            }
        }
        if (!this.isDebug && map.containsKey("debug")) {
            string2 = map.get("debug");
            if (string2.toLowerCase().equals("true")) {
                this.isDebug = true;
            } else if (string2.toLowerCase().equals("false")) {
                this.isDebug = false;
            } else {
                Log.warn("Setting of \"Debug\" should only be \"true\" or \"false\"", new Object[0]);
            }
        }
        return true;
    }

    private void parseSettingFileIfNull(Map<String, String> map) {
        if (this.zipFileName == null && map.containsKey("output")) {
            this.parseZipFileName(map.get("output"));
        }
        if (this.appId == null && map.containsKey("id")) {
            this.appId = map.get("id");
        }
        if (this.appKey == null && map.containsKey("key")) {
            this.appKey = map.get("key");
        }
        if (this.appPackage == null && map.containsKey("package")) {
            this.appPackage = map.get("package");
        }
        if (this.appVersion == null && map.containsKey("version")) {
            this.appKey = map.get("version");
        }
        if (this.crashsightVersion == null && map.containsKey("crashsight")) {
            this.crashsightVersion = map.get("crashsight");
        }
    }

    private boolean parseNetworkTimeout(String string) {
        if (null == string) {
            return false;
        }
        try {
            this.networkTimeout = Integer.parseInt(string, 10);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Log.error("Failed to parse offset address: Wrong format!", new Object[0]);
            return false;
        }
    }

    private void parseDefaultSettingFile() {
        File file;
        URL uRL = ArgsParser.class.getProtectionDomain().getCodeSource().getLocation();
        String string = null;
        try {
            string = URLDecoder.decode(uRL.getPath(), "utf-8");
            if (string.endsWith(".jar")) {
                string = string.substring(0, string.lastIndexOf("/") + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = "settings.txt";
        if (string != null) {
            string2 = string + string2;
        }
        if ((file = new File(string2)).exists()) {
            this.parseSettingFile(file.getAbsolutePath());
        }
    }

    private boolean parse(String[] stringArray) {
        if (null == stringArray) {
            return false;
        }
        boolean bl = false;
        Log.debug("Args length is " + stringArray.length, new Object[0]);
        Log.info("Current argument: " + Arrays.toString(stringArray), new Object[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            Log.debug("Arg[" + i + "] is " + stringArray[i], new Object[0]);
            if (stringArray[i].equals(SETTING_FILE)) {
                bl = true;
                if (i + 1 >= stringArray.length) {
                    Log.error("The arguments are not enough!", new Object[0]);
                    break;
                }
                this.parseSettingFile(stringArray[i + 1]);
                continue;
            }
            if (this.parseArgWithoutData(stringArray[i])) continue;
            if (i + 1 >= stringArray.length) {
                Log.error("The value of argument " + stringArray[i] + " is missing!", new Object[0]);
                break;
            }
            if (!this.parseArgWithData(stringArray[i], stringArray[i + 1])) {
                Log.error("Unknown argument [%s]. Please check arguments. ", stringArray[i]);
                break;
            }
            ++i;
        }
        if (!bl) {
            this.parseDefaultSettingFile();
        }
        return this.verify();
    }

    private boolean parseArgWithoutData(String string) {
        if (null == string) {
            return false;
        }
        if (string.equals(UPLOAD)) {
            this.shouldUpload = true;
        } else if (string.equals(IS_DEBUG)) {
            this.isDebug = true;
        } else if (string.equals(DUMP_SYMBOL)) {
            this.dumpSymbol = true;
        } else if (string.equals(DUMP_UUID)) {
            this.dumpUuid = true;
        } else if (string.equals(ONLY_REBUILD_DSYM)) {
            this.onlyRebuildDsym = true;
        } else if (string.equals(REBUILD_DSYM)) {
            this.rebuildDsym = true;
        } else if (string.equals(DUMP_STIF)) {
            this.dumpStif = true;
        } else if (string.equals(NOT_DUMP_STIF)) {
            this.dumpStif = false;
        } else if (string.equals(DUMP_CFI)) {
            this.dumpCfi = true;
        } else if (string.equals(DUMP_SYM)) {
            this.dumpSym = true;
        } else if (string.equals(UPLOAD_COS)) {
            this.uploadCos = true;
        } else if (string.equals(USE_TEMP_DIR)) {
            this.useTempDir = true;
        } else {
            return false;
        }
        return true;
    }

    private boolean parseArgWithData(String string, String string2) {
        if (null == string || null == string2) {
            return false;
        }
        if (string.equals(INPUT_FILE)) {
            this.parseFileName(string2);
        } else if (string.equals(OUTPUT_FILE)) {
            this.stifZipFileName = this.parseZipFileName(string2);
        } else if (string.equals(SYM_OUTPUT_FILE)) {
            this.symZipFileName = this.parseZipFileName(string2);
        } else if (string.equals(STIF_OUTPUT_FILE)) {
            this.stifZipFileName = this.parseZipFileName(string2);
        } else if (string.equals(APP_ID)) {
            this.appId = string2;
        } else if (string.equals(APP_KEY)) {
            this.appKey = string2;
        } else if (string.equals(APP_VERSION)) {
            this.appVersion = string2;
        } else if (string.equals(APP_PACKAGE)) {
            this.appPackage = string2;
        } else if (string.equals(CRASHSIGHT_VERSION)) {
            this.crashsightVersion = string2;
        } else if (string.equals(NETWORK_TIMEOUT)) {
            this.parseNetworkTimeout(string2);
        } else if (string.equals(UPLOAD_URL)) {
            this.uploadUrl = string2;
        } else if (string.equals(PARSE_MODE)) {
            this.parseMode = string2;
        } else if (string.equals(SYMBOL_PLATFORM)) {
            this.symbolPlatform = string2;
        } else if (string.equals(UPLOAD_PROXY)) {
            this.upload_proxy = string2;
            this.setProxy();
        } else if (string.equals(DUMP_STACK_VARIABLE)) {
            this.dumpStackVariable = true;
        } else if (string.equals(ID_STYLE)) {
            this.idStyle = string2;
        } else if (string.equals(MAPPING_FILE)) {
            this.mappingFileName = string2;
        } else if (string.equals(JS_FILE)) {
            this.jsFileName = string2;
        } else {
            return false;
        }
        return true;
    }

    private boolean setProxy() {
        if (this.upload_proxy == null || this.upload_proxy.split(":").length != 2) {
            Log.error("Proxy is ilegal.", new Object[0]);
            return false;
        }
        String string = this.upload_proxy.split(":")[0];
        String string2 = this.upload_proxy.split(":")[1];
        Log.info("Proxy is host:%s port:%s.", string, string2);
        Properties properties = System.getProperties();
        properties.setProperty("https.proxySet", "true");
        properties.setProperty("https.proxyHost", string);
        properties.setProperty("https.proxyPort", string2);
        properties.setProperty("http.proxySet", "true");
        properties.setProperty("http.proxyHost", string);
        properties.setProperty("http.proxyPort", string2);
        Log.info("Proxy is %s", properties.toString());
        return true;
    }

    public static ArgsParser create(String[] stringArray) {
        ArgsParser argsParser = new ArgsParser();
        if (!argsParser.parse(stringArray)) {
            argsParser = null;
        }
        return argsParser;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public boolean getUploadCos() {
        return this.uploadCos;
    }

    public void setUploadUrl(String string) {
        this.uploadUrl = string;
    }

    public void setParseMode(String string) {
        this.parseMode = string;
    }

    public String getJsFileName() {
        return this.jsFileName;
    }

    public boolean getUseTempDir() {
        return this.useTempDir;
    }
}

