/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class ParseBuffer {
    private static final long FIX_LEB128 = 127L;
    private ByteBuffer buffer;
    private final ByteBuffer tmpBuffer = ByteBuffer.allocate(8);
    private final byte[] tmpBytes = new byte[8];
    private long sectionOffset = 0L;
    private long offset = 0L;
    private long initialSize = 0L;

    public static ParseBuffer empty() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(0);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return new ParseBuffer(byteBuffer);
    }

    public ParseBuffer(byte[] byArray, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(byteOrder);
        this.sectionOffset = 0L;
        this.offset = 0L;
        this.initialSize = byArray.length;
        this.buffer = byteBuffer;
    }

    public ParseBuffer(ByteBuffer byteBuffer) {
        assert (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN);
        this.buffer = byteBuffer;
    }

    public ParseBuffer(ByteBuffer byteBuffer, long l, long l2) {
        this.sectionOffset = l;
        this.offset = 0L;
        this.initialSize = l2;
        this.buffer = byteBuffer;
    }

    public long getPtr() {
        return this.sectionOffset + this.offset;
    }

    public ParseBuffer copy() {
        return new ParseBuffer(this.buffer, this.sectionOffset + this.offset, this.len());
    }

    public ParseBuffer[] take(long l) {
        ParseBuffer parseBuffer = new ParseBuffer(this.buffer, this.sectionOffset + this.offset, l);
        ParseBuffer parseBuffer2 = new ParseBuffer(this.buffer, this.sectionOffset + this.offset + l, this.len() - l);
        ParseBuffer[] parseBufferArray = new ParseBuffer[]{parseBuffer, parseBuffer2};
        return parseBufferArray;
    }

    public long pos() {
        return this.offset;
    }

    public void pos(long l) {
        this.buffer.position((int)l);
    }

    public long len() {
        return this.initialSize - this.offset;
    }

    public boolean isEmpty() {
        return this.len() == 0L;
    }

    public void align(long l) {
        long l2 = this.pos() % l;
        if (l2 > 0L) {
            if (this.len() < l - l2) {
                Log.error("UnexpectedEof", new Object[0]);
            }
            this.pos(this.pos() + (l - l2));
        }
    }

    public byte readI8() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        ++this.offset;
        return this.buffer.get();
    }

    public short readI16() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        this.offset += 2L;
        return this.buffer.getShort();
    }

    public int readI32() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        this.offset += 4L;
        return this.buffer.getInt();
    }

    public long readI64() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        this.offset += 8L;
        return this.buffer.getLong();
    }

    public short readU8() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        ++this.offset;
        byte by = this.buffer.get();
        this.tmpBuffer.clear();
        this.tmpBuffer.put((byte)0);
        this.tmpBuffer.put(by);
        this.tmpBuffer.flip();
        return this.tmpBuffer.getShort();
    }

    public short getU8() {
        short s2 = this.readU8();
        --this.offset;
        return s2;
    }

    public int readU16() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        this.offset += 2L;
        this.buffer.get(this.tmpBytes, 0, 2);
        this.tmpBuffer.clear();
        this.tmpBuffer.putShort((short)0);
        for (int i = 1; i >= 0; --i) {
            this.tmpBuffer.put(this.tmpBytes[i]);
        }
        this.tmpBuffer.flip();
        return this.tmpBuffer.getInt();
    }

    public int getU16() {
        int n = this.readU16();
        this.offset -= 2L;
        return n;
    }

    public long readU32() {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        this.offset += 4L;
        this.buffer.get(this.tmpBytes, 0, 4);
        this.tmpBuffer.clear();
        this.tmpBuffer.putInt(0);
        for (int i = 3; i >= 0; --i) {
            this.tmpBuffer.put(this.tmpBytes[i]);
        }
        this.tmpBuffer.flip();
        return this.tmpBuffer.getLong();
    }

    public long getU32() {
        long l = this.readU32();
        this.offset -= 4L;
        return l;
    }

    public long parseULeb128() {
        byte by;
        this.buffer.position((int)(this.sectionOffset + this.offset));
        int n = this.buffer.position();
        long l = 0L;
        long l2 = 0L;
        do {
            by = this.buffer.get();
            l |= ((long)by & 0x7FL) << (int)l2;
            l2 += 7L;
        } while ((by & 0x80) != 0);
        this.offset += (long)(this.buffer.position() - n);
        return l;
    }

    public long parseSLeb128() {
        byte by;
        this.buffer.position((int)(this.sectionOffset + this.offset));
        int n = this.buffer.position();
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        do {
            by = this.buffer.get();
            l |= ((long)by & 0x7FL) << (int)l2;
            l2 += 7L;
            boolean bl2 = bl = (by & 0x40) != 0;
        } while ((by & 0x80) != 0);
        if (bl) {
            l |= -(1L << (int)l2);
        }
        this.offset += (long)(this.buffer.position() - n);
        return l;
    }

    public int find(byte by) {
        this.buffer.position((int)(this.sectionOffset + this.offset));
        int n = 0;
        while ((long)n < this.initialSize && this.buffer.get() != by) {
            ++n;
        }
        return (long)n == this.initialSize ? -1 : n;
    }

    public String parseAddress(long l) {
        long l2 = 0L;
        if (32L == l) {
            l2 = this.readU32();
        } else if (64L == l) {
            l2 = this.readI64();
        }
        return Long.toHexString(l2);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getTmpBuffer() {
        return this.tmpBuffer;
    }

    public byte[] getTmpBytes() {
        return this.tmpBytes;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public void setBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public void setInitialSize(long l) {
        this.initialSize = l;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ParseBuffer)) {
            return false;
        }
        ParseBuffer parseBuffer = (ParseBuffer)object;
        if (!parseBuffer.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != parseBuffer.getSectionOffset()) {
            return false;
        }
        if (this.getOffset() != parseBuffer.getOffset()) {
            return false;
        }
        if (this.getInitialSize() != parseBuffer.getInitialSize()) {
            return false;
        }
        ByteBuffer byteBuffer = this.getBuffer();
        ByteBuffer byteBuffer2 = parseBuffer.getBuffer();
        if (byteBuffer == null ? byteBuffer2 != null : !((Object)byteBuffer).equals(byteBuffer2)) {
            return false;
        }
        ByteBuffer byteBuffer3 = this.getTmpBuffer();
        ByteBuffer byteBuffer4 = parseBuffer.getTmpBuffer();
        if (byteBuffer3 == null ? byteBuffer4 != null : !((Object)byteBuffer3).equals(byteBuffer4)) {
            return false;
        }
        return Arrays.equals(this.getTmpBytes(), parseBuffer.getTmpBytes());
    }

    protected boolean canEqual(Object object) {
        return object instanceof ParseBuffer;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getOffset();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = this.getInitialSize();
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        ByteBuffer byteBuffer = this.getBuffer();
        n2 = n2 * 59 + (byteBuffer == null ? 43 : ((Object)byteBuffer).hashCode());
        ByteBuffer byteBuffer2 = this.getTmpBuffer();
        n2 = n2 * 59 + (byteBuffer2 == null ? 43 : ((Object)byteBuffer2).hashCode());
        n2 = n2 * 59 + Arrays.hashCode(this.getTmpBytes());
        return n2;
    }

    public String toString() {
        return "ParseBuffer(buffer=" + this.getBuffer() + ", tmpBuffer=" + this.getTmpBuffer() + ", tmpBytes=" + Arrays.toString(this.getTmpBytes()) + ", sectionOffset=" + this.getSectionOffset() + ", offset=" + this.getOffset() + ", initialSize=" + this.getInitialSize() + ")";
    }
}

