/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.IntervalManager;
import com.uqm.crashsight.symtabtool.common.Pair;
import com.uqm.crashsight.symtabtool.common.Subroutine;
import com.uqm.crashsight.symtabtool.common.SubroutineVariable;
import com.uqm.crashsight.symtabtool.common.VariableEntry;
import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.file.ElfCompressionHeader;
import com.uqm.crashsight.symtabtool.common.file.FileHelper;
import com.uqm.crashsight.symtabtool.common.file.FileSegmentExtractor;
import com.uqm.crashsight.symtabtool.common.file.SectionReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.common.utils.Utils;
import com.uqm.crashsight.symtabtool.dwarf.DebugAbbrevParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugAddrParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugInfoPasrser;
import com.uqm.crashsight.symtabtool.dwarf.DebugLineParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugLineStrParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugPubnamesParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugRangesParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugRnglistParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugStrOffsetsParser;
import com.uqm.crashsight.symtabtool.dwarf.DebugStrParser;
import com.uqm.crashsight.symtabtool.dwarf.DwarfInfoBean;
import com.uqm.crashsight.symtabtool.symtab.Symbol;
import com.uqm.crashsight.symtabtool.symtab.SymbolTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.zip.InflaterInputStream;
import org.apache.commons.lang3.StringUtils;

public class DwarfParser {
    public static final long DWARF2_VERSION = 2L;
    public static final long DWARF3_VERSION = 3L;
    public static final long DWARF4_VERSION = 4L;
    public static final long DWARF5_VERSION = 5L;
    public static final long DWARF_ADDR_BITS_32 = 32L;
    public static final long DWARF_ADDR_BITS_64 = 64L;
    public static final long FILE_FORMAT_32 = 32L;
    public static final long FILE_FORMAT_64 = 64L;
    public static final long DWARF_FORMAT_32 = 32L;
    public static final long DWARF_FORMAT_64 = 64L;
    public int cunum = 0;
    private String fileName = null;
    private long fileFormat = 0L;
    long dwarfVersion = 4L;
    private DebugAbbrevParser debugAbbrev = null;
    private DebugInfoPasrser debugInfo = null;
    private DebugStrParser debugStr = null;
    private DebugLineParser debugLine = null;
    private DebugRangesParser debugRanges = null;
    private DebugPubnamesParser debugPubnames = null;
    private long parseDebugLineCost = 0L;
    private DebugStrOffsetsParser debugStrOffsetsParser = null;
    private DebugLineStrParser debugLineStrParser = null;
    private DebugRnglistParser debugRnglistParser = null;
    private DebugAddrParser debugAddrParser = null;
    private final Map<Long, String> sectionOffset2Name = new HashMap<Long, String>();
    private final Set<Long> referencedDieTag = new HashSet<Long>();
    private long DW_FORM_ref_addr_num = 0L;
    long cacheNotHit = 0L;
    private boolean useRefName = true;
    private String platform = "None";
    private HashSet<String> invalidPaths = new HashSet();

    private DwarfParser() {
    }

    public DwarfParser(String string) {
        this.setFileName(string);
    }

    private static void sortSubroutineTable(Vector<Subroutine> vector) {
        vector.sort((subroutine, subroutine2) -> {
            if (subroutine.getLowPc() == subroutine2.getLowPc()) {
                return subroutine.getLevel() - subroutine2.getLevel();
            }
            return (int)(subroutine.getLowPc() - subroutine2.getLowPc());
        });
    }

    private static void sortSubroutineTable(List<Subroutine> list) {
        list.sort((subroutine, subroutine2) -> {
            if (subroutine.getLowPc() == subroutine2.getLowPc()) {
                return subroutine2.getLevel() - subroutine.getLevel();
            }
            return (int)(subroutine.getLowPc() - subroutine2.getLowPc());
        });
    }

    private static void sortLineInfoTable(Vector<DebugLineParser.DebugLineEntry> vector) {
        Collections.sort(vector, new Comparator<DebugLineParser.DebugLineEntry>(){

            @Override
            public int compare(DebugLineParser.DebugLineEntry debugLineEntry, DebugLineParser.DebugLineEntry debugLineEntry2) {
                return (int)(debugLineEntry.getAddress() - debugLineEntry2.getAddress());
            }
        });
    }

    public static SymbolTable getSymbolTable(Vector<Subroutine> vector, DwarfInfoBean dwarfInfoBean) {
        DwarfParser dwarfParser = new DwarfParser();
        dwarfParser.setDwarfInfo(dwarfInfoBean);
        SymbolTable symbolTable = dwarfParser.getSymbolTable(vector);
        dwarfParser.printSummaryInfo();
        dwarfParser.close();
        return symbolTable;
    }

    private boolean setFileName(String string) {
        if (null == string) {
            return false;
        }
        this.fileName = string;
        return true;
    }

    public boolean setDebugAbbrev(DwarfInfoBean dwarfInfoBean) {
        long l = dwarfInfoBean.getDebugAbbrevOffset();
        long l2 = dwarfInfoBean.getDebugAbbrevSize();
        if (l < 0L || l2 <= 0L) {
            Log.error("Not a valid debug_abbrev section", new Object[0]);
            return false;
        }
        if (dwarfInfoBean.isDebugAbbrevCompressed()) {
            try {
                Pair<String, Long> pair = this.checkToUncompressed(".debug_abbrev", l, l2, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
                this.debugAbbrev = new DebugAbbrevParser(pair.getKey(), 0L, pair.getValue(), dwarfInfoBean.isLittleEndian());
            }
            catch (Exception exception) {
                Log.error("uncompressed debug_abbrev section error", exception);
                return false;
            }
        } else {
            this.debugAbbrev = new DebugAbbrevParser(this.fileName, l, l2, dwarfInfoBean.isLittleEndian());
        }
        return true;
    }

    public boolean setDebugStrOffsets(DwarfInfoBean dwarfInfoBean) {
        long l = dwarfInfoBean.getDebugStrOffsetsOffset();
        long l2 = dwarfInfoBean.getDebugStrOffsetsSize();
        if (l < 0L || l2 <= 0L) {
            Log.error("Not a valid debug_str_offsets section", new Object[0]);
            return false;
        }
        if (dwarfInfoBean.isDebugStrOffsetCompressed()) {
            try {
                Pair<String, Long> pair = this.checkToUncompressed(".debug_str_offsets", l, l2, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
                this.debugStrOffsetsParser = new DebugStrOffsetsParser(pair.getKey(), 0L, pair.getValue());
            }
            catch (Exception exception) {
                Log.error("uncompressed debug_str_offsets section error", exception);
                return false;
            }
        } else {
            this.debugStrOffsetsParser = new DebugStrOffsetsParser(this.fileName, l, l2);
        }
        return true;
    }

    public boolean setDebugInfo(DwarfInfoBean dwarfInfoBean) {
        long l = dwarfInfoBean.getDebugInfoOffset();
        long l2 = dwarfInfoBean.getDebugInfoSize();
        if (l < 0L || l2 <= 0L) {
            Log.error("Not a valid debug_info section", new Object[0]);
            return false;
        }
        if (dwarfInfoBean.isDebugInfoCompressed()) {
            try {
                Pair<String, Long> pair = this.checkToUncompressed(".debug_info", l, l2, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
                this.debugInfo = new DebugInfoPasrser(pair.getKey(), 0L, pair.getValue(), true, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
            }
            catch (Exception exception) {
                Log.error("uncompressed filename error", exception);
                return false;
            }
        } else {
            this.debugInfo = new DebugInfoPasrser(this.fileName, l, l2, false, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
        }
        return true;
    }

    public Pair<String, Long> checkToUncompressed(String string, long l, long l2, boolean bl, boolean bl2) throws Exception {
        Serializable serializable;
        Object object;
        String string2 = Paths.get(this.fileName, new String[0]).toFile().getAbsolutePath() + string + ".compressed";
        FileSegmentExtractor.extractSegment(this.fileName, string2, l, l2);
        BinaryFileReader binaryFileReader = new BinaryFileReader(string2, bl2);
        ElfCompressionHeader elfCompressionHeader = new ElfCompressionHeader();
        elfCompressionHeader.chType = binaryFileReader.readInt();
        if (!bl) {
            elfCompressionHeader.chReserved = binaryFileReader.readInt();
            elfCompressionHeader.chSize = binaryFileReader.readLong();
            elfCompressionHeader.chAddralign = binaryFileReader.readLong();
        } else {
            elfCompressionHeader.chSize = binaryFileReader.readInt();
            elfCompressionHeader.chAddralign = binaryFileReader.readInt();
        }
        String string3 = Paths.get(this.fileName, new String[0]).toFile().getAbsolutePath() + string + ".uncompressed";
        try {
            object = new FileInputStream(string2);
            serializable = null;
            try (InflaterInputStream inflaterInputStream = new InflaterInputStream((InputStream)object);
                 FileOutputStream fileOutputStream = new FileOutputStream(string3);){
                int n;
                ((FileInputStream)object).skip(binaryFileReader.getOffset());
                byte[] byArray = new byte[8192];
                while ((n = inflaterInputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (serializable != null) {
                        try {
                            ((FileInputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)serializable).addSuppressed(throwable);
                        }
                    } else {
                        ((FileInputStream)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new Exception("checkToUncompressed error", iOException);
        }
        object = new File(string3);
        ((File)object).deleteOnExit();
        serializable = new File(string2);
        ((File)serializable).deleteOnExit();
        return new Pair<String, Long>(string3, elfCompressionHeader.chSize);
    }

    public boolean setDebugStr(DwarfInfoBean dwarfInfoBean) {
        long l = dwarfInfoBean.getDebugStrOffset();
        long l2 = dwarfInfoBean.getDebugStrSize();
        if (l < 0L || l2 <= 0L) {
            Log.error("Not a valid debug_str section", new Object[0]);
            return false;
        }
        if (dwarfInfoBean.isDebugStrCompressed()) {
            try {
                Pair<String, Long> pair = this.checkToUncompressed(".debug_str", l, l2, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
                this.debugStr = new DebugStrParser(pair.getKey(), 0L, pair.getValue());
            }
            catch (Exception exception) {
                Log.error("uncompressed debug_str section error", exception);
                return false;
            }
        } else {
            this.debugStr = new DebugStrParser(this.fileName, l, l2);
        }
        return true;
    }

    public boolean setDebugPubnames(DwarfInfoBean dwarfInfoBean) {
        long l = dwarfInfoBean.getDebugPubnamesOffset();
        long l2 = dwarfInfoBean.getDebugPubnamesSize();
        if (l < 0L || l2 <= 0L) {
            Log.error("Not a valid debug_pubnames section", new Object[0]);
            return false;
        }
        if (dwarfInfoBean.isDebugPubnamesCompressed()) {
            try {
                Pair<String, Long> pair = this.checkToUncompressed(".debug_pubnames", l, l2, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
                this.debugPubnames = new DebugPubnamesParser(pair.getKey(), 0L, pair.getValue());
            }
            catch (Exception exception) {
                Log.error("uncompressed debug_pubnames section error", exception);
                return false;
            }
        } else {
            this.debugPubnames = new DebugPubnamesParser(this.fileName, l, l2);
        }
        return true;
    }

    public boolean setDebugLine(DwarfInfoBean dwarfInfoBean) {
        long l = dwarfInfoBean.getDebugLineOffset();
        long l2 = dwarfInfoBean.getDebugLineSize();
        if (l < 0L || l2 <= 0L) {
            Log.error("Not a valid debug_line section", new Object[0]);
            return false;
        }
        if (dwarfInfoBean.isDebugLineCompressed()) {
            try {
                Pair<String, Long> pair = this.checkToUncompressed(".debug_line", l, l2, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
                this.debugLine = new DebugLineParser(pair.getKey(), 0L, pair.getValue(), dwarfInfoBean.isLittleEndian());
            }
            catch (Exception exception) {
                Log.error("uncompressed debug_line section error", exception);
                return false;
            }
        } else {
            this.debugLine = new DebugLineParser(this.fileName, l, l2, dwarfInfoBean.isLittleEndian());
        }
        return true;
    }

    public void setDebugRanges(DwarfInfoBean dwarfInfoBean) {
        long l = dwarfInfoBean.getDebugRangesOffset();
        long l2 = dwarfInfoBean.getDebugRangesSize();
        if (l < 0L || l2 <= 0L) {
            return;
        }
        if (dwarfInfoBean.isDebugRangesCompressed()) {
            try {
                Pair<String, Long> pair = this.checkToUncompressed(".debug_ranges", l, l2, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
                this.debugRanges = new DebugRangesParser(pair.getKey(), 0L, pair.getValue(), dwarfInfoBean.isLittleEndian());
            }
            catch (Exception exception) {
                Log.error("uncompressed debug_ranges section error", exception);
            }
        } else {
            this.debugRanges = new DebugRangesParser(this.fileName, l, l2, dwarfInfoBean.isLittleEndian());
        }
    }

    public void setDebugLineStr(DwarfInfoBean dwarfInfoBean) {
        long l = dwarfInfoBean.getDebugLineStrOffset();
        long l2 = dwarfInfoBean.getDebugLineStrSize();
        if (l < 0L || l2 <= 0L) {
            return;
        }
        if (dwarfInfoBean.isDebugLineStrCompressed()) {
            try {
                Pair<String, Long> pair = this.checkToUncompressed(".debug_line_str", l, l2, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
                this.debugLineStrParser = new DebugLineStrParser(pair.getKey(), 0L, pair.getValue());
            }
            catch (Exception exception) {
                Log.error("uncompressed debug_line_str section error", exception);
            }
        } else {
            this.debugLineStrParser = new DebugLineStrParser(this.fileName, l, l2);
        }
    }

    public void setDebugRnglist(DwarfInfoBean dwarfInfoBean, DebugAddrParser debugAddrParser) {
        long l = dwarfInfoBean.getDebugRngListOffset();
        long l2 = dwarfInfoBean.getDebugRngListSize();
        if (l < 0L || l2 <= 0L) {
            return;
        }
        if (dwarfInfoBean.isDebugRngListCompressed()) {
            try {
                Pair<String, Long> pair = this.checkToUncompressed(".debug_rnglists", l, l2, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
                this.debugRnglistParser = new DebugRnglistParser(pair.getKey(), 0L, pair.getValue(), debugAddrParser);
            }
            catch (Exception exception) {
                Log.error("uncompressed debug_rnglists section error", exception);
            }
        } else {
            this.debugRnglistParser = new DebugRnglistParser(this.fileName, l, l2, debugAddrParser);
        }
    }

    public void setDebugAddr(DwarfInfoBean dwarfInfoBean) {
        long l = dwarfInfoBean.getDebugAddrOffset();
        long l2 = dwarfInfoBean.getDebugAddrSize();
        if (l < 0L || l2 <= 0L) {
            return;
        }
        if (dwarfInfoBean.isDebugAddrCompressed()) {
            try {
                Pair<String, Long> pair = this.checkToUncompressed(".debug_addr", l, l2, dwarfInfoBean.is32bitElf(), dwarfInfoBean.isLittleEndian());
                this.debugAddrParser = new DebugAddrParser(pair.getKey(), 0L, pair.getValue());
            }
            catch (Exception exception) {
                Log.error("uncompressed debug_addr section error", exception);
            }
        } else {
            this.debugAddrParser = new DebugAddrParser(this.fileName, l, l2);
        }
    }

    private void setDwarfInfo(DwarfInfoBean dwarfInfoBean) {
        if (!this.setFileName(dwarfInfoBean.getFileName())) {
            return;
        }
        if (!this.setDebugInfo(dwarfInfoBean)) {
            return;
        }
        if (!this.setDebugAbbrev(dwarfInfoBean)) {
            return;
        }
        if (!this.setDebugLine(dwarfInfoBean)) {
            return;
        }
        this.setDebugStr(dwarfInfoBean);
        this.setDebugRanges(dwarfInfoBean);
        this.setDebugPubnames(dwarfInfoBean);
        this.setDebugStrOffsets(dwarfInfoBean);
        this.setDebugLineStr(dwarfInfoBean);
        this.setDebugAddr(dwarfInfoBean);
        this.setDebugRnglist(dwarfInfoBean, this.debugAddrParser);
        long l = 4L;
        if (dwarfInfoBean.getDebugRngListOffset() != -1L) {
            l = 5L;
        }
        this.dwarfVersion = l;
        this.debugInfo.setDebugPubnamesParser(this.debugPubnames);
        this.debugInfo.setDebugStrOffsetsParser(this.debugStrOffsetsParser);
        this.platform = dwarfInfoBean.getPlatform();
    }

    private boolean checkInit() {
        if (null == this.fileName) {
            return false;
        }
        if (null == this.debugAbbrev) {
            return false;
        }
        if (null == this.debugInfo) {
            return false;
        }
        if (null == this.debugLine) {
            return false;
        }
        if (32L != this.debugLine.getAddrBits() && 64L == this.debugLine.getAddrBits()) {
            Log.error("File format no setting", new Object[0]);
            return false;
        }
        return true;
    }

    public boolean setFileFormat(long l) {
        switch ((int)l) {
            case 4: 
            case 32: {
                this.fileFormat = 32L;
                break;
            }
            case 8: 
            case 64: {
                this.fileFormat = 64L;
                break;
            }
            default: {
                Log.warn("Address bits error", new Object[0]);
                return false;
            }
        }
        return true;
    }

    private boolean checkFileFormat() {
        return 0L != this.fileFormat;
    }

    private boolean setDebugLineAddrBits() {
        if (32L == this.fileFormat) {
            this.debugLine.setAddrBits(32L);
        } else if (64L == this.fileFormat) {
            this.debugLine.setAddrBits(64L);
        } else {
            Log.error("File format error", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean setDebugRangesAddrBits() {
        if (null == this.debugRanges) {
            return true;
        }
        if (32L == this.fileFormat) {
            this.debugRanges.setAddrBits(32L);
        } else if (64L == this.fileFormat) {
            this.debugRanges.setAddrBits(64L);
        } else {
            Log.error("File format error", new Object[0]);
            return false;
        }
        return true;
    }

    private long getDebugLineOffset(HashMap<Long, DebugInfoPasrser.DebugInfoEntry> hashMap) {
        DebugInfoPasrser.DebugInfoEntry debugInfoEntry = hashMap.get(this.debugInfo.getCuDieOffset());
        if (null == debugInfoEntry) {
            Log.error("Failed to get debug info table", new Object[0]);
            return 0L;
        }
        String string = debugInfoEntry.getAttribute(16L);
        if (null == string) {
            Log.error("Compilation unit has not DW_AT_stmt_list", new Object[0]);
            return 0L;
        }
        return Long.parseLong(string, 16);
    }

    private Vector<DebugLineParser.DebugLineEntry> getLineInfoTable(long l, String string) {
        long l2 = System.currentTimeMillis();
        if (!this.checkFileFormat()) {
            return null;
        }
        Vector<DebugLineParser.DebugLineEntry> vector = this.debugLine.getLineInfoTable(l, this.debugStr, this.debugLineStrParser);
        DwarfParser.sortLineInfoTable(vector);
        for (DebugLineParser.DebugLineEntry debugLineEntry : vector) {
            boolean bl;
            if (debugLineEntry.getAddress() == 106165056L) {
                bl = true;
            }
            debugLineEntry.setPathName(this.checkToMergeDirAndPath(string, debugLineEntry.getPathName()));
            if (debugLineEntry.getAddress() != 106165056L) continue;
            bl = true;
        }
        this.parseDebugLineCost += System.currentTimeMillis() - l2;
        return vector;
    }

    private int mangleStyle(int n) {
        switch (n) {
            case 3: 
            case 13: 
            case 46: 
            case 47: {
                return 32768;
            }
            case 4: 
            case 25: 
            case 26: 
            case 33: 
            case 42: 
            case 43: 
            case 58: {
                return 16384;
            }
            case 11: {
                return 4;
            }
            case 19: {
                return 65536;
            }
            case 28: 
            case 36864: {
                return 131072;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 29: 
            case 44: 
            case 45: 
            case 49: 
            case 62: 
            case 63: 
            case 32769: 
            case 32772: 
            case 32774: 
            case 32775: 
            case 34661: {
                return 0;
            }
        }
        return 256;
    }

    private String parseSubroutineName(Map<Long, DebugInfoPasrser.DebugInfoEntry> map, DebugInfoPasrser.DebugInfoEntry debugInfoEntry, HashSet<DebugInfoPasrser.DebugInfoEntry> hashSet, TreeMap<Long, List<Subroutine>> treeMap, long l, long l2, int n) {
        String string;
        block54: {
            boolean bl;
            block53: {
                String string2;
                if (null != debugInfoEntry.getName()) {
                    return debugInfoEntry.getName();
                }
                if (debugInfoEntry.getOffsetInSection() == 82986L) {
                    bl = true;
                }
                if (l == 28364732L) {
                    bl = true;
                }
                if (debugInfoEntry.getAttribute(3L) == null && debugInfoEntry.getAttribute(8199L) == null && debugInfoEntry.getAttribute(110L) == null && debugInfoEntry.getAttribute(71L) == null && debugInfoEntry.getAttribute(49L) == null) {
                    Subroutine subroutine;
                    if (l > 0L && debugInfoEntry.getTag() == 46L && (subroutine = this.findFloorSubroutine(treeMap, l, l2)) != null && StringUtils.isNotEmpty(subroutine.getName())) {
                        return subroutine.getName();
                    }
                    return null;
                }
                bl = false;
                long l3 = 0L;
                string = debugInfoEntry.getAttribute(3L);
                if (null != string) {
                    l3 = 3L;
                }
                if (null != (string2 = debugInfoEntry.getAttribute(8199L))) {
                    string = string2;
                    l3 = 8199L;
                    bl = true;
                } else {
                    String string3 = debugInfoEntry.getAttribute(110L);
                    if (null != string3) {
                        string = string3;
                        l3 = 110L;
                        bl = true;
                    }
                }
                try {
                    if (l3 == 0L) break block53;
                    long l4 = debugInfoEntry.getAttributeForm().get(l3);
                    switch ((int)l4) {
                        case 8: {
                            break;
                        }
                        case 14: {
                            String string4 = this.debugStr.getString(Long.parseLong(string, 16));
                            if (null == string4) break;
                            string = string4;
                            break;
                        }
                        case 31: {
                            String string5 = this.debugLineStrParser.getString(Long.parseLong(string, 16));
                            if (null == string5) break;
                            string = string5;
                            break;
                        }
                        case 26: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: {
                            try {
                                long l5;
                                if (debugInfoEntry.getCompileUnit() == null) break;
                                long l6 = Long.parseLong(debugInfoEntry.getCompileUnit().getAttribute(114L), 16);
                                long l7 = this.debugStrOffsetsParser.getStrOffset(l6, (int)(l5 = Long.parseLong(string, 16)));
                                String string6 = this.debugStr.getString(l7);
                                if (null != string6) {
                                    string = string6;
                                }
                                break;
                            }
                            catch (Exception exception) {
                                Log.error(exception);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    Log.error(exception);
                }
            }
            if (l == 28364732L) {
                boolean bl2 = true;
            }
            if (string != null) {
                if (bl) {
                    return string;
                }
                if (l > 0L) {
                    Subroutine subroutine = this.findFloorSubroutine(treeMap, l);
                    if (subroutine != null && StringUtils.isNotEmpty(subroutine.getName())) {
                        return subroutine.getName();
                    }
                } else {
                    return string;
                }
            }
            try {
                boolean bl3;
                long l8;
                long l9 = 0L;
                String string7 = debugInfoEntry.getAttribute(71L);
                if (null != string7) {
                    l8 = debugInfoEntry.getAttributeForm().get(71L);
                    l9 = 71L;
                } else {
                    string7 = debugInfoEntry.getAttribute(49L);
                    if (null != string7) {
                        l9 = 49L;
                    }
                }
                if (l9 == 0L) {
                    return null;
                }
                try {
                    l8 = Long.parseLong(string7, 16);
                }
                catch (Exception exception) {
                    Log.error(exception);
                    return null;
                }
                long l10 = debugInfoEntry.getForm(l9);
                if (l10 == 16L) {
                    boolean bl4;
                    if (n > 15) {
                        Log.error("Parse suboutine name over 15 level.", new Object[0]);
                        return null;
                    }
                    SectionReader.Context context = this.debugInfo.getParseBufferContext();
                    boolean bl5 = bl4 = debugInfoEntry.getTag() == 29L;
                    if (bl4) {
                        l = -1L;
                    }
                    string = this.parseSubroutineNameInSection(l8, this.debugInfo.copy(), this.debugAbbrev, this.debugStr, this.debugLineStrParser, treeMap, l, l2, n);
                    this.debugInfo.loadParseBufferContext(context);
                    break block54;
                }
                if (l10 == 32L) {
                    Log.error("need to process DW_AT_SPECIFICATION DW_FORM_REF_SIG8", new Object[0]);
                    break block54;
                }
                DebugInfoPasrser.DebugInfoEntry debugInfoEntry2 = null;
                if (map.size() == 0) {
                    long l11 = debugInfoEntry.getOffsetInSection() - debugInfoEntry.getOffsetInCu();
                    long l12 = l11 + l8;
                    DebugInfoPasrser debugInfoPasrser = this.debugInfo.copy();
                    DebugInfoPasrser.CompilationUnitHeader compilationUnitHeader = null;
                    for (int i = 1; i < debugInfoPasrser.cuHeaders.size() && (l12 <= (compilationUnitHeader = debugInfoPasrser.cuHeaders.get(i)).getOffsetInSection() || l12 >= compilationUnitHeader.getNextOffsetInSection()); ++i) {
                    }
                    if (compilationUnitHeader == null) {
                        return null;
                    }
                    if (!debugInfoPasrser.openFile()) {
                        debugInfoPasrser.close();
                        return null;
                    }
                    debugInfoPasrser.binaryFileReader.skip(l12);
                    debugInfoPasrser.debugInfoTable = new LinkedHashMap();
                    debugInfoPasrser.header = compilationUnitHeader;
                    if (!debugInfoPasrser.setDwarfFormat(debugInfoPasrser.header.getDwarfFormat())) {
                        return null;
                    }
                    if (!debugInfoPasrser.setAddrBits(debugInfoPasrser.header.getAddressSize())) {
                        return null;
                    }
                    long l13 = 0L;
                    try {
                        l13 = debugInfoPasrser.binaryFileReader.parseULeb128();
                        if (0L == l13) {
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        Log.error("Failed to get abbrev entry, abbrev code\uff1a%s", exception.getMessage());
                        return null;
                    }
                    long l14 = debugInfoPasrser.header.getDebugAbbrevOffset();
                    DebugAbbrevParser.DebugAbbrevEntry debugAbbrevEntry = this.debugAbbrev.getAbbrevTable(l14).get(l13);
                    if (null == debugAbbrevEntry) {
                        Log.error("Failed to get abbrev entry, abbrev code\uff1a%d", l13);
                        return null;
                    }
                    debugInfoEntry2 = debugInfoPasrser.parseDebugInfoEntry(debugAbbrevEntry);
                    if (null == debugInfoEntry2) {
                        Log.error("Failed to parse debug info entry", new Object[0]);
                        return null;
                    }
                } else {
                    debugInfoEntry2 = map.get(l8);
                }
                if (null == debugInfoEntry2 || debugInfoEntry2 == debugInfoEntry) {
                    return null;
                }
                if (hashSet.contains(debugInfoEntry2)) {
                    return null;
                }
                hashSet.add(debugInfoEntry2);
                this.referencedDieTag.add(debugInfoEntry2.getTag());
                boolean bl6 = bl3 = debugInfoEntry.getTag() == 29L;
                if (bl3) {
                    l = -1L;
                }
                string = this.parseSubroutineName(map, debugInfoEntry2, hashSet, treeMap, l, l2, n + 1);
            }
            catch (Exception exception) {
                Log.error(exception);
            }
        }
        return string;
    }

    public String parseSubroutineNameInSection(long l, DebugInfoPasrser debugInfoPasrser, DebugAbbrevParser debugAbbrevParser, DebugStrParser debugStrParser, DebugLineStrParser debugLineStrParser, TreeMap<Long, List<Subroutine>> treeMap, long l2, long l3, int n) {
        ++this.DW_FORM_ref_addr_num;
        if (!this.useRefName) {
            return null;
        }
        DebugInfoPasrser.CompilationUnitHeader compilationUnitHeader = null;
        for (int i = 1; i < debugInfoPasrser.cuHeaders.size() && (l <= (compilationUnitHeader = debugInfoPasrser.cuHeaders.get(i)).getOffsetInSection() || l >= compilationUnitHeader.getNextOffsetInSection()); ++i) {
        }
        if (compilationUnitHeader == null) {
            return null;
        }
        if (!debugInfoPasrser.openFile()) {
            debugInfoPasrser.close();
            return null;
        }
        debugInfoPasrser.debugInfoTable = new LinkedHashMap();
        debugInfoPasrser.header = compilationUnitHeader;
        if (!debugInfoPasrser.setDwarfFormat(debugInfoPasrser.header.getDwarfFormat())) {
            return null;
        }
        if (!debugInfoPasrser.setAddrBits(debugInfoPasrser.header.getAddressSize())) {
            return null;
        }
        long l4 = debugInfoPasrser.header.getDebugAbbrevOffset();
        HashMap<Long, DebugAbbrevParser.DebugAbbrevEntry> hashMap = debugAbbrevParser.GetAbbrvByCache(l4);
        if (hashMap == null) {
            hashMap = debugAbbrevParser.getAbbrevTable(l4);
            debugAbbrevParser.PutAbbrvByCache(l4, hashMap);
        }
        debugInfoPasrser.binaryFileReader.skip(l);
        long l5 = 0L;
        try {
            l5 = debugInfoPasrser.binaryFileReader.parseULeb128();
            if (0L == l5) {
                return null;
            }
        }
        catch (Exception exception) {
            Log.error("Failed to get abbrev entry, abbrev code\uff1a%s", exception.getMessage());
            return null;
        }
        DebugAbbrevParser.DebugAbbrevEntry debugAbbrevEntry = hashMap.get(l5);
        if (null == debugAbbrevEntry) {
            Log.error("Failed to get abbrev entry, abbrev code\uff1a%d", l5);
            return null;
        }
        DebugInfoPasrser.DebugInfoEntry debugInfoEntry = debugInfoPasrser.parseDebugInfoEntry(debugAbbrevEntry);
        if (null == debugInfoEntry) {
            Log.error("Failed to parse debug info entry", new Object[0]);
            return null;
        }
        debugInfoEntry.offsetInCu = l - compilationUnitHeader.getOffsetInSection();
        debugInfoEntry.offsetInSection = l;
        if (!debugInfoPasrser.binaryFileReader.isUseParseBuffer()) {
            debugInfoPasrser.close();
        }
        this.referencedDieTag.add(debugInfoEntry.getTag());
        return this.parseSubroutineName(debugInfoPasrser.debugInfoTable, debugInfoEntry, treeMap, l2, l3, n);
    }

    private String parseSubroutineName(Map<Long, DebugInfoPasrser.DebugInfoEntry> map, DebugInfoPasrser.DebugInfoEntry debugInfoEntry, TreeMap<Long, List<Subroutine>> treeMap, long l, long l2, int n) {
        if (this.sectionOffset2Name.containsKey(debugInfoEntry.offsetInSection)) {
            return this.sectionOffset2Name.get(debugInfoEntry.offsetInSection);
        }
        String string = this.parseSubroutineName(map, debugInfoEntry, new HashSet<DebugInfoPasrser.DebugInfoEntry>(), treeMap, l, l2, n);
        if (debugInfoEntry.getTag() == 46L) {
            if (string == null) {
                boolean bl = true;
            }
            this.sectionOffset2Name.put(debugInfoEntry.offsetInSection, string);
        }
        return string;
    }

    private String getInlineFuncName(DebugInfoPasrser.DebugInfoEntry debugInfoEntry, String string) {
        String string2 = null;
        for (DebugInfoPasrser.DebugInfoEntry debugInfoEntry2 = debugInfoEntry.getParent(); debugInfoEntry2 != null && debugInfoEntry2.getLevel() > 0; debugInfoEntry2 = debugInfoEntry2.getParent()) {
            if (StringUtils.isEmpty(debugInfoEntry2.getName())) {
                continue;
            }
            string2 = debugInfoEntry2.getName();
            break;
        }
        if (string2 == null) {
            return string;
        }
        if (debugInfoEntry.getTag() == 29L) {
            StringBuilder stringBuilder = new StringBuilder();
            long l = Long.parseLong(debugInfoEntry.getAttribute(89L), 16);
            long l2 = Long.parseLong(debugInfoEntry.getAttribute(88L), 16);
            String string3 = this.debugLine.getSourceFile((int)l2);
            string3 = this.checkToMergeDirAndPath(this.debugInfo.cuDir, string3);
            stringBuilder.append(string2).append("#").append(string3).append("#").append(l).append(";").append(string);
            return stringBuilder.toString();
        }
        if (StringUtils.isEmpty(string)) {
            return string2;
        }
        if (string2.equals(string)) {
            return string2;
        }
        return string2 + ";" + string;
    }

    private Vector<Subroutine> parseEntrySubroutines(Map<Long, DebugInfoPasrser.DebugInfoEntry> map, DebugInfoPasrser.DebugInfoEntry debugInfoEntry, TreeMap<Long, List<Subroutine>> treeMap) {
        Object object;
        long l;
        Object object2;
        String string;
        if (null == this.debugRanges && null == this.debugRnglistParser) {
            return null;
        }
        Vector<Object> vector = new Vector();
        long l2 = 0L;
        if (5L != this.dwarfVersion) {
            string = debugInfoEntry.getAttribute(85L);
            if (null != string) {
                l2 = Long.parseLong(string, 16);
                vector = this.debugRanges.getRangesTable(l2);
                if (null == vector) {
                    Log.warn("Fail to get ranges table", new Object[0]);
                } else {
                    object2 = debugInfoEntry.getCompileUnit().attributeTable.get(17L);
                    if (object2 != null) {
                        l = Long.parseLong((String)object2, 16);
                        for (DebugRangesParser.DebugRangeEntry debugRangeEntry : vector) {
                            debugRangeEntry.setLowPc(debugRangeEntry.getLowPc() + l);
                            debugRangeEntry.setHighPc(debugRangeEntry.getHighPc() + l);
                        }
                    }
                }
            }
        } else {
            long l3;
            Vector<DebugRnglistParser.DebugRangeEntry> vector2;
            long l4 = 0L;
            l = 0L;
            Object object3 = this.debugInfo.debugInfoTable.entrySet().iterator();
            while (object3.hasNext()) {
                Map.Entry<Long, DebugInfoPasrser.DebugInfoEntry> entry = object3.next();
                if (entry.getValue().getTag() != 17L) continue;
                object = entry.getValue().attributeTable.get(115L);
                if (object != null) {
                    l4 = Long.parseLong((String)object, 16);
                }
                if ((object = entry.getValue().attributeTable.get(116L)) == null) break;
                l = Long.parseLong((String)object, 16);
                break;
            }
            if (null == (object3 = debugInfoEntry.getAttribute(85L)) || null == (vector2 = this.debugRnglistParser.getRangesTable(l3 = Long.parseLong((String)object3, 16), l4, l))) {
                // empty if block
            }
        }
        if (null == vector || vector.isEmpty()) {
            return null;
        }
        string = this.parseSubroutineName(map, debugInfoEntry, treeMap, ((DebugRangesParser.DebugRangeEntry)vector.get(0)).getLowPc(), ((DebugRangesParser.DebugRangeEntry)vector.get(0)).getHighPc(), 0);
        if (null == (string = this.getInlineFuncName(debugInfoEntry, string))) {
            return null;
        }
        debugInfoEntry.setName(string);
        object2 = new Vector();
        Object object4 = null;
        for (Object object3 : vector) {
            boolean bl;
            boolean bl2 = false;
            if (object4 != null && ((Subroutine)object4).getHighPc() == ((DebugRangesParser.DebugRangeEntry)object3).getHighPc() && ((Subroutine)object4).getLowPc() == ((DebugRangesParser.DebugRangeEntry)object3).getLowPc() && ((Subroutine)object4).getLevel() == debugInfoEntry.getLevel()) {
                bl = true;
            }
            if (bl) continue;
            object = new Subroutine();
            ((Subroutine)object).setLowPc(((DebugRangesParser.DebugRangeEntry)object3).getLowPc());
            ((Subroutine)object).setHighPc(((DebugRangesParser.DebugRangeEntry)object3).getHighPc());
            ((Subroutine)object).setLevel(debugInfoEntry.getLevel());
            ((Subroutine)object).setName(string);
            ((Vector)object2).add(object);
            object4 = object;
        }
        return object2;
    }

    private Subroutine parseSubroutine(Map<Long, DebugInfoPasrser.DebugInfoEntry> map, DebugInfoPasrser.DebugInfoEntry debugInfoEntry, TreeMap<Long, List<Subroutine>> treeMap) {
        Object object;
        Long l = this.parsePc(debugInfoEntry, 17L);
        if (l == null) {
            return null;
        }
        long l2 = 0L;
        if (debugInfoEntry.getTag() == 10L) {
            object = this.parseLowPcHighPc(map, debugInfoEntry.getCompileUnit());
            l2 = ((DebugRangesParser.DebugRangeEntry)object).getHighPc();
        } else {
            object = debugInfoEntry.getAttribute(18L);
            if (null == object) {
                return null;
            }
            l2 = Long.parseLong((String)object, 16);
            if (l2 < l) {
                l2 = l + l2;
            }
        }
        object = new Subroutine();
        ((Subroutine)object).setLowPc(l);
        ((Subroutine)object).setHighPc(l2);
        ((Subroutine)object).setLevel(debugInfoEntry.getLevel());
        if (this.useRefName && debugInfoEntry.getOffsetInSection() > 0xF0000000L && this.platform.equals("iOS")) {
            this.useRefName = false;
        }
        String string = this.parseSubroutineName(map, debugInfoEntry, treeMap, l, l2, 0);
        if (null == (string = this.getInlineFuncName(debugInfoEntry, string))) {
            return null;
        }
        ((Subroutine)object).setName(string);
        debugInfoEntry.setName(string);
        return object;
    }

    private Long parsePc(DebugInfoPasrser.DebugInfoEntry debugInfoEntry, long l) {
        String string = debugInfoEntry.getAttribute(l);
        if (null == string) {
            return null;
        }
        long l2 = debugInfoEntry.getAttributeForm().get(l);
        switch ((int)l2) {
            case 1: 
            case 14: {
                return Long.parseLong(string, 16);
            }
            case 27: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                DebugInfoPasrser.DebugInfoEntry debugInfoEntry2 = debugInfoEntry.getCompileUnit();
                if (debugInfoEntry.getTag() == 17L) {
                    debugInfoEntry2 = debugInfoEntry;
                }
                long l3 = Long.parseLong(debugInfoEntry2.getAttribute(115L), 16);
                long l4 = Long.parseLong(string, 16);
                return this.debugAddrParser.getAddress(l3, (int)l4);
            }
        }
        return null;
    }

    private DebugRangesParser.DebugRangeEntry parseLowPcHighPc(Map<Long, DebugInfoPasrser.DebugInfoEntry> map, DebugInfoPasrser.DebugInfoEntry debugInfoEntry) {
        DebugRangesParser.DebugRangeEntry debugRangeEntry = new DebugRangesParser.DebugRangeEntry();
        Long l = this.parsePc(debugInfoEntry, 17L);
        Long l2 = this.parsePc(debugInfoEntry, 18L);
        if (l != null && l2 != null) {
            debugRangeEntry.setLowPc(l);
            if (l2 < l) {
                l2 = l + l2;
            }
            debugRangeEntry.setHighPc(l2);
            return debugRangeEntry;
        }
        Vector<DebugRangesParser.DebugRangeEntry> vector = this.getLowPcHighPcFromRanges(map, debugInfoEntry);
        if (vector != null && !vector.isEmpty()) {
            long l3 = vector.get(0).getLowPc();
            long l4 = vector.get(0).getHighPc();
            for (int i = 1; i < vector.size(); ++i) {
                DebugRangesParser.DebugRangeEntry debugRangeEntry2 = vector.get(i);
                if (debugRangeEntry2.getLowPc() < l3) {
                    l3 = debugRangeEntry2.getLowPc();
                }
                if (debugRangeEntry2.getHighPc() <= l4) continue;
                l4 = debugRangeEntry2.getHighPc();
            }
            debugRangeEntry.setLowPc(l3);
            debugRangeEntry.setHighPc(l4);
        }
        return debugRangeEntry;
    }

    private Vector<DebugRangesParser.DebugRangeEntry> getLowPcHighPcFromRanges(Map<Long, DebugInfoPasrser.DebugInfoEntry> map, DebugInfoPasrser.DebugInfoEntry debugInfoEntry) {
        if (null == this.debugRanges && null == this.debugRnglistParser) {
            return null;
        }
        Vector<DebugRangesParser.DebugRangeEntry> vector = new Vector<DebugRangesParser.DebugRangeEntry>();
        if (5L != this.dwarfVersion) {
            String string = debugInfoEntry.getAttribute(85L);
            if (null != string) {
                long l = Long.parseLong(string, 16);
                vector = this.debugRanges.getRangesTable(l);
                if (null == vector) {
                    Log.warn("Fail to get ranges table", new Object[0]);
                } else {
                    DebugInfoPasrser.DebugInfoEntry debugInfoEntry2 = debugInfoEntry.getTag() == 17L ? debugInfoEntry : debugInfoEntry.getCompileUnit();
                    String string2 = debugInfoEntry2.attributeTable.get(17L);
                    if (string2 != null) {
                        long l2 = Long.parseLong(string2, 16);
                        for (DebugRangesParser.DebugRangeEntry debugRangeEntry : vector) {
                            debugRangeEntry.setLowPc(debugRangeEntry.getLowPc() + l2);
                            debugRangeEntry.setHighPc(debugRangeEntry.getHighPc() + l2);
                        }
                    }
                }
            }
        } else {
            long l;
            Vector<DebugRnglistParser.DebugRangeEntry> vector2;
            long l3 = 0L;
            long l4 = 0L;
            Object object = this.debugInfo.debugInfoTable.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<Long, DebugInfoPasrser.DebugInfoEntry> entry = object.next();
                if (entry.getValue().getTag() != 17L) continue;
                String string = entry.getValue().attributeTable.get(115L);
                if (string != null) {
                    l3 = Long.parseLong(string, 16);
                }
                if ((string = entry.getValue().attributeTable.get(116L)) == null) break;
                l4 = Long.parseLong(string, 16);
                break;
            }
            if (null == (object = debugInfoEntry.getAttribute(85L)) || null == (vector2 = this.debugRnglistParser.getRangesTable(l = Long.parseLong((String)object, 16), l3, l4))) {
                // empty if block
            }
        }
        return vector;
    }

    private String parseCuComDir(DebugInfoPasrser.DebugInfoEntry debugInfoEntry) {
        if (debugInfoEntry == null) {
            return null;
        }
        if (debugInfoEntry.getAttributeForm() == null) {
            return null;
        }
        Long l = debugInfoEntry.getAttributeForm().get(27L);
        if (l == null) {
            return null;
        }
        String string = debugInfoEntry.attributeTable.get(27L);
        switch (l.intValue()) {
            case 8: {
                return string;
            }
            case 14: {
                return this.debugStr.getString(Long.parseLong(string, 16));
            }
            case 31: {
                return this.debugLineStrParser.getString(Long.parseLong(string, 16));
            }
            case 26: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                try {
                    long l2 = Long.parseLong(debugInfoEntry.getAttribute(114L), 16);
                    long l3 = Long.parseLong(string, 16);
                    long l4 = this.debugStrOffsetsParser.getStrOffset(l2, (int)l3);
                    return this.debugStr.getString(l4);
                }
                catch (Exception exception) {
                    Log.error(exception);
                    return null;
                }
            }
        }
        return string;
    }

    private String checkToMergeDirAndPath(String string, String string2) {
        block3: {
            try {
                if (!FileHelper.isAbsolutePathManual(string2) && StringUtils.isNotEmpty(string)) {
                    Path path = Paths.get(string, new String[0]).normalize();
                    Path path2 = Paths.get(string2, new String[0]).normalize();
                    return path.resolve(path2).toString();
                }
            }
            catch (InvalidPathException invalidPathException) {
                if (this.invalidPaths.size() >= 1000 || this.invalidPaths.contains(string2)) break block3;
                this.invalidPaths.add(string2);
                Log.warn("Invalid path: " + string2, new Object[0]);
            }
        }
        return string2;
    }

    public TreeMap<Long, List<Subroutine>> filterOutSubroutines(Map<Long, DebugInfoPasrser.DebugInfoEntry> map, TreeMap<Long, List<Subroutine>> treeMap) {
        TreeMap<Long, List<Subroutine>> treeMap2 = new TreeMap<Long, List<Subroutine>>();
        for (Map.Entry<Long, DebugInfoPasrser.DebugInfoEntry> entry : map.entrySet()) {
            DebugInfoPasrser.DebugInfoEntry debugInfoEntry = entry.getValue();
            if (debugInfoEntry.getTag() == 17L) continue;
            Subroutine subroutine = null;
            Vector<Subroutine> vector = this.parseEntrySubroutines(map, debugInfoEntry, treeMap);
            if (null != vector) {
                for (Subroutine subroutine2 : vector) {
                    if (subroutine2.getHighPc() - subroutine2.getLowPc() == 0L && subroutine2.getHighPc() == 1L || subroutine2.getHighPc() < 256L || subroutine2.getLowPc() < 256L) continue;
                    List list = treeMap2.getOrDefault(subroutine2.getLowPc(), new ArrayList());
                    list.add(subroutine2);
                    DwarfParser.sortSubroutineTable(list);
                    treeMap2.put(subroutine2.getLowPc(), list);
                    if (subroutine2.getLowPc() == 18678496L) {
                        boolean bl = true;
                    }
                    subroutine2.debugInfoEntry = debugInfoEntry;
                }
            } else {
                subroutine = this.parseSubroutine(map, debugInfoEntry, treeMap);
                if (null != subroutine) {
                    Subroutine subroutine2;
                    if (subroutine.getHighPc() - subroutine.getLowPc() == 0L && subroutine.getHighPc() == 1L || subroutine.getHighPc() < 256L || subroutine.getLowPc() < 256L) continue;
                    List list = treeMap2.getOrDefault(subroutine.getLowPc(), new ArrayList());
                    list.add(subroutine);
                    DwarfParser.sortSubroutineTable(list);
                    treeMap2.put(subroutine.getLowPc(), list);
                    subroutine.debugInfoEntry = debugInfoEntry;
                    if (debugInfoEntry.getTag() == 10L && (subroutine2 = this.findFloorSubroutine(treeMap, subroutine.getLowPc())) != null && StringUtils.equalsIgnoreCase(subroutine2.getName(), subroutine.getName())) {
                        subroutine.setHighPc(subroutine2.getHighPc());
                    }
                }
            }
            if (subroutine == null && (vector == null || vector.isEmpty())) continue;
            debugInfoEntry.subroutines = new ArrayList<Subroutine>();
            if (subroutine != null) {
                debugInfoEntry.subroutines.add(subroutine);
                continue;
            }
            debugInfoEntry.subroutines.addAll(vector);
        }
        return treeMap2;
    }

    private VariableEntry parseVariable(Map<Long, DebugInfoPasrser.DebugInfoEntry> map, DebugInfoPasrser.DebugInfoEntry debugInfoEntry) {
        String string;
        long l;
        VariableEntry variableEntry = new VariableEntry();
        String string2 = debugInfoEntry.getAttribute(2L);
        if (string2 == null) {
            return null;
        }
        if (!StringUtils.startsWith(string2, "block_")) {
            return null;
        }
        string2 = string2.substring("block_".length());
        byte[] byArray = Base64.getDecoder().decode(string2);
        variableEntry.setBlock(byArray);
        variableEntry.setBlockHex(Utils.byteArrayToHexString(byArray));
        String string3 = this.debugInfo.parseLocation(byArray);
        if (StringUtils.isEmpty(string3)) {
            string3 = "block: " + variableEntry.getBlockHex();
        }
        variableEntry.setReadable(string3);
        String string4 = debugInfoEntry.getAttribute(3L);
        if (string4 == null) {
            string4 = "null";
        } else {
            try {
                l = Long.parseLong(string4, 16);
                string = this.debugStr.getString(l);
                if (null != string) {
                    string4 = string;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        variableEntry.setName(string4);
        l = 0L;
        try {
            string = debugInfoEntry.getAttribute(73L);
            long l2 = Long.parseLong(string, 16);
            DebugInfoPasrser.DebugInfoEntry debugInfoEntry2 = map.get(l2);
            while (debugInfoEntry2 != null) {
                String string5 = debugInfoEntry2.getAttribute(11L);
                if (string5 != null) {
                    l = Long.parseLong(string5, 16);
                    break;
                }
                string = debugInfoEntry2.getAttribute(73L);
                l2 = Long.parseLong(string, 16);
                debugInfoEntry2 = map.get(l2);
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        if (l == 0L) {
            return null;
        }
        variableEntry.setSize(l);
        return variableEntry;
    }

    public List<SubroutineVariable> filterOutVariables(Map<Long, DebugInfoPasrser.DebugInfoEntry> map) {
        Object object;
        Object object2;
        LinkedHashMap<Long, Object> linkedHashMap = new LinkedHashMap<Long, Object>();
        for (Map.Entry<Long, DebugInfoPasrser.DebugInfoEntry> entry : map.entrySet()) {
            DebugInfoPasrser.DebugInfoEntry object3 = entry.getValue();
            if (object3.getTag() != 5L && object3.getTag() != 52L || (object2 = this.parseVariable(map, object3)) == null || object3.getParent() == null || object3.getParent().subroutines == null) continue;
            if (linkedHashMap.containsKey(object3.getParent().offsetInCu)) {
                object = (List)linkedHashMap.get(object3.getParent().offsetInCu);
                object.add(object2);
                continue;
            }
            object = new ArrayList();
            object.add(object2);
            linkedHashMap.put(object3.getParent().offsetInCu, object);
        }
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object2 = map.get(entry.getKey());
            object = new SubroutineVariable();
            ((SubroutineVariable)object).setSubroutines(((DebugInfoPasrser.DebugInfoEntry)object2).subroutines);
            ((SubroutineVariable)object).setVariableEntries((List)entry.getValue());
            arrayList.add(object);
        }
        return arrayList;
    }

    private int dfs() {
        return 1;
    }

    private void splitInline(Vector<Subroutine> vector, Subroutine subroutine) {
        Subroutine subroutine2;
        if (!vector.isEmpty() && (subroutine2 = vector.lastElement()).getHighPc() > subroutine.getLowPc()) {
            vector.lastElement().setHighPc(subroutine.getHighPc());
        }
    }

    private void setSymbolValue(Symbol symbol, DebugLineParser.DebugLineEntry debugLineEntry) {
        symbol.setAddress(debugLineEntry.getAddress());
        symbol.setSourceFile(debugLineEntry.getPathName());
        symbol.setSourceLine(debugLineEntry.getLineNumber());
        symbol.setSourceEndLine(debugLineEntry.getEndLineNumber());
        symbol.setSourceColumn(debugLineEntry.getColumnNumber());
    }

    private void setSymbolValue(Symbol symbol, Subroutine subroutine) {
        symbol.setAddress(subroutine.getLowPc());
        symbol.setEndAddress(subroutine.getHighPc());
        symbol.setFunction(subroutine.getName());
    }

    private Vector<Symbol> mergeToSymbolTable(Vector<DebugLineParser.DebugLineEntry> vector, Vector<Subroutine> vector2) {
        int n;
        Long l = System.currentTimeMillis();
        Vector<Symbol> vector3 = new Vector<Symbol>();
        int n2 = n = 0;
        int n3 = n;
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            DebugLineParser.DebugLineEntry debugLineEntry = vector.elementAt(i);
            DebugLineParser.DebugLineEntry debugLineEntry2 = null;
            if (i + 1 < vector.size()) {
                debugLineEntry2 = vector.elementAt(i + 1);
            }
            Symbol symbol = new Symbol();
            if (n >= vector2.size()) {
                this.setSymbolValue(symbol, debugLineEntry);
                vector3.add(symbol);
                continue;
            }
            Subroutine subroutine = vector2.elementAt(n);
            if (subroutine.beyond(debugLineEntry.getAddress())) {
                this.setSymbolValue(symbol, debugLineEntry);
                vector3.add(symbol);
                continue;
            }
            if (subroutine.below(debugLineEntry.getAddress())) {
                this.setSymbolValue(symbol, subroutine);
                vector3.add(symbol);
                ++n;
                --i;
                continue;
            }
            if (!subroutine.contain(debugLineEntry.getAddress())) continue;
            n2 = n;
            n3 = n;
            this.setSymbolValue(symbol, debugLineEntry);
            symbol.setFunction(subroutine.getName());
            symbol.setEndAddress(subroutine.getHighPc());
            if (null != debugLineEntry2 && subroutine.contain(debugLineEntry2.getAddress())) {
                symbol.setEndAddress(debugLineEntry2.getAddress());
            }
            int n4 = 0;
            boolean bl = false;
            while (++n3 < vector2.size()) {
                object = vector2.elementAt(n3);
                if (!subroutine.contain((Subroutine)object)) {
                    n2 = n3;
                    break;
                }
                if (((Subroutine)object).contain(debugLineEntry.getAddress())) {
                    n4 = n3;
                    symbol.setFunction(((Subroutine)object).getName());
                    if (null == debugLineEntry2 || ((Subroutine)object).contain(debugLineEntry2.getAddress())) continue;
                    symbol.setEndAddress(((Subroutine)object).getHighPc());
                    continue;
                }
                bl = false;
            }
            vector3.add(symbol);
            object = symbol;
            if (0 != n4 && null != debugLineEntry2) {
                Subroutine subroutine2;
                while (++n4 < vector2.size() && (subroutine2 = vector2.elementAt(n4)).getLowPc() == ((Symbol)object).getEndAddress() && subroutine2.below(debugLineEntry2.getAddress())) {
                    object = new Symbol();
                    this.setSymbolValue((Symbol)object, debugLineEntry);
                    this.setSymbolValue((Symbol)object, subroutine2);
                    vector3.add((Symbol)object);
                }
            }
            if (null == debugLineEntry2 || subroutine.contain(debugLineEntry2.getAddress())) continue;
            if (n == n2) {
                ++n;
                continue;
            }
            n = n2;
        }
        Log.info("mergeToSymbolTable cost %d", System.currentTimeMillis() - l);
        return vector3;
    }

    private Vector<Symbol> mergeToSymbolTable2(TaskParams taskParams) {
        Vector<DebugLineParser.DebugLineEntry> vector = taskParams.lineInfoTable;
        TreeMap<Long, List<Subroutine>> treeMap = taskParams.lowPcSubroutineTable;
        TreeMap<Long, List<Subroutine>> treeMap2 = taskParams.lowPcSymtabSubroutineTable;
        Vector<Symbol> vector2 = new Vector<Symbol>();
        if (vector == null || vector.isEmpty()) {
            return vector2;
        }
        for (int i = taskParams.startIdx; i < taskParams.endIdx; ++i) {
            DebugLineParser.DebugLineEntry debugLineEntry = vector.elementAt(i);
            long l = debugLineEntry.getAddress();
            long l2 = debugLineEntry.getEndAddress();
            Subroutine subroutine = null;
            Symbol symbol = null;
            long l3 = l;
            while (l3 < l2) {
                Subroutine subroutine2 = this.findFloorSubroutine(treeMap, l3);
                if (subroutine2 == null) {
                    subroutine2 = this.findFloorSubroutine(treeMap2, l3);
                }
                if (subroutine2 == null) {
                    l3 += 4L;
                    continue;
                }
                if (subroutine2.getLowPc() >= 402284336L) {
                    boolean bl = true;
                }
                if (subroutine2 != subroutine) {
                    Symbol symbol2 = new Symbol(debugLineEntry, subroutine2);
                    symbol2.setAddress(l3);
                    symbol2.setEndAddress(l3);
                    if (symbol != null) {
                        vector2.add(symbol);
                    }
                    symbol = symbol2;
                    subroutine = subroutine2;
                } else if (symbol != null) {
                    symbol.setEndAddress(l3);
                }
                l3 += 4L;
            }
            if (symbol == null) continue;
            vector2.add(symbol);
        }
        return vector2;
    }

    private TreeMap<Long, List<Subroutine>> getLowPcKeyTreeMap(TreeMap<Long, List<Subroutine>> treeMap) {
        TreeMap<Long, List<Subroutine>> treeMap2 = new TreeMap<Long, List<Subroutine>>();
        for (Map.Entry<Long, List<Subroutine>> entry : treeMap.entrySet()) {
            for (Subroutine subroutine : entry.getValue()) {
                List list = treeMap2.getOrDefault(subroutine.getLowPc(), new ArrayList());
                list.add(subroutine);
                treeMap2.put(subroutine.getLowPc(), list);
            }
        }
        return treeMap2;
    }

    private Subroutine findCeilingSubroutine(TreeMap<Long, List<Subroutine>> treeMap, long l) {
        Map.Entry<Long, List<Subroutine>> entry = treeMap.ceilingEntry(l);
        if (entry == null) {
            return null;
        }
        return this.containAddress(entry.getValue(), l);
    }

    private Subroutine findFloorSubroutine(TreeMap<Long, List<Subroutine>> treeMap, long l) {
        Map.Entry<Long, List<Subroutine>> entry = treeMap.floorEntry(l);
        if (entry == null) {
            return null;
        }
        return this.containAddress(entry.getValue(), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subroutine containAddress(List<Subroutine> list, long l) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() > 100) {
            boolean bl = true;
        }
        List<Subroutine> list2 = list;
        synchronized (list2) {
            if (list.size() == 1) {
                if (list.get(0).contain(l)) {
                    return list.get(0);
                }
            } else {
                for (Subroutine subroutine : list) {
                    if (!subroutine.contain(l)) continue;
                    return subroutine;
                }
            }
            for (Subroutine subroutine : list) {
                DebugInfoPasrser.DebugInfoEntry debugInfoEntry;
                if (subroutine.debugInfoEntry == null || (debugInfoEntry = subroutine.debugInfoEntry.getParent()) == null) continue;
                return this.containAddress(debugInfoEntry.subroutines, l);
            }
            return null;
        }
    }

    private Subroutine findFloorSubroutine(TreeMap<Long, List<Subroutine>> treeMap, long l, long l2) {
        Map.Entry<Long, List<Subroutine>> entry = treeMap.floorEntry(l);
        if (entry == null) {
            return null;
        }
        return this.containAddress(entry.getValue(), l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subroutine containAddress(List<Subroutine> list, long l, long l2) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        List<Subroutine> list2 = list;
        synchronized (list2) {
            DwarfParser.sortSubroutineTable(list);
            for (Subroutine subroutine : list) {
                if (!subroutine.contain(l, l2)) continue;
                return subroutine;
            }
            for (Subroutine subroutine : list) {
                DebugInfoPasrser.DebugInfoEntry debugInfoEntry;
                if (subroutine.debugInfoEntry == null || (debugInfoEntry = subroutine.debugInfoEntry.getParent()) == null) continue;
                return this.containAddress(debugInfoEntry.subroutines, l, l2);
            }
            return null;
        }
    }

    private void compare(Vector<Symbol> vector, Vector<Symbol> vector2) {
        if (vector.size() != vector2.size()) {
            Log.error("symbols1.size() != symbols2.size()", new Object[0]);
        }
        vector.sort((symbol, symbol2) -> {
            if (symbol.getAddress() == symbol2.getAddress()) {
                return (int)(symbol.getEndAddress() - symbol2.getEndAddress());
            }
            return (int)(symbol.getAddress() - symbol2.getAddress());
        });
        vector2.sort((symbol, symbol2) -> {
            if (symbol.getAddress() == symbol2.getAddress()) {
                return (int)(symbol.getEndAddress() - symbol2.getEndAddress());
            }
            return (int)(symbol.getAddress() - symbol2.getAddress());
        });
        for (int i = 0; i < vector.size(); ++i) {
            Symbol symbol3 = vector.elementAt(i);
            Symbol symbol4 = vector2.elementAt(i);
            if (symbol3.getAddress() != symbol4.getAddress()) {
                Log.error("symbols1.size() != symbols2.size()", new Object[0]);
            }
            if (symbol3.getEndAddress() != symbol4.getEndAddress()) {
                Log.error("symbols1.size() != symbols2.size()", new Object[0]);
            }
            if (!Objects.equals(symbol3.getFunction(), symbol4.getFunction())) {
                Log.error("symbols1.size() != symbols2.size()", new Object[0]);
            }
            if (!Objects.equals(symbol3.getSourceFile(), symbol4.getSourceFile())) {
                Log.error("symbols1.size() != symbols2.size()", new Object[0]);
            }
            if (symbol3.getSourceLine() != symbol4.getSourceLine()) {
                Log.error("symbols1.size() != symbols2.size()", new Object[0]);
            }
            if (symbol3.getSourceColumn() == symbol4.getSourceColumn()) continue;
            Log.error("symbols1.size() != symbols2.size()", new Object[0]);
        }
    }

    private Vector<Symbol> filterSymbolTable(HashSet<Long> hashSet, Vector<Symbol> vector) {
        Vector<Symbol> vector2 = new Vector<Symbol>();
        for (Symbol symbol : vector) {
            if (hashSet.contains(symbol.getAddress())) continue;
            hashSet.add(symbol.getAddress());
            vector2.add(symbol);
            if (vector2.size() <= 100) continue;
            List<Symbol> list = vector2.subList(vector2.size() - 10, vector2.size());
            int n = 2;
        }
        return vector2;
    }

    public SymbolTable getSymbolTable(Vector<Subroutine> vector) {
        TreeMap<Long, List<Subroutine>> treeMap;
        Object object;
        Collection collection;
        if (!this.checkInit()) {
            return null;
        }
        TreeMap<Long, List<Subroutine>> treeMap2 = new TreeMap<Long, List<Subroutine>>();
        for (Subroutine object22 : vector) {
            object22.setSymtab(true);
            collection = treeMap2.getOrDefault(object22.getLowPc(), new ArrayList());
            collection.add(object22);
            treeMap2.put(object22.getLowPc(), (List<Subroutine>)collection);
        }
        this.debugInfo.cuHeaders = this.debugInfo.findAllCuHeader();
        LinkedHashMap<Long, DebugInfoPasrser.DebugInfoEntry> linkedHashMap = this.debugInfo.getDebugInfoTable(this.debugAbbrev, 0L);
        if (null == linkedHashMap) {
            Log.error("Failed to get debug info table", new Object[0]);
            return null;
        }
        if (!this.setFileFormat(this.debugInfo.getAddrBits())) {
            Log.error("Failed to set file format", new Object[0]);
            return null;
        }
        if (!this.setDebugLineAddrBits()) {
            Log.error("Failed to set address bits of debug line", new Object[0]);
            return null;
        }
        if (!this.setDebugRangesAddrBits()) {
            Log.error("Failed to set address bits of debug rages", new Object[0]);
            return null;
        }
        SymbolTable symbolTable = new SymbolTable();
        collection = new HashSet();
        int n = 0;
        long l = 0L;
        IntervalManager intervalManager = new IntervalManager();
        while (null != linkedHashMap) {
            ++n;
            if (!linkedHashMap.isEmpty()) {
                long n7 = System.currentTimeMillis();
                long subroutine = this.getDebugLineOffset((HashMap<Long, DebugInfoPasrser.DebugInfoEntry>)linkedHashMap);
                String i = this.parseCuComDir(this.debugInfo.getCu());
                this.debugInfo.setCuDir(i);
                object = this.getLineInfoTable(subroutine, i);
                treeMap = ((Vector)object).iterator();
                while (treeMap.hasNext()) {
                    DebugLineParser.DebugLineEntry debugLineEntry = treeMap.next();
                    intervalManager.addInterval(debugLineEntry.getAddress(), debugLineEntry.getEndAddress());
                }
                treeMap = this.filterOutSubroutines(linkedHashMap, treeMap2);
                int debugLineEntry = Runtime.getRuntime().availableProcessors();
                ArrayList<TaskParams> arrayList = new ArrayList<TaskParams>();
                int n2 = 0;
                int n3 = 1;
                if (((Vector)object).size() < 5000000) {
                    n3 = 1;
                } else {
                    n3 = Integer.min(debugLineEntry, ((Vector)object).size() % 500);
                    if (n3 == 0) {
                        n3 = 1;
                    }
                }
                int n4 = (((Vector)object).size() + n3 - 1) / n3;
                for (int j = 0; j < n3; ++j) {
                    int n5 = Math.min(n2 + n4, ((Vector)object).size());
                    arrayList.add(new TaskParams((Vector<DebugLineParser.DebugLineEntry>)object, treeMap, treeMap2, n2, n5, j + 1));
                    n2 += n4;
                }
                Vector<Symbol> i2 = new Vector<Symbol>();
                Object n6 = new Object();
                CountDownLatch countDownLatch = new CountDownLatch(arrayList.size());
                ArrayList<Thread> arrayList2 = new ArrayList<Thread>();
                for (TaskParams taskParams : arrayList) {
                    Vector<Symbol> vector2 = i2;
                    Thread thread2 = new Thread(() -> {
                        try {
                            Vector<Symbol> vector2 = this.mergeToSymbolTable2(taskParams);
                            Object object2 = object3;
                            synchronized (object2) {
                                vector3.addAll(vector2);
                            }
                        }
                        finally {
                            countDownLatch.countDown();
                        }
                    });
                    arrayList2.add(thread2);
                    thread2.start();
                }
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                l += System.currentTimeMillis() - n7;
                i2 = this.filterSymbolTable((HashSet<Long>)collection, i2);
                symbolTable.add(i2);
            }
            if (n != 0 && n % 100 == 0) {
                Log.error("cu loop is %d", n);
                Log.info("[Time]current cost %d[ms]", l);
            }
            linkedHashMap = this.debugInfo.next(this.debugAbbrev);
        }
        int n6 = 0;
        for (Subroutine subroutine : vector) {
            List<IntervalManager.Interval> list = intervalManager.queryUncovered(subroutine.getLowPc(), subroutine.getHighPc());
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                treeMap = new Symbol();
                ((Symbol)((Object)treeMap)).setAddress(((IntervalManager.Interval)object).getStart());
                ((Symbol)((Object)treeMap)).setEndAddress(((IntervalManager.Interval)object).getEnd());
                ((Symbol)((Object)treeMap)).setFunction(subroutine.getName());
                ((Symbol)((Object)treeMap)).setSourceFile(subroutine.getFilePathFromSymtab());
                symbolTable.add((Symbol)((Object)treeMap));
            }
            if (list.size() <= 0) continue;
            n6 += list.size();
        }
        Log.error("interval size is %d", n6);
        if (!symbolTable.sort()) {
            Log.error("Failed to sort symbol table", new Object[0]);
            return null;
        }
        Log.warn("symbolTable size after diff: " + symbolTable.size(), new Object[0]);
        return symbolTable;
    }

    public void printSummaryInfo() {
        Log.warn("referencedDieTag: %s", StringUtils.join(this.referencedDieTag, ","));
        Log.warn("sectionOffset2Name size: %d", this.sectionOffset2Name.size());
        Log.warn("DW_FORM_ref_addr num: %d", this.DW_FORM_ref_addr_num);
    }

    public void close() {
        if (null != this.debugAbbrev) {
            this.debugAbbrev.close();
            this.debugAbbrev = null;
        }
        if (null != this.debugStr) {
            this.debugStr.close();
            this.debugStr = null;
        }
        if (null != this.debugLine) {
            this.debugLine.close();
            this.debugLine = null;
        }
        if (null != this.debugInfo) {
            this.debugInfo.close();
            this.debugInfo = null;
        }
        if (null != this.debugRanges) {
            this.debugRanges.close();
            this.debugRanges = null;
        }
        if (null != this.debugPubnames) {
            this.debugPubnames = null;
        }
        if (null != this.debugStrOffsetsParser) {
            this.debugStrOffsetsParser.close();
            this.debugStrOffsetsParser = null;
        }
        if (null != this.debugLineStrParser) {
            this.debugLineStrParser.close();
            this.debugLineStrParser = null;
        }
        if (null != this.debugRnglistParser) {
            this.debugRnglistParser.close();
            this.debugRnglistParser = null;
        }
        if (null != this.debugAddrParser) {
            this.debugAddrParser.close();
            this.debugAddrParser = null;
        }
    }

    static class TaskParams {
        Vector<DebugLineParser.DebugLineEntry> lineInfoTable;
        TreeMap<Long, List<Subroutine>> lowPcSubroutineTable;
        TreeMap<Long, List<Subroutine>> lowPcSymtabSubroutineTable;
        int startIdx;
        int endIdx;
        int taskId;

        public TaskParams(Vector<DebugLineParser.DebugLineEntry> vector, TreeMap<Long, List<Subroutine>> treeMap, TreeMap<Long, List<Subroutine>> treeMap2, int n, int n2, int n3) {
            this.lineInfoTable = vector;
            this.lowPcSubroutineTable = treeMap;
            this.lowPcSymtabSubroutineTable = treeMap2;
            this.startIdx = n;
            this.endIdx = n2;
            this.taskId = n3;
        }
    }
}

