/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class DebugStrOffsetsParser {
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    BinaryFileReader binaryFileReader;
    TreeMap<Long, List<Long>> strOffsetsBaseToOffsets = null;

    public DebugStrOffsetsParser(String string, long l, long l2) {
        this.fileName = string;
        this.sectionOffset = l;
        this.sectionSize = l2;
        this.parseStrOffsetsBaseToOffsets();
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return this.binaryFileReader.skip(this.sectionOffset);
    }

    private void parseStrOffsetsBaseToOffsets() {
        if (this.strOffsetsBaseToOffsets != null) {
            return;
        }
        if (!this.openFile()) {
            return;
        }
        this.strOffsetsBaseToOffsets = new TreeMap();
        long l = this.sectionOffset;
        while (l < this.sectionOffset + this.sectionSize) {
            DebugStrOffsetsHeader debugStrOffsetsHeader = new DebugStrOffsetsHeader(this.fileName, l);
            if (!debugStrOffsetsHeader.parse()) {
                return;
            }
            l = debugStrOffsetsHeader.getNextHeaderFileOffset();
            this.strOffsetsBaseToOffsets.put(debugStrOffsetsHeader.getStrOffsetsBaseFileOffset() - this.sectionOffset, debugStrOffsetsHeader.getAddresses());
        }
        this.close();
    }

    public long getStrOffset(long l, int n) {
        try {
            List<Long> list = this.strOffsetsBaseToOffsets.get(l);
            return list.get(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0L;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public BinaryFileReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public TreeMap<Long, List<Long>> getStrOffsetsBaseToOffsets() {
        return this.strOffsetsBaseToOffsets;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    public void setStrOffsetsBaseToOffsets(TreeMap<Long, List<Long>> treeMap) {
        this.strOffsetsBaseToOffsets = treeMap;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DebugStrOffsetsParser)) {
            return false;
        }
        DebugStrOffsetsParser debugStrOffsetsParser = (DebugStrOffsetsParser)object;
        if (!debugStrOffsetsParser.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != debugStrOffsetsParser.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != debugStrOffsetsParser.getSectionSize()) {
            return false;
        }
        String string = this.getFileName();
        String string2 = debugStrOffsetsParser.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        BinaryFileReader binaryFileReader = this.getBinaryFileReader();
        BinaryFileReader binaryFileReader2 = debugStrOffsetsParser.getBinaryFileReader();
        if (binaryFileReader == null ? binaryFileReader2 != null : !binaryFileReader.equals(binaryFileReader2)) {
            return false;
        }
        TreeMap<Long, List<Long>> treeMap = this.getStrOffsetsBaseToOffsets();
        TreeMap<Long, List<Long>> treeMap2 = debugStrOffsetsParser.getStrOffsetsBaseToOffsets();
        return !(treeMap == null ? treeMap2 != null : !((Object)treeMap).equals(treeMap2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DebugStrOffsetsParser;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getSectionSize();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        BinaryFileReader binaryFileReader = this.getBinaryFileReader();
        n2 = n2 * 59 + (binaryFileReader == null ? 43 : binaryFileReader.hashCode());
        TreeMap<Long, List<Long>> treeMap = this.getStrOffsetsBaseToOffsets();
        n2 = n2 * 59 + (treeMap == null ? 43 : ((Object)treeMap).hashCode());
        return n2;
    }

    public String toString() {
        return "DebugStrOffsetsParser(fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", binaryFileReader=" + this.getBinaryFileReader() + ", strOffsetsBaseToOffsets=" + this.getStrOffsetsBaseToOffsets() + ")";
    }

    public static class DebugStrOffsetsHeader {
        String fileName;
        long fileOffset;
        BinaryFileReader binaryFileReader;
        private long dwarfFormat = 0L;
        private long unitLength = 0L;
        private long version = 0L;
        private long padding = 0L;
        long strOffsetsBaseFileOffset;
        long nextHeaderFileOffset;
        List<Long> addresses = new ArrayList<Long>();

        public DebugStrOffsetsHeader(String string, long l) {
            this.fileName = string;
            this.fileOffset = l;
        }

        private boolean checkInit() {
            return this.fileOffset >= 0L;
        }

        private void close() {
            if (null == this.binaryFileReader) {
                return;
            }
            if (!this.binaryFileReader.close()) {
                return;
            }
            this.binaryFileReader = null;
        }

        private boolean openFile() {
            if (!this.checkInit()) {
                return false;
            }
            if (null != this.binaryFileReader) {
                this.close();
            }
            try {
                this.binaryFileReader = new BinaryFileReader(this.fileName);
            }
            catch (Exception exception) {
                Log.error(exception);
                return false;
            }
            return this.binaryFileReader.skip(this.fileOffset);
        }

        public boolean parse() {
            if (!this.openFile()) {
                return false;
            }
            if (!this.parseUnitLength()) {
                return false;
            }
            this.nextHeaderFileOffset = this.binaryFileReader.getOffset() + this.unitLength;
            if (!this.parseVersion()) {
                return false;
            }
            if (!this.parsePadding()) {
                return false;
            }
            this.strOffsetsBaseFileOffset = this.binaryFileReader.getOffset();
            if (!this.parseAddresses()) {
                return false;
            }
            this.close();
            return true;
        }

        private boolean parseUnitLength() {
            try {
                this.unitLength = this.binaryFileReader.readUInt();
                if (0xFFFFFFFFL == this.unitLength) {
                    this.dwarfFormat = 64L;
                    this.unitLength = this.binaryFileReader.readULong();
                } else {
                    this.dwarfFormat = 32L;
                }
                this.binaryFileReader.resetReadBytes();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseVersion() {
            try {
                this.version = this.binaryFileReader.readUShort();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parsePadding() {
            try {
                this.padding = this.binaryFileReader.readUShort();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseAddresses() {
            while (this.binaryFileReader.getOffset() < this.nextHeaderFileOffset) {
                Long l = this.parseAddress();
                if (l == null) {
                    return false;
                }
                this.addresses.add(l);
            }
            return true;
        }

        private Long parseAddress() {
            try {
                if (32L == this.dwarfFormat) {
                    return this.binaryFileReader.readUInt();
                }
                if (64L == this.dwarfFormat) {
                    return this.binaryFileReader.readULong();
                }
                Log.warn("parseAddress invalid: dwarfFormat == %d", this.dwarfFormat);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }

        public BinaryFileReader getBinaryFileReader() {
            return this.binaryFileReader;
        }

        public long getDwarfFormat() {
            return this.dwarfFormat;
        }

        public long getUnitLength() {
            return this.unitLength;
        }

        public long getVersion() {
            return this.version;
        }

        public long getPadding() {
            return this.padding;
        }

        public long getStrOffsetsBaseFileOffset() {
            return this.strOffsetsBaseFileOffset;
        }

        public long getNextHeaderFileOffset() {
            return this.nextHeaderFileOffset;
        }

        public List<Long> getAddresses() {
            return this.addresses;
        }

        public void setFileName(String string) {
            this.fileName = string;
        }

        public void setFileOffset(long l) {
            this.fileOffset = l;
        }

        public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
            this.binaryFileReader = binaryFileReader;
        }

        public void setDwarfFormat(long l) {
            this.dwarfFormat = l;
        }

        public void setUnitLength(long l) {
            this.unitLength = l;
        }

        public void setVersion(long l) {
            this.version = l;
        }

        public void setPadding(long l) {
            this.padding = l;
        }

        public void setStrOffsetsBaseFileOffset(long l) {
            this.strOffsetsBaseFileOffset = l;
        }

        public void setNextHeaderFileOffset(long l) {
            this.nextHeaderFileOffset = l;
        }

        public void setAddresses(List<Long> list) {
            this.addresses = list;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DebugStrOffsetsHeader)) {
                return false;
            }
            DebugStrOffsetsHeader debugStrOffsetsHeader = (DebugStrOffsetsHeader)object;
            if (!debugStrOffsetsHeader.canEqual(this)) {
                return false;
            }
            if (this.getFileOffset() != debugStrOffsetsHeader.getFileOffset()) {
                return false;
            }
            if (this.getDwarfFormat() != debugStrOffsetsHeader.getDwarfFormat()) {
                return false;
            }
            if (this.getUnitLength() != debugStrOffsetsHeader.getUnitLength()) {
                return false;
            }
            if (this.getVersion() != debugStrOffsetsHeader.getVersion()) {
                return false;
            }
            if (this.getPadding() != debugStrOffsetsHeader.getPadding()) {
                return false;
            }
            if (this.getStrOffsetsBaseFileOffset() != debugStrOffsetsHeader.getStrOffsetsBaseFileOffset()) {
                return false;
            }
            if (this.getNextHeaderFileOffset() != debugStrOffsetsHeader.getNextHeaderFileOffset()) {
                return false;
            }
            String string = this.getFileName();
            String string2 = debugStrOffsetsHeader.getFileName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            BinaryFileReader binaryFileReader = this.getBinaryFileReader();
            BinaryFileReader binaryFileReader2 = debugStrOffsetsHeader.getBinaryFileReader();
            if (binaryFileReader == null ? binaryFileReader2 != null : !binaryFileReader.equals(binaryFileReader2)) {
                return false;
            }
            List<Long> list = this.getAddresses();
            List<Long> list2 = debugStrOffsetsHeader.getAddresses();
            return !(list == null ? list2 != null : !((Object)list).equals(list2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DebugStrOffsetsHeader;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = this.getFileOffset();
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = this.getDwarfFormat();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = this.getUnitLength();
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            long l4 = this.getVersion();
            n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
            long l5 = this.getPadding();
            n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
            long l6 = this.getStrOffsetsBaseFileOffset();
            n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
            long l7 = this.getNextHeaderFileOffset();
            n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
            String string = this.getFileName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            BinaryFileReader binaryFileReader = this.getBinaryFileReader();
            n2 = n2 * 59 + (binaryFileReader == null ? 43 : binaryFileReader.hashCode());
            List<Long> list = this.getAddresses();
            n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
            return n2;
        }

        public String toString() {
            return "DebugStrOffsetsParser.DebugStrOffsetsHeader(fileName=" + this.getFileName() + ", fileOffset=" + this.getFileOffset() + ", binaryFileReader=" + this.getBinaryFileReader() + ", dwarfFormat=" + this.getDwarfFormat() + ", unitLength=" + this.getUnitLength() + ", version=" + this.getVersion() + ", padding=" + this.getPadding() + ", strOffsetsBaseFileOffset=" + this.getStrOffsetsBaseFileOffset() + ", nextHeaderFileOffset=" + this.getNextHeaderFileOffset() + ", addresses=" + this.getAddresses() + ")";
        }
    }
}

