/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import com.uqm.crashsight.symtabtool.dwarf.DebugAddrParser;
import com.uqm.crashsight.symtabtool.dwarf.Leb128Parser;
import java.io.IOException;
import java.util.TreeMap;
import java.util.Vector;

public class DebugRnglistParser {
    public final int DW_RLE_end_of_list = 0;
    public final int DW_RLE_base_addressx = 1;
    public final int DW_RLE_startx_endx = 2;
    public final int DW_RLE_startx_length = 3;
    public final int DW_RLE_offset_pair = 4;
    public final int DW_RLE_base_address = 5;
    public final int DW_RLE_start_end = 6;
    public final int DW_RLE_start_length = 7;
    DebugAddrParser debugAddrParser = null;
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    private BinaryFileReader binaryFileReader = null;
    TreeMap<Long, DebugRnglistHeader> rnglistsBaseToHeader = null;

    public DebugRnglistParser(String string, long l, long l2, DebugAddrParser debugAddrParser) {
        this.fileName = string;
        this.sectionOffset = l;
        this.sectionSize = l2;
        this.debugAddrParser = debugAddrParser;
        this.parseRnglistsBaseToHeader();
    }

    private boolean checkInit() {
        return this.sectionOffset >= 0L && this.sectionSize > 0L;
    }

    public void close() {
        if (null == this.binaryFileReader) {
            return;
        }
        if (!this.binaryFileReader.close()) {
            return;
        }
        this.binaryFileReader = null;
    }

    private boolean openFile() {
        if (!this.checkInit()) {
            return false;
        }
        if (null != this.binaryFileReader) {
            this.close();
        }
        try {
            this.binaryFileReader = new BinaryFileReader(this.fileName);
        }
        catch (Exception exception) {
            Log.error(exception);
            return false;
        }
        return this.binaryFileReader.skip(this.sectionOffset);
    }

    private void parseRnglistsBaseToHeader() {
        if (this.rnglistsBaseToHeader != null) {
            return;
        }
        if (!this.openFile()) {
            return;
        }
        this.rnglistsBaseToHeader = new TreeMap();
        long l = this.sectionOffset;
        while (l < this.sectionOffset + this.sectionSize) {
            DebugRnglistHeader debugRnglistHeader = new DebugRnglistHeader(this.fileName, l);
            if (!debugRnglistHeader.parse()) {
                return;
            }
            l = debugRnglistHeader.getNextHeaderFileOffset();
            this.rnglistsBaseToHeader.put(debugRnglistHeader.getBeginOfOffsetArrayInFile() - this.sectionOffset, debugRnglistHeader);
        }
        this.close();
    }

    public Vector<DebugRangeEntry> getRangesTable(long l, long l2, long l3) {
        if (l < 0L) {
            return null;
        }
        if (!this.openFile()) {
            this.close();
            return null;
        }
        if (!this.binaryFileReader.skip(l3)) {
            this.close();
            return null;
        }
        DebugRnglistHeader debugRnglistHeader = this.rnglistsBaseToHeader.get(l3);
        if (debugRnglistHeader == null) {
            return null;
        }
        Vector<DebugRangeEntry> vector = this.parseRangesTable(debugRnglistHeader, l, l2);
        this.close();
        return vector;
    }

    private Vector<DebugRangeEntry> parseRangesTable(DebugRnglistHeader debugRnglistHeader, long l, long l2) {
        Vector<Long> vector = debugRnglistHeader.getOffsets();
        long l3 = vector.get((int)l);
        this.binaryFileReader.skip(l3);
        Vector<DebugRangeEntry> vector2 = new Vector<DebugRangeEntry>();
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        try {
            while (true) {
                int n = (int)this.binaryFileReader.readUByte();
                switch (n) {
                    case 0: {
                        return vector2;
                    }
                    case 1: {
                        long l7 = Leb128Parser.parseULeb128(this.binaryFileReader);
                        l6 = this.debugAddrParser.getAddress(l2, (int)l7);
                        break;
                    }
                    case 2: {
                        long l8 = Leb128Parser.parseULeb128(this.binaryFileReader);
                        l4 = this.debugAddrParser.getAddress(l2, (int)l8);
                        long l9 = Leb128Parser.parseULeb128(this.binaryFileReader);
                        l5 = this.debugAddrParser.getAddress(l2, (int)l9);
                        break;
                    }
                    case 3: {
                        long l10 = Leb128Parser.parseULeb128(this.binaryFileReader);
                        l4 = this.debugAddrParser.getAddress(l2, (int)l10);
                        long l9 = Leb128Parser.parseULeb128(this.binaryFileReader);
                        l5 = l4 + l9;
                        break;
                    }
                    case 4: {
                        long l11 = Leb128Parser.parseULeb128(this.binaryFileReader);
                        long l9 = Leb128Parser.parseULeb128(this.binaryFileReader);
                        l4 = l11 + l6;
                        l5 = l9 + l6;
                        break;
                    }
                    case 5: {
                        l6 = this.readFormAddr(debugRnglistHeader.addrBits);
                        break;
                    }
                    case 6: {
                        l4 = this.readFormAddr(debugRnglistHeader.addrBits);
                        l5 = this.readFormAddr(debugRnglistHeader.addrBits);
                        break;
                    }
                    case 7: {
                        l4 = this.readFormAddr(debugRnglistHeader.addrBits);
                        long l12 = Leb128Parser.parseULeb128(this.binaryFileReader);
                        l5 = l4 + l12;
                        break;
                    }
                }
                DebugRangeEntry debugRangeEntry = new DebugRangeEntry();
                debugRangeEntry.setLowPc(l4);
                debugRangeEntry.setHighPc(l5);
                vector2.add(debugRangeEntry);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private long readFormAddr(long l) {
        try {
            if (32L == l) {
                return this.binaryFileReader.readUInt();
            }
            if (64L == l) {
                return this.binaryFileReader.readULong();
            }
            Log.warn("readFormAddr invalid: addrBits == %d", l);
        }
        catch (Exception exception) {
            Log.warn("readFormAddr err: %s", exception.toString());
            return 0L;
        }
        return 0L;
    }

    public int getDW_RLE_end_of_list() {
        return this.DW_RLE_end_of_list;
    }

    public int getDW_RLE_base_addressx() {
        return this.DW_RLE_base_addressx;
    }

    public int getDW_RLE_startx_endx() {
        return this.DW_RLE_startx_endx;
    }

    public int getDW_RLE_startx_length() {
        return this.DW_RLE_startx_length;
    }

    public int getDW_RLE_offset_pair() {
        return this.DW_RLE_offset_pair;
    }

    public int getDW_RLE_base_address() {
        return this.DW_RLE_base_address;
    }

    public int getDW_RLE_start_end() {
        return this.DW_RLE_start_end;
    }

    public int getDW_RLE_start_length() {
        return this.DW_RLE_start_length;
    }

    public DebugAddrParser getDebugAddrParser() {
        return this.debugAddrParser;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public BinaryFileReader getBinaryFileReader() {
        return this.binaryFileReader;
    }

    public TreeMap<Long, DebugRnglistHeader> getRnglistsBaseToHeader() {
        return this.rnglistsBaseToHeader;
    }

    public void setDebugAddrParser(DebugAddrParser debugAddrParser) {
        this.debugAddrParser = debugAddrParser;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
        this.binaryFileReader = binaryFileReader;
    }

    public void setRnglistsBaseToHeader(TreeMap<Long, DebugRnglistHeader> treeMap) {
        this.rnglistsBaseToHeader = treeMap;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DebugRnglistParser)) {
            return false;
        }
        DebugRnglistParser debugRnglistParser = (DebugRnglistParser)object;
        if (!debugRnglistParser.canEqual(this)) {
            return false;
        }
        if (this.getDW_RLE_end_of_list() != debugRnglistParser.getDW_RLE_end_of_list()) {
            return false;
        }
        if (this.getDW_RLE_base_addressx() != debugRnglistParser.getDW_RLE_base_addressx()) {
            return false;
        }
        if (this.getDW_RLE_startx_endx() != debugRnglistParser.getDW_RLE_startx_endx()) {
            return false;
        }
        if (this.getDW_RLE_startx_length() != debugRnglistParser.getDW_RLE_startx_length()) {
            return false;
        }
        if (this.getDW_RLE_offset_pair() != debugRnglistParser.getDW_RLE_offset_pair()) {
            return false;
        }
        if (this.getDW_RLE_base_address() != debugRnglistParser.getDW_RLE_base_address()) {
            return false;
        }
        if (this.getDW_RLE_start_end() != debugRnglistParser.getDW_RLE_start_end()) {
            return false;
        }
        if (this.getDW_RLE_start_length() != debugRnglistParser.getDW_RLE_start_length()) {
            return false;
        }
        if (this.getSectionOffset() != debugRnglistParser.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != debugRnglistParser.getSectionSize()) {
            return false;
        }
        DebugAddrParser debugAddrParser = this.getDebugAddrParser();
        DebugAddrParser debugAddrParser2 = debugRnglistParser.getDebugAddrParser();
        if (debugAddrParser == null ? debugAddrParser2 != null : !((Object)debugAddrParser).equals(debugAddrParser2)) {
            return false;
        }
        String string = this.getFileName();
        String string2 = debugRnglistParser.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        BinaryFileReader binaryFileReader = this.getBinaryFileReader();
        BinaryFileReader binaryFileReader2 = debugRnglistParser.getBinaryFileReader();
        if (binaryFileReader == null ? binaryFileReader2 != null : !binaryFileReader.equals(binaryFileReader2)) {
            return false;
        }
        TreeMap<Long, DebugRnglistHeader> treeMap = this.getRnglistsBaseToHeader();
        TreeMap<Long, DebugRnglistHeader> treeMap2 = debugRnglistParser.getRnglistsBaseToHeader();
        return !(treeMap == null ? treeMap2 != null : !((Object)treeMap).equals(treeMap2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DebugRnglistParser;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        n2 = n2 * 59 + this.getDW_RLE_end_of_list();
        n2 = n2 * 59 + this.getDW_RLE_base_addressx();
        n2 = n2 * 59 + this.getDW_RLE_startx_endx();
        n2 = n2 * 59 + this.getDW_RLE_startx_length();
        n2 = n2 * 59 + this.getDW_RLE_offset_pair();
        n2 = n2 * 59 + this.getDW_RLE_base_address();
        n2 = n2 * 59 + this.getDW_RLE_start_end();
        n2 = n2 * 59 + this.getDW_RLE_start_length();
        long l = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getSectionSize();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        DebugAddrParser debugAddrParser = this.getDebugAddrParser();
        n2 = n2 * 59 + (debugAddrParser == null ? 43 : ((Object)debugAddrParser).hashCode());
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        BinaryFileReader binaryFileReader = this.getBinaryFileReader();
        n2 = n2 * 59 + (binaryFileReader == null ? 43 : binaryFileReader.hashCode());
        TreeMap<Long, DebugRnglistHeader> treeMap = this.getRnglistsBaseToHeader();
        n2 = n2 * 59 + (treeMap == null ? 43 : ((Object)treeMap).hashCode());
        return n2;
    }

    public String toString() {
        return "DebugRnglistParser(DW_RLE_end_of_list=" + this.getDW_RLE_end_of_list() + ", DW_RLE_base_addressx=" + this.getDW_RLE_base_addressx() + ", DW_RLE_startx_endx=" + this.getDW_RLE_startx_endx() + ", DW_RLE_startx_length=" + this.getDW_RLE_startx_length() + ", DW_RLE_offset_pair=" + this.getDW_RLE_offset_pair() + ", DW_RLE_base_address=" + this.getDW_RLE_base_address() + ", DW_RLE_start_end=" + this.getDW_RLE_start_end() + ", DW_RLE_start_length=" + this.getDW_RLE_start_length() + ", debugAddrParser=" + this.getDebugAddrParser() + ", fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", binaryFileReader=" + this.getBinaryFileReader() + ", rnglistsBaseToHeader=" + this.getRnglistsBaseToHeader() + ")";
    }

    public static class DebugRangeEntry {
        private long lowPc = -1L;
        private long highPc = -1L;

        public long getLowPc() {
            return this.lowPc;
        }

        public void setLowPc(long l) {
            this.lowPc = l;
        }

        public long getHighPc() {
            return this.highPc;
        }

        public void setHighPc(long l) {
            this.highPc = l;
        }
    }

    public static class DebugRnglistHeader {
        String fileName;
        long fileOffset;
        BinaryFileReader binaryFileReader;
        long nextHeaderFileOffset;
        long beginOfOffsetArrayInFile;
        private long addrBits = 0L;
        private long dwarfFormat = 0L;
        private long unitLength = 0L;
        private long version = 0L;
        private long addressSize = 0L;
        private long segmentSelectorSize;
        private long offsetEntryCount;
        Vector<Long> offsets;

        public DebugRnglistHeader(String string, long l) {
            this.fileName = string;
            this.fileOffset = l;
        }

        private boolean checkInit() {
            return this.fileOffset >= 0L;
        }

        private void close() {
            if (null == this.binaryFileReader) {
                return;
            }
            if (!this.binaryFileReader.close()) {
                return;
            }
            this.binaryFileReader = null;
        }

        private boolean openFile() {
            if (!this.checkInit()) {
                return false;
            }
            if (null != this.binaryFileReader) {
                this.close();
            }
            try {
                this.binaryFileReader = new BinaryFileReader(this.fileName);
            }
            catch (Exception exception) {
                Log.error(exception);
                return false;
            }
            return this.binaryFileReader.skip(this.fileOffset);
        }

        public boolean parse() {
            if (!this.openFile()) {
                return false;
            }
            if (!this.parseUnitLength()) {
                return false;
            }
            this.nextHeaderFileOffset = this.binaryFileReader.getOffset() + this.unitLength;
            if (!this.parseVersion()) {
                return false;
            }
            if (!this.parseAddressSize()) {
                return false;
            }
            if (!this.parseSegmentSelectorSize()) {
                return false;
            }
            if (!this.parseOffsetEntryCount()) {
                return false;
            }
            this.beginOfOffsetArrayInFile = this.binaryFileReader.getOffset();
            if (!this.parseOffsetLocations()) {
                return false;
            }
            if (!this.setAddrBits()) {
                return false;
            }
            this.close();
            return true;
        }

        public boolean setAddrBits() {
            switch ((int)this.addressSize) {
                case 4: 
                case 32: {
                    this.addrBits = 32L;
                    break;
                }
                case 8: 
                case 64: {
                    this.addrBits = 64L;
                    break;
                }
                default: {
                    Log.warn("Address bits error: %d", this.addrBits);
                    return false;
                }
            }
            return true;
        }

        private boolean parseUnitLength() {
            try {
                this.unitLength = this.binaryFileReader.readUInt();
                if (0xFFFFFFFFL == this.unitLength) {
                    this.dwarfFormat = 64L;
                    this.unitLength = this.binaryFileReader.readULong();
                } else {
                    this.dwarfFormat = 32L;
                }
                this.binaryFileReader.resetReadBytes();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseVersion() {
            try {
                this.version = this.binaryFileReader.readUShort();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseAddressSize() {
            try {
                this.addressSize = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            if (4L != this.addressSize && 8L != this.addressSize) {
                Log.error("Address size of debug rnglists header error: %d", this.addressSize);
                return false;
            }
            return true;
        }

        private boolean parseSegmentSelectorSize() {
            try {
                this.segmentSelectorSize = this.binaryFileReader.readUByte();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseOffsetEntryCount() {
            try {
                this.offsetEntryCount = this.binaryFileReader.readUInt();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseOffsetLocations() {
            this.offsets = new Vector();
            try {
                int n = 0;
                while ((long)n < this.offsetEntryCount) {
                    long l = this.parseOffset();
                    this.offsets.add(l);
                    ++n;
                }
            }
            catch (Exception exception) {
                Log.error(exception);
                return false;
            }
            return true;
        }

        private long parseOffset() {
            try {
                if (32L == this.dwarfFormat) {
                    return this.binaryFileReader.readUInt();
                }
                if (64L == this.dwarfFormat) {
                    return this.binaryFileReader.readULong();
                }
            }
            catch (IOException iOException) {
                Log.error(iOException);
            }
            return 0L;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }

        public BinaryFileReader getBinaryFileReader() {
            return this.binaryFileReader;
        }

        public long getNextHeaderFileOffset() {
            return this.nextHeaderFileOffset;
        }

        public long getBeginOfOffsetArrayInFile() {
            return this.beginOfOffsetArrayInFile;
        }

        public long getAddrBits() {
            return this.addrBits;
        }

        public long getDwarfFormat() {
            return this.dwarfFormat;
        }

        public long getUnitLength() {
            return this.unitLength;
        }

        public long getVersion() {
            return this.version;
        }

        public long getAddressSize() {
            return this.addressSize;
        }

        public long getSegmentSelectorSize() {
            return this.segmentSelectorSize;
        }

        public long getOffsetEntryCount() {
            return this.offsetEntryCount;
        }

        public Vector<Long> getOffsets() {
            return this.offsets;
        }

        public void setFileName(String string) {
            this.fileName = string;
        }

        public void setFileOffset(long l) {
            this.fileOffset = l;
        }

        public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
            this.binaryFileReader = binaryFileReader;
        }

        public void setNextHeaderFileOffset(long l) {
            this.nextHeaderFileOffset = l;
        }

        public void setBeginOfOffsetArrayInFile(long l) {
            this.beginOfOffsetArrayInFile = l;
        }

        public void setAddrBits(long l) {
            this.addrBits = l;
        }

        public void setDwarfFormat(long l) {
            this.dwarfFormat = l;
        }

        public void setUnitLength(long l) {
            this.unitLength = l;
        }

        public void setVersion(long l) {
            this.version = l;
        }

        public void setAddressSize(long l) {
            this.addressSize = l;
        }

        public void setSegmentSelectorSize(long l) {
            this.segmentSelectorSize = l;
        }

        public void setOffsetEntryCount(long l) {
            this.offsetEntryCount = l;
        }

        public void setOffsets(Vector<Long> vector) {
            this.offsets = vector;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DebugRnglistHeader)) {
                return false;
            }
            DebugRnglistHeader debugRnglistHeader = (DebugRnglistHeader)object;
            if (!debugRnglistHeader.canEqual(this)) {
                return false;
            }
            if (this.getFileOffset() != debugRnglistHeader.getFileOffset()) {
                return false;
            }
            if (this.getNextHeaderFileOffset() != debugRnglistHeader.getNextHeaderFileOffset()) {
                return false;
            }
            if (this.getBeginOfOffsetArrayInFile() != debugRnglistHeader.getBeginOfOffsetArrayInFile()) {
                return false;
            }
            if (this.getAddrBits() != debugRnglistHeader.getAddrBits()) {
                return false;
            }
            if (this.getDwarfFormat() != debugRnglistHeader.getDwarfFormat()) {
                return false;
            }
            if (this.getUnitLength() != debugRnglistHeader.getUnitLength()) {
                return false;
            }
            if (this.getVersion() != debugRnglistHeader.getVersion()) {
                return false;
            }
            if (this.getAddressSize() != debugRnglistHeader.getAddressSize()) {
                return false;
            }
            if (this.getSegmentSelectorSize() != debugRnglistHeader.getSegmentSelectorSize()) {
                return false;
            }
            if (this.getOffsetEntryCount() != debugRnglistHeader.getOffsetEntryCount()) {
                return false;
            }
            String string = this.getFileName();
            String string2 = debugRnglistHeader.getFileName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            BinaryFileReader binaryFileReader = this.getBinaryFileReader();
            BinaryFileReader binaryFileReader2 = debugRnglistHeader.getBinaryFileReader();
            if (binaryFileReader == null ? binaryFileReader2 != null : !binaryFileReader.equals(binaryFileReader2)) {
                return false;
            }
            Vector<Long> vector = this.getOffsets();
            Vector<Long> vector2 = debugRnglistHeader.getOffsets();
            return !(vector == null ? vector2 != null : !((Object)vector).equals(vector2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DebugRnglistHeader;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = this.getFileOffset();
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = this.getNextHeaderFileOffset();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = this.getBeginOfOffsetArrayInFile();
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            long l4 = this.getAddrBits();
            n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
            long l5 = this.getDwarfFormat();
            n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
            long l6 = this.getUnitLength();
            n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
            long l7 = this.getVersion();
            n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
            long l8 = this.getAddressSize();
            n2 = n2 * 59 + (int)(l8 >>> 32 ^ l8);
            long l9 = this.getSegmentSelectorSize();
            n2 = n2 * 59 + (int)(l9 >>> 32 ^ l9);
            long l10 = this.getOffsetEntryCount();
            n2 = n2 * 59 + (int)(l10 >>> 32 ^ l10);
            String string = this.getFileName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            BinaryFileReader binaryFileReader = this.getBinaryFileReader();
            n2 = n2 * 59 + (binaryFileReader == null ? 43 : binaryFileReader.hashCode());
            Vector<Long> vector = this.getOffsets();
            n2 = n2 * 59 + (vector == null ? 43 : ((Object)vector).hashCode());
            return n2;
        }

        public String toString() {
            return "DebugRnglistParser.DebugRnglistHeader(fileName=" + this.getFileName() + ", fileOffset=" + this.getFileOffset() + ", binaryFileReader=" + this.getBinaryFileReader() + ", nextHeaderFileOffset=" + this.getNextHeaderFileOffset() + ", beginOfOffsetArrayInFile=" + this.getBeginOfOffsetArrayInFile() + ", addrBits=" + this.getAddrBits() + ", dwarfFormat=" + this.getDwarfFormat() + ", unitLength=" + this.getUnitLength() + ", version=" + this.getVersion() + ", addressSize=" + this.getAddressSize() + ", segmentSelectorSize=" + this.getSegmentSelectorSize() + ", offsetEntryCount=" + this.getOffsetEntryCount() + ", offsets=" + this.getOffsets() + ")";
        }
    }
}

