/*
 * Decompiled with CFR 0.152.
 */
package com.uqm.crashsight.symtabtool.dwarf;

import com.uqm.crashsight.symtabtool.common.file.BinaryFileReader;
import com.uqm.crashsight.symtabtool.common.utils.Log;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.Map;
import java.util.TreeMap;

public class DebugPubnamesParser {
    private String fileName = null;
    private long sectionOffset = 0L;
    private long sectionSize = 0L;
    MappedByteBuffer mapper = null;
    Map<Long, String> sectionOffset2Name = null;

    public DebugPubnamesParser(String string, long l, long l2) {
        this.setFileName(string);
        this.setSectionOffset(l);
        this.setSectionSize(l2);
        this.parseStrOffsetsBaseToOffsets();
    }

    private void parseStrOffsetsBaseToOffsets() {
        if (this.sectionOffset2Name != null) {
            return;
        }
        this.sectionOffset2Name = new TreeMap<Long, String>();
        long l = this.sectionOffset;
        while (l < this.sectionOffset + this.sectionSize) {
            DebugPubnamesHeader debugPubnamesHeader = new DebugPubnamesHeader(this.fileName, l);
            if (!debugPubnamesHeader.parse()) {
                return;
            }
            this.sectionOffset2Name.putAll(debugPubnamesHeader.getSectionOffset2Name());
            l = debugPubnamesHeader.getNextHeaderFileOffset();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSectionOffset() {
        return this.sectionOffset;
    }

    public long getSectionSize() {
        return this.sectionSize;
    }

    public MappedByteBuffer getMapper() {
        return this.mapper;
    }

    public Map<Long, String> getSectionOffset2Name() {
        return this.sectionOffset2Name;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setSectionOffset(long l) {
        this.sectionOffset = l;
    }

    public void setSectionSize(long l) {
        this.sectionSize = l;
    }

    public void setMapper(MappedByteBuffer mappedByteBuffer) {
        this.mapper = mappedByteBuffer;
    }

    public void setSectionOffset2Name(Map<Long, String> map) {
        this.sectionOffset2Name = map;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DebugPubnamesParser)) {
            return false;
        }
        DebugPubnamesParser debugPubnamesParser = (DebugPubnamesParser)object;
        if (!debugPubnamesParser.canEqual(this)) {
            return false;
        }
        if (this.getSectionOffset() != debugPubnamesParser.getSectionOffset()) {
            return false;
        }
        if (this.getSectionSize() != debugPubnamesParser.getSectionSize()) {
            return false;
        }
        String string = this.getFileName();
        String string2 = debugPubnamesParser.getFileName();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        MappedByteBuffer mappedByteBuffer = this.getMapper();
        MappedByteBuffer mappedByteBuffer2 = debugPubnamesParser.getMapper();
        if (mappedByteBuffer == null ? mappedByteBuffer2 != null : !((Object)mappedByteBuffer).equals(mappedByteBuffer2)) {
            return false;
        }
        Map<Long, String> map = this.getSectionOffset2Name();
        Map<Long, String> map2 = debugPubnamesParser.getSectionOffset2Name();
        return !(map == null ? map2 != null : !((Object)map).equals(map2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof DebugPubnamesParser;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        long l = this.getSectionOffset();
        n2 = n2 * 59 + (int)(l >>> 32 ^ l);
        long l2 = this.getSectionSize();
        n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
        String string = this.getFileName();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        MappedByteBuffer mappedByteBuffer = this.getMapper();
        n2 = n2 * 59 + (mappedByteBuffer == null ? 43 : ((Object)mappedByteBuffer).hashCode());
        Map<Long, String> map = this.getSectionOffset2Name();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        return n2;
    }

    public String toString() {
        return "DebugPubnamesParser(fileName=" + this.getFileName() + ", sectionOffset=" + this.getSectionOffset() + ", sectionSize=" + this.getSectionSize() + ", mapper=" + this.getMapper() + ", sectionOffset2Name=" + this.getSectionOffset2Name() + ")";
    }

    public static class DebugPubnamesHeader {
        String fileName;
        long fileOffset;
        BinaryFileReader binaryFileReader;
        private long dwarfFormat = 0L;
        private long unitLength = 0L;
        private long version = 0L;
        private long debugInfoOffset = 0L;
        private long debugInfoLength = 0L;
        long nextHeaderFileOffset;
        Map<Long, String> sectionOffset2Name = null;

        public DebugPubnamesHeader(String string, long l) {
            this.fileName = string;
            this.fileOffset = l;
            this.sectionOffset2Name = new TreeMap<Long, String>();
        }

        private boolean checkInit() {
            return this.fileOffset >= 0L;
        }

        private void close() {
            if (null == this.binaryFileReader) {
                return;
            }
            if (!this.binaryFileReader.close()) {
                return;
            }
            this.binaryFileReader = null;
        }

        private boolean openFile() {
            if (!this.checkInit()) {
                return false;
            }
            if (null != this.binaryFileReader) {
                this.close();
            }
            try {
                this.binaryFileReader = new BinaryFileReader(this.fileName);
            }
            catch (Exception exception) {
                Log.error(exception);
                return false;
            }
            return this.binaryFileReader.skip(this.fileOffset);
        }

        public boolean parse() {
            if (!this.openFile()) {
                return false;
            }
            if (!this.parseUnitLength()) {
                return false;
            }
            this.nextHeaderFileOffset = this.binaryFileReader.getOffset() + this.unitLength;
            if (!this.parseVersion()) {
                return false;
            }
            if (!this.parseDebugInfoOffset()) {
                return false;
            }
            if (!this.parseDebugInfoLength()) {
                return false;
            }
            if (!this.parseOffset2Name()) {
                return false;
            }
            this.close();
            return true;
        }

        private boolean parseUnitLength() {
            try {
                this.unitLength = this.binaryFileReader.readUInt();
                if (0xFFFFFFFFL == this.unitLength) {
                    this.dwarfFormat = 64L;
                    this.unitLength = this.binaryFileReader.readULong();
                } else {
                    this.dwarfFormat = 32L;
                }
                this.binaryFileReader.resetReadBytes();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseVersion() {
            try {
                this.version = this.binaryFileReader.readUShort();
            }
            catch (IOException iOException) {
                Log.error(iOException);
                return false;
            }
            return true;
        }

        private boolean parseDebugInfoOffset() {
            try {
                if (32L == this.dwarfFormat) {
                    this.debugInfoOffset = this.binaryFileReader.readUInt();
                } else if (64L == this.dwarfFormat) {
                    this.debugInfoOffset = this.binaryFileReader.readULong();
                } else {
                    Log.warn("parseDebugInfoOffset invalid: dwarfFormat == %d", this.dwarfFormat);
                }
            }
            catch (Exception exception) {
                Log.error(exception);
                return false;
            }
            return true;
        }

        private boolean parseDebugInfoLength() {
            try {
                if (32L == this.dwarfFormat) {
                    this.debugInfoLength = this.binaryFileReader.readUInt();
                } else if (64L == this.dwarfFormat) {
                    this.debugInfoLength = this.binaryFileReader.readULong();
                } else {
                    Log.warn("parseDebugInfoLength invalid: dwarfFormat == %d", this.dwarfFormat);
                }
            }
            catch (Exception exception) {
                Log.error(exception);
                return false;
            }
            return true;
        }

        private boolean parseOffset2Name() {
            while (this.binaryFileReader.getOffset() < this.nextHeaderFileOffset) {
                Long l = this.parseOffset();
                if (l == null) {
                    return false;
                }
                if (l == 0L) break;
                String string = this.pickString();
                if (string == null) {
                    return false;
                }
                this.sectionOffset2Name.put(l + this.debugInfoOffset, string);
            }
            return true;
        }

        private Long parseOffset() {
            try {
                if (32L == this.dwarfFormat) {
                    return this.binaryFileReader.readUInt();
                }
                if (64L == this.dwarfFormat) {
                    return this.binaryFileReader.readULong();
                }
                Log.warn("parseOffset invalid: dwarfFormat == %d", this.dwarfFormat);
            }
            catch (Exception exception) {
                Log.error(exception);
            }
            return null;
        }

        private String pickString() {
            try {
                byte by;
                StringBuilder stringBuilder = new StringBuilder();
                long l = 0L;
                while (0 != (by = this.binaryFileReader.readByte())) {
                    stringBuilder.append((char)by);
                    ++l;
                }
                return stringBuilder.toString();
            }
            catch (Exception exception) {
                Log.error(exception);
                return null;
            }
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getFileOffset() {
            return this.fileOffset;
        }

        public BinaryFileReader getBinaryFileReader() {
            return this.binaryFileReader;
        }

        public long getDwarfFormat() {
            return this.dwarfFormat;
        }

        public long getUnitLength() {
            return this.unitLength;
        }

        public long getVersion() {
            return this.version;
        }

        public long getDebugInfoOffset() {
            return this.debugInfoOffset;
        }

        public long getDebugInfoLength() {
            return this.debugInfoLength;
        }

        public long getNextHeaderFileOffset() {
            return this.nextHeaderFileOffset;
        }

        public Map<Long, String> getSectionOffset2Name() {
            return this.sectionOffset2Name;
        }

        public void setFileName(String string) {
            this.fileName = string;
        }

        public void setFileOffset(long l) {
            this.fileOffset = l;
        }

        public void setBinaryFileReader(BinaryFileReader binaryFileReader) {
            this.binaryFileReader = binaryFileReader;
        }

        public void setDwarfFormat(long l) {
            this.dwarfFormat = l;
        }

        public void setUnitLength(long l) {
            this.unitLength = l;
        }

        public void setVersion(long l) {
            this.version = l;
        }

        public void setDebugInfoOffset(long l) {
            this.debugInfoOffset = l;
        }

        public void setDebugInfoLength(long l) {
            this.debugInfoLength = l;
        }

        public void setNextHeaderFileOffset(long l) {
            this.nextHeaderFileOffset = l;
        }

        public void setSectionOffset2Name(Map<Long, String> map) {
            this.sectionOffset2Name = map;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DebugPubnamesHeader)) {
                return false;
            }
            DebugPubnamesHeader debugPubnamesHeader = (DebugPubnamesHeader)object;
            if (!debugPubnamesHeader.canEqual(this)) {
                return false;
            }
            if (this.getFileOffset() != debugPubnamesHeader.getFileOffset()) {
                return false;
            }
            if (this.getDwarfFormat() != debugPubnamesHeader.getDwarfFormat()) {
                return false;
            }
            if (this.getUnitLength() != debugPubnamesHeader.getUnitLength()) {
                return false;
            }
            if (this.getVersion() != debugPubnamesHeader.getVersion()) {
                return false;
            }
            if (this.getDebugInfoOffset() != debugPubnamesHeader.getDebugInfoOffset()) {
                return false;
            }
            if (this.getDebugInfoLength() != debugPubnamesHeader.getDebugInfoLength()) {
                return false;
            }
            if (this.getNextHeaderFileOffset() != debugPubnamesHeader.getNextHeaderFileOffset()) {
                return false;
            }
            String string = this.getFileName();
            String string2 = debugPubnamesHeader.getFileName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            BinaryFileReader binaryFileReader = this.getBinaryFileReader();
            BinaryFileReader binaryFileReader2 = debugPubnamesHeader.getBinaryFileReader();
            if (binaryFileReader == null ? binaryFileReader2 != null : !binaryFileReader.equals(binaryFileReader2)) {
                return false;
            }
            Map<Long, String> map = this.getSectionOffset2Name();
            Map<Long, String> map2 = debugPubnamesHeader.getSectionOffset2Name();
            return !(map == null ? map2 != null : !((Object)map).equals(map2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof DebugPubnamesHeader;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = this.getFileOffset();
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = this.getDwarfFormat();
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = this.getUnitLength();
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            long l4 = this.getVersion();
            n2 = n2 * 59 + (int)(l4 >>> 32 ^ l4);
            long l5 = this.getDebugInfoOffset();
            n2 = n2 * 59 + (int)(l5 >>> 32 ^ l5);
            long l6 = this.getDebugInfoLength();
            n2 = n2 * 59 + (int)(l6 >>> 32 ^ l6);
            long l7 = this.getNextHeaderFileOffset();
            n2 = n2 * 59 + (int)(l7 >>> 32 ^ l7);
            String string = this.getFileName();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            BinaryFileReader binaryFileReader = this.getBinaryFileReader();
            n2 = n2 * 59 + (binaryFileReader == null ? 43 : binaryFileReader.hashCode());
            Map<Long, String> map = this.getSectionOffset2Name();
            n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
            return n2;
        }

        public String toString() {
            return "DebugPubnamesParser.DebugPubnamesHeader(fileName=" + this.getFileName() + ", fileOffset=" + this.getFileOffset() + ", binaryFileReader=" + this.getBinaryFileReader() + ", dwarfFormat=" + this.getDwarfFormat() + ", unitLength=" + this.getUnitLength() + ", version=" + this.getVersion() + ", debugInfoOffset=" + this.getDebugInfoOffset() + ", debugInfoLength=" + this.getDebugInfoLength() + ", nextHeaderFileOffset=" + this.getNextHeaderFileOffset() + ", sectionOffset2Name=" + this.getSectionOffset2Name() + ")";
        }
    }
}

